/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.mods;

import de.zwanzigeins.io.PartialInputStream;
import de.zwanzigeins.util.HelperPath;
import de.zwanzigeins.util.LogContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.zerotoaster.httpd.config.Configuration;
import net.zerotoaster.httpd.mods.IntermediateModuleData;
import net.zerotoaster.httpd.mods.Mod_Base;
import net.zerotoaster.httpd.request.Http_Request;
import net.zerotoaster.httpd.response.Http_Response;
import net.zerotoaster.httpd.util.Helper;

public class Mod_File_Response
extends Mod_Base {
    public Mod_File_Response(Configuration cnfConfig, LogContext logContext) {
        super(cnfConfig, logContext);
    }

    protected ContentRange calcContentRange(File flToSend, Http_Request req, IntermediateModuleData imd) {
        String strTo;
        ContentRange cr = new ContentRange(this);
        cr.blnHasRange = false;
        cr.lngLwbRange = 0L;
        cr.lngUpbRange = flToSend.length() - 1L;
        cr.lngContentLength = flToSend.length();
        cr.lngCompleteLength = flToSend.length();
        if (!imd.iniVHOST.getPropertyBoolean(this.MOD_NAME, "allow_partial_content", true)) {
            return cr;
        }
        if (req.strRange.length() == 0) {
            return cr;
        }
        if (!req.strRange.startsWith("bytes")) {
            return cr;
        }
        int pp = req.strRange.indexOf("=");
        if (pp == -1) {
            return cr;
        }
        String strRange = req.strRange.substring(pp + 1).trim();
        if (strRange.length() == 0) {
            return cr;
        }
        if (strRange.indexOf(",") != -1) {
            return cr;
        }
        pp = strRange.indexOf("-");
        if (pp == -1) {
            return cr;
        }
        String strFrom = strRange.substring(0, pp).trim();
        if (strFrom.length() == 0) {
            strFrom = "0";
        }
        if ((strTo = strRange.substring(pp + 1).trim()).length() == 0) {
            strTo = "0";
        }
        long lngFrom = -1L;
        long lngTo = -1L;
        try {
            lngFrom = Long.parseLong(strFrom);
            lngTo = Long.parseLong(strTo);
        }
        catch (NumberFormatException numberFormatException) {
            return cr;
        }
        if (lngTo == 0L) {
            lngTo = flToSend.length() - 1L;
        }
        if (lngFrom > lngTo) {
            return cr;
        }
        if (lngTo > flToSend.length() - 1L) {
            return cr;
        }
        cr.blnHasRange = true;
        cr.lngLwbRange = lngFrom;
        cr.lngUpbRange = lngTo;
        cr.lngContentLength = cr.lngUpbRange - cr.lngLwbRange + 1L;
        return cr;
    }

    public boolean processREQ(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        return false;
    }

    public boolean processRES(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        if (httpRES.strContentType.length() == 0) {
            httpRES.strContentType = Helper.getMimeType(imd.iniVHOST, imd.strFileToServe);
        }
        try {
            if (Configuration.mode_nofile()) {
                return this.sendFile_ressource(imd.strFileToServe, httpREQ, imd, httpRES);
            }
            File fl = new File(imd.strFileToServe);
            httpRES.lngLastModified = fl.lastModified() / 1000L * 1000L;
            if (this.sendNotModified(httpREQ, imd, httpRES)) {
                return true;
            }
            return this.sendFile_disk(fl, httpREQ, imd, httpRES);
        }
        catch (IOException iOException) {
        }
        catch (Throwable e) {
            this.logContext.write(e);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean sendFile_disk(File fl, Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) throws IOException {
        long lngFlush;
        ContentRange cr = this.calcContentRange(fl, httpREQ, imd);
        if (!cr.blnHasRange) {
            httpRES.intStatusCode = 200;
            httpRES.strStatusCode = "OK";
            httpRES.lngContentLength = cr.lngContentLength;
        } else {
            httpRES.intStatusCode = 206;
            httpRES.strStatusCode = "Partial content";
            httpRES.lngContentLength = cr.lngContentLength;
            httpRES.strContentRange = cr.lngLwbRange + "-" + cr.lngUpbRange + "/" + cr.lngCompleteLength;
        }
        this.writeResponseHeader(httpREQ, imd, httpRES);
        long lngNextFlush = lngFlush = (long)imd.iniVHOST.getPropertyInt(this.MOD_NAME, "flush_data", 8192);
        byte[] buffer = new byte[this.cnfConfig.intStreamBufferSize];
        PartialInputStream pis = null;
        try {
            try {
                pis = new PartialInputStream((InputStream)new FileInputStream(fl), cr.lngLwbRange, cr.lngUpbRange);
                int i = 0;
                while (true) {
                    if ((i = pis.read(buffer)) == -1) {
                        Object var12_12 = null;
                        break;
                    }
                    httpRES.osResponse.write(buffer, 0, i);
                    httpRES.lngTransferredBytes += (long)i;
                    if (lngFlush <= 0L || httpRES.lngTransferredBytes <= lngNextFlush) continue;
                    httpRES.osResponse.flush();
                    lngNextFlush += lngFlush;
                }
            }
            catch (IOException iOException) {
                Object var12_13 = null;
                Helper.close(pis);
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            Helper.close(pis);
            throw throwable;
        }
        Helper.close(pis);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean sendFile_ressource(String strRessource, Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) throws IOException {
        httpRES.intStatusCode = 200;
        httpRES.strStatusCode = "OK";
        httpRES.lngContentLength = -1L;
        this.writeResponseHeader(httpREQ, imd, httpRES);
        byte[] buffer = new byte[this.cnfConfig.intStreamBufferSize];
        InputStream is = null;
        try {
            try {
                is = ((Object)((Object)this)).getClass().getResourceAsStream(HelperPath.buildRessourcePath((String)strRessource));
                int i = 0;
                while (true) {
                    if ((i = is.read(buffer)) == -1) {
                        Object var7_9 = null;
                        break;
                    }
                    httpRES.osResponse.write(buffer, 0, i);
                    httpRES.lngTransferredBytes += (long)i;
                }
            }
            catch (IOException iOException) {
                Object var7_10 = null;
                Helper.close(is);
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            Helper.close(is);
            throw throwable;
        }
        Helper.close(is);
        return true;
    }

    protected boolean sendNotModified(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        if (httpREQ.lngIfModifiedSince == -1L) {
            return false;
        }
        if (httpRES.lngLastModified <= httpREQ.lngIfModifiedSince) {
            httpRES.intStatusCode = 304;
            httpRES.strStatusCode = "Not modified";
            httpRES.strConnection = "close";
            httpRES.lngContentLength = -1L;
            httpRES.strContentType = "";
            httpRES.lngLastModified = -1L;
            this.writeResponseHeader(httpREQ, imd, httpRES);
            return true;
        }
        return false;
    }

    class ContentRange {
        /* synthetic */ Mod_File_Response this$0;
        boolean blnHasRange;
        long lngLwbRange;
        long lngUpbRange;
        long lngContentLength;
        long lngCompleteLength;

        ContentRange(Mod_File_Response this$0) {
            this.this$0 = this$0;
        }
    }
}

