/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.request;

import de.zwanzigeins.io.CRLFInputStream;
import de.zwanzigeins.sort.Comparator;
import de.zwanzigeins.sort.HelperSort;
import de.zwanzigeins.util.Encoding;
import de.zwanzigeins.util.LogContext;
import de.zwanzigeins.util.TimeFactory;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import net.zerotoaster.httpd.request.QualityComparator;
import net.zerotoaster.httpd.request.QualityRanking;
import net.zerotoaster.httpd.util.Helper;

public class Http_Request
implements Cloneable {
    public long lngRequestStarted = 0L;
    private int intLines;
    private Hashtable hshHeader;
    public CRLFInputStream crlfisRequest;
    public String strURLAbsolute;
    public String strAction;
    public String strURL;
    public String strQuery;
    public String strQueryUnEscaped;
    public String strProtocol;
    public String strHost;
    public String strVHost;
    public int intPost;
    public String strUserAgent;
    public String strReferer;
    public String strConnection;
    public String strRange;
    public long lngIfModifiedSince;
    public QualityRanking[] qrAccept;
    public QualityRanking[] qrAccept_Language;
    public QualityRanking[] qrAccept_Encoding;
    public QualityRanking[] qrAccept_Charset;
    public long lngContentLength;
    public String strCookies;
    private Hashtable hshCookies;
    public String strContentType;
    public String strAuthorization_Type;
    public String strAuthorization_User;
    public String strAuthorization_Pass;

    public Http_Request() {
        this.init();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Hashtable getCookies() {
        return this.hshCookies;
    }

    public Hashtable getHeaderAsHashtable() {
        return (Hashtable)this.hshHeader.clone();
    }

    public String[] getHeaderElement(String strKey) {
        try {
            return (String[])this.hshHeader.get(strKey);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public String getRequestURL(int intPort) {
        String strScheme = "http";
        int pp = this.strProtocol.indexOf("/");
        if (pp != -1) {
            strScheme = this.strProtocol.substring(0, pp).toLowerCase();
        }
        StringBuffer strb = new StringBuffer();
        strb.append(strScheme);
        strb.append("://");
        strb.append(this.strVHost);
        if (strScheme.equals("http") && intPort != 80 || strScheme.equals("https") && intPort != 443) {
            strb.append(':');
            strb.append(intPort);
        }
        strb.append(this.strURL);
        return strb.toString();
    }

    public void init() {
        if (this.crlfisRequest != null) {
            this.crlfisRequest.resetBytesRead();
        }
        this.lngRequestStarted = TimeFactory.getTime();
        this.intLines = 0;
        this.hshHeader = new Hashtable();
        this.strURLAbsolute = "";
        this.strAction = "GET";
        this.strURL = "/";
        this.strQuery = "";
        this.strQueryUnEscaped = "";
        this.strProtocol = "HTTP/1.1";
        this.strHost = "";
        this.strVHost = "";
        this.intPost = 80;
        this.strUserAgent = "";
        this.strReferer = "";
        this.strConnection = "";
        this.strRange = "";
        this.lngIfModifiedSince = -1L;
        this.qrAccept = new QualityRanking[0];
        this.qrAccept_Language = new QualityRanking[0];
        this.qrAccept_Encoding = new QualityRanking[0];
        this.qrAccept_Charset = new QualityRanking[0];
        this.lngContentLength = 0L;
        this.strCookies = "";
        this.hshCookies = new Hashtable();
        this.strContentType = "";
        this.strAuthorization_Type = "";
        this.strAuthorization_User = "";
        this.strAuthorization_Pass = "";
    }

    public boolean loadHeader(LogContext logContext) {
        int intLinesRead = 0;
        while (true) {
            String strLine = null;
            try {
                strLine = this.crlfisRequest.readCRLFLine();
            }
            catch (IOException iOException) {
                return false;
            }
            ++intLinesRead;
            if (logContext != null) {
                logContext.write("H I:" + strLine);
            }
            if (strLine.length() == 0) break;
            this.parseHeaderLine(strLine);
        }
        return intLinesRead > 0;
    }

    private void parseAuth(String string) {
        int pp = string.indexOf(" ");
        if (pp == -1) {
            return;
        }
        String strMethod = string.substring(0, pp).trim();
        String strAuth = string.substring(pp + 1).trim();
        if (strMethod.equalsIgnoreCase("Basic")) {
            Encoding enc = Encoding.createEncodingInstance((String)"base64");
            strAuth = enc.decodeString(strAuth);
            pp = strAuth.indexOf(":");
            if (pp == -1) {
                return;
            }
            this.strAuthorization_Type = "BASIC";
            this.strAuthorization_User = strAuth.substring(0, pp).trim();
            this.strAuthorization_Pass = strAuth.substring(pp + 1).trim();
            return;
        }
    }

    private void parseCookie(String string) {
        String strArg;
        if (!string.endsWith(";")) {
            strArg = String.valueOf(string) + ";";
        }
        StringTokenizer strt = new StringTokenizer(strArg, ";");
        while (strt.hasMoreTokens()) {
            String strKey = strt.nextToken().trim();
            String strData = "";
            int pp = strKey.indexOf("=");
            if (pp == -1) {
                this.hshCookies.remove(strKey);
                continue;
            }
            strData = strKey.substring(pp + 1).trim();
            strKey = strKey.substring(0, pp).trim();
            if (strData.length() == 0) {
                this.hshCookies.remove(strKey);
                continue;
            }
            this.hshCookies.put(strKey, strData);
        }
        StringBuffer strb = new StringBuffer();
        Enumeration e = this.hshCookies.keys();
        while (e.hasMoreElements()) {
            String strKey = (String)e.nextElement();
            String strData = (String)this.hshCookies.get(strKey);
            strb.append(strKey);
            strb.append("=");
            strb.append(strData);
            strb.append("; ");
        }
        this.strCookies = strb.toString();
    }

    private void parseHeaderLine(String strLine) {
        ++this.intLines;
        int pp = strLine.indexOf(":");
        String strCmd = "";
        String strArg = "";
        double dblArg = 0.0;
        if (pp == -1) {
            strCmd = strLine.trim().toLowerCase();
        } else {
            strCmd = strLine.substring(0, pp).trim().toLowerCase();
            strArg = strLine.substring(pp + 1).trim();
        }
        try {
            dblArg = Double.valueOf(strArg);
        }
        catch (NumberFormatException numberFormatException) {}
        if (this.intLines == 1) {
            StringTokenizer strt = new StringTokenizer(strLine, " ");
            if (strt.hasMoreTokens()) {
                this.strAction = strt.nextToken().toUpperCase();
            }
            if (strt.hasMoreTokens()) {
                this.strURL = strt.nextToken();
            }
            if (strt.hasMoreTokens()) {
                this.strProtocol = strt.nextToken().toUpperCase();
            }
            this.parseQuery();
            return;
        }
        if (!this.hshHeader.containsKey(strCmd)) {
            this.hshHeader.put(strCmd, new String[]{strArg});
        } else {
            String[] strOld = (String[])this.hshHeader.get(strCmd);
            String[] strNew = new String[strOld.length + 1];
            System.arraycopy(strOld, 0, strNew, 0, strOld.length);
            this.hshHeader.put(strCmd, strNew);
        }
        if (strCmd.equals("host")) {
            this.strHost = strArg;
            pp = strArg.indexOf(":");
            this.strVHost = pp == -1 ? strArg : strArg.substring(0, pp);
            return;
        }
        if (strCmd.equals("user-agent")) {
            this.strUserAgent = strArg;
            return;
        }
        if (strCmd.equals("referer")) {
            this.strReferer = strArg;
            return;
        }
        if (strCmd.equals("connection")) {
            this.strConnection = strArg;
            return;
        }
        if (strCmd.equals("range")) {
            this.strRange = strArg;
            return;
        }
        if (strCmd.equals("accept")) {
            this.qrAccept = this.parseQR(strArg, this.qrAccept);
            return;
        }
        if (strCmd.equals("accept-language")) {
            this.qrAccept_Language = this.parseQR(strArg, this.qrAccept_Language);
            return;
        }
        if (strCmd.equals("accept-encoding")) {
            this.qrAccept_Encoding = this.parseQR(strArg, this.qrAccept_Encoding);
            return;
        }
        if (strCmd.equals("accept-charset")) {
            this.qrAccept_Charset = this.parseQR(strArg, this.qrAccept_Charset);
            return;
        }
        if (strCmd.equals("if-modified-since")) {
            this.lngIfModifiedSince = Helper.fromHTTPDate(strArg);
            return;
        }
        if (strCmd.equals("content-length")) {
            this.lngContentLength = (long)dblArg;
            return;
        }
        if (strCmd.equals("cookie")) {
            this.parseCookie(strArg);
            return;
        }
        if (strCmd.equals("content-type")) {
            this.strContentType = strArg;
            return;
        }
        if (strCmd.equals("authorization")) {
            this.parseAuth(strArg);
            return;
        }
    }

    public QualityRanking[] parseQR(String str, QualityRanking[] qualityRankingArray) {
        QualityRanking[] qrOld;
        if (qualityRankingArray == null) {
            qrOld = new QualityRanking[]{};
        }
        if (str.length() == 0) {
            return qrOld;
        }
        Vector<QualityRanking> v = new Vector<QualityRanking>(qrOld.length + 1, 1);
        int i = 0;
        while (i < qrOld.length) {
            v.addElement(qrOld[i]);
            ++i;
        }
        StringTokenizer strt1 = new StringTokenizer(str, ",");
        while (strt1.hasMoreTokens()) {
            QualityRanking q = new QualityRanking();
            String strToken = String.valueOf(strt1.nextToken().trim()) + ";";
            StringTokenizer strt2 = new StringTokenizer(strToken, ";");
            q.strToken = strt2.nextToken().toLowerCase();
            while (strt2.hasMoreTokens()) {
                String strParam = strt2.nextToken();
                if (!strParam.startsWith("q=")) continue;
                strParam = strParam.substring("q=".length()).trim();
                try {
                    q.dblRank = Double.valueOf(strParam);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            v.addElement(q);
        }
        HelperSort.quick(v, (Comparator)new QualityComparator());
        Object[] qr = new QualityRanking[v.size()];
        v.copyInto(qr);
        return qr;
    }

    private void parseQuery() {
        int pp = this.strURL.indexOf("?");
        if (pp == -1) {
            return;
        }
        this.strQueryUnEscaped = this.strURL.substring(pp + 1);
        this.strQuery = Helper.fromHexURL(this.strQueryUnEscaped);
        this.strURL = this.strURL.substring(0, pp);
    }

    public String qrtoString(QualityRanking[] qr) {
        if (qr == null) {
            return "<not assigned>";
        }
        StringBuffer strb = new StringBuffer();
        int i = 0;
        while (i < qr.length) {
            if (qr[i] != null) {
                strb.append(qr[i].toString());
                strb.append(", ");
            }
            ++i;
        }
        if (strb.length() > 2) {
            strb.setLength(strb.length() - 2);
        }
        return strb.toString();
    }

    public String toString() {
        StringBuffer strb = new StringBuffer();
        strb.append("Action    : " + this.strAction + "\r\n");
        strb.append("URL       : " + this.strURL + "\r\n");
        strb.append("Protocol  : " + this.strProtocol + "\r\n");
        strb.append("Host      : " + this.strHost + "\r\n");
        strb.append("V-Host    : " + this.strVHost + "\r\n");
        strb.append("User-Agent: " + this.strUserAgent + "\r\n");
        strb.append("Query     : " + this.strQuery + "\r\n");
        strb.append("Accept         : " + this.qrtoString(this.qrAccept) + "\r\n");
        strb.append("Accept-Language: " + this.qrtoString(this.qrAccept_Language) + "\r\n");
        strb.append("Accept-Encoding: " + this.qrtoString(this.qrAccept_Encoding) + "\r\n");
        strb.append("Accept-Charset : " + this.qrtoString(this.qrAccept_Charset) + "\r\n");
        return strb.toString();
    }
}

