/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.response;

import de.zwanzigeins.util.TimeFactory;
import java.io.OutputStream;
import java.util.Vector;
import net.zerotoaster.httpd.util.Helper;

public class Http_Response
implements Cloneable {
    public long lngRequestFinished = 0L;
    public OutputStream osResponse = null;
    public String strLocation;
    private Vector vecAddSingleHeader = new Vector();
    private Vector vecAddMultipleHeader = new Vector();
    public String strProtocol;
    public int intStatusCode;
    public String strStatusCode;
    public String strDate;
    public String strServer;
    public String strConnection;
    public String strContentType;
    public String strContentEncoding;
    public String strContentRange;
    public String strVary;
    public long lngContentLength;
    public long lngLastModified;
    public long lngTransferredBytes;
    public String strWWWAuthenticate_Method;
    public String strWWWAuthenticate_Space;

    public Http_Response() {
        this.init();
    }

    public void addMultipleHeader(String strKey, String strData) {
        if (strKey == null || strKey.length() == 0) {
            return;
        }
        if (strData == null || strData.length() == 0) {
            return;
        }
        this.vecAddMultipleHeader.addElement(String.valueOf(strKey) + ": " + strData);
    }

    public void addSingleHeader(String strKey, String strData) {
        if (strKey == null || strKey.length() == 0) {
            return;
        }
        if (strData == null || strData.length() == 0) {
            return;
        }
        int idx = this.getHeaderIdx(strKey);
        if (idx == -1) {
            this.vecAddSingleHeader.addElement(String.valueOf(strKey) + ": " + strData);
            return;
        }
        String strCurrent = (String)this.vecAddSingleHeader.elementAt(idx);
        if (!(strCurrent = strCurrent.trim()).endsWith(";")) {
            strCurrent = String.valueOf(strCurrent) + "; ";
        }
        strCurrent = String.valueOf(strCurrent) + strData;
        this.vecAddSingleHeader.setElementAt(strCurrent, idx);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean containsHeader(String strKey) {
        return this.getHeaderIdx(strKey) != -1;
    }

    public String[] getHeader() {
        Vector<String> vecRes = new Vector<String>(25, 5);
        vecRes.addElement(String.valueOf(this.strProtocol) + " " + this.intStatusCode + " " + this.strStatusCode + "\r\n");
        vecRes.addElement("Date: " + this.strDate + "\r\n");
        vecRes.addElement("Server: " + this.strServer + "\r\n");
        vecRes.addElement("Connection: " + this.strConnection + "\r\n");
        if (this.strContentType.length() != 0) {
            vecRes.addElement("Content-Type: " + this.strContentType + "\r\n");
        }
        if (this.strContentEncoding.length() != 0) {
            vecRes.addElement("Content-Encoding: " + this.strContentEncoding + "\r\n");
        }
        if (this.strContentRange.length() != 0) {
            vecRes.addElement("Content-Range: " + this.strContentRange + "\r\n");
        }
        if (this.strVary.length() != 0) {
            vecRes.addElement("Vary: " + this.strVary + "\r\n");
        }
        if (this.lngContentLength != -1L) {
            vecRes.addElement("Content-Length: " + this.lngContentLength + "\r\n");
        }
        if (this.strLocation.length() != 0) {
            vecRes.addElement("Location: " + this.strLocation + "\r\n");
        }
        if (this.lngLastModified != -1L) {
            vecRes.addElement("Last-Modified: " + Helper.toHTTPDate(this.lngLastModified) + "\r\n");
        }
        if (this.strWWWAuthenticate_Method.length() != 0 && this.strWWWAuthenticate_Space.length() != 0) {
            vecRes.addElement("WWW-authenticate: " + this.strWWWAuthenticate_Method + " realm=\"" + this.strWWWAuthenticate_Space + "\"" + "\r\n");
        }
        int i = 0;
        while (i < this.vecAddSingleHeader.size()) {
            String s = (String)this.vecAddSingleHeader.elementAt(i);
            int pp = s.indexOf(":");
            if (pp != -1) {
                String strCmp = s.substring(0, pp + 1);
                boolean blnFound = false;
                int h = 0;
                while (h < vecRes.size()) {
                    if (((String)vecRes.elementAt(h)).startsWith(strCmp)) {
                        vecRes.setElementAt(String.valueOf(s) + "\r\n", h);
                        blnFound = true;
                        break;
                    }
                    ++h;
                }
                if (!blnFound) {
                    vecRes.addElement(String.valueOf(s.trim()) + "\r\n");
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.vecAddMultipleHeader.size()) {
            vecRes.addElement(String.valueOf(((String)this.vecAddMultipleHeader.elementAt(i)).trim()) + "\r\n");
            ++i;
        }
        vecRes.addElement("\r\n");
        Object[] s = new String[vecRes.size()];
        vecRes.copyInto(s);
        return s;
    }

    private int getHeaderIdx(String string) {
        String strKey = String.valueOf(string.toLowerCase()) + ":";
        int i = 0;
        while (i < this.vecAddSingleHeader.size()) {
            String s = (String)this.vecAddSingleHeader.elementAt(i);
            if ((s = s.toLowerCase()).startsWith(strKey)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void init() {
        this.strLocation = "";
        this.lngRequestFinished = TimeFactory.getTime();
        this.vecAddSingleHeader.removeAllElements();
        this.vecAddMultipleHeader.removeAllElements();
        this.strProtocol = "HTTP/1.1";
        this.intStatusCode = 0;
        this.strStatusCode = "";
        this.strDate = Helper.toHTTPDate(TimeFactory.getTime());
        this.strServer = "ZeroToaster::HTTPD 1.63";
        this.strConnection = "close";
        this.strContentType = "";
        this.strContentEncoding = "";
        this.strContentRange = "";
        this.strVary = "";
        this.lngContentLength = -1L;
        this.lngLastModified = -1L;
        this.lngTransferredBytes = -1L;
        this.strWWWAuthenticate_Method = "";
        this.strWWWAuthenticate_Space = "";
    }

    public void setSingleHeader(String strKey, String strData) {
        if (strKey == null || strKey.length() == 0) {
            return;
        }
        if (strData == null || strData.length() == 0) {
            return;
        }
        int idx = this.getHeaderIdx(strKey);
        if (idx == -1) {
            this.vecAddSingleHeader.addElement(String.valueOf(strKey) + ": " + strData);
        } else {
            this.vecAddSingleHeader.setElementAt(String.valueOf(strKey) + ": " + strData, idx);
        }
    }

    public String toString() {
        StringBuffer strb = new StringBuffer();
        String[] s = this.getHeader();
        int i = 0;
        while (i < s.length) {
            strb.append(s[i]);
            ++i;
        }
        return strb.toString();
    }
}

