/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.servlet;

import java.security.Principal;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.zerotoaster.httpd.servlet.HttpSession_Impl;
import net.zerotoaster.httpd.servlet.IntermediateServletData;
import net.zerotoaster.httpd.servlet.ServletRequest_Impl;
import net.zerotoaster.httpd.util.Helper;
import sun.security.acl.PrincipalImpl;

public class HttpServletRequest_Impl
extends ServletRequest_Impl
implements HttpServletRequest {
    private Cookie[] cookies = null;

    public HttpServletRequest_Impl(IntermediateServletData reqdat) {
        super(reqdat);
        reqdat.srvlReqHTTP = this;
    }

    public String getAuthType() {
        return this.reqdat.reqHTTP.strAuthorization_Type;
    }

    public String getContextPath() {
        return "";
    }

    public Cookie[] getCookies() {
        int intCookieVersion = 0;
        if (this.reqdat.reqHTTP.strCookies.length() == 0) {
            return null;
        }
        if (this.cookies != null) {
            return this.cookies;
        }
        String strCookieList = this.reqdat.reqHTTP.strCookies;
        Vector<Cookie> vecCookies = new Vector<Cookie>();
        int length = strCookieList.length();
        int start = 0;
        while (start < length) {
            int end = strCookieList.indexOf(61, start);
            if (end == -1) break;
            String name = strCookieList.substring(start, end);
            start = end + 1;
            int nextAttSep = strCookieList.indexOf(59, start);
            int nextCookieSep = strCookieList.indexOf(44, start);
            end = nextCookieSep > start && nextCookieSep < nextAttSep ? nextCookieSep : nextAttSep;
            if (end < 0) {
                end = length;
            }
            String value = strCookieList.substring(start, end);
            start = end + 1;
            name = name.trim();
            if ((value = value.trim()).endsWith(";") || value.endsWith(",")) {
                value = value.substring(0, value.length() - 1);
            }
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            if (name.startsWith("$")) {
                Cookie last;
                if (name.equalsIgnoreCase("$Version")) {
                    try {
                        intCookieVersion = Integer.parseInt(value);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (name.equalsIgnoreCase("$Path")) {
                    last = (Cookie)vecCookies.lastElement();
                    if (last == null) continue;
                    last.setPath(value);
                    continue;
                }
                if (!name.equalsIgnoreCase("$Domain") || (last = (Cookie)vecCookies.lastElement()) == null) continue;
                last.setDomain(value);
                continue;
            }
            Cookie cookie = new Cookie(name, value);
            if (intCookieVersion > 0) {
                cookie.setVersion(intCookieVersion);
            }
            vecCookies.addElement(cookie);
        }
        if (vecCookies.size() == 0) {
            return null;
        }
        Object[] c = new Cookie[vecCookies.size()];
        vecCookies.copyInto(c);
        return c;
    }

    public long getDateHeader(String strHeaderName) {
        String strTmp = this.getHeader(strHeaderName);
        if (strTmp == null) {
            return -1L;
        }
        return Helper.fromHTTPDate(strTmp);
    }

    public String getHeader(String strHeaderName) {
        String[] s = this.reqdat.reqHTTP.getHeaderElement(strHeaderName);
        if (s == null) {
            return null;
        }
        return s[0];
    }

    public Enumeration getHeaderNames() {
        return this.reqdat.reqHTTP.getHeaderAsHashtable().keys();
    }

    public Enumeration getHeaders(String strHeaderName) {
        String[] s = this.reqdat.reqHTTP.getHeaderElement(strHeaderName);
        Vector<String> v = new Vector<String>();
        if (s != null) {
            int i = 0;
            while (i < s.length) {
                v.addElement(s[i]);
                ++i;
            }
        }
        return v.elements();
    }

    public int getIntHeader(String strKey) {
        String s = this.getHeader(strKey);
        return s == null ? -1 : Integer.parseInt(s);
    }

    public String getMethod() {
        return this.reqdat.reqHTTP.strAction;
    }

    public String getPathInfo() {
        return this.reqdat.imd.strCgiExtraPath;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getQueryString() {
        return this.reqdat.reqHTTP.strQuery.length() == 0 ? null : this.reqdat.reqHTTP.strQuery;
    }

    public String getRemoteUser() {
        return this.reqdat.reqHTTP.strAuthorization_User.length() == 0 ? null : this.reqdat.reqHTTP.strAuthorization_User;
    }

    public String getRequestedSessionId() {
        if (this.reqdat.blnUseCookies) {
            return this.getSessionIDFromCookie();
        }
        return this.getSessionIDFromURL();
    }

    public String getRequestURI() {
        return this.reqdat.reqHTTP.strURL;
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.reqdat.reqHTTP.getRequestURL(this.reqdat.imd.intLocalServerPort));
    }

    public String getServletPath() {
        return this.reqdat.imd.strCgiScript;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean blnCreate) {
        boolean blnValidSession = this.isRequestedSessionIdValid();
        if (!blnValidSession && !blnCreate) {
            return null;
        }
        if (blnValidSession) {
            if (this.reqdat.session != null) {
                return this.reqdat.session;
            }
            String strID = this.getRequestedSessionId();
            this.reqdat.session = this.reqdat.smManager.getHttpSession(strID);
            return this.reqdat.session;
        }
        if (blnCreate) {
            this.reqdat.session = this.reqdat.smManager.createHttpSession(this);
            return this.reqdat.session;
        }
        return null;
    }

    private String getSessionIDFromCookie() {
        if (!this.reqdat.blnUseCookies) {
            return null;
        }
        String strID = null;
        Cookie[] cookies = this.getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                if (cookies[i].getName().equals(HttpSession_Impl.SESSION_IDENTIFIER)) {
                    strID = cookies[i].getValue();
                    break;
                }
                ++i;
            }
        }
        if (strID == null && this.reqdat.session != null) {
            strID = this.reqdat.session.getId();
        }
        return strID;
    }

    private String getSessionIDFromURL() {
        if (this.reqdat.blnUseCookies) {
            return null;
        }
        String strID = this.getParameter(HttpSession_Impl.SESSION_IDENTIFIER);
        if (strID == null && this.reqdat.session != null) {
            strID = this.reqdat.session.getId();
        }
        return strID;
    }

    public Principal getUserPrincipal() {
        if (this.getAuthType() == null || this.getAuthType().equals("")) {
            return null;
        }
        String strRemoteName = this.getRemoteUser();
        if (strRemoteName == null || strRemoteName.equals("")) {
            return null;
        }
        return new PrincipalImpl(strRemoteName);
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.getSessionIDFromCookie() != null;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.getSessionIDFromURL() != null;
    }

    public boolean isRequestedSessionIdValid() {
        String strID = this.getRequestedSessionId();
        if (strID == null) {
            return false;
        }
        return this.reqdat.smManager.isValid(strID);
    }

    public boolean isUserInRole(String strRole) {
        Principal pp = this.getUserPrincipal();
        return pp.getName().equalsIgnoreCase(strRole);
    }

    public String toString() {
        StringBuffer strb = new StringBuffer();
        strb.append(this.reqdat.reqHTTP.toString());
        strb.append("\r\n");
        if (this.reqdat.session != null) {
            strb.append("Session: " + this.reqdat.session.toString() + "\r\n");
        }
        return strb.toString();
    }
}

