/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.servlet;

import de.zwanzigeins.io.ExtendedBufferedOutputStream;
import de.zwanzigeins.util.TimeFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import net.zerotoaster.httpd.mods.IntermediateModuleData;
import net.zerotoaster.httpd.servlet.HttpSession_Impl;
import net.zerotoaster.httpd.servlet.IntermediateServletData;
import net.zerotoaster.httpd.servlet.ServletResponse_Impl;
import net.zerotoaster.httpd.util.Helper;

public class HttpServletResponse_Impl
extends ServletResponse_Impl
implements HttpServletResponse {
    private IntermediateModuleData imd = null;
    private boolean blnUseCookies = true;
    private Vector vecCookies = new Vector();

    public HttpServletResponse_Impl(IntermediateServletData reqdat, boolean blnWriteHeader) {
        super(reqdat, blnWriteHeader);
    }

    public void addCookie(Cookie cookie) {
        this.check_committed();
        int i = 0;
        while (i < this.vecCookies.size()) {
            Cookie co = (Cookie)this.vecCookies.elementAt(i);
            if (co.getName().equalsIgnoreCase(cookie.getName())) {
                this.vecCookies.removeElementAt(i);
                --i;
            }
            ++i;
        }
        this.vecCookies.addElement(cookie);
        Cookie[] co = this.reqdat.srvlReqHTTP.getCookies();
        if (co == null) {
            co = new Cookie[]{};
        }
        Cookie[] co_new = new Cookie[co.length + 1];
        co_new[0] = cookie;
        int i2 = 0;
        while (i2 < co.length) {
            co_new[i2 + 1] = co[i2];
            ++i2;
        }
    }

    public void addDateHeader(String strKey, long lngDate) {
        this.check_committed();
        this.reqdat.resHTTP.addSingleHeader(strKey, Helper.toHTTPDate(lngDate));
    }

    public void addHeader(String strKey, String strData) {
        this.check_committed();
        if (strKey == null || strKey.equals("")) {
            throw new IllegalArgumentException("Wrong parameter: " + strKey);
        }
        this.reqdat.resHTTP.addSingleHeader(strKey, strData);
    }

    public void addIntHeader(String strKey, int intData) {
        this.check_committed();
        this.addHeader(strKey, Integer.toString(intData));
    }

    public boolean containsHeader(String strKey) {
        return this.reqdat.resHTTP.containsHeader(strKey);
    }

    public String encodeRedirectURL(String strURL) {
        int pp1 = strURL.indexOf("?");
        int pp2 = strURL.indexOf("://");
        if (pp2 < pp1 || pp2 != -1 && pp1 == -1) {
            return strURL;
        }
        return this.encodeURL(strURL);
    }

    public String encodeRedirectUrl(String strURL) {
        return this.encodeRedirectURL(strURL);
    }

    public String encodeUrl(String strURL) {
        return this.encodeURL(strURL);
    }

    public String encodeURL(String string) {
        String strURL = string.replace('\\', '/');
        if (this.blnUseCookies) {
            return strURL;
        }
        if (this.reqdat.session == null) {
            return strURL;
        }
        if (!this.reqdat.session._getSessionData().isValidSession()) {
            return strURL;
        }
        if (strURL.indexOf("?") == -1) {
            return String.valueOf(strURL) + "?" + HttpSession_Impl.SESSION_IDENTIFIER + "=" + this.reqdat.session.getId();
        }
        int pp1 = strURL.indexOf(HttpSession_Impl.SESSION_IDENTIFIER);
        if (pp1 != -1) {
            pp1 = pp1 + HttpSession_Impl.SESSION_IDENTIFIER.length() + 1;
            int pp2 = Math.min(strURL.length(), strURL.indexOf("&", pp1));
            return String.valueOf(strURL.substring(0, pp1)) + this.reqdat.session.getId() + strURL.substring(pp2);
        }
        return String.valueOf(strURL) + "&" + HttpSession_Impl.SESSION_IDENTIFIER + "=" + this.reqdat.session.getId();
    }

    public void flushBefore() {
        if (this.reqdat.session != null && this.reqdat.session._getSessionData().isValidSession()) {
            if (this.reqdat.blnUseCookies) {
                Cookie coo = new Cookie(HttpSession_Impl.SESSION_IDENTIFIER, this.reqdat.session.getId());
                coo.setMaxAge(-1);
                this.vecCookies.addElement(coo);
            }
            this.reqdat.smManager.putHttpSession(this.reqdat.session);
        }
        StringBuffer strb = new StringBuffer();
        int i = 0;
        while (i < this.vecCookies.size()) {
            Cookie cookie = (Cookie)this.vecCookies.elementAt(i);
            strb.append(String.valueOf(cookie.getName()) + "=" + cookie.getValue());
            if (cookie.getVersion() > 0) {
                strb.append("; version=" + Integer.toString(cookie.getVersion()));
            }
            if (cookie.getPath() != null) {
                strb.append("; path=" + cookie.getPath());
            } else {
                strb.append("; path=/");
            }
            if (cookie.getComment() != null) {
                strb.append("; comment=" + cookie.getComment());
            }
            if (cookie.getDomain() != null) {
                strb.append("; domain=" + cookie.getDomain());
            }
            if (cookie.getMaxAge() > 0) {
                String strTmp = Helper.toHTTPDate(TimeFactory.getTime() + (long)cookie.getMaxAge() * 1000L);
                strb.append("; expires=" + strTmp);
                strb.append("; max-age=" + String.valueOf(cookie.getMaxAge()));
            }
            if (cookie.getSecure()) {
                strb.append("; secure");
            }
            this.reqdat.resHTTP.addMultipleHeader("Set-Cookie", strb.toString());
            strb.setLength(0);
            ++i;
        }
        super.flushBefore();
    }

    public void sendError(int intStatus) throws IOException {
        this.check_committed();
        this.sendError(intStatus, "");
    }

    public void sendError(int intStatus, String strMsg) throws IOException {
        ((ExtendedBufferedOutputStream)this.reqdat.resHTTP.osResponse).reset();
        this.setStatus(intStatus, strMsg);
        PrintWriter pw = new PrintWriter(this.reqdat.resHTTP.osResponse);
        pw.println("<html>");
        pw.println(" <head>");
        pw.println("  <title>Error " + intStatus + "</title>");
        pw.println(" </head>");
        pw.println(" <body>");
        pw.println("  An error " + intStatus + " ocurred.<br>");
        pw.println("  <hr>");
        pw.println("  <b>" + strMsg + "</b>");
        pw.println("  <hr>");
        pw.println("  ZeroToaster::HTTPD 1.63");
        pw.println(" </body>");
        pw.println("</html>");
        pw.flush();
    }

    public void sendRedirect(String string) throws IOException {
        String strURL;
        this.check_committed();
        this.reqdat.resHTTP.strLocation = strURL = this.encodeRedirectURL(string);
        this.reqdat.resHTTP.intStatusCode = 302;
        this.reqdat.resHTTP.strStatusCode = "Redirected";
    }

    public void setDateHeader(String strKey, long lngDate) {
        this.check_committed();
        this.setHeader(strKey, Helper.toHTTPDate(lngDate));
    }

    public void setHeader(String strKey, String strData) {
        this.check_committed();
        if (strKey == null || strKey.equals("")) {
            throw new IllegalArgumentException("Wrong parameter: " + strKey);
        }
        this.reqdat.resHTTP.setSingleHeader(strKey, strData);
    }

    public void setIntHeader(String strKey, int intData) {
        this.check_committed();
        this.setHeader(strKey, Integer.toString(intData));
    }

    public void setStatus(int intStatus) {
        this.check_committed();
        this.setStatus(intStatus, "");
    }

    public void setStatus(int intStatus, String strStatus) {
        this.check_committed();
        this.reqdat.resHTTP.intStatusCode = intStatus;
        this.reqdat.resHTTP.strStatusCode = strStatus;
    }

    public String toString() {
        StringBuffer strb = new StringBuffer();
        strb.append(this.reqdat.resHTTP.toString());
        strb.append("\r\n");
        strb.append("Status: " + this.reqdat.resHTTP.intStatusCode + " " + this.reqdat.resHTTP.strStatusCode + "\r\n");
        return strb.toString();
    }

    public int _getStatusCode() {
        return this.reqdat.resHTTP.intStatusCode;
    }
}

