/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.servlet;

import de.zwanzigeins.io.ExtendedBufferedOutputStream;
import de.zwanzigeins.io.ExtendedBufferedOutputStreamCallback;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import net.zerotoaster.httpd.servlet.IntermediateServletData;
import net.zerotoaster.httpd.servlet.ServletOutputStream_Impl;

public class ServletResponse_Impl
implements ServletResponse,
ExtendedBufferedOutputStreamCallback {
    protected IntermediateServletData reqdat = null;
    protected boolean blnWriteHeader = false;
    private ExtendedBufferedOutputStream osResponse = null;
    private PrintWriter pwOut = null;
    private ServletOutputStream osOut = null;
    private Locale loc = Locale.getDefault();

    public ServletResponse_Impl(IntermediateServletData reqdat, boolean blnWriteHeader) {
        this.reqdat = reqdat;
        this.blnWriteHeader = blnWriteHeader;
        this.osResponse = (ExtendedBufferedOutputStream)reqdat.resHTTP.osResponse;
        this.osResponse.setHandler((ExtendedBufferedOutputStreamCallback)this);
    }

    protected void check_committed() {
        if (this.isCommitted()) {
            throw new IllegalStateException(this.osResponse.STACKTRACE_CLOSE);
        }
    }

    public void flushBefore() {
        if (!this.blnWriteHeader) {
            return;
        }
        try {
            String[] strHeader = this.reqdat.resHTTP.getHeader();
            int i = 0;
            while (i < strHeader.length) {
                this.osResponse.write_direct(strHeader[i].getBytes());
                this.reqdat.logContextGlobal.write("H O:" + strHeader[i]);
                ++i;
            }
        }
        catch (IOException iOException) {}
        this.osResponse.setHandler(null);
    }

    public void flushBuffer() throws IOException {
        if (this.pwOut != null) {
            this.pwOut.flush();
        }
        if (this.osOut != null) {
            this.osOut.flush();
        }
        this.osResponse.flush();
    }

    public int getBufferSize() {
        return this.osResponse.getBufferSize();
    }

    public String getCharacterEncoding() {
        if (this.reqdat.resHTTP.strContentEncoding.length() == 0) {
            return "ISO-8859-1";
        }
        return this.reqdat.resHTTP.strContentEncoding;
    }

    public String getContentType() {
        if (this.reqdat.resHTTP.strContentType.length() == 0) {
            return null;
        }
        return this.reqdat.resHTTP.strContentType;
    }

    public Locale getLocale() {
        return this.loc;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.pwOut != null) {
            throw new IllegalStateException("Stream already grabbed as Writer");
        }
        if (this.osOut != null) {
            return this.osOut;
        }
        this.osOut = new ServletOutputStream_Impl((OutputStream)this.osResponse);
        return this.osOut;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.osOut != null) {
            throw new IllegalStateException("Writer already grabbed as Stream");
        }
        if (this.pwOut != null) {
            return this.pwOut;
        }
        this.pwOut = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)this.osResponse, this.getCharacterEncoding()), false);
        return this.pwOut;
    }

    public boolean isCommitted() {
        return this.osResponse.isCommitted();
    }

    public void reset() {
        this.resetBuffer();
        this.reqdat.resHTTP.init();
    }

    public void resetBuffer() {
        this.check_committed();
        this.osResponse.reset();
    }

    public void setBufferSize(int i) {
        if (this.osResponse.hasWritten()) {
            throw new IllegalStateException("Data was already written");
        }
        try {
            this.osResponse.setBufferSize(i);
        }
        catch (IOException iOException) {}
    }

    public void setCharacterEncoding(String s) {
        this.check_committed();
        this.reqdat.resHTTP.strContentEncoding = s;
    }

    public void setContentLength(int i) {
        this.check_committed();
        this.reqdat.resHTTP.lngContentLength = i;
    }

    public void setContentType(String s) {
        this.check_committed();
        this.reqdat.resHTTP.strContentType = s;
    }

    public void setLocale(Locale locale) {
        this.check_committed();
        this.loc = locale;
    }
}

