/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.servlet;

import de.zwanzigeins.sort.Comparator;
import de.zwanzigeins.sort.ComparatorString;
import de.zwanzigeins.sort.HelperSort;
import de.zwanzigeins.util.TimeFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.zerotoaster.httpd.servlet.util.ExtendedHttpServlet;
import net.zerotoaster.httpd.servlet.util.FilePart;
import net.zerotoaster.httpd.servlet.util.MultipartParser;
import net.zerotoaster.httpd.servlet.util.Part;

public class TestServlet
extends ExtendedHttpServlet {
    private HttpServletRequest req = null;
    private HttpServletResponse res = null;
    private ServletOutputStream pw = null;
    private static final String HK = "\"";
    private boolean blnIsSSIRequest = false;

    public TestServlet() {
        super(true);
    }

    private void action() throws ServletException, IOException {
        try {
            this.blnIsSSIRequest = this.req.getAttribute("net.zerotoaster.httpd.is_ssi_request") != null;
            String strAction = (String)this.req.getAttribute("action");
            if (strAction == null) {
                strAction = this.req.getParameter("action");
            }
            if (strAction == null) {
                strAction = "";
            }
            if (strAction.equals("send_bytes")) {
                this.perfTestSendBytes();
                return;
            }
            if (strAction.equals("exec_redirect")) {
                this.actionExecRedirect();
                return;
            }
            if (strAction.equals("exec_upload")) {
                this.actionExecUpload();
                return;
            }
            if (strAction.equals("getimage")) {
                this.getImage();
                return;
            }
            this.pw = this.res.getOutputStream();
            if (!this.blnIsSSIRequest) {
                this.pw.println("<html>");
                this.pw.println("<head><title>ZeroToaster::HTTPD is working</title></head>");
                this.pw.println("<body>");
                this.pw.println(String.valueOf(this.getServletContext().getServerInfo()) + "<br>");
                this.pw.println("<hr>");
            }
            this.pw.println("Requested Action=\"" + strAction + HK + "<br>");
            this.pw.println("Requestmethod=\"" + this.req.getMethod() + HK);
            this.pw.println("<hr>");
            if (strAction.equals("")) {
                this.actionListParameters();
            }
            if (strAction.equals("list_parameters")) {
                this.actionListParameters();
            }
            if (strAction.equals("list_headers")) {
                this.actionListHeaders();
            }
            if (strAction.equals("list_req_attributes")) {
                this.actionListRequestAttributes();
            }
            if (strAction.equals("list_srv_attributes")) {
                this.actionListServletAttributes();
            }
            if (strAction.equals("list_cookies")) {
                this.actionListCookies();
            }
            if (strAction.equals("list_request_methods")) {
                this.actionListRequestMethods();
            }
            if (strAction.equals("list_context_methods")) {
                this.actionListContextMethods();
            }
            if (strAction.equals("list_context_ini")) {
                this.actionListContextIni();
            }
            if (strAction.equals("list_servlet_ini")) {
                this.actionListServletIni();
            }
            if (strAction.equals("test_formpost")) {
                this.actionTestFormPost();
            }
            if (strAction.equals("test_formupload")) {
                this.actionTestFormUpload();
            }
            if (strAction.equals("test_cookies")) {
                this.actionTestCookies();
            }
            if (strAction.equals("store_cookie")) {
                this.actionStoreCookie();
            }
            if (strAction.equals("test_sessions")) {
                this.actionTestSessions();
            }
            if (strAction.equals("store_sessiondata")) {
                this.actionStoreSessionData();
            }
            if (strAction.equals("list_sessiondata")) {
                this.actionListSessionData();
            }
            if (strAction.equals("test_redirect")) {
                this.actionTestRedirect();
            }
            if (strAction.equals("test_binary")) {
                this.actionTestBinary();
            }
            if (strAction.equals("test_choice")) {
                this.actionTestChoice();
            }
            if (strAction.equals("exec_choice")) {
                this.actionExecChoice();
            }
            if (strAction.equals("test_bigdata")) {
                this.actionTestBigData();
            }
            if (strAction.equals("test_include")) {
                this.actionTestInclude();
            }
            if (strAction.equals("test_forward")) {
                this.actionTestForward();
            }
            this.writeNavigation();
            if (!this.blnIsSSIRequest) {
                this.pw.println("</body>");
                this.pw.println("</head>");
                this.pw.println("</html>");
            }
        }
        catch (IOException iOException) {}
    }

    private void actionExecChoice() throws IOException {
        this.pw.println("<pre>You selected the following entries:");
        String[] s = this.req.getParameterValues("choice");
        if (s == null) {
            this.pw.print("Nothing");
        } else {
            int i = 0;
            while (i < s.length) {
                this.pw.print("<li>" + s[i]);
                ++i;
            }
        }
        this.pw.print("</pre>");
    }

    private void actionExecRealPath() throws IOException {
        String s = String.valueOf(this.req.getParameter("translate_path")) + "\n";
        this.pw.print("<pre>");
        this.pw.print("Path entered   : " + s);
        this.pw.print("Path translated: " + this.getServletContext().getRealPath(s));
        this.pw.print("</pre>");
    }

    private void actionExecRedirect() throws IOException {
        this.res.sendRedirect(this.req.getParameter("redirect_url"));
    }

    private void actionExecUpload() throws IOException {
        this.pw = this.res.getOutputStream();
        this.pw.println("<pre>");
        this.pw.println("Content-Length: " + this.req.getContentLength());
        MultipartParser mp = new MultipartParser(this.req, 0x3200000);
        Part part = mp.readNextPart();
        while (part != null) {
            this.pw.println("");
            this.pw.println("Content: " + this.req.getContentType());
            this.pw.println(part.toString());
            if (part.isFile()) {
                FilePart fp = (FilePart)part;
                if (fp.getFileName() == null) {
                    this.pw.println("Not stored, filename was null");
                } else {
                    File flStore = new File(this.strREQ_HTDOCS, fp.getFileName());
                    fp.writeTo(flStore);
                    this.pw.println("Stored to HTDOCS (" + flStore + ")");
                }
            }
            part = mp.readNextPart();
        }
        this.pw.println("</pre>");
        this.writeNavigation();
    }

    private void actionListContextIni() throws IOException {
        Vector<String> v = new Vector<String>();
        Enumeration e = this.getServletContext().getInitParameterNames();
        while (e.hasMoreElements()) {
            v.addElement((String)e.nextElement());
        }
        HelperSort.quick(v, (Comparator)new ComparatorString());
        this.pw.print("<b>Attributes [getServletContext().getInitParameterNames()]</b><pre>");
        int i = 0;
        while (i < v.size()) {
            String s1 = (String)v.elementAt(i);
            String o = this.getServletContext().getInitParameter(s1);
            String s2 = o == null ? "(null)" : o.toString();
            this.pw.print("<li>" + s1 + "=" + s2);
            ++i;
        }
        this.pw.print("</pre>");
    }

    private void actionListContextMethods() throws IOException {
        ServletContext sc = this.getServletContext();
        this.pw.print("<b>List by methods (getServletContext()..) </b><pre>");
        this.pw.print("<li>getAttributeNames() = " + this.listEnum(sc.getAttributeNames()));
        this.pw.print("<li>getInitParameterNames() = " + this.listEnum(sc.getInitParameterNames()));
        this.pw.print("<li>getMajorVersion() = " + sc.getMajorVersion());
        this.pw.print("<li>getMimeType(\"\") = " + sc.getMimeType(""));
        this.pw.print("<li>getMinorVersion() = " + sc.getMinorVersion());
        this.pw.print("<li>getRealPath(\"\\\") = " + sc.getRealPath("\\"));
        this.pw.print("<li>getServerInfo() = " + sc.getServerInfo());
        this.pw.print("<li>getServletContextName() = " + sc.getServletContextName());
        this.pw.print("</pre>");
    }

    private void actionListCookies() throws IOException {
        this.pw.print("<b>Cookies [getCookies()]</b>");
        Cookie[] c = this.req.getCookies();
        if (c == null) {
            this.pw.print("<pre>** no cookies defined **</pre>");
            return;
        }
        this.pw.print("<blockquote><pre>");
        int i = 0;
        while (i < c.length) {
            Cookie co = c[i];
            this.pw.print("<li>");
            this.pw.println("Name   : " + co.getName());
            this.pw.println("Value  : " + co.getValue());
            this.pw.print("<i>");
            this.pw.println("MaxAge : " + co.getMaxAge());
            this.pw.println("Version: " + co.getVersion());
            this.pw.println("Comment: " + co.getComment());
            this.pw.println("Domain : " + co.getDomain());
            this.pw.println("Path   : " + co.getPath());
            this.pw.println("Secure : " + co.getSecure());
            this.pw.print("</i>");
            this.pw.print("</li>");
            ++i;
        }
        this.pw.println("</pre></blockquote>");
    }

    private void actionListHeaders() throws IOException {
        Vector<String> v = new Vector<String>();
        Enumeration e = this.req.getHeaderNames();
        while (e.hasMoreElements()) {
            v.addElement((String)e.nextElement());
        }
        HelperSort.quick(v, (Comparator)new ComparatorString());
        this.pw.print("<b>Headers [getHeaderNames()]</b><pre>");
        int i = 0;
        while (i < v.size()) {
            String s1 = (String)v.elementAt(i);
            String s2 = this.req.getHeader(s1);
            this.pw.print("<li>" + s1 + "=" + s2);
            ++i;
        }
        this.pw.print("</pre>");
    }

    private void actionListParameters() throws IOException {
        Vector<String> v = new Vector<String>();
        Enumeration e = this.req.getParameterNames();
        while (e.hasMoreElements()) {
            v.addElement((String)e.nextElement());
        }
        HelperSort.quick(v, (Comparator)new ComparatorString());
        this.pw.print("Parameterlist in QUERY_STRING:<pre>");
        int i = 0;
        while (i < v.size()) {
            String s1 = (String)v.elementAt(i);
            String s2 = this.req.getParameter(s1);
            this.pw.print("<li>" + s1 + "=" + s2);
            ++i;
        }
        this.pw.print("</pre>");
    }

    private void actionListRequestAttributes() throws IOException {
        Vector<String> v = new Vector<String>();
        Enumeration e = this.req.getAttributeNames();
        while (e.hasMoreElements()) {
            v.addElement((String)e.nextElement());
        }
        HelperSort.quick(v, (Comparator)new ComparatorString());
        this.pw.print("<b>Attributes [req.getAttributeNames()]</b><pre>");
        int i = 0;
        while (i < v.size()) {
            String s1 = (String)v.elementAt(i);
            Object o = this.req.getAttribute(s1);
            String s2 = o == null ? "(null)" : o.toString();
            this.pw.print("<li>" + s1 + "=" + s2);
            ++i;
        }
        this.pw.print("</pre>");
    }

    private void actionListRequestMethods() throws IOException {
        this.pw.print("<b>List by methods (HttpServletRequet) </b><pre>");
        this.pw.print("<li>getAuthType() = " + this.req.getAuthType());
        this.pw.print("<li>getAttributeNames() = " + this.listEnum(this.req.getAttributeNames()));
        this.pw.print("<li>getContextPath() = " + this.req.getContextPath());
        this.pw.print("<li>getCharacterEncoding() = " + this.req.getCharacterEncoding());
        this.pw.print("<li>getContentLength() = " + this.req.getContentLength());
        this.pw.print("<li>getContentType() = " + this.req.getContentType());
        this.pw.print("<li>getContextPath() = " + this.req.getContextPath());
        this.pw.print("<li>getHeaderNames() = " + this.listEnum(this.req.getHeaderNames()));
        this.pw.print("<li>getLocale() = " + this.req.getLocale());
        this.pw.print("<li>getLocales() = " + this.listEnum(this.req.getLocales()));
        this.pw.print("<li>getMethod() = " + this.req.getMethod());
        this.pw.print("<li>getParameterNames() = " + this.listEnum(this.req.getParameterNames()));
        this.pw.print("<li>getPathInfo() = " + this.req.getPathInfo());
        this.pw.print("<li>getPathTranslated() = " + this.req.getPathTranslated());
        this.pw.print("<li>getProtocol() = " + this.req.getProtocol());
        this.pw.print("<li>getQueryString() = " + this.req.getQueryString());
        this.pw.print("<li>getRemoteAddr() = " + this.req.getRemoteAddr());
        this.pw.print("<li>getRemoteHost() = " + this.req.getRemoteHost());
        this.pw.print("<li>getRemoteUser() = " + this.req.getRemoteUser());
        this.pw.print("<li>getRequestedSessionId() = " + this.req.getRequestedSessionId());
        this.pw.print("<li>getRequestURI() = " + this.req.getRequestURI());
        this.pw.print("<li>getRequestURL() = " + this.req.getRequestURL());
        this.pw.print("<li>getScheme() = " + this.req.getScheme());
        this.pw.print("<li>getServerName() = " + this.req.getServerName());
        this.pw.print("<li>getServerPort() = " + this.req.getServerPort());
        this.pw.print("<li>getServletPath() = " + this.req.getServletPath());
        this.pw.print("<li>getUserPrincipal() = " + this.req.getUserPrincipal());
        this.pw.print("<li>isSecure() = " + this.req.isSecure());
        this.pw.print("<li>isRequestedSessionIdFromCookie() = " + this.req.isRequestedSessionIdFromCookie());
        this.pw.print("<li>isRequestedSessionIdFromURL() = " + this.req.isRequestedSessionIdFromURL());
        this.pw.print("<li>isRequestedSessionIdValid() = " + this.req.isRequestedSessionIdValid());
        this.pw.print("</pre>");
    }

    private void actionListServletAttributes() throws IOException {
        Vector<String> v = new Vector<String>();
        Enumeration e = this.getServletContext().getAttributeNames();
        while (e.hasMoreElements()) {
            v.addElement((String)e.nextElement());
        }
        HelperSort.quick(v, (Comparator)new ComparatorString());
        this.pw.print("<b>Attributes [getServletContext().getAttributeNames()]</b><pre>");
        int i = 0;
        while (i < v.size()) {
            String s1 = (String)v.elementAt(i);
            Object o = this.getServletContext().getAttribute(s1);
            String s2 = o == null ? "(null)" : o.toString();
            this.pw.print("<li>" + s1 + "=" + s2);
            ++i;
        }
        this.pw.print("</pre>");
    }

    private void actionListServletIni() throws IOException {
        Vector<String> v = new Vector<String>();
        Enumeration e = this.getServletConfig().getInitParameterNames();
        while (e.hasMoreElements()) {
            v.addElement((String)e.nextElement());
        }
        HelperSort.quick(v, (Comparator)new ComparatorString());
        this.pw.print("<b>Attributes [getServletConfig().getInitParameterNames()]</b><pre>");
        int i = 0;
        while (i < v.size()) {
            String s1 = (String)v.elementAt(i);
            String o = this.getServletConfig().getInitParameter(s1);
            String s2 = o == null ? "(null)" : o.toString();
            this.pw.print("<li>" + s1 + "=" + s2);
            ++i;
        }
        this.pw.print("</pre>");
    }

    private void actionListSessionData() throws IOException {
        this.pw.println("<b>Session Data [getSession()]</b>");
        HttpSession sess = this.req.getSession(false);
        if (sess == null) {
            this.pw.println("<pre>There is no session or the session is outdated. Create one first ! ('Test Sessions')</pre>");
            return;
        }
        this.pw.println("<pre>");
        this.pw.println("ID           : " + sess.getId());
        this.pw.println("Created      : " + new Date(sess.getCreationTime()));
        this.pw.println("Last access  : " + new Date(sess.getLastAccessedTime()));
        this.pw.println("Invalid after: " + new Date(TimeFactory.getTime() + (long)sess.getMaxInactiveInterval()));
        if (this.req.isRequestedSessionIdFromCookie()) {
            this.pw.println("Session-ID is: stored in Cookie");
        } else {
            this.pw.println("Session-ID is: stored in URL");
        }
        this.pw.println("</pre>");
        this.pw.print("<blockquote><pre>");
        Enumeration e = sess.getAttributeNames();
        while (e.hasMoreElements()) {
            this.pw.print("<li>");
            String strKey = (String)e.nextElement();
            this.pw.print(String.valueOf(strKey) + " = " + sess.getAttribute(strKey));
        }
        this.pw.println("</pre></blockquote>");
    }

    private void actionStoreCookie() throws IOException {
        String cn = this.req.getParameter("cookie_name");
        String cv = this.req.getParameter("cookie_value");
        if (cn == null || cv == null) {
            return;
        }
        Cookie c = new Cookie(cn, cv);
        String s = null;
        s = this.req.getParameter("cookie_age");
        if (s.length() != 0) {
            c.setMaxAge(Integer.parseInt(s));
        }
        if ((s = this.req.getParameter("cookie_version")).length() != 0) {
            c.setVersion(Integer.parseInt(s));
        }
        if ((s = this.req.getParameter("cookie_comment")).length() != 0) {
            c.setComment(s);
        }
        if ((s = this.req.getParameter("cookie_domain")).length() != 0) {
            c.setDomain(s);
        }
        if ((s = this.req.getParameter("cookie_path")).length() != 0) {
            c.setPath(s);
        }
        this.res.addCookie(c);
        this.pw.print("<pre>Cookie stored - try 'List Cookies' now</pre>");
    }

    private void actionStoreSessionData() throws IOException {
        HttpSession sess = this.req.getSession(false);
        if (sess == null) {
            this.pw.println("OOPS - There is no session for us, but there should one !");
            return;
        }
        sess.setAttribute(this.req.getParameter("session_param"), (Object)this.req.getParameter("session_value"));
        this.actionListSessionData();
    }

    private void actionTestBigData() throws IOException {
        this.pw.println("<b>Testing big data</b><p>");
        this.pw.print("This is an HTML page with aprox. 1024kb in size");
        StringBuffer strb = new StringBuffer(1024);
        int i = 0;
        while (i < 1024) {
            strb.append("A");
            ++i;
        }
        String s = strb.toString();
        this.pw.print("<pre>\n");
        int i2 = 0;
        while (i2 < 1024) {
            this.pw.print(i2 + 1);
            this.pw.print(" ");
            this.pw.println(s);
            this.pw.flush();
            ++i2;
        }
        this.pw.print("</pre>\n");
    }

    private void actionTestBinary() throws IOException {
        if (this.blnIsSSIRequest) {
            this.pw.println("Binary/Image not possible when called by SSI");
            return;
        }
        this.pw.println("You should see an image here<br>");
        this.pw.println("<img src=\"" + this.res.encodeURL(String.valueOf(this.req.getServletPath()) + "?action=getimage" + HK + " name=" + HK + "testimage.jpg" + HK) + HK + ">");
    }

    private void actionTestChoice() throws IOException {
        this.pw.println("You should see a list. Select 1 or more entries<br>");
        this.pw.print("<form action=\"" + this.res.encodeURL(String.valueOf(this.req.getServletPath()) + "?action=exec_choice") + HK);
        this.pw.print(" method=\"post\">");
        this.pw.println("<select name=\"choice\" size=\"5\" multiple>");
        this.pw.println("  <option value=\"01\">Coffee</option>");
        this.pw.println("  <option value=\"02\">Tea</option>");
        this.pw.println("  <option value=\"03\">Water</option>");
        this.pw.println("  <option value=\"04\">Beer</option>");
        this.pw.println("  <option value=\"05\">Wine (red)</option>");
        this.pw.println("  <option value=\"06\">Wine (white)</option>");
        this.pw.println("  <option value=\"07\">Vodka</option>");
        this.pw.println("  <option value=\"08\">Tequilla</option>");
        this.pw.println("  <option value=\"09\">Sake</option>");
        this.pw.println("  <option value=\"10\">Rum</option>");
        this.pw.println("</select>");
        this.pw.print(" <input type=\"submit\" value=\"Send\">");
        this.pw.print("</form>");
    }

    private void actionTestCookies() throws IOException {
        this.pw.println("<b>Testing cookies</b><p>");
        this.pw.print("<form action=\"" + this.res.encodeURL(String.valueOf(this.req.getServletPath()) + "?action=store_cookie") + HK);
        this.pw.print("method=\"post\">\n");
        this.pw.print("<pre>\n");
        this.pw.print("Name    <input type=\"text\" name=\"cookie_name\" size=\"20\" maxlength=\"20\"> (text) \n");
        this.pw.print("Value   <input type=\"text\" name=\"cookie_value\" size=\"20\" maxlength=\"20\"> (text) \n");
        this.pw.print("Max age <input type=\"text\" name=\"cookie_age\" size=\"20\" maxlength=\"20\"> (numeric, seconds; -1 = Browsersession only) \n\n");
        this.pw.print("Version <input type=\"text\" name=\"cookie_version\" size=\"5\" maxlength=\"5\"> (numeric)\n");
        this.pw.print("Comment <input type=\"text\" name=\"cookie_comment\" size=\"20\" maxlength=\"20\"> (text) \n\n");
        this.pw.print("Domain  <input type=\"text\" name=\"cookie_domain\" size=\"20\" maxlength=\"20\"> (text, you must know what you're doing here !) \n");
        this.pw.print("Path    <input type=\"text\" name=\"cookie_path\" size=\"20\" maxlength=\"20\"> (text. you must know what you're doing here !) \n");
        this.pw.print("</pre>\n");
        this.pw.print("<input TYPE=\"submit\" value=\"Send\"></form>\n");
    }

    private void actionTestFormPost() throws IOException {
        this.pw.println("<b>Testing forms</b><p>");
        this.pw.print("<form action=\"" + this.res.encodeURL(String.valueOf(this.req.getServletPath()) + "?action=list_parameters") + HK);
        this.pw.print("method=\"post\">\n");
        this.pw.print("Value 1: <input type=\"text\" name=\"form_field_1\" size=\"20\" maxlength=\"20\"><br>\n");
        this.pw.print("Value 2: <input type=\"text\" name=\"form_field_2\" size=\"20\" maxlength=\"20\"><br>\n");
        this.pw.print("<input TYPE=\"submit\" value=\"Send\"></form>\n");
    }

    private void actionTestFormUpload() throws IOException {
        this.pw.println("<b>Testing upload (multipart/form-data)</b><p>");
        this.pw.print("<form enctype=\"multipart/form-data\" action=\"" + this.res.encodeURL(String.valueOf(this.req.getServletPath()) + "?action=exec_upload") + HK);
        this.pw.print("method=\"post\">\n");
        this.pw.print("File: <input type=\"file\" name=\"upload_file\" size=\"20\" maxlength=\"20\"><br>\n");
        this.pw.print("Text: <input type=\"text\" name=\"upload_text\" size=\"20\" maxlength=\"20\">\n");
        this.pw.print("<input TYPE=\"submit\" value=\"Send\"></form>\n");
    }

    private void actionTestForward() throws ServletException, IOException {
        this.pw.println("if you see this, something went wrong (1).");
        RequestDispatcher rd = this.getServletContext().getNamedDispatcher("testforward?parameter=value");
        rd.forward((ServletRequest)this.req, (ServletResponse)this.res);
        this.pw.println("if you see this, something went wrong (2).");
    }

    private void actionTestInclude() throws ServletException, IOException {
        this.pw.println("<b>Testing include</b><br>");
        this.pw.println("include starts");
        this.pw.println("<hr><pre>");
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher("net.zerotoaster.httpd.servlet.TestForward?parameter=value");
        rd.include((ServletRequest)this.req, (ServletResponse)this.res);
        this.pw.println("</pre><hr>");
        this.pw.println("include ends");
    }

    private void actionTestRedirect() throws IOException {
        this.pw.println("<b>Testing redirect</b><p>");
        this.pw.print("<form action=\"" + this.res.encodeURL(String.valueOf(this.req.getServletPath()) + "?action=exec_redirect") + HK);
        this.pw.print("method=\"post\">\n");
        this.pw.print("<pre>\n");
        this.pw.print("URL to redirect: <input type=\"text\" name=\"redirect_url\" size=\"50\" maxlength=\"50\"><br> (Protocol, URL, path... like http://www.zerotoaster.net) \n");
        this.pw.print("</pre>\n");
        this.pw.print("<input TYPE=\"submit\" value=\"Send\"></form>\n");
    }

    private void actionTestSessions() throws IOException {
        this.pw.println("<b>Testing sessiondata</b><p>");
        HttpSession sess = this.req.getSession();
        if (sess.isNew()) {
            this.pw.println("A new session with ID '" + sess.getId() + "' was created for you");
        } else {
            this.pw.println("An existing session with ID '" + sess.getId() + "' is used");
        }
        this.pw.print("<form action=\"" + this.res.encodeURL(String.valueOf(this.req.getServletPath()) + "?action=store_sessiondata") + HK);
        this.pw.print("method=\"post\">\n");
        this.pw.print("<pre>\n");
        this.pw.print("Name    <input type=\"text\" name=\"session_param\" size=\"20\" maxlength=\"20\"> (text) \n");
        this.pw.print("Value   <input type=\"text\" name=\"session_value\" size=\"20\" maxlength=\"20\"> (text) \n");
        this.pw.print("</pre>\n");
        this.pw.print("<input TYPE=\"submit\" value=\"Send\"></form>\n");
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.req = req;
        this.res = res;
        this.action();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.req = req;
        this.res = res;
        this.action();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.req = req;
        this.res = res;
        this.action();
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.req = req;
        this.res = res;
        this.action();
    }

    private void getImage() throws IOException {
        String strFile = "testpic.jpg";
        this.res.setContentType(this.getServletContext().getMimeType(strFile));
        this.res.setContentLength(-1);
        InputStream is = this.getServletContext().getResourceAsStream(strFile);
        if (is == null) {
            this.res.sendError(404, "Cannot load image");
            return;
        }
        ServletOutputStream sos = this.res.getOutputStream();
        byte[] buffer = new byte[512];
        int i = -1;
        int intSize = 0;
        try {
            while ((i = is.read(buffer)) != -1) {
                sos.write(buffer, 0, i);
                intSize += i;
            }
            sos.flush();
        }
        catch (IOException iOException) {
            this.res.sendError(404, "Cannot load image");
            return;
        }
    }

    private String listEnum(Enumeration e) {
        StringBuffer strb = new StringBuffer();
        strb.append("{");
        while (e.hasMoreElements()) {
            strb.append(e.nextElement());
            if (!e.hasMoreElements()) continue;
            strb.append(",");
        }
        strb.append("}");
        return strb.toString();
    }

    private void perfTestSendBytes() throws IOException {
        String s = this.req.getParameter("size");
        int i = -1;
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RuntimeException("Illegal 'size' argument");
        }
        this.res.getOutputStream().write(new byte[i]);
    }

    private void writeButtonPOST(String strLabel, String strAction) throws IOException {
        this.pw.print("<form action=\"" + this.res.encodeURL(String.valueOf(this.req.getServletPath()) + "?" + strAction) + HK);
        this.pw.print(" method=\"post\">");
        this.pw.print(" <input type=\"submit\" value=\"" + strLabel + HK + ">");
        this.pw.print("</form>");
    }

    private void writeLabelGET(String strLabel, String strAction) throws IOException {
        this.pw.print("<a href=\"" + this.res.encodeURL(String.valueOf(this.req.getServletPath()) + "?action=" + strAction) + HK + ">");
        this.pw.print(strLabel);
        this.pw.print("</a>&nbsp;");
    }

    private void writeNavigation() throws IOException {
        this.pw.print("<hr>");
        this.pw.print("<table cellspacing=0 cellpadding=3 border=1>\n");
        this.pw.print("<tr>\n");
        this.pw.print("<td colspan=\"4\" align=\"center\">Navigation</td>");
        this.pw.print("</tr>\n");
        this.pw.print("<tr>\n");
        this.pw.print("<td width=\"25%\" wrap=\"nowrap\">");
        this.writeLabelGET("List Parameters", "list_parameters");
        this.pw.print("</td>\n<td width=\"25%\" wrap=\"nowrap\">");
        this.writeLabelGET("List Headers", "list_headers");
        this.pw.print("</td>\n<td width=\"25%\" wrap=\"nowrap\">");
        this.writeLabelGET("List Request-Attributes", "list_req_attributes");
        this.pw.print("</td>\n<td width=\"25%\" wrap=\"nowrap\">");
        this.writeLabelGET("List Servlet-Attributes", "list_srv_attributes");
        this.pw.print("</td>\n");
        this.pw.print("</tr>\n");
        this.pw.print("<tr>\n");
        this.pw.print("<td width=\"25%\" wrap=\"nowrap\">");
        this.writeLabelGET("List Request Methods", "list_request_methods");
        this.pw.print("</td>\n<td width=\"25%\" wrap=\"nowrap\">");
        this.writeLabelGET("List Context Methods", "list_context_methods");
        this.pw.print("</td>\n<td width=\"25%\" wrap=\"nowrap\">");
        this.writeLabelGET("List Cookies", "list_cookies");
        this.pw.print("</td>\n<td width=\"25%\" wrap=\"nowrap\">");
        this.writeLabelGET("List Sessiondata", "list_sessiondata");
        this.pw.print("</td>");
        this.pw.print("</tr>");
        this.pw.print("<tr>\n");
        this.pw.print("<td width=\"25%\" wrap=\"nowrap\">");
        this.writeLabelGET("List Context Ini", "list_context_ini");
        this.pw.print("</td>\n<td width=\"25%\" wrap=\"nowrap\">");
        this.writeLabelGET("List Servlet Ini", "list_servlet_ini");
        this.pw.print("</td>\n<td width=\"25%\" wrap=\"nowrap\">");
        this.pw.print("&nbsp;");
        this.pw.print("</td>\n<td width=\"25%\" wrap=\"nowrap\">");
        this.pw.print("&nbsp;");
        this.pw.print("</td>\n");
        this.pw.print("</tr>\n");
        this.pw.print("<tr>");
        this.pw.print("<td width=\"25%\" wrap=\"nowrap\">");
        this.writeLabelGET("Test Form", "test_formpost");
        this.pw.print("</td>\n<td width=\"25%\" wrap=\"nowrap\">");
        this.writeLabelGET("Test Upload", "test_formupload");
        this.pw.print("</td>\n<td width=\"25%\" wrap=\"nowrap\">");
        this.writeLabelGET("Test Cookies", "test_cookies");
        this.pw.print("</td>\n<td width=\"25%\" wrap=\"nowrap\">");
        this.writeLabelGET("Test Sessions", "test_sessions");
        this.pw.print("</td>");
        this.pw.print("</tr>");
        this.pw.print("<tr>");
        this.pw.print("<td width=\"25%\" wrap=\"nowrap\">");
        this.writeLabelGET("Test Redirect", "test_redirect");
        this.pw.print("</td>\n<td width=\"25%\" wrap=\"nowrap\">");
        this.writeLabelGET("Test Binary", "test_binary");
        this.pw.print("</td>\n<td width=\"25%\" wrap=\"nowrap\">");
        this.writeLabelGET("Test Choice", "test_choice");
        this.pw.print("</td>\n<td width=\"25%\" wrap=\"nowrap\">");
        this.writeLabelGET("Test BigData", "test_bigdata");
        this.pw.print("</td>");
        this.pw.print("</tr>");
        this.pw.println("</table>");
    }
}

