/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.servlet.util;

import java.io.IOException;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import net.zerotoaster.httpd.servlet.util.FilePart;
import net.zerotoaster.httpd.servlet.util.LimitedServletInputStream;
import net.zerotoaster.httpd.servlet.util.ParamPart;
import net.zerotoaster.httpd.servlet.util.Part;

public class MultipartParser {
    private ServletInputStream in;
    private String boundary;
    private FilePart lastFilePart;
    private byte[] buf = new byte[8192];
    private static String DEFAULT_ENCODING = "ISO-8859-1";
    private String encoding = DEFAULT_ENCODING;

    public MultipartParser(HttpServletRequest req, int maxSize) throws IOException {
        this(req, maxSize, true, true);
    }

    public MultipartParser(HttpServletRequest req, int maxSize, boolean buffer, boolean limitLength) throws IOException {
        this(req, maxSize, buffer, limitLength, null);
    }

    public MultipartParser(HttpServletRequest req, int maxSize, boolean buffer, boolean limitLength, String encoding) throws IOException {
        String line;
        if (encoding != null) {
            this.setEncoding(encoding);
        }
        String type = null;
        String type1 = req.getHeader("Content-Type");
        String type2 = req.getContentType();
        if (type1 == null && type2 != null) {
            type = type2;
        } else if (type2 == null && type1 != null) {
            type = type1;
        } else if (type1 != null && type2 != null) {
            String string = type = type1.length() > type2.length() ? type1 : type2;
        }
        if (type == null || !type.toLowerCase().startsWith("multipart/form-data")) {
            throw new IOException("Posted content type isn't multipart/form-data");
        }
        int length = req.getContentLength();
        if (length > maxSize) {
            throw new IOException("Posted content length of " + length + " exceeds limit of " + maxSize);
        }
        String boundary = this.extractBoundary(type);
        if (boundary == null) {
            throw new IOException("Separation boundary was not specified");
        }
        ServletInputStream in = req.getInputStream();
        if (limitLength) {
            in = new LimitedServletInputStream(in, length);
        }
        this.in = in;
        this.boundary = boundary;
        do {
            if ((line = this.readLine()) != null) continue;
            throw new IOException("Corrupt form data: premature ending");
        } while (!line.startsWith(boundary));
    }

    private String extractBoundary(String line) {
        int index = line.lastIndexOf("boundary=");
        if (index == -1) {
            return null;
        }
        String boundary = line.substring(index + 9);
        if (boundary.charAt(0) == '\"') {
            index = boundary.lastIndexOf(34);
            boundary = boundary.substring(1, index);
        }
        boundary = "--" + boundary;
        return boundary;
    }

    private static String extractContentType(String string) throws IOException {
        String line = string.toLowerCase();
        int end = line.indexOf(";");
        if (end == -1) {
            end = line.length();
        }
        return line.substring(13, end).trim();
    }

    private String[] extractDispositionInfo(String string) throws IOException {
        String[] retval = new String[4];
        String origline = string;
        String line = origline.toLowerCase();
        int start = line.indexOf("content-disposition: ");
        int end = line.indexOf(";");
        if (start == -1 || end == -1) {
            throw new IOException("Content disposition corrupt: " + origline);
        }
        String disposition = line.substring(start + 21, end);
        if (!disposition.equals("form-data")) {
            throw new IOException("Invalid content disposition: " + disposition);
        }
        start = line.indexOf("name=\"", end);
        end = line.indexOf("\"", start + 7);
        int startOffset = 6;
        if (start == -1 || end == -1) {
            start = line.indexOf("name=", end);
            end = line.indexOf(";", start + 6);
            if (start == -1) {
                throw new IOException("Content disposition corrupt: " + origline);
            }
            if (end == -1) {
                end = line.length();
            }
            startOffset = 5;
        }
        String name = origline.substring(start + startOffset, end);
        String filename = null;
        String origname = null;
        start = line.indexOf("filename=\"", end + 2);
        end = line.indexOf("\"", start + 10);
        if (start != -1 && end != -1) {
            origname = filename = origline.substring(start + 10, end);
            int slash = Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92));
            if (slash > -1) {
                filename = filename.substring(slash + 1);
            }
        }
        retval[0] = disposition;
        retval[1] = name;
        retval[2] = filename;
        retval[3] = origname;
        return retval;
    }

    private String readLine() throws IOException {
        int result;
        StringBuffer sbuf = new StringBuffer();
        do {
            if ((result = this.in.readLine(this.buf, 0, this.buf.length)) == -1) continue;
            sbuf.append(new String(this.buf, 0, result, this.encoding));
        } while (result == this.buf.length);
        if (sbuf.length() == 0) {
            return null;
        }
        int len = sbuf.length();
        if (len >= 2 && sbuf.charAt(len - 2) == '\r') {
            sbuf.setLength(len - 2);
        } else if (len >= 1 && sbuf.charAt(len - 1) == '\n') {
            sbuf.setLength(len - 1);
        }
        return sbuf.toString();
    }

    /*
     * Unable to fully structure code
     */
    public Part readNextPart() throws IOException {
        if (this.lastFilePart != null) {
            this.lastFilePart.getInputStream().close();
            this.lastFilePart = null;
        }
        headers = new Vector<String>();
        line = this.readLine();
        if (line == null) {
            return null;
        }
        if (line.length() != 0) ** GOTO lbl21
        return null;
lbl-1000:
        // 1 sources

        {
            nextLine = null;
            getNextLine = true;
            while (getNextLine) {
                nextLine = this.readLine();
                if (nextLine != null && (nextLine.startsWith(" ") || nextLine.startsWith("\t"))) {
                    line = String.valueOf(line) + nextLine;
                    continue;
                }
                getNextLine = false;
            }
            headers.addElement(line);
            line = nextLine;
lbl21:
            // 2 sources

            ** while (line != null && line.length() > 0)
        }
lbl22:
        // 1 sources

        if (line == null) {
            return null;
        }
        name = null;
        filename = null;
        origname = null;
        contentType = "text/plain";
        enum = headers.elements();
        while (enum.hasMoreElements()) {
            headerline = (String)enum.nextElement();
            if (headerline.toLowerCase().startsWith("content-disposition:")) {
                dispInfo = this.extractDispositionInfo(headerline);
                name = dispInfo[1];
                filename = dispInfo[2];
                origname = dispInfo[3];
                continue;
            }
            if (!headerline.toLowerCase().startsWith("content-type:") || (type = MultipartParser.extractContentType(headerline)) == null) continue;
            contentType = type;
        }
        if (filename == null) {
            return new ParamPart(name, this.in, this.boundary, this.encoding);
        }
        if (filename.equals("")) {
            filename = null;
        }
        this.lastFilePart = new FilePart(name, this.in, this.boundary, contentType, filename, origname);
        return this.lastFilePart;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

