/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;

public class HttpUtils {
    static Hashtable nullHashtable = new Hashtable();

    public static StringBuffer getRequestURL(HttpServletRequest httpservletrequest) {
        StringBuffer stringbuffer = new StringBuffer();
        String s = httpservletrequest.getScheme();
        int i = httpservletrequest.getServerPort();
        String s1 = httpservletrequest.getRequestURI();
        stringbuffer.append(s);
        stringbuffer.append("://");
        stringbuffer.append(httpservletrequest.getServerName());
        if (s.equals("http") && i != 80 || s.equals("https") && i != 443) {
            stringbuffer.append(':');
            stringbuffer.append(httpservletrequest.getServerPort());
        }
        stringbuffer.append(s1);
        return stringbuffer;
    }

    private static String parseName(String s, StringBuffer stringbuffer) {
        stringbuffer.setLength(0);
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    stringbuffer.append(' ');
                    break;
                }
                case '%': {
                    try {
                        stringbuffer.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                        i += 2;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        String s1 = s.substring(i);
                        stringbuffer.append(s1);
                        if (s1.length() != 2) break;
                        ++i;
                        break;
                    }
                }
                default: {
                    stringbuffer.append(c);
                }
            }
            ++i;
        }
        return stringbuffer.toString();
    }

    public static Hashtable parsePostData(int i, ServletInputStream servletinputstream) {
        if (i <= 0) {
            return new Hashtable();
        }
        if (servletinputstream == null) {
            throw new IllegalArgumentException();
        }
        byte[] abyte0 = new byte[i];
        try {
            int k;
            int j = 0;
            do {
                if ((k = servletinputstream.read(abyte0, j, i - j)) > 0) continue;
                throw new IllegalArgumentException("Short Read");
            } while (i - (j += k) > 0);
        }
        catch (IOException ioexception) {
            throw new IllegalArgumentException(ioexception.getMessage());
        }
        try {
            String s = new String(abyte0, 0, i, "8859_1");
            return HttpUtils.parseQueryString(s);
        }
        catch (UnsupportedEncodingException unsupportedencodingexception) {
            throw new IllegalArgumentException(unsupportedencodingexception.getMessage());
        }
    }

    public static Hashtable parseQueryString(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        StringBuffer stringbuffer = new StringBuffer();
        StringTokenizer stringtokenizer = new StringTokenizer(s, "&");
        while (stringtokenizer.hasMoreTokens()) {
            String[] as;
            String s1 = stringtokenizer.nextToken();
            int i = s1.indexOf(61);
            if (i == -1) {
                throw new IllegalArgumentException();
            }
            String s2 = HttpUtils.parseName(s1.substring(0, i), stringbuffer);
            String s3 = HttpUtils.parseName(s1.substring(i + 1, s1.length()), stringbuffer);
            if (hashtable.containsKey(s2)) {
                String[] as1 = (String[])hashtable.get(s2);
                as = new String[as1.length + 1];
                int j = 0;
                while (j < as1.length) {
                    as[j] = as1[j];
                    ++j;
                }
                as[as1.length] = s3;
            } else {
                as = new String[]{s3};
            }
            hashtable.put(s2, as);
        }
        return hashtable;
    }
}

