/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.cache;

import de.zwanzigeins.cache.PrecomputedFileContentProducer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashedFileContentProducer
extends PrecomputedFileContentProducer {
    private String strAlgorithm = null;

    public HashedFileContentProducer() {
        this("MD5");
    }

    public HashedFileContentProducer(String strAlgorithm) {
        this.strAlgorithm = strAlgorithm;
    }

    public long produce(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(this.strAlgorithm);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("No such MessageDigest: " + this.strAlgorithm);
        }
        int i = 0;
        long lngProduced = 0L;
        while ((i = in.read(buffer)) != -1) {
            md.update(buffer, 0, i);
            lngProduced += (long)i;
        }
        out.write(md.digest());
        out.flush();
        return lngProduced;
    }
}

