/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.io;

import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PartialInputStream
extends FilterInputStream {
    private long lngLwbByte = 0L;
    private long lngUpbByte = 0L;
    private long lngRemaining = 0L;
    private boolean blnHadSeeked = false;

    public PartialInputStream(InputStream in, long lngLwbByte, long lngUpbByte) {
        super(in);
        this.lngLwbByte = lngLwbByte;
        this.lngUpbByte = lngUpbByte;
    }

    public int available() throws IOException {
        int i = this.in.available();
        if ((long)i > this.lngRemaining) {
            return (int)this.lngRemaining;
        }
        return i;
    }

    private void firstSkip() throws IOException {
        if (this.blnHadSeeked) {
            return;
        }
        this.in.skip(this.lngLwbByte);
        this.lngRemaining = this.lngUpbByte - this.lngLwbByte + 1L;
        this.blnHadSeeked = true;
    }

    public static void main(String[] args) throws IOException {
        FileInputStream fis = new FileInputStream("data");
        PartialInputStream pis = new PartialInputStream(fis, 11L, 10L);
        byte[] b = new byte[255];
        int i = pis.read(b);
        fis.close();
        System.out.println("Read  : " + i);
        System.out.println("Buffer: " + new String(b, 0, i));
    }

    public int read() throws IOException {
        this.firstSkip();
        --this.lngRemaining;
        if (this.lngRemaining < 0L) {
            return -1;
        }
        return this.in.read();
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int off, int n) throws IOException {
        int len;
        this.firstSkip();
        if (this.lngRemaining == 0L) {
            return -1;
        }
        if (this.lngRemaining - (long)n < 0L) {
            len = (int)this.lngRemaining;
        }
        int i = this.in.read(buffer, off, len);
        this.lngRemaining -= (long)i;
        return i;
    }
}

