/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

public class ByteTokenizer {
    private byte bytDelimiter = 0;
    private byte[] bytBuffer = null;
    private int intIdx = -1;

    public ByteTokenizer(byte[] bytBuffer, byte bytDelimiter) {
        this.bytBuffer = bytBuffer;
        this.bytDelimiter = bytDelimiter;
        this.intIdx = 0;
    }

    public ByteTokenizer(byte[] bytBuffer, char chDelimiter) {
        this(bytBuffer, (byte)chDelimiter);
    }

    public boolean hasMoreTokens() {
        return this.nextDelimiterPosition() != -1;
    }

    public int nextDelimiterPosition() {
        if (this.intIdx >= this.bytBuffer.length) {
            return -1;
        }
        int intFound = -1;
        int i = this.intIdx;
        while (i < this.bytBuffer.length) {
            if (this.bytBuffer[i] == this.bytDelimiter) {
                intFound = i;
                break;
            }
            ++i;
        }
        return intFound;
    }

    public String nextToken() {
        int intNextIdx = this.nextDelimiterPosition();
        if (intNextIdx == -1) {
            return null;
        }
        int intDiff = intNextIdx - this.intIdx - 1;
        if (intDiff == -1) {
            this.intIdx = intNextIdx + 1;
            return "";
        }
        String strSub = new String(this.bytBuffer, this.intIdx, intDiff + 1);
        this.intIdx = intNextIdx + 1;
        return strSub;
    }
}

