/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

public final class FastSearch {
    private int[] dict;

    public FastSearch() {
        this(256);
    }

    public FastSearch(int intDictSize) {
        this.setDictionarySize(intDictSize);
    }

    public final int find(String txt, String pat, int intOffset) {
        int intPatLen;
        int intTxtLen = txt.length();
        int r = this.precheck(intTxtLen, intPatLen = pat.length());
        if (r != 1) {
            return r;
        }
        int intCurrPos = 0;
        if (intOffset == 0) {
            int l = this.dict.length;
            int i = 0;
            while (i < l) {
                this.dict[i] = intPatLen;
                ++i;
            }
            i = 0;
            while (i < intPatLen) {
                this.dict[pat.charAt((int)i)] = intPatLen - i;
                ++i;
            }
            intCurrPos = 0;
        } else {
            intCurrPos = intOffset;
        }
        int lim = intTxtLen - intPatLen;
        int intCnt = 0;
        while (intCurrPos <= lim) {
            intCnt = 0;
            while (intCnt < intPatLen && txt.charAt(intCurrPos + intCnt) == pat.charAt(intCnt)) {
                ++intCnt;
            }
            if (intCnt == intPatLen) {
                return intCurrPos;
            }
            intCnt = intCurrPos + intPatLen;
            if (intCnt >= intTxtLen) break;
            intCurrPos += this.dict[txt.charAt(intCurrPos + intPatLen)];
        }
        return -1;
    }

    public final int find(char[] txt, char[] pat, int intOffset) {
        int intTxtLen = txt.length;
        int intPatLen = pat.length;
        int r = this.precheck(intTxtLen, intPatLen);
        if (r != 1) {
            return r;
        }
        int intCurrPos = 0;
        if (intOffset == 0) {
            int l = this.dict.length;
            int i = 0;
            while (i < l) {
                this.dict[i] = intPatLen;
                ++i;
            }
            i = 0;
            while (i < intPatLen) {
                this.dict[pat[i]] = intPatLen - i;
                ++i;
            }
            intCurrPos = 0;
        } else {
            intCurrPos = intOffset;
        }
        int lim = intTxtLen - intPatLen;
        int intCnt = 0;
        while (intCurrPos <= lim) {
            intCnt = 0;
            while (intCnt < intPatLen && txt[intCurrPos + intCnt] == pat[intCnt]) {
                ++intCnt;
            }
            if (intCnt == intPatLen) {
                return intCurrPos;
            }
            intCnt = intCurrPos + intPatLen;
            if (intCnt >= intTxtLen) break;
            intCurrPos += this.dict[txt[intCurrPos + intPatLen]];
        }
        return -1;
    }

    private final int precheck(int intTxtLen, int intPatLen) {
        if (intTxtLen == 0) {
            return -1;
        }
        if (intPatLen == 0) {
            return 0;
        }
        if (intTxtLen < intPatLen) {
            return -1;
        }
        return 1;
    }

    public final void setDictionarySize(int intSize) {
        this.dict = new int[intSize];
    }
}

