/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.io;

import de.zwanzigeins.util.LogContext;
import java.io.IOException;
import java.util.Vector;
import net.zerotoaster.mta.io.LineReader;

public class SMTPInputReader
extends LineReader {
    private LogContext logContext = null;
    private Vector vecHeader = null;
    private boolean blnDone = false;
    private boolean blnCanStore = true;
    private String strRejectMessage = "";
    private boolean blnHadData = false;
    private boolean blnInHeader = false;

    public SMTPInputReader(LineReader lr, Vector vecHeader, LogContext logContext) {
        super(lr);
        this.vecHeader = vecHeader;
        this.logContext = logContext;
        this.blnDone = false;
        this.blnHadData = false;
        this.blnCanStore = true;
        this.blnInHeader = true;
    }

    public boolean canStore() {
        return this.blnCanStore;
    }

    public String getRejectMessage() {
        return this.strRejectMessage;
    }

    public int read() {
        throw new IllegalAccessError();
    }

    public int read(char[] cbuf, int off, int len) {
        throw new IllegalAccessError();
    }

    public String readln() throws IOException {
        if (this.blnDone) {
            return null;
        }
        String strData = "";
        if (this.vecHeader.size() > 0) {
            strData = (String)this.vecHeader.elementAt(0);
            this.vecHeader.removeElementAt(0);
            return strData;
        }
        try {
            strData = super.readln();
        }
        catch (Throwable t) {
            this.strRejectMessage = "Error reading your data (" + t.getMessage() + ")";
            this.logContext.write("? " + this.strRejectMessage, t);
            this.blnCanStore = false;
            this.blnDone = true;
            return null;
        }
        if (strData == null) {
            this.strRejectMessage = "EOS before '.' reached";
            this.blnCanStore = false;
            this.blnDone = true;
            return null;
        }
        if (this.blnInHeader && strData.trim().length() > 0) {
            this.blnHadData = true;
        }
        if (this.blnHadData && strData.length() == 0) {
            this.blnInHeader = false;
        }
        if (strData.length() == 1 && strData.charAt(0) == '.') {
            this.blnDone = true;
            if (this.blnInHeader) {
                this.strRejectMessage = "Your message doesn't contain a header, rejected";
                this.blnCanStore = false;
            }
        }
        return strData;
    }
}

