/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.mailfilters;

import java.io.Serializable;
import net.zerotoaster.mta.storage.StorageRecord;
import net.zerotoaster.mta.util.Helper;

public class BayesianFilterRecord
extends StorageRecord
implements Serializable {
    public static final String KEYDATA_APPL_RECORD = "BAYESIAN_FILTER_RECORD";
    private String strUserName = null;
    private String strWord = null;
    private int intProbability = 0;
    private boolean blnTestBody = true;
    private boolean blnTestHeader = true;
    private long lngTimesUsed = 0L;
    private long lngLastUsed = 0L;

    public BayesianFilterRecord() {
        this.init();
    }

    public long getLastUsed() {
        return this.lngLastUsed;
    }

    public int getProbability() {
        return this.intProbability;
    }

    public boolean getTestBody() {
        return this.blnTestBody;
    }

    public boolean getTestHeader() {
        return this.blnTestHeader;
    }

    public long getTimesUsed() {
        return this.lngTimesUsed;
    }

    public String getUserName() {
        return this.strUserName;
    }

    public String getWord() {
        return this.strWord;
    }

    public void init() {
        this.strUserName = "";
        this.strWord = "";
        this.intProbability = 50;
        this.blnTestBody = true;
        this.blnTestHeader = true;
        this.lngTimesUsed = 0L;
        this.lngLastUsed = 0L;
    }

    public String recordExport() {
        StringBuffer strb = new StringBuffer();
        strb.append(this.strUserName);
        strb.append('\u0014');
        strb.append(this.strWord);
        strb.append('\u0014');
        strb.append(this.intProbability);
        strb.append('\u0014');
        strb.append(this.blnTestBody);
        strb.append('\u0014');
        strb.append(this.blnTestHeader);
        strb.append('\u0014');
        strb.append(this.lngTimesUsed);
        strb.append('\u0014');
        strb.append(this.lngLastUsed);
        strb.append('\u0014');
        return strb.toString();
    }

    public void recordImport(String str) {
        this.initTokenizer(str);
        this.strUserName = this.nextToken();
        this.strWord = this.nextToken();
        this.intProbability = Integer.parseInt(this.nextToken());
        this.blnTestBody = Boolean.valueOf(this.nextToken());
        this.blnTestHeader = Boolean.valueOf(this.nextToken());
        if (this.hasMoreTokens()) {
            this.lngTimesUsed = Long.parseLong(this.nextToken());
            this.lngLastUsed = Long.parseLong(this.nextToken());
        }
    }

    public void setLastUsed(long l) {
        this.lngLastUsed = l;
    }

    public void setProbability(int i) {
        this.intProbability = i;
    }

    public void setTestBody(boolean b) {
        this.blnTestBody = b;
    }

    public void setTestHeader(boolean b) {
        this.blnTestHeader = b;
    }

    public void setTimesUsed(long l) {
        this.lngTimesUsed = l;
    }

    public void setUserName(String s) {
        this.strUserName = Helper.limit(s.toLowerCase(), 129);
    }

    public void setWord(String s) {
        this.strWord = s.toLowerCase().trim();
    }

    public String toString() {
        return String.valueOf(this.getUserName()) + "/" + this.getWord();
    }
}

