/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.main;

import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.HelperValidate;
import de.zwanzigeins.util.IP_Network;
import de.zwanzigeins.util.TimeFactory;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Vector;
import net.zerotoaster.mta.config.Configuration;
import net.zerotoaster.mta.io.LineSocket;
import net.zerotoaster.mta.io.POP3OutputWriter;
import net.zerotoaster.mta.main.ServerSocketInstance;
import net.zerotoaster.mta.main.ZeroToaster;
import net.zerotoaster.mta.storage.DomainRecord;
import net.zerotoaster.mta.storage.MailHeaderRecord;
import net.zerotoaster.mta.storage.UserRecord;
import net.zerotoaster.mta.util.Helper;

public class POP3_ServerInstance
extends ServerSocketInstance {
    private static final int CMD_NOTFOUND = 0;
    private static final int CMD_HELP = 1;
    private static final int CMD_QUIT = 2;
    private static final int CMD_NOOP = 3;
    private static final int CMD_USER = 4;
    private static final int CMD_PASS = 5;
    private static final int CMD_LAST = 6;
    private static final int CMD_RSET = 7;
    private static final int CMD_STAT = 8;
    private static final int CMD_UIDL = 9;
    private static final int CMD_LIST = 10;
    private static final int CMD_DELE = 11;
    private static final int CMD_TOP = 12;
    private static final int CMD_RETR = 13;
    private static final int CMD_LIC = 15;
    private static final int CMD_XREN = 16;
    private static final int CMD_ILLEGAL = 99;
    private static String[] CMDS = null;
    private Vector vecMails = null;
    private boolean blnLoggedIn = false;
    private UserRecord usr = null;
    private static int intInstances = 0;
    private DomainRecord domHub = null;
    private static Vector vecActiveUsers = null;

    public POP3_ServerInstance(String strInstanceID) {
        super(strInstanceID);
        this.init();
        this.kickThread();
    }

    private void cmdSend_ERR(String strMsg) throws IOException {
        if (strMsg.length() > 0) {
            this.cmdSend("-ERR " + strMsg);
        } else {
            this.cmdSend("-ERR");
        }
    }

    private void cmdSend_OK(String strMsg) throws IOException {
        if (strMsg.length() > 0) {
            this.cmdSend("+OK " + strMsg);
        } else {
            this.cmdSend("+OK");
        }
    }

    private void cmd_dele(String strInput) throws IOException {
        String strArgument = Helper.getArg(strInput);
        MailHeaderRecord mhr = this.getMailHeaderForNumber(strArgument);
        if (mhr != null) {
            mhr.setMailDeleted(true);
            this.cmdSend_OK("Mail marked for deletion");
        }
    }

    private void cmd_help(String strInput) throws IOException {
        this.cmdSend_OK("HELP");
        this.cmdSend(String.valueOf(ZeroToaster.getVersion()) + " POP3 Help");
        this.cmdSend("HELP            - this help");
        this.cmdSend("USER [username] - sets the username");
        this.cmdSend("PASS [password] - sets the password");
        this.cmdSend("QUIT            - ends this session");
        this.cmdSend("LAST            - returns '0' in every case");
        this.cmdSend("RSET            - resets all actions/deletes");
        this.cmdSend("NOOP            . does nothing");
        this.cmdSend("STAT            - returns number of mails and current size of your maildrop");
        this.cmdSend("UIDL            - returns all undeleted mails with their ID");
        this.cmdSend("UIDL [number]   - returns the ID of this message");
        this.cmdSend("LIST            - lists all undeleted messages");
        this.cmdSend("DELE [number]   - marks a message for deletion");
        this.cmdSend("TOP [number]    - returns [number] lines of the message text");
        this.cmdSend("RETR [number]   - retrieves a message");
    }

    private void cmd_illegal(String strInput) throws IOException {
        this.cmdSend_ERR("Command " + strInput + " not valid in this context");
    }

    private void cmd_last(String strInput) throws IOException {
        this.cmdSend_OK("0");
    }

    private void cmd_lic(String strInput) throws IOException {
        this.cmdSend_OK(this.cnf.lic.toString());
    }

    private void cmd_list(String strInput) throws IOException {
        String strArgument = Helper.getArg(strInput);
        if (strArgument == null) {
            this.cmdSend_OK("scan listing follows");
            int i = 0;
            while (i < this.vecMails.size()) {
                MailHeaderRecord mhr = (MailHeaderRecord)this.vecMails.elementAt(i);
                if (!mhr.getMailDeleted()) {
                    this.cmdSend(i + 1 + " " + mhr.getMailSize());
                }
                ++i;
            }
            this.cmdSend(".");
        } else {
            MailHeaderRecord mhr = this.getMailHeaderForNumber(strArgument);
            if (mhr != null) {
                this.cmdSend_OK(String.valueOf(strArgument) + " " + mhr.getMailSize());
            }
        }
    }

    private void cmd_noop(String strInput) throws IOException {
        this.cmdSend_OK("NOOP");
    }

    private void cmd_notfound(String strInput) throws IOException {
        this.cmdSend_ERR("Command \"" + strInput + "\" not found");
    }

    private void cmd_pass(String strInput) throws IOException {
        String strArgument = Helper.getArg(strInput);
        if (strArgument == null) {
            this.cmdSend_ERR("Argument missing");
            return;
        }
        strArgument = strArgument.toLowerCase();
        this.cmd_pass_user(strArgument);
    }

    private void cmd_pass_user(String strArgument) throws IOException {
        if (this.usr == null) {
            this.cmdSend_ERR("User not found");
            return;
        }
        if (!this.usr.getPassWord().equals(strArgument)) {
            this.cmdSend_ERR("Password mismatch");
            return;
        }
        if (!this.usr.getEnabled()) {
            this.cmdSend_ERR("Account disabled");
            return;
        }
        DomainRecord dom = this.smManager.domainRead(HelperExtract.splitUserName_getDomain((String)this.usr.getUserName()));
        if (dom == null) {
            this.cmdSend_ERR("Domain missing in configuration");
            return;
        }
        if (!dom.getEnable_POP3()) {
            this.cmdSend_ERR("POP3 disabled for domain");
            return;
        }
        IP_Network[] ipn = new IP_Network[]{};
        switch (this.usr.getRestrictIP_POP3()) {
            case 0: {
                break;
            }
            case 1: {
                ipn = dom.getIP_Networks();
                break;
            }
            case 2: {
                ipn = this.usr.getIP_Networks();
                break;
            }
            case 3: {
                ipn = new IP_Network[dom.getIP_Networks().length + this.usr.getIP_Networks().length];
                int ii = 0;
                int i = 0;
                while (i < dom.getIP_Networks().length) {
                    ipn[ii++] = dom.getIP_Networks()[i];
                    ++i;
                }
                i = 0;
                while (i < this.usr.getIP_Networks().length) {
                    ipn[ii++] = this.usr.getIP_Networks()[i];
                    ++i;
                }
                break;
            }
        }
        String strINA = this.lsok.getInetAddress().getHostAddress();
        boolean blnIPN_Match = ipn.length == 0;
        int i = 0;
        while (i < ipn.length) {
            Configuration.logContext.write("M " + strINA + " -> " + ipn[i]);
            if (ipn[i].match(strINA)) {
                blnIPN_Match = true;
                break;
            }
            ++i;
        }
        if (!blnIPN_Match) {
            this.cmdSend_ERR("Your IP isn't in the range of allowed networks");
            return;
        }
        if (!this.mbxLock(this.usr)) {
            this.cmdSend_ERR("You are already logged in. Please try again later");
            return;
        }
        this.usr.setPOP3_IP(this.lsok.getInetAddress().getHostAddress());
        this.usr.setPOP3_Time(TimeFactory.getTime());
        this.smManager.userWrite(this.usr);
        Configuration.logContext.write("D SMTP after POP3 timestamp updated");
        this.cmd_rset("");
        this.blnLoggedIn = true;
    }

    private void cmd_quit(String strInput) throws IOException {
        int i = 0;
        while (i < this.vecMails.size()) {
            MailHeaderRecord mhr = (MailHeaderRecord)this.vecMails.elementAt(i);
            this.smManager.mailWriteHeader(mhr);
            ++i;
        }
        try {
            this.cmdSend_OK("QUIT");
        }
        catch (Throwable throwable) {}
        this.smManager.commit();
    }

    private void cmd_retr(String string) throws IOException {
        String strInput = Helper.getArg(string).trim();
        MailHeaderRecord mhr = this.getMailHeaderForNumber(strInput);
        if (mhr == null) {
            return;
        }
        this.cmdSend_OK("Message follows");
        Configuration.logContext.write("D Sending message " + mhr.toString() + ", UID=" + mhr.getUID());
        this.smManager.mailReadBody(mhr, new POP3OutputWriter(this.lsok.getLineWriter()));
        Configuration.logContext.write("D Message " + mhr.toString() + " sent, UID=" + mhr.getUID());
        mhr.setTimeFetched(TimeFactory.getTime());
    }

    private void cmd_rset(String strInput) throws IOException {
        this.vecMails = this.smManager.mailGetHeadersForUser(this.usr.getUserName());
        long lngSize = 0L;
        int i = 0;
        while (i < this.vecMails.size()) {
            MailHeaderRecord mhr = (MailHeaderRecord)this.vecMails.elementAt(i);
            lngSize += mhr.getMailSize();
            ++i;
        }
        this.cmdSend_OK("Maildrop has " + this.vecMails.size() + " messages (" + lngSize + " octets)");
    }

    private void cmd_stat(String strInput) throws IOException {
        long lngSize = 0L;
        int intMails = 0;
        int i = 0;
        while (i < this.vecMails.size()) {
            MailHeaderRecord mhr = (MailHeaderRecord)this.vecMails.elementAt(i);
            if (!mhr.getMailDeleted()) {
                ++intMails;
                lngSize += mhr.getMailSize();
            }
            ++i;
        }
        this.cmdSend_OK(intMails + " " + lngSize + " messages/octets");
    }

    private void cmd_top(String string) throws IOException {
        String strInput = Helper.getArg(string);
        if (strInput == null) {
            this.cmdSend_ERR("Argument missing");
        }
        String strIDX = Helper.getCmd(strInput);
        String strTOP = Helper.getArg(strInput);
        if (strTOP == null) {
            this.cmdSend_ERR("Argument missing");
            return;
        }
        MailHeaderRecord mhr = this.getMailHeaderForNumber(strIDX);
        if (mhr == null) {
            return;
        }
        int intTOP = 0;
        try {
            intTOP = Integer.parseInt(strTOP);
        }
        catch (NumberFormatException numberFormatException) {
            this.cmdSend_ERR(String.valueOf(strTOP) + " is not a valid argument");
            return;
        }
        this.cmdSend_OK("Message follows");
        Configuration.logContext.write("D Sending message " + mhr.toString() + ", first " + intTOP + " lines");
        this.smManager.mailReadBody(mhr, new POP3OutputWriter(this.lsok.getLineWriter(), intTOP));
        Configuration.logContext.write("D Message " + mhr.toString() + ", first " + intTOP + " lines sent");
    }

    private void cmd_uidl(String string) throws IOException {
        String strInput = Helper.getArg(string);
        if (strInput == null) {
            this.cmdSend_OK("");
            int i = 0;
            while (i < this.vecMails.size()) {
                MailHeaderRecord mhr = (MailHeaderRecord)this.vecMails.elementAt(i);
                if (!mhr.getMailDeleted()) {
                    this.cmdSend(i + 1 + " " + mhr.getUID());
                }
                ++i;
            }
            this.cmdSend(".");
        } else {
            MailHeaderRecord mhr = this.getMailHeaderForNumber(strInput);
            if (mhr != null) {
                this.cmdSend_OK(String.valueOf(strInput) + " " + mhr.getUID());
            }
        }
    }

    private void cmd_user(String strInput) throws IOException {
        String strUserTmp;
        String strArgument = Helper.getArg(strInput);
        if (strArgument == null) {
            this.cmdSend_ERR("Argument missing");
            return;
        }
        strArgument = strArgument.toLowerCase();
        Configuration.logContext.write("# User '" + strArgument + "' is coming in");
        int pp1 = strArgument.indexOf("%");
        int pp2 = strArgument.indexOf("@");
        if (pp1 != -1 && pp2 == -1) {
            strArgument = strArgument.replace('%', '@');
        }
        if ((strUserTmp = HelperValidate.validateRFC822_User((String)strArgument)) == null) {
            this.cmdSend_ERR(String.valueOf(strInput) + " is syntactically incorrect");
            return;
        }
        this.usr = this.smManager.userRead(strUserTmp);
        this.domHub = null;
        this.cmdSend_OK("Password required for user " + strUserTmp);
    }

    private void cmd_xren(String string) throws IOException {
        if (!this.usr.getAllowXREN()) {
            this.cmdSend_ERR("Command not allowed for your account");
            return;
        }
        String strInput = Helper.getArg(string).trim();
        String strMsgNb = Helper.getCmd(strInput).trim();
        String strNewMb = Helper.getArg(strInput).trim();
        MailHeaderRecord mhr = this.getMailHeaderForNumber(strMsgNb);
        if (mhr == null) {
            return;
        }
        String s = HelperValidate.validateRFC822_User((String)strNewMb);
        if (s == null) {
            this.cmdSend_ERR("'" + strNewMb + "' is not a valid e-mail address");
            return;
        }
        strNewMb = s;
        if (this.smManager.userRead(strNewMb) == null) {
            this.cmdSend_ERR("'" + strNewMb + "' is not a user on this system");
            return;
        }
        MailHeaderRecord mhrOld = mhr;
        MailHeaderRecord mhrNew = (MailHeaderRecord)mhr.clone();
        mhrNew.recipientReset();
        mhrNew.addEnvelopeTo_Redirected(strNewMb);
        this.smManager.mailMove(mhrOld, mhrNew);
        this.cmdSend_OK("Message renamed");
        Configuration.logContext.write("D Message renamed from " + mhrOld.getEnvelopeTo_Redirected()[0] + " to " + mhrNew.getEnvelopeTo_Redirected()[0]);
        mhr.recipientReset();
        mhr.addEnvelopeTo_Redirected(strNewMb);
    }

    public void dispose() {
        this.setThreadName();
        super.dispose();
        if (this.vecMails != null) {
            this.vecMails.removeAllElements();
            this.vecMails = null;
        }
        this.usr = null;
        this.resetThreadName();
    }

    private int getCommand(String strInput) {
        String strCmd = Helper.getCmd(strInput);
        int intCmd = 0;
        int i = 0;
        while (i < CMDS.length) {
            String strCmp = CMDS[i];
            if (strCmp != null && strCmp.equals(strCmd)) {
                intCmd = i;
                break;
            }
            ++i;
        }
        switch (intCmd) {
            case 0: 
            case 1: 
            case 2: 
            case 7: 
            case 15: {
                return intCmd;
            }
            case 4: 
            case 5: {
                if (this.blnLoggedIn) {
                    return 99;
                }
                return intCmd;
            }
            case 3: 
            case 16: {
                if (!this.blnLoggedIn) {
                    return 99;
                }
                return intCmd;
            }
        }
        if (!this.blnLoggedIn || this.domHub != null) {
            return 99;
        }
        return intCmd;
    }

    private MailHeaderRecord getMailHeaderForNumber(String strIdx) throws IOException {
        if (strIdx == null) {
            this.cmdSend_ERR("Numeric argument missing");
            return null;
        }
        int idx = 0;
        try {
            idx = Integer.parseInt(strIdx);
        }
        catch (NumberFormatException numberFormatException) {
            this.cmdSend_ERR(String.valueOf(strIdx) + " is not a number");
            return null;
        }
        if (idx < 1 || idx > this.vecMails.size()) {
            this.cmdSend_ERR("Message " + idx + " is out of range");
            return null;
        }
        MailHeaderRecord mhr = (MailHeaderRecord)this.vecMails.elementAt(idx - 1);
        if (mhr.getMailDeleted()) {
            this.cmdSend_ERR("Message " + idx + " has been marked for deletion");
            return null;
        }
        return mhr;
    }

    private void init() {
        if (CMDS == null) {
            CMDS = new String[20];
            POP3_ServerInstance.CMDS[1] = "help";
            POP3_ServerInstance.CMDS[4] = "user";
            POP3_ServerInstance.CMDS[5] = "pass";
            POP3_ServerInstance.CMDS[2] = "quit";
            POP3_ServerInstance.CMDS[6] = "last";
            POP3_ServerInstance.CMDS[7] = "rset";
            POP3_ServerInstance.CMDS[3] = "noop";
            POP3_ServerInstance.CMDS[8] = "stat";
            POP3_ServerInstance.CMDS[9] = "uidl";
            POP3_ServerInstance.CMDS[10] = "list";
            POP3_ServerInstance.CMDS[11] = "dele";
            POP3_ServerInstance.CMDS[12] = "top";
            POP3_ServerInstance.CMDS[13] = "retr";
            POP3_ServerInstance.CMDS[15] = "lic";
            POP3_ServerInstance.CMDS[16] = "xren";
            vecActiveUsers = new Vector(this.cnf.intPOP3_Instances);
        }
        this.vecMails = new Vector();
    }

    public boolean kickInstance(Object o) {
        this.lsok = (LineSocket)o;
        this.loNotify.lo_notify();
        return true;
    }

    public boolean mbxLock(UserRecord usrPOP3) {
        String strUsr = usrPOP3.getUserName();
        Vector vector = vecActiveUsers;
        synchronized (vector) {
            if (vecActiveUsers.indexOf(strUsr) == -1) {
                vecActiveUsers.addElement(strUsr);
                return true;
            }
            return false;
        }
    }

    public void mbxUnlockLock(UserRecord usrPOP3) {
        if (usrPOP3 == null) {
            return;
        }
        vecActiveUsers.removeElement(usrPOP3.getUserName());
    }

    private boolean sendWelcome() throws IOException {
        this.cmdSend_OK(String.valueOf(ZeroToaster.getVersion()) + " greets you !");
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected void service() throws IOException {
        this.cnf.statrec.intPOP3_peak = Math.max(this.cnf.statrec.intPOP3_peak, ++POP3_ServerInstance.intInstances);
        Configuration.logContext.write("# " + this.lsok.getInetAddress() + " is coming in");
        this.vecMails.removeAllElements();
        this.blnLoggedIn = false;
        this.usr = null;
        if (this.sendWelcome()) ** GOTO lbl69
        return;
lbl-1000:
        // 1 sources

        {
            strInput = null;
            try {
                strInput = this.cmdReceive();
            }
            catch (InterruptedIOException e) {
                this.cmdSend_ERR("Session timeout");
                throw e;
            }
            switch (this.getCommand(strInput)) {
                case 0: {
                    this.cmd_notfound(strInput);
                    break;
                }
                case 99: {
                    this.cmd_illegal(strInput);
                    break;
                }
                case 1: {
                    this.cmd_help(strInput);
                    break;
                }
                case 3: {
                    this.cmd_noop(strInput);
                    break;
                }
                case 7: {
                    this.cmd_rset(strInput);
                    break;
                }
                case 6: {
                    this.cmd_last(strInput);
                    break;
                }
                case 4: {
                    this.cmd_user(strInput);
                    break;
                }
                case 5: {
                    this.cmd_pass(strInput);
                    break;
                }
                case 8: {
                    this.cmd_stat(strInput);
                    break;
                }
                case 9: {
                    this.cmd_uidl(strInput);
                    break;
                }
                case 10: {
                    this.cmd_list(strInput);
                    break;
                }
                case 11: {
                    this.cmd_dele(strInput);
                    break;
                }
                case 12: {
                    this.cmd_top(strInput);
                    break;
                }
                case 13: {
                    this.cmd_retr(strInput);
                    break;
                }
                case 15: {
                    this.cmd_lic(strInput);
                    break;
                }
                case 16: {
                    this.cmd_xren(strInput);
                    break;
                }
                case 2: {
                    this.cmd_quit(strInput);
                    return;
                }
                default: {
                    this.cmdSend_ERR("You did something we never thinked about...");
                }
            }
lbl69:
            // 18 sources

            ** while (!this.blnDisposed)
        }
lbl70:
        // 1 sources

    }

    protected void servicePostProcess() {
        --intInstances;
        ++this.cnf.statrec.lngPOP3_accesses;
        this.cnf.statrec.lngPOP3_bytes += this.lsok.getBytesTotal();
        if (this.usr != null) {
            this.smManager.accountingStore("I", this.usr.getUserName(), this.lsok.getBytesReceived(), this.lsok.getBytesSent());
            this.mbxUnlockLock(this.usr);
        }
    }
}

