/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.storage;

import de.zwanzigeins.util.HelperValidate;
import de.zwanzigeins.util.IP_Network;
import java.io.Serializable;
import net.zerotoaster.mta.storage.StorageRecord;
import net.zerotoaster.mta.util.Helper;

public class FilterRecord
extends StorageRecord
implements Serializable {
    public static final int FILTER_RELAY = 1;
    public static final int FILTER_WHITELIST = 2;
    public static final int FILTER_BLACKLIST = 3;
    public static final int TYPE_USER = 1;
    public static final int TYPE_DOMAIN = 2;
    public static final int TYPE_NETWORK = 3;
    private int intFilterType = 0;
    private String strName = null;
    private String strMask = null;
    private int intType = 0;
    private String strMemo = null;
    private boolean blnAVScan;
    private boolean blnRBLcheck;

    public FilterRecord() {
        this.init();
    }

    public boolean getAVScan() {
        return this.blnAVScan;
    }

    public int getFilterType() {
        return this.intFilterType;
    }

    public String getMask() {
        return this.strMask;
    }

    public String getMemo() {
        return this.strMemo;
    }

    public String getName() {
        return this.strName;
    }

    public boolean getRBLCheck() {
        return this.blnRBLcheck;
    }

    public int getType() {
        return this.intType;
    }

    public void init() {
        this.intFilterType = 1;
        this.strName = "";
        this.strMask = "";
        this.intType = -1;
        this.strMemo = "";
        this.blnAVScan = false;
        this.blnRBLcheck = false;
    }

    public String recordExport() {
        StringBuffer strb = new StringBuffer();
        strb.append(this.intFilterType);
        strb.append('\u0014');
        strb.append(this.strName);
        strb.append('\u0014');
        strb.append(this.strMask);
        strb.append('\u0014');
        strb.append(this.intType);
        strb.append('\u0014');
        strb.append(this.strMemo);
        strb.append('\u0014');
        strb.append(this.blnAVScan);
        strb.append('\u0014');
        strb.append(this.blnRBLcheck);
        strb.append('\u0014');
        return strb.toString();
    }

    public void recordImport(String str) {
        this.initTokenizer(str);
        this.intFilterType = Integer.parseInt(this.nextToken());
        this.strName = this.nextToken();
        this.strMask = this.nextToken();
        this.intType = Integer.parseInt(this.nextToken());
        this.strMemo = this.nextToken();
        if (this.hasMoreTokens()) {
            this.blnAVScan = Boolean.valueOf(this.nextToken());
        }
        if (this.hasMoreTokens()) {
            this.blnRBLcheck = Boolean.valueOf(this.nextToken());
        }
    }

    public void setAVScan(boolean b) {
        this.blnAVScan = b;
    }

    public void setFilterType(int i) {
        this.intFilterType = i;
    }

    public void setMask(String string) {
        String s = string.toLowerCase();
        if (s.indexOf("@") != -1) {
            if (HelperValidate.validateRFC822_User((String)s) == null) {
                throw new IllegalArgumentException("Not a valid username");
            }
            this.strMask = s;
            this.intType = 1;
            return;
        }
        if (s.indexOf(",") != -1) {
            try {
                new IP_Network(s);
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException(String.valueOf(s) + " is not a valid network,netmask");
            }
            this.strMask = s;
            this.intType = 3;
            return;
        }
        if (HelperValidate.validateRFC822_Domain((String)s) == null) {
            throw new IllegalArgumentException(String.valueOf(s) + " is not a valid domain name");
        }
        this.strMask = s;
        this.intType = 2;
    }

    public void setMemo(String s) {
        this.strMemo = Helper.limit(s, 512);
    }

    public void setName(String s) {
        this.strName = s;
    }

    public void setRBLcheck(boolean b) {
        this.blnRBLcheck = b;
    }

    public String toString() {
        return this.getName();
    }
}

