/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.storage;

import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.InitializationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import net.zerotoaster.mta.config.Configuration;
import net.zerotoaster.mta.io.LineReader;
import net.zerotoaster.mta.io.LineWriter;
import net.zerotoaster.mta.io.POP3OutputWriter;
import net.zerotoaster.mta.io.RemoteFile;
import net.zerotoaster.mta.mailfilters.MailFilterChain;
import net.zerotoaster.mta.main.ZeroToaster;
import net.zerotoaster.mta.storage.DomainRecord;
import net.zerotoaster.mta.storage.FilterRecord;
import net.zerotoaster.mta.storage.MailHeaderRecord;
import net.zerotoaster.mta.storage.MailQueueRecord;
import net.zerotoaster.mta.storage.MailingListRecord;
import net.zerotoaster.mta.storage.RemoteStorageManager_Const;
import net.zerotoaster.mta.storage.StatisticsRecord;
import net.zerotoaster.mta.storage.StorageManager;
import net.zerotoaster.mta.storage.UserRecord;
import net.zerotoaster.mta.storage.VoidAnswer;
import net.zerotoaster.mta.util.Helper;

public class RemoteStorageManager_Server
extends StorageManager
implements RemoteStorageManager_Const,
Runnable {
    private ServerSocket ssok = null;
    private boolean blnRemoteRunning = false;
    private Vector vecThreads = null;
    private Thread thrdRemote = null;
    private String strLocalPassword = null;
    private StorageManager smLocal = Configuration.getStorageManager();

    protected Vector accountingReadAll_Impl() throws Throwable {
        return this.smLocal.accountingReadAll_Impl();
    }

    protected Vector accountingRead_Impl(String strID) throws Throwable {
        return this.smLocal.accountingRead_Impl(strID);
    }

    protected void accountingStore_Impl(String strID, String strUser, long lngBytesReceived, long lngBytesSent) {
        this.smLocal.accountingStore_Impl(strID, strUser, lngBytesReceived, lngBytesSent);
    }

    protected void adminForceFetchmail_Impl() throws Throwable {
        this.smLocal.adminForceFetchmail_Impl();
    }

    protected void adminFullRestart_Impl() throws Throwable {
        this.smLocal.adminFullRestart_Impl();
    }

    protected void adminRestart_Impl() throws Throwable {
        this.smLocal.adminRestart_Impl();
    }

    protected void adminShutdown_Impl() throws Throwable {
        this.smLocal.adminShutdown_Impl();
    }

    protected void cleanup_Impl(boolean blnStartupMode) throws Throwable {
        this.smLocal.cleanup_Impl(blnStartupMode);
    }

    protected void commit_Impl() throws Throwable {
        this.smLocal.commit_Impl();
    }

    private void dispatch(int intCmd, ObjectInputStream ois, ObjectOutputStream oos) throws Throwable {
        VoidAnswer voidAnswer = new VoidAnswer();
        try {
            try {
                switch (intCmd) {
                    case 1: {
                        Configuration.logContext.write("R noop");
                        oos.writeObject(voidAnswer);
                        break;
                    }
                    case 2: {
                        Configuration.logContext.write("R licence status get");
                        oos.writeObject(this.licenceCheck_Impl());
                        break;
                    }
                    case 10: {
                        Configuration.logContext.write("R domain delete");
                        this.domainDelete_Impl(ois.readUTF());
                        oos.writeObject(voidAnswer);
                        break;
                    }
                    case 12: {
                        Configuration.logContext.write("R domain read");
                        oos.writeObject(this.domainRead_Impl(ois.readUTF()));
                        break;
                    }
                    case 11: {
                        Configuration.logContext.write("R domain read all");
                        oos.writeObject(this.domainReadAll_Impl());
                        break;
                    }
                    case 13: {
                        Configuration.logContext.write("R domain write");
                        this.domainWrite_Impl((DomainRecord)ois.readObject());
                        oos.writeObject(voidAnswer);
                        break;
                    }
                    case 14: {
                        Configuration.logContext.write("R domain rename");
                        this.domainRename_Impl(ois.readUTF(), ois.readUTF());
                        oos.writeObject(voidAnswer);
                        break;
                    }
                    case 70: {
                        Configuration.logContext.write("R file delete");
                        this.fileDelete_Impl(ois.readUTF());
                        oos.writeObject(voidAnswer);
                        break;
                    }
                    case 74: {
                        Configuration.logContext.write("R file get");
                        oos.writeObject(this.fileGet_Impl(ois.readUTF()));
                        break;
                    }
                    case 73: {
                        Configuration.logContext.write("R file list");
                        oos.writeObject(this.fileList_Impl(ois.readUTF()));
                        break;
                    }
                    case 71: {
                        Configuration.logContext.write("R file load");
                        DeflaterOutputStream dos = new DeflaterOutputStream(oos);
                        this.fileLoad_Impl(ois.readUTF(), dos);
                        dos.finish();
                        oos.flush();
                        oos.writeObject(voidAnswer);
                        break;
                    }
                    case 72: {
                        Configuration.logContext.write("R file save");
                        InflaterInputStream iis = new InflaterInputStream(ois);
                        this.fileSave_Impl(ois.readUTF(), iis);
                        oos.writeObject(voidAnswer);
                        break;
                    }
                    case 67: {
                        Configuration.logContext.write("R server shutdown");
                        this.adminShutdown_Impl();
                        break;
                    }
                    case 68: {
                        Configuration.logContext.write("R server restart");
                        this.adminRestart_Impl();
                        break;
                    }
                    case 69: {
                        Configuration.logContext.write("R server full restart");
                        this.adminFullRestart_Impl();
                        break;
                    }
                    case 22: {
                        Configuration.logContext.write("R mail get headers for user");
                        oos.writeObject(this.mailGetHeadersForUser_Impl(ois.readUTF()));
                        break;
                    }
                    case 24: {
                        Configuration.logContext.write("R mail get headers to send");
                        oos.writeObject(this.mailGetHeadersToSend_Impl(ois.readInt(), ois.readLong()));
                        break;
                    }
                    case 25: {
                        Configuration.logContext.write("R mail get all headers");
                        oos.writeObject(this.mailGetAllHeaders());
                        break;
                    }
                    case 26: {
                        Configuration.logContext.write("R mail read body");
                        this.mailReadBody_Impl((MailHeaderRecord)ois.readObject(), new POP3OutputWriter(new LineWriter(oos), 50));
                        oos.flush();
                        oos.writeObject(voidAnswer);
                        break;
                    }
                    case 27: {
                        Configuration.logContext.write("R mail read header");
                        oos.writeObject(this.mailReadHeader_Impl(ois.readUTF()));
                        break;
                    }
                    case 29: {
                        Configuration.logContext.write("R mail write header");
                        this.mailWriteHeader_Impl((MailHeaderRecord)ois.readObject());
                        oos.writeObject(voidAnswer);
                        break;
                    }
                    case 30: {
                        Configuration.logContext.write("R mail write from string");
                        this.mailWriteFromString_Impl((MailHeaderRecord)ois.readObject(), ois.readUTF());
                        oos.writeObject(voidAnswer);
                        break;
                    }
                    case 31: {
                        Configuration.logContext.write("R mail move");
                        this.mailMove_Impl((MailHeaderRecord)ois.readObject(), (MailHeaderRecord)ois.readObject());
                        oos.writeObject(voidAnswer);
                        break;
                    }
                    case 51: {
                        Configuration.logContext.write("R user delete");
                        this.userDelete_Impl(ois.readUTF());
                        oos.writeObject(voidAnswer);
                        break;
                    }
                    case 53: {
                        Configuration.logContext.write("R user read");
                        oos.writeObject(this.userRead_Impl(ois.readUTF()));
                        break;
                    }
                    case 52: {
                        Configuration.logContext.write("R user read all by domain");
                        oos.writeObject(this.userReadAllByDomain_Impl(ois.readUTF()));
                        break;
                    }
                    case 54: {
                        Configuration.logContext.write("R user write");
                        this.userWrite_Impl((UserRecord)ois.readObject());
                        oos.writeObject(voidAnswer);
                        break;
                    }
                    case 60: {
                        Configuration.logContext.write("R commit");
                        this.commit();
                        oos.writeObject(voidAnswer);
                        break;
                    }
                    case 61: {
                        Configuration.logContext.write("R rollback");
                        this.rollback();
                        oos.writeObject(voidAnswer);
                        break;
                    }
                    case 62: {
                        Configuration.logContext.write("R cleanup");
                        this.cleanup(ois.readBoolean());
                        oos.writeObject(voidAnswer);
                        break;
                    }
                    case 81: {
                        Configuration.logContext.write("R stats poll");
                        oos.writeObject(this.statsGet());
                        break;
                    }
                    case 82: {
                        Configuration.logContext.write("R logging poll");
                        oos.writeObject(this.logGet());
                        break;
                    }
                    case 85: {
                        Configuration.logContext.write("R force fetchmail");
                        this.adminForceFetchmail_Impl();
                        break;
                    }
                    case 40: {
                        Configuration.logContext.write("R filter delete");
                        this.filterDelete_Impl(ois.readUTF());
                        oos.writeObject(voidAnswer);
                        break;
                    }
                    case 42: {
                        Configuration.logContext.write("R filter read");
                        oos.writeObject(this.filterRead_Impl(ois.readUTF()));
                        break;
                    }
                    case 41: {
                        Configuration.logContext.write("R filter read all");
                        oos.writeObject(this.filterReadAll_Impl());
                        break;
                    }
                    case 43: {
                        Configuration.logContext.write("R filter write");
                        this.filterWrite_Impl((FilterRecord)ois.readObject());
                        oos.writeObject(voidAnswer);
                        break;
                    }
                    case 90: {
                        Configuration.logContext.write("R keydata delete");
                        this.keyDataDelete_Impl(ois.readUTF(), ois.readUTF(), ois.readUTF());
                        oos.writeObject(voidAnswer);
                        break;
                    }
                    case 92: {
                        Configuration.logContext.write("R keydata read");
                        oos.writeObject(this.keyDataRead_Impl(ois.readUTF(), ois.readUTF(), ois.readUTF()));
                        break;
                    }
                    case 91: {
                        Configuration.logContext.write("R keydata read all");
                        oos.writeObject(this.keyDataReadAll_Impl(ois.readUTF(), ois.readUTF()));
                        break;
                    }
                    case 93: {
                        Configuration.logContext.write("R keydata write");
                        this.keyDataWrite_Impl(ois.readUTF(), ois.readUTF(), ois.readUTF(), ois.readUTF());
                        oos.writeObject(voidAnswer);
                        break;
                    }
                    case 100: {
                        Configuration.logContext.write("R accounting read all");
                        oos.writeObject(this.accountingReadAll_Impl());
                        break;
                    }
                    case 101: {
                        Configuration.logContext.write("R accounting read");
                        oos.writeObject(this.accountingRead_Impl(ois.readUTF()));
                        break;
                    }
                    case 110: {
                        Configuration.logContext.write("R mailinglist delete");
                        this.mailinglistDelete_Impl(ois.readUTF());
                        oos.writeObject(voidAnswer);
                        break;
                    }
                    case 112: {
                        Configuration.logContext.write("R mailinglist read");
                        oos.writeObject(this.mailinglistRead_Impl(ois.readUTF()));
                        break;
                    }
                    case 111: {
                        Configuration.logContext.write("R mailinglist read all");
                        oos.writeObject(this.mailinglistReadAll_Impl());
                        break;
                    }
                    case 113: {
                        Configuration.logContext.write("R mailinglist write");
                        this.mailinglistWrite_Impl((MailingListRecord)ois.readObject());
                        oos.writeObject(voidAnswer);
                        break;
                    }
                    case 120: {
                        Configuration.logContext.write("R quota exceeded");
                        oos.writeObject(new Boolean(this.quotaExceeded_Impl(ois.readUTF())));
                        break;
                    }
                    case 121: {
                        Configuration.logContext.write("R quota cleanup");
                        this.quotaCleanup_Impl();
                        oos.writeObject(voidAnswer);
                        break;
                    }
                    default: {
                        Configuration.logContext.write("R unknown command " + intCmd);
                        throw new RuntimeException("Unknown remote command " + intCmd);
                    }
                }
            }
            catch (Throwable t) {
                oos.writeObject(t);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            oos.flush();
            oos.reset();
            throw throwable;
        }
        Object var7_10 = null;
        oos.flush();
        oos.reset();
    }

    public void dispose() {
        if (this.ssok != null) {
            this.blnRemoteRunning = false;
            Helper.close(this.ssok);
            this.ssok = null;
            this.thrdRemote = null;
        }
        if (this.vecThreads != null) {
            while (this.vecThreads.size() > 0) {
                ((Scheduler)this.vecThreads.elementAt(0)).dispose();
            }
        }
        super.dispose();
    }

    protected void domainDelete_Impl(String strDomain) throws Throwable {
        this.smLocal.domainDelete_Impl(strDomain);
    }

    protected Vector domainReadAll_Impl() throws Throwable {
        return this.smLocal.domainReadAll_Impl();
    }

    protected DomainRecord domainRead_Impl(String strDomain) throws Throwable {
        return this.smLocal.domainRead_Impl(strDomain);
    }

    protected void domainRename_Impl(String strOldDomain, String strNewDomain) throws Throwable {
        this.smLocal.domainRename_Impl(strOldDomain, strNewDomain);
    }

    protected void domainWrite_Impl(DomainRecord dom) throws Throwable {
        this.smLocal.domainWrite_Impl(dom);
    }

    protected void fileDelete_Impl(String strFile) throws Throwable {
        this.smLocal.fileDelete_Impl(strFile);
    }

    protected RemoteFile fileGet_Impl(String strPath) throws Throwable {
        return this.smLocal.fileGet_Impl(strPath);
    }

    protected RemoteFile[] fileList_Impl(String strPath) throws Throwable {
        return this.smLocal.fileList_Impl(strPath);
    }

    protected void fileLoad_Impl(String strFile, OutputStream out) throws Throwable {
        this.smLocal.fileLoad_Impl(strFile, out);
    }

    protected void fileSave_Impl(String strFile, InputStream in) throws Throwable {
        this.smLocal.fileSave_Impl(strFile, in);
    }

    protected void filterDelete_Impl(String strName) throws Throwable {
        this.smLocal.filterDelete_Impl(strName);
    }

    protected Vector filterReadAll_Impl() throws Throwable {
        return this.smLocal.filterReadAll_Impl();
    }

    protected FilterRecord filterRead_Impl(String strName) throws Throwable {
        return this.smLocal.filterRead_Impl(strName);
    }

    protected void filterWrite_Impl(FilterRecord fr) throws Throwable {
        this.smLocal.filterWrite_Impl(fr);
    }

    public void initRemoteControl() {
        if (this.ssok != null) {
            Configuration.logContext.write("? Remote control service already started");
            throw new InitializationException();
        }
        try {
            InetAddress ina = null;
            if (!this.cnf.strRemote_Host.startsWith("*")) {
                ina = InetAddress.getByName(HelperExtract.splitIP_getHost((String)this.cnf.strRemote_Host));
            }
            this.ssok = new ServerSocket(HelperExtract.splitIP_getPort((String)this.cnf.strRemote_Host, (int)411), 5, ina);
        }
        catch (Throwable t) {
            Configuration.logContext.write("? Cannot start remote control socket", t);
            throw new InitializationException();
        }
        this.strLocalPassword = this.strLocalPassword;
        this.blnRemoteRunning = true;
        this.thrdRemote = new Thread((Runnable)this, "Remote-Control");
        this.thrdRemote.start();
    }

    protected void keyDataDelete_Impl(String strApplName, String strUserName, String strKey) throws Throwable {
        this.smLocal.keyDataDelete_Impl(strApplName, strUserName, strKey);
    }

    protected Vector keyDataReadAll_Impl(String strApplName, String strUserName) {
        return this.smLocal.keyDataReadAll(strApplName, strUserName);
    }

    protected String keyDataRead_Impl(String strApplName, String strUserName, String strKey) throws Throwable {
        return this.smLocal.keyDataRead_Impl(strApplName, strUserName, strKey);
    }

    protected void keyDataWrite_Impl(String strApplName, String strUserName, String strKey, String strData) throws Throwable {
        this.smLocal.keyDataWrite_Impl(strApplName, strUserName, strKey, strData);
    }

    protected String licenceCheck_Impl() throws Throwable {
        return this.smLocal.licenceCheck_Impl();
    }

    protected String[] logGet_Impl() throws Throwable {
        return this.smLocal.logGet_Impl();
    }

    protected Vector mailGetAllHeaders_Impl() throws Throwable {
        return this.smLocal.mailGetAllHeaders();
    }

    protected Vector mailGetHeadersForDomain_Impl(String strDomain) throws Throwable {
        return this.smLocal.mailGetHeadersForDomain_Impl(strDomain);
    }

    protected Vector mailGetHeadersForUser_Impl(String strUserName) throws Throwable {
        return this.smLocal.mailGetHeadersForUser_Impl(strUserName);
    }

    protected Vector mailGetHeadersToSend_Impl(int intUpperLimit, long lngRetryDelay) throws Throwable {
        return this.smLocal.mailGetHeadersToSend_Impl(intUpperLimit, lngRetryDelay);
    }

    protected void mailinglistDelete_Impl(String strName) throws Throwable {
        this.smLocal.mailinglistDelete_Impl(strName);
    }

    protected Vector mailinglistReadAll_Impl() throws Throwable {
        return this.smLocal.mailinglistReadAll_Impl();
    }

    protected MailingListRecord mailinglistRead_Impl(String strName) throws Throwable {
        return this.smLocal.mailinglistRead_Impl(strName);
    }

    protected void mailinglistWrite_Impl(MailingListRecord mlr) throws Throwable {
        this.smLocal.mailinglistWrite_Impl(mlr);
    }

    protected void mailMove_Impl(MailHeaderRecord mhrOld, MailHeaderRecord mhrNew) throws Throwable {
        this.smLocal.mailMove_Impl(mhrOld, mhrNew);
    }

    protected void mailProcessQueueAdd_Impl(MailQueueRecord mqr) throws Throwable {
        this.smLocal.mailProcessQueueAdd_Impl(mqr);
    }

    protected Vector mailProcessQueueNext_Impl(int intUpb) throws Throwable {
        return this.smLocal.mailProcessQueueNext_Impl(intUpb);
    }

    protected void mailProcessQueueRemove_Impl(MailQueueRecord mqr) throws Throwable {
        this.smLocal.mailProcessQueueRemove_Impl(mqr);
    }

    protected LineReader mailReadBody_Impl(MailHeaderRecord mhr) throws Throwable {
        return this.smLocal.mailReadBody_Impl(mhr);
    }

    protected void mailReadBody_Impl(MailHeaderRecord mhr, POP3OutputWriter out) throws Throwable {
        this.smLocal.mailReadBody_Impl(mhr, out);
    }

    protected MailHeaderRecord mailReadHeader_Impl(String strUID) throws Throwable {
        return this.smLocal.mailReadHeader_Impl(strUID);
    }

    protected void mailWriteFromString_Impl(MailHeaderRecord mhr, String strMail) throws Throwable {
        this.smLocal.mailWriteFromString_Impl(mhr, strMail);
    }

    protected void mailWriteFromTemp_Impl(MailFilterChain sfc, MailHeaderRecord mhr, String strUID) throws Throwable {
        this.smLocal.mailWriteFromTemp_Impl(sfc, mhr, strUID);
    }

    protected int mailWriteHeader_Impl(MailHeaderRecord mhr) throws Throwable {
        return this.smLocal.mailWriteHeader_Impl(mhr);
    }

    protected void quotaCleanup_Impl() throws Throwable {
        this.smLocal.quotaCleanup_Impl();
    }

    protected boolean quotaExceeded_Impl(String strUser) throws Throwable {
        return this.smLocal.quotaExceeded_Impl(strUser);
    }

    protected void rollback_Impl() throws Throwable {
        this.smLocal.rollback_Impl();
    }

    public void run() {
        this.vecThreads = new Vector();
        Configuration.logContext.write("# Remote control starting on " + this.ssok.getInetAddress());
        while (this.blnRemoteRunning) {
            Socket sok = null;
            try {
                sok = this.ssok.accept();
                if (!this.blnRemoteRunning) {
                    Configuration.logContext.write("# Remote control closing");
                    return;
                }
                Configuration.logContext.write("! Incoming remote control: " + sok.getInetAddress());
                ObjectInputStream ois = new ObjectInputStream(sok.getInputStream());
                ObjectOutputStream oos = new ObjectOutputStream(sok.getOutputStream());
                Scheduler t = new Scheduler(this, this, sok, oos, ois);
                t.setName("Remote-Control " + sok.getInetAddress());
            }
            catch (StreamCorruptedException streamCorruptedException) {
                try {
                    PrintWriter pw = new PrintWriter(sok.getOutputStream());
                    pw.println("You failed.");
                    Helper.close(sok);
                    Configuration.logContext.write("? Remote control server rejected incoming TELNET session");
                }
                catch (IOException iOException) {}
            }
            catch (Throwable t) {
                Helper.close(sok);
                if (!this.blnRemoteRunning) continue;
                Configuration.logContext.write("? Remote control server", t);
            }
        }
    }

    protected StatisticsRecord statsGet_Impl() throws Throwable {
        StatisticsRecord sr = this.smLocal.statsGet_Impl();
        return (StatisticsRecord)sr.clone();
    }

    protected void tempDelete_Impl(String strUID) throws Throwable {
        this.smLocal.tempDelete_Impl(strUID);
    }

    protected LineReader tempRead_Impl(String strUID) throws Throwable {
        return this.smLocal.tempRead_Impl(strUID);
    }

    protected LineWriter tempWrite_Impl(String strUID) throws Throwable {
        return this.smLocal.tempWrite_Impl(strUID);
    }

    protected void tempWrite_Impl(String strUID, LineReader in) throws Throwable {
        this.smLocal.tempWrite_Impl(strUID, in);
    }

    public String toString() {
        return "remote storage manager server";
    }

    protected void userDelete_Impl(String strUser) throws Throwable {
        this.smLocal.userDelete_Impl(strUser);
    }

    protected Vector userReadAllByDomain_Impl(String strDomain) throws Throwable {
        return this.smLocal.userReadAllByDomain_Impl(strDomain);
    }

    protected UserRecord userRead_Impl(String strUser) throws Throwable {
        return this.smLocal.userRead_Impl(strUser);
    }

    protected void userWrite_Impl(UserRecord usr) throws Throwable {
        this.smLocal.userWrite_Impl(usr);
    }

    static Vector access$vecThreads(RemoteStorageManager_Server remoteStorageManager_Server) {
        return remoteStorageManager_Server.vecThreads;
    }

    static void access$dispatch(RemoteStorageManager_Server remoteStorageManager_Server, int n, ObjectInputStream objectInputStream, ObjectOutputStream objectOutputStream) throws Throwable {
        remoteStorageManager_Server.dispatch(n, objectInputStream, objectOutputStream);
    }

    public class Scheduler
    extends Thread {
        /* synthetic */ RemoteStorageManager_Server this$0;
        private Socket sok;
        private StorageManager sm;
        private InputStream in;
        private OutputStream out;
        private ObjectInputStream ois;
        private ObjectOutputStream oos;
        private boolean blnSchedulerRunning = true;

        public Scheduler(RemoteStorageManager_Server this$0, StorageManager smg, Socket s, ObjectOutputStream out, ObjectInputStream in) throws IOException {
            this.this$0 = this$0;
            this.sm = smg;
            this.ois = in;
            this.oos = out;
            this.sok = s;
            RemoteStorageManager_Server.access$vecThreads(this$0).addElement(this);
            this.start();
        }

        public void run() {
            boolean blnLoggedIn = false;
            while (this.blnSchedulerRunning) {
                try {
                    int intCmd;
                    try {
                        intCmd = this.ois.readInt();
                    }
                    catch (IOException iOException) {
                        intCmd = 66;
                    }
                    if (intCmd == 66) {
                        this.dispose();
                        return;
                    }
                    if (!blnLoggedIn) {
                        if (intCmd != 65) {
                            this.oos.writeInt(-3);
                            this.oos.writeUTF(ZeroToaster.getVersion());
                            this.oos.flush();
                            this.oos.reset();
                            this.dispose();
                            return;
                        }
                        String strUser = this.ois.readUTF();
                        String strPass = this.ois.readUTF();
                        if (strUser.equals(this.this$0.cnf.strRemote_Admin_User) && strPass.equals(this.this$0.cnf.strRemote_Admin_Pass)) {
                            this.oos.writeInt(5);
                            this.oos.writeUTF(ZeroToaster.getVersion());
                            this.oos.flush();
                            this.oos.reset();
                            blnLoggedIn = true;
                            continue;
                        }
                        UserRecord usr = this.sm.userRead(strUser);
                        if (usr == null) {
                            this.oos.writeInt(-1);
                            this.oos.writeUTF(ZeroToaster.getVersion());
                            this.oos.flush();
                            this.oos.reset();
                            this.dispose();
                            return;
                        }
                        if (!strPass.equalsIgnoreCase(usr.getPassWord())) {
                            this.oos.writeInt(-2);
                            this.oos.writeUTF(ZeroToaster.getVersion());
                            this.oos.flush();
                            this.oos.reset();
                            this.dispose();
                            return;
                        }
                        this.oos.writeInt(usr.getPrivilege());
                        this.oos.writeUTF(ZeroToaster.getVersion());
                        this.oos.flush();
                        this.oos.reset();
                        blnLoggedIn = true;
                        continue;
                    }
                    RemoteStorageManager_Server.access$dispatch(this.this$0, intCmd, this.ois, this.oos);
                }
                catch (Throwable t) {
                    Configuration.logContext.write("? Remotecontrol:", t);
                    this.blnSchedulerRunning = false;
                    break;
                }
            }
            this.dispose();
        }

        public void dispose() {
            Configuration.logContext.write("# Remote control end");
            this.blnSchedulerRunning = false;
            Helper.flush(this.oos);
            Helper.close(this.sok);
            RemoteStorageManager_Server.access$vecThreads(this.this$0).removeElement(this);
        }
    }
}

