/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.test;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Hashtable;
import net.zerotoaster.mta.util.Helper;
import net.zerotoaster.mta.util.HostIP;

public class MXMonitor {
    public static void main(String[] args) throws Throwable {
        if (args.length != 3) {
            System.out.println("MX Resolver test");
            System.out.println("Usage: domain.tld interval_in_minutes dns_to_use,dns_to_use");
            System.out.println("Example: zerotoaster.net 15 donald.harddiskcafe.de,daisy.harddiskcafe.de");
            System.out.println("Result will be written into mxchk_domain.tld");
            return;
        }
        String strDomain = args[0];
        long lngWait = Long.parseLong(args[1]) * 1000L * 60L;
        String strDNS = args[2];
        ((Hashtable)System.getProperties()).put("dns.server", strDNS);
        String strOutFile = "mxchk_" + strDomain;
        new File(strOutFile).delete();
        while (true) {
            System.out.println("checking " + strDomain);
            PrintWriter pw = null;
            pw = new PrintWriter((Writer)new FileWriter(strOutFile, true), true);
            Date d = new Date();
            try {
                pw.println(d + " Checking " + strDomain);
                HostIP[] ip = Helper.getMXHosts(strDomain, false);
                if (ip == null) {
                    pw.println(d + " got NULL");
                } else {
                    pw.println(d + " " + ip.length + " Hosts");
                    pw.print(d + " ");
                    int i = 0;
                    while (i < ip.length) {
                        pw.print(ip[i].toString());
                        pw.print(", ");
                        ++i;
                    }
                    pw.println();
                }
            }
            catch (Throwable t) {
                pw.println(d + " Error " + t.toString());
            }
            Helper.close(pw);
            System.out.println("sleeping");
            Thread.sleep(lngWait);
        }
    }
}

