/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;
import org.xbill.DNS.utils.base64;

public class CERTRecord
extends Record {
    public static final int PKIX = 1;
    public static final int SPKI = 2;
    public static final int PGP = 3;
    public static final int URL = 253;
    public static final int OID = 254;
    private short certType;
    private short keyTag;
    private byte alg;
    private byte[] cert;

    private CERTRecord() {
    }

    public CERTRecord(Name _name, short _dclass, int _ttl, int _certType, int _keyTag, int _alg, byte[] _cert) {
        super(_name, (short)37, _dclass, _ttl);
        this.certType = (short)_certType;
        this.keyTag = (short)_keyTag;
        this.alg = (byte)_alg;
        this.cert = _cert;
    }

    CERTRecord(Name _name, short _dclass, int _ttl, int length, DataByteInputStream in) throws IOException {
        super(_name, (short)37, _dclass, _ttl);
        if (in == null) {
            return;
        }
        this.certType = in.readShort();
        this.keyTag = (short)in.readUnsignedShort();
        this.alg = in.readByte();
        if (length > 5) {
            this.cert = new byte[length - 5];
            in.read(this.cert);
        }
    }

    CERTRecord(Name _name, short _dclass, int _ttl, MyStringTokenizer st, Name origin) throws IOException {
        super(_name, (short)37, _dclass, _ttl);
        this.certType = (short)Integer.parseInt(st.nextToken());
        this.keyTag = (short)Integer.parseInt(st.nextToken());
        this.alg = (byte)Integer.parseInt(st.nextToken());
        this.cert = base64.fromString(st.remainingTokens());
    }

    public byte getAlgorithm() {
        return this.alg;
    }

    public byte[] getCert() {
        return this.cert;
    }

    public short getCertType() {
        return this.certType;
    }

    public short getKeyTag() {
        return this.keyTag;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.cert != null) {
            sb.append(this.certType);
            sb.append(" ");
            sb.append(this.keyTag & 0xFFFF);
            sb.append(" ");
            sb.append(this.alg);
            if (this.cert != null) {
                sb.append(" (\n");
                sb.append(base64.formatString(this.cert, 64, "\t", true));
            }
        }
        return sb.toString();
    }

    void rrToWire(DataByteOutputStream out, Compression c) throws IOException {
        if (this.cert == null) {
            return;
        }
        out.writeShort(this.certType);
        out.writeShort(this.keyTag);
        out.writeByte(this.alg);
        out.write(this.cert);
    }
}

