/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Enumeration;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.Master;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameSet;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.SOARecord;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.Type;
import org.xbill.DNS.TypeMap;
import org.xbill.DNS.Verifier;

public class Cache
extends NameSet {
    private Verifier verifier;
    private boolean secure;
    private int maxncache = -1;
    private long cleanInterval = 30L;
    private Thread cleaner = new CacheCleaner(this);
    private short dclass;

    public Cache() {
        this(1);
    }

    /*
     * WARNING - void declaration
     */
    public Cache(String file) throws IOException {
        super(true);
        Record record;
        Master m = new Master(file);
        while ((record = m.nextRecord()) != null) {
            void var3_3;
            this.addRecord((Record)var3_3, (byte)0, m);
        }
    }

    public Cache(short dclass) {
        super(true);
        this.dclass = dclass;
    }

    public void addMessage(Message in) {
        byte cred;
        int i;
        Name queryName;
        boolean isAuth = in.getHeader().getFlag(5);
        Name lookupName = queryName = in.getQuestion().getName();
        short queryType = in.getQuestion().getType();
        in.getQuestion().getDClass();
        short rcode = in.getHeader().getRcode();
        boolean haveAnswer = false;
        if (this.secure) {
            Cache c = new Cache(this.dclass);
            c.addMessage(in);
            this.verifyRecords(c);
            return;
        }
        if (rcode != 0 && rcode != 3) {
            return;
        }
        Record[] answers = in.getSectionArray(1);
        while (!haveAnswer || queryType == 255) {
            boolean restart = false;
            i = 0;
            while (i < answers.length) {
                short type = answers[i].getType();
                short rrtype = answers[i].getRRsetType();
                Name name = answers[i].getName();
                cred = this.getCred(name, queryName, (short)1, isAuth);
                if (type == 5 && name.equals(lookupName)) {
                    this.addRecord(answers[i], cred, in);
                    CNAMERecord cname = (CNAMERecord)answers[i];
                    lookupName = cname.getTarget();
                    restart = true;
                } else if (rrtype == 5 && name.equals(lookupName)) {
                    this.addRecord(answers[i], cred, in);
                } else if (type == 39 && lookupName.subdomain(name)) {
                    this.addRecord(answers[i], cred, in);
                    DNAMERecord dname = (DNAMERecord)answers[i];
                    lookupName = lookupName.fromDNAME(dname);
                    restart = true;
                } else if (rrtype == 39 && lookupName.subdomain(name)) {
                    this.addRecord(answers[i], cred, in);
                } else if ((rrtype == queryType || queryType == 255) && name.equals(lookupName)) {
                    this.addRecord(answers[i], cred, in);
                    haveAnswer = true;
                }
                ++i;
            }
            if (!restart) break;
        }
        Record[] auth = in.getSectionArray(2);
        if (!haveAnswer) {
            Record soa = null;
            i = 0;
            while (i < auth.length) {
                if (auth[i].getType() == 6 && lookupName.subdomain(auth[i].getName())) {
                    soa = (SOARecord)auth[i];
                    break;
                }
                ++i;
            }
            if (soa != null) {
                long soattl = (long)soa.getTTL() & 0xFFFFFFFFL;
                long soamin = (long)((SOARecord)soa).getMinimum() & 0xFFFFFFFFL;
                long ttl = Math.min(soattl, soamin);
                if (this.maxncache >= 0) {
                    ttl = Math.min(ttl, (long)this.maxncache);
                }
                cred = this.getCred(soa.getName(), queryName, (short)2, isAuth);
                if (rcode == 3) {
                    this.addNegative(rcode, lookupName, (short)0, ttl, cred, in);
                } else {
                    this.addNegative(rcode, lookupName, queryType, ttl, cred, in);
                }
            }
        }
        int i2 = 0;
        while (i2 < auth.length) {
            short type = auth[i2].getRRsetType();
            Name name = auth[i2].getName();
            if ((type == 2 || type == 6) && lookupName.subdomain(name)) {
                cred = this.getCred(name, queryName, (short)2, isAuth);
                this.addRecord(auth[i2], cred, in);
            }
            ++i2;
        }
        Record[] addl = in.getSectionArray(3);
        i2 = 0;
        while (i2 < addl.length) {
            short type = addl[i2].getRRsetType();
            if (type == 1 || type == 28 || type == 38) {
                Name name = addl[i2].getName();
                cred = this.getCred(name, queryName, (short)3, isAuth);
                this.addRecord(addl[i2], cred, in);
            }
            ++i2;
        }
    }

    public void addNegative(short rcode, Name name, short type, long ttl, byte cred, Object o) {
        if (rcode == 3) {
            type = 0;
        }
        int src = o != null ? o.hashCode() : 0;
        Element element = (Element)this.findExactSet(name, type);
        if (element == null || cred > element.credibility) {
            this.addSet(name, type, new Element(this, name, ttl, cred, src, type));
        }
    }

    public void addRecord(Record r, byte cred, Object o) {
        Name name = r.getName();
        short type = r.getRRsetType();
        if (!Type.isRR(type)) {
            return;
        }
        int src = o != null ? o.hashCode() : 0;
        Element element = (Element)this.findExactSet(name, type);
        if (element == null || cred > element.credibility) {
            element = new Element(this, r, cred, src);
            this.addSet(name, type, element);
        } else if (cred == element.credibility) {
            if (element.srcid != src) {
                element.rrset.clear();
                element.srcid = src;
            }
            element.update(r);
        }
    }

    public void addRRset(RRset rrset, byte cred, Object o) {
        int src;
        Name name = rrset.getName();
        short type = rrset.getType();
        int n = src = o != null ? o.hashCode() : 0;
        if (this.verifier != null) {
            rrset.setSecurity(this.verifier.verify(rrset, this));
        }
        if (this.secure && rrset.getSecurity() < 1) {
            return;
        }
        Element element = (Element)this.findExactSet(name, type);
        if (element == null || cred > element.credibility) {
            this.addSet(name, type, new Element(this, rrset, cred, src));
        }
    }

    public void clearCache() {
        this.clear();
    }

    public RRset[] findAnyRecords(Name name, short type) {
        return this.findRecords(name, type, (byte)1);
    }

    public RRset[] findRecords(Name name, short type) {
        return this.findRecords(name, type, (byte)2);
    }

    private RRset[] findRecords(Name name, short type, byte minCred) {
        SetResponse cr = this.lookupRecords(name, type, minCred);
        if (cr.isSuccessful()) {
            return cr.answers();
        }
        return null;
    }

    void flushName(Name name) {
        this.removeName(name);
    }

    void flushSet(Name name, short type) {
        Element element = (Element)this.findExactSet(name, type);
        if (element == null || element.rrset == null) {
            return;
        }
        this.removeSet(name, type, element);
    }

    private final byte getCred(Name recordName, Name queryName, short section, boolean isAuth) {
        byte cred = section == 1 ? (isAuth && recordName.equals(queryName) ? (byte)5 : (isAuth ? (byte)2 : 2)) : (section == 2 ? (isAuth ? (byte)4 : 1) : (section == 3 ? (isAuth ? (byte)1 : 1) : (byte)0));
        return cred;
    }

    public SetResponse lookupRecords(Name name, short type, byte minCred) {
        Element element;
        SetResponse cr = null;
        Object o = this.findSets(name, type);
        if (o == null || o instanceof TypeMap) {
            return new SetResponse(0);
        }
        Object[] objects = o instanceof Element ? new Object[]{o} : (Object[])o;
        int nelements = 0;
        int i = 0;
        while (i < objects.length) {
            element = (Element)objects[i];
            if (element.TTL0Ours()) {
                this.removeSet(name, type, element);
                ++nelements;
            } else if (element.TTL0NotOurs()) {
                objects[i] = null;
            } else if (element.expiredTTL()) {
                this.removeSet(name, type, element);
                objects[i] = null;
            } else if (element.credibility < minCred) {
                objects[i] = null;
            } else {
                ++nelements;
            }
            ++i;
        }
        if (nelements == 0) {
            return new SetResponse(0);
        }
        i = 0;
        while (i < objects.length) {
            if (objects[i] != null) {
                element = (Element)objects[i];
                RRset rrset = element.rrset;
                if (rrset == null) {
                    if (element.type == 0) {
                        return new SetResponse(1);
                    }
                    if (type != 255) {
                        return new SetResponse(2);
                    }
                } else if (name.equals(rrset.getName())) {
                    if (type != 5 && type != 255 && rrset.getType() == 5) {
                        cr = new SetResponse(4);
                        cr.addCNAME((CNAMERecord)rrset.first());
                        return cr;
                    }
                    if (type != 2 && type != 255 && rrset.getType() == 2) {
                        cr = new SetResponse(3);
                        cr.addNS(rrset);
                        return cr;
                    }
                    if (cr == null) {
                        cr = new SetResponse(6);
                    }
                    cr.addRRset(rrset);
                } else {
                    if (rrset.getType() == 5) {
                        return new SetResponse(1);
                    }
                    if (rrset.getType() == 39) {
                        cr = new SetResponse(5);
                        cr.addDNAME((DNAMERecord)rrset.first());
                        return cr;
                    }
                    if (rrset.getType() == 2) {
                        cr = new SetResponse(3);
                        cr.addNS(rrset);
                        return cr;
                    }
                }
            }
            ++i;
        }
        if (cr == null && type == 255) {
            return new SetResponse(0);
        }
        return cr;
    }

    public void setCleanInterval(int minutes) {
        this.cleanInterval = minutes;
        if (this.cleanInterval <= 0L) {
            this.cleaner = null;
        } else if (this.cleaner == null) {
            this.cleaner = new CacheCleaner(this);
        }
    }

    public void setMaxNCache(int seconds) {
        this.maxncache = seconds;
    }

    public void setSecurePolicy() {
        this.secure = true;
    }

    public void setVerifier(Verifier v) {
        this.verifier = v;
    }

    private void verifyRecords(Cache tcache) {
        Enumeration e = tcache.names();
        while (e.hasMoreElements()) {
            Object[] elements;
            Name name = (Name)e.nextElement();
            TypeMap tm = tcache.findName(name);
            if (tm == null || (elements = tm.getAll()) == null) continue;
            int i = 0;
            while (i < elements.length) {
                Element element = (Element)elements[i];
                RRset rrset = element.rrset;
                if (rrset != null) {
                    if (this.verifier != null) {
                        rrset.setSecurity(this.verifier.verify(rrset, this));
                    }
                    if (rrset.getSecurity() >= 1) {
                        this.addSet(name, rrset.getType(), element);
                    }
                }
                ++i;
            }
        }
    }

    static long access$cleanInterval(Cache cache) {
        return cache.cleanInterval;
    }

    private class Element {
        /* synthetic */ Cache this$0;
        Name name;
        RRset rrset;
        short type;
        byte credibility;
        long timeIn;
        long ttl;
        int srcid;
        Thread tid;

        public Element(Cache this$0, Name _name, long _ttl, byte cred, int src, short _type) {
            this.this$0 = this$0;
            this.name = _name;
            this.rrset = null;
            this.type = _type;
            this.credibility = cred;
            this.ttl = _ttl & 0xFFFFFFFFL;
            this.srcid = src;
            this.timeIn = System.currentTimeMillis();
            this.tid = Thread.currentThread();
        }

        public Element(Cache this$0, Record r, byte cred, int src) {
            this.this$0 = this$0;
            this.name = r.getName();
            this.rrset = new RRset();
            this.type = this.rrset.getType();
            this.credibility = cred;
            this.timeIn = System.currentTimeMillis();
            this.ttl = -1L;
            this.srcid = src;
            this.update(r);
            this.tid = Thread.currentThread();
        }

        public Element(Cache this$0, RRset r, byte cred, int src) {
            this.this$0 = this$0;
            this.name = r.getName();
            this.rrset = r;
            this.type = r.getType();
            this.credibility = cred;
            this.timeIn = System.currentTimeMillis();
            this.ttl = (long)r.getTTL() & 0xFFFFFFFFL;
            this.srcid = src;
            this.tid = Thread.currentThread();
        }

        public final void update(Record r) {
            this.rrset.addRR(r);
            this.timeIn = System.currentTimeMillis();
            if (this.ttl < 0L) {
                this.ttl = (long)r.getTTL() & 0xFFFFFFFFL;
            }
        }

        public void deleteRecord(Record r) {
            this.rrset.deleteRR(r);
        }

        public final boolean expiredTTL() {
            long expire;
            long now = System.currentTimeMillis();
            return now > (expire = this.timeIn + 1000L * this.ttl);
        }

        public final boolean TTL0Ours() {
            return this.ttl == 0L && this.tid == Thread.currentThread();
        }

        public final boolean TTL0NotOurs() {
            return this.ttl == 0L && this.tid != Thread.currentThread();
        }

        public final String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.rrset != null) {
                sb.append(this.rrset);
            } else if (this.type == 0) {
                sb.append("NXDOMAIN " + this.name);
            } else {
                sb.append("NXRRSET " + this.name + " " + Type.string(this.type));
            }
            sb.append(" cl = ");
            sb.append(this.credibility);
            return sb.toString();
        }
    }

    private class CacheCleaner
    extends Thread {
        /* synthetic */ Cache this$0;

        public CacheCleaner(Cache this$0) {
            this.this$0 = this$0;
            this.setDaemon(true);
            this.setName("CacheCleaner");
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[UNCONDITIONALDOLOOP]], but top level block is 4[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

