/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import org.xbill.DNS.FindServer;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.ResolveThread;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverListener;
import org.xbill.DNS.SimpleResolver;
import org.xbill.Task.WorkerThread;

public class ExtendedResolver
implements Resolver {
    private static final int quantum = 20;
    private static int uniqueID = 0;
    private static final Random random = new Random();
    private Vector resolvers;
    private boolean loadBalance = false;
    private int lbStart = 0;
    private int retries = 3;

    public ExtendedResolver() throws UnknownHostException {
        this.init();
        String[] servers = FindServer.servers();
        if (servers != null) {
            int i = 0;
            while (i < servers.length) {
                SimpleResolver r = new SimpleResolver(servers[i]);
                r.setTimeout(20);
                this.resolvers.addElement(r);
                ++i;
            }
        } else {
            this.resolvers.addElement(new SimpleResolver());
        }
    }

    public ExtendedResolver(String[] servers) throws UnknownHostException {
        this.init();
        int i = 0;
        while (i < servers.length) {
            SimpleResolver r = new SimpleResolver(servers[i]);
            r.setTimeout(20);
            this.resolvers.addElement(r);
            ++i;
        }
    }

    public ExtendedResolver(Resolver[] res) throws UnknownHostException {
        this.init();
        int i = 0;
        while (i < res.length) {
            this.resolvers.addElement(res[i]);
            ++i;
        }
    }

    public void addResolver(Resolver r) {
        this.resolvers.addElement(r);
    }

    public void deleteResolver(Resolver r) {
        this.resolvers.removeElement(r);
    }

    public Resolver getResolver(int i) {
        if (i < this.resolvers.size()) {
            return (Resolver)this.resolvers.elementAt(i);
        }
        return null;
    }

    public Resolver[] getResolvers() {
        Resolver[] res = new Resolver[this.resolvers.size()];
        int i = 0;
        while (i < this.resolvers.size()) {
            res[i] = (Resolver)this.resolvers.elementAt(i);
            ++i;
        }
        return res;
    }

    private void init() {
        this.resolvers = new Vector();
    }

    public Message send(Message query) throws IOException {
        Message best = null;
        IOException bestException = null;
        boolean[] invalid = new boolean[this.resolvers.size()];
        byte[] sent = new byte[this.resolvers.size()];
        byte[] recvd = new byte[this.resolvers.size()];
        Vector queue = new Vector();
        Hashtable idMap = new Hashtable();
        Receiver receiver = new Receiver(this, queue, idMap);
        while (true) {
            Message m;
            QElement qe;
            boolean waiting = false;
            Vector vector = queue;
            synchronized (vector) {
                int r;
                int start;
                int nresolvers = this.resolvers.size();
                if (this.loadBalance) {
                    start = this.lbStart % nresolvers;
                    if (this.lbStart > nresolvers) {
                        this.lbStart %= nresolvers;
                    }
                } else {
                    start = 0;
                }
                int i = start;
                while (i < nresolvers + start) {
                    r = i % nresolvers;
                    if (sent[r] == recvd[r] && sent[r] < this.retries) {
                        this.sendTo(query, receiver, idMap, r);
                        int n = r;
                        sent[n] = (byte)(sent[n] + 1);
                        waiting = true;
                        break;
                    }
                    if (recvd[r] < sent[r]) {
                        waiting = true;
                    }
                    ++i;
                }
                if (!waiting) {
                    break;
                }
                try {
                    queue.wait();
                }
                catch (InterruptedException interruptedException) {}
                if (queue.size() == 0) {
                    continue;
                }
                qe = (QElement)queue.firstElement();
                queue.removeElement(qe);
                m = qe.obj instanceof Message ? (Message)qe.obj : null;
                int n = r = qe.res;
                recvd[n] = (byte)(recvd[n] + 1);
            }
            if (m == null) {
                IOException e = (IOException)qe.obj;
                if (!(e instanceof InterruptedIOException)) {
                    invalid[r] = true;
                }
                if (bestException != null) continue;
                bestException = e;
                continue;
            }
            short rcode = m.getRcode();
            if (rcode == 0) {
                return m;
            }
            if (best == null) {
                best = m;
            } else {
                short bestrcode = best.getRcode();
                if (rcode == 3 && bestrcode != 3) {
                    best = m;
                }
            }
            invalid[r] = true;
        }
        if (best != null) {
            return best;
        }
        throw bestException;
    }

    public Object sendAsync(Message query, ResolverListener listener) {
        Integer id;
        ExtendedResolver extendedResolver = this;
        synchronized (extendedResolver) {
            id = new Integer(uniqueID++);
        }
        String name = this.getClass() + ": " + query.getQuestion().getName();
        WorkerThread.assignThread(new ResolveThread(this, query, id, listener), name);
        return id;
    }

    private void sendTo(Message query, Receiver receiver, Hashtable idMap, int r) {
        Resolver res = (Resolver)this.resolvers.elementAt(r);
        Hashtable hashtable = idMap;
        synchronized (hashtable) {
            Object id = res.sendAsync(query, receiver);
            if (Options.check("verbose")) {
                System.err.println("ExtendedResolver: sending id " + id + " to resolver " + r);
            }
            idMap.put(id, new Integer(r));
        }
    }

    public void setEDNS(int level) {
        int i = 0;
        while (i < this.resolvers.size()) {
            ((Resolver)this.resolvers.elementAt(i)).setEDNS(level);
            ++i;
        }
    }

    public void setIgnoreTruncation(boolean flag) {
        int i = 0;
        while (i < this.resolvers.size()) {
            ((Resolver)this.resolvers.elementAt(i)).setIgnoreTruncation(flag);
            ++i;
        }
    }

    public void setLoadBalance(boolean flag) {
        this.loadBalance = flag;
    }

    public void setPort(int port) {
        int i = 0;
        while (i < this.resolvers.size()) {
            ((Resolver)this.resolvers.elementAt(i)).setPort(port);
            ++i;
        }
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setTCP(boolean flag) {
        int i = 0;
        while (i < this.resolvers.size()) {
            ((Resolver)this.resolvers.elementAt(i)).setTCP(flag);
            ++i;
        }
    }

    public void setTimeout(int secs) {
        int i = 0;
        while (i < this.resolvers.size()) {
            ((Resolver)this.resolvers.elementAt(i)).setTimeout(secs);
            ++i;
        }
    }

    public void setTSIGKey(String key) {
        int i = 0;
        while (i < this.resolvers.size()) {
            ((Resolver)this.resolvers.elementAt(i)).setTSIGKey(key);
            ++i;
        }
    }

    public void setTSIGKey(String name, String key) {
        int i = 0;
        while (i < this.resolvers.size()) {
            ((Resolver)this.resolvers.elementAt(i)).setTSIGKey(name, key);
            ++i;
        }
    }

    public void setTSIGKey(Name name, byte[] key) {
        int i = 0;
        while (i < this.resolvers.size()) {
            ((Resolver)this.resolvers.elementAt(i)).setTSIGKey(name, key);
            ++i;
        }
    }

    class QElement {
        /* synthetic */ ExtendedResolver this$0;
        Object obj;
        int res;

        public QElement(ExtendedResolver this$0, Object _obj, int _res) {
            this.this$0 = this$0;
            this.obj = _obj;
            this.res = _res;
        }
    }

    class Receiver
    implements ResolverListener {
        /* synthetic */ ExtendedResolver this$0;
        Vector queue;
        Hashtable idMap;

        public Receiver(ExtendedResolver this$0, Vector _queue, Hashtable _idMap) {
            this.this$0 = this$0;
            this.queue = _queue;
            this.idMap = _idMap;
        }

        public void enqueueInfo(Object id, Object obj) {
            int r;
            Cloneable cloneable = this.idMap;
            synchronized (cloneable) {
                Integer R = (Integer)this.idMap.get(id);
                if (R == null) {
                    return;
                }
                r = R;
                this.idMap.remove(id);
            }
            cloneable = this.queue;
            synchronized (cloneable) {
                QElement qe = new QElement(this.this$0, obj, r);
                this.queue.addElement(qe);
                this.queue.notify();
            }
        }

        public void receiveMessage(Object id, Message m) {
            if (Options.check("verbose")) {
                System.err.println("ExtendedResolver: received message " + id);
            }
            this.enqueueInfo(id, m);
        }

        public void handleException(Object id, Exception e) {
            if (Options.check("verbose")) {
                System.err.println("ExtendedResolver: exception on message " + id);
            }
            this.enqueueInfo(id, e);
        }
    }
}

