/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class HINFORecord
extends Record {
    private String cpu;
    private String os;

    private HINFORecord() {
    }

    HINFORecord(Name _name, short _dclass, int _ttl, int length, DataByteInputStream in) throws IOException {
        super(_name, (short)13, _dclass, _ttl);
        if (in == null) {
            return;
        }
        this.cpu = in.readString();
        this.os = in.readString();
    }

    public HINFORecord(Name _name, short _dclass, int _ttl, String _cpu, String _os) {
        super(_name, (short)13, _dclass, _ttl);
        this.cpu = _cpu;
        this.os = _os;
    }

    HINFORecord(Name _name, short _dclass, int _ttl, MyStringTokenizer st, Name origin) throws IOException {
        super(_name, (short)13, _dclass, _ttl);
        this.cpu = st.nextToken();
        this.os = st.nextToken();
    }

    public String getCPU() {
        return this.cpu;
    }

    public String getOS() {
        return this.os;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.cpu != null && this.os != null) {
            sb.append("\"");
            sb.append(this.cpu);
            sb.append("\" \"");
            sb.append(this.os);
            sb.append("\"");
        }
        return sb.toString();
    }

    void rrToWire(DataByteOutputStream out, Compression c) {
        if (this.cpu == null || this.os == null) {
            return;
        }
        out.writeString(this.cpu);
        out.writeString(this.os);
    }
}

