/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class MX_KXRecord
extends Record {
    private short priority;
    private Name target;

    protected MX_KXRecord() {
    }

    public MX_KXRecord(Name _name, short _type, short _dclass, int _ttl, int _priority, Name _target) {
        super(_name, _type, _dclass, _ttl);
        this.priority = (short)_priority;
        this.target = _target;
    }

    protected MX_KXRecord(Name _name, short _type, short _dclass, int _ttl, int length, DataByteInputStream in) throws IOException {
        super(_name, _type, _dclass, _ttl);
        if (in == null) {
            return;
        }
        this.priority = (short)in.readUnsignedShort();
        this.target = new Name(in);
    }

    protected MX_KXRecord(Name _name, short _type, short _dclass, int _ttl, MyStringTokenizer st, Name origin) throws IOException {
        super(_name, _type, _dclass, _ttl);
        this.priority = Short.parseShort(st.nextToken());
        this.target = new Name(st.nextToken(), origin);
    }

    public short getPriority() {
        return this.priority;
    }

    public Name getTarget() {
        return this.target;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.target != null) {
            sb.append(this.priority);
            sb.append(" ");
            sb.append(this.target);
        }
        return sb.toString();
    }

    void rrToWire(DataByteOutputStream out, Compression c) throws IOException {
        if (this.target == null) {
            return;
        }
        out.writeShort(this.priority);
        if (this.type == 15) {
            this.target.toWire(out, c);
        } else {
            this.target.toWire(out, null);
        }
    }

    void rrToWireCanonical(DataByteOutputStream out) throws IOException {
        if (this.target == null) {
            return;
        }
        out.writeShort(this.priority);
        this.target.toWireCanonical(out);
    }
}

