/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.xbill.DNS.BitString;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.Options;
import org.xbill.DNS.WireParseException;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class Name {
    private static final int LABEL_NORMAL = 0;
    private static final int LABEL_COMPRESSION = 192;
    private static final int LABEL_EXTENDED = 64;
    private static final int LABEL_MASK = 192;
    private static final int EXT_LABEL_BITSTRING = 1;
    private Object[] name;
    private byte labels;
    private boolean qualified;
    public static final Name root = new Name(".");
    static final int MAXLABELS = 128;
    private static final int STARTLABELS = 4;
    private static DecimalFormat byteFormat = new DecimalFormat();

    static {
        ((NumberFormat)byteFormat).setMinimumIntegerDigits(3);
    }

    private Name() {
    }

    public Name(String s) {
        this(s, null);
    }

    public Name(String s, Name origin) {
        boolean seenBitString = false;
        this.labels = 0;
        this.name = new Object[4];
        if (s.equals("@") && origin != null) {
            this.append(origin);
            this.qualified = true;
            return;
        }
        try {
            MyStringTokenizer st = new MyStringTokenizer(s, ".");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (this.labels == this.name.length) {
                    this.grow();
                }
                if (token.charAt(0) == '[') {
                    byte by = this.labels;
                    this.labels = (byte)(by + 1);
                    this.name[by] = new BitString(token);
                    seenBitString = true;
                    continue;
                }
                byte by = this.labels;
                this.labels = (byte)(by + 1);
                this.name[by] = token.getBytes();
            }
            if (st.hasMoreDelimiters()) {
                this.qualified = true;
            } else if (origin != null) {
                this.append(origin);
                this.qualified = true;
            } else {
                this.qualified = Options.check("pqdn") ? false : this.labels > 1;
            }
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            sb.append(s);
            if (origin != null) {
                sb.append(".");
                sb.append(origin);
            }
            if (e instanceof ArrayIndexOutOfBoundsException) {
                sb.append(" has too many labels");
            } else if (e instanceof IOException) {
                sb.append(" contains an invalid binary label");
            } else {
                sb.append(" is invalid");
            }
            System.err.println(sb.toString());
            this.name = null;
            this.labels = 0;
        }
        if (seenBitString) {
            this.compact();
        }
    }

    public Name(Name d, int n) {
        this.name = new Object[d.labels - n];
        this.labels = (byte)(d.labels - n);
        System.arraycopy(d.name, n, this.name, 0, this.labels);
        this.qualified = d.qualified;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Name(DataByteInputStream in) throws IOException {
        int len;
        int count = 0;
        boolean seenBitString = false;
        this.labels = 0;
        this.name = new Object[4];
        in.getPos();
        block10: while ((len = in.readUnsignedByte()) != 0) {
            void var2_4;
            ++count;
            block1 : switch (var2_4 & 0xC0) {
                case 0: {
                    byte[] b = new byte[var2_4];
                    in.read(b);
                    if (this.labels == this.name.length) {
                        this.grow();
                    }
                    byte by = this.labels;
                    this.labels = (byte)(by + 1);
                    this.name[by] = b;
                    break;
                }
                case 192: {
                    Name name2;
                    int pos = in.readUnsignedByte();
                    pos += (var2_4 & 0xFFFFFF3F) << 8;
                    if (Options.check("verbosecompression")) {
                        System.err.println("currently " + in.getPos() + ", pointer to " + pos);
                    }
                    if (pos >= in.getPos()) {
                        throw new WireParseException("bad compression");
                    }
                    int savedpos = in.getPos();
                    in.setPos(pos);
                    if (Options.check("verbosecompression")) {
                        System.err.println("current name '" + this + "', seeking to " + pos);
                    }
                    try {
                        name2 = new Name(in);
                    }
                    catch (Throwable throwable) {
                        Object var9_7 = null;
                        in.setPos(savedpos);
                        throw throwable;
                    }
                    Object var9_8 = null;
                    in.setPos(savedpos);
                    if (this.labels + name2.labels > this.name.length) {
                        this.grow(this.labels + name2.labels);
                    }
                    System.arraycopy(name2.name, 0, this.name, this.labels, name2.labels);
                    this.labels = (byte)(this.labels + name2.labels);
                    break block10;
                }
                case 64: {
                    int type = var2_4 & 0xFFFFFF3F;
                    switch (type) {
                        case 1: {
                            int bits = in.readUnsignedByte();
                            if (bits == 0) {
                                bits = 256;
                            }
                            int bytes = (bits + 7) / 8;
                            byte[] data = new byte[bytes];
                            in.read(data);
                            if (this.labels == this.name.length) {
                                this.grow();
                            }
                            byte by = this.labels;
                            this.labels = (byte)(by + 1);
                            this.name[by] = new BitString(bits, data);
                            seenBitString = true;
                            break block1;
                        }
                    }
                    throw new WireParseException("Unknown name format");
                }
            }
        }
        this.qualified = true;
        if (seenBitString) {
            this.compact();
        }
    }

    public void append(Name d) {
        if (this.labels + d.labels > this.name.length) {
            this.grow(this.labels + d.labels);
        }
        System.arraycopy(d.name, 0, this.name, this.labels, d.labels);
        this.labels = (byte)(this.labels + d.labels);
        this.qualified = d.qualified;
        this.compact();
    }

    private String byteString(byte[] array) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < array.length) {
            short b = (short)(array[i] & 0xFF);
            if (b <= 32 || b >= 127) {
                sb.append('\\');
                sb.append(byteFormat.format(b));
            } else if (b == 34 || b == 40 || b == 41 || b == 46 || b == 59 || b == 92 || b == 64 || b == 36) {
                sb.append('\\');
                sb.append((char)b);
            } else {
                sb.append((char)b);
            }
            ++i;
        }
        return sb.toString();
    }

    private final void compact() {
        int i = this.labels - 1;
        while (i > 0) {
            if (this.name[i] instanceof BitString && this.name[i - 1] instanceof BitString) {
                BitString bs = (BitString)this.name[i];
                BitString bs2 = (BitString)this.name[i - 1];
                if (bs.nbits != 256) {
                    int nbits = bs.nbits + bs2.nbits;
                    bs.join(bs2);
                    if (nbits <= 256) {
                        System.arraycopy(this.name, i, this.name, i - 1, this.labels - i);
                        this.labels = (byte)(this.labels - 1);
                    }
                }
            }
            --i;
        }
    }

    public int compareTo(Object o) {
        Name arg = (Name)o;
        int compares = this.labels > arg.labels ? arg.labels : this.labels;
        int i = 1;
        while (i <= compares) {
            int n;
            Object label = this.name[this.labels - i];
            Object alabel = arg.name[arg.labels - i];
            if (label.getClass() != alabel.getClass()) {
                if (label instanceof BitString) {
                    return -1;
                }
                return 1;
            }
            if (label instanceof BitString) {
                BitString bs = (BitString)label;
                BitString abs = (BitString)alabel;
                int bits = bs.nbits > abs.nbits ? abs.nbits : bs.nbits;
                n = bs.compareBits(abs, bits);
                if (n != 0) {
                    return n;
                }
                if (bs.nbits != abs.nbits) {
                    if (bs.nbits > abs.nbits) {
                        return i == arg.labels ? 1 : -1;
                    }
                    return i == this.labels ? -1 : 1;
                }
            } else {
                byte[] b = (byte[])label;
                byte[] ab = (byte[])alabel;
                int j = 0;
                while (j < b.length && j < ab.length) {
                    n = Name.toLower(b[j]) - Name.toLower(ab[j]);
                    if (n != 0) {
                        return n;
                    }
                    ++j;
                }
                if (b.length != ab.length) {
                    return b.length - ab.length;
                }
            }
            ++i;
        }
        return this.labels - arg.labels;
    }

    public boolean equals(Object arg) {
        if (arg == null || !(arg instanceof Name)) {
            return false;
        }
        if (arg == this) {
            return true;
        }
        Name d = (Name)arg;
        if (d.labels != this.labels) {
            return false;
        }
        int i = 0;
        while (i < this.labels) {
            if (this.name[i].getClass() != d.name[i].getClass()) {
                return false;
            }
            if (this.name[i] instanceof BitString) {
                if (!this.name[i].equals(d.name[i])) {
                    return false;
                }
            } else {
                byte[] b1 = (byte[])this.name[i];
                byte[] b2 = (byte[])d.name[i];
                if (b1.length != b2.length) {
                    return false;
                }
                int j = 0;
                while (j < b1.length) {
                    if (Name.toLower(b1[j]) != Name.toLower(b2[j])) {
                        return false;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return true;
    }

    public Name fromDNAME(DNAMERecord dname) {
        Name dnameowner = dname.getName();
        Name dnametarget = dname.getTarget();
        if (!this.subdomain(dnameowner)) {
            return null;
        }
        int saved = this.labels - dnameowner.labels;
        int nlabels = saved + dnametarget.labels;
        if (nlabels > 128) {
            return null;
        }
        Name newname = new Name();
        newname.labels = (byte)nlabels;
        newname.name = new Object[this.labels];
        System.arraycopy(this.name, 0, newname.name, 0, saved);
        System.arraycopy(dnametarget.name, 0, newname.name, saved, dnametarget.labels);
        newname.qualified = true;
        newname.compact();
        return newname;
    }

    public String getLabelString(int n) {
        if (this.name[n] instanceof BitString) {
            return this.name[n].toString();
        }
        return this.byteString((byte[])this.name[n]);
    }

    private final void grow() {
        this.grow(this.labels * 2);
    }

    private final void grow(int n) {
        if (n > 128) {
            throw new ArrayIndexOutOfBoundsException("name too long");
        }
        Object[] newarray = new Object[n];
        System.arraycopy(this.name, 0, newarray, 0, this.labels);
        this.name = newarray;
    }

    public int hashCode() {
        int code = this.labels;
        int i = 0;
        while (i < this.labels) {
            int j;
            Object b;
            if (this.name[i] instanceof BitString) {
                b = (BitString)this.name[i];
                j = 0;
                while (j < ((BitString)b).bytes()) {
                    code += (code << 3) + ((BitString)b).data[j];
                    ++j;
                }
            } else {
                b = (byte[])this.name[i];
                j = 0;
                while (j < ((Object)b).length) {
                    code += (code << 3) + Name.toLower((byte)b[j]);
                    ++j;
                }
            }
            ++i;
        }
        return code;
    }

    public boolean isQualified() {
        return this.qualified;
    }

    public boolean isWild() {
        if (this.labels == 0 || this.name[0] instanceof BitString) {
            return false;
        }
        byte[] b = (byte[])this.name[0];
        return b.length == 1 && b[0] == 42;
    }

    public byte labels() {
        return this.labels;
    }

    public short length() {
        int total = 0;
        int i = 0;
        while (i < this.labels) {
            total = this.name[i] instanceof BitString ? (int)((short)(total + (((BitString)this.name[i]).bytes() + 2))) : (int)((short)(total + (((byte[])this.name[i]).length + 1)));
            ++i;
        }
        short s = (short)(total + 1);
        total = s;
        return s;
    }

    public boolean subdomain(Name domain) {
        if (domain == null || domain.labels > this.labels) {
            return false;
        }
        Name tname = new Name(this, this.labels - domain.labels);
        return tname.equals(domain);
    }

    private static final byte toLower(byte b) {
        if (b < 65 || b > 90) {
            return b;
        }
        return (byte)(b - 65 + 97);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.labels == 0) {
            sb.append(".");
        }
        int i = 0;
        while (i < this.labels) {
            if (this.name[i] instanceof BitString) {
                sb.append(this.name[i]);
            } else {
                sb.append(this.byteString((byte[])this.name[i]));
            }
            if (this.qualified || i < this.labels - 1) {
                sb.append(".");
            }
            ++i;
        }
        return sb.toString();
    }

    public void toWire(DataByteOutputStream out, Compression c) throws IOException {
        int i = 0;
        while (i < this.labels) {
            Name tname = i == 0 ? this : new Name(this, i);
            int pos = -1;
            if (c != null) {
                pos = c.get(tname);
                if (Options.check("verbosecompression")) {
                    System.err.println("Looking for " + tname + ", found " + pos);
                }
            }
            if (pos >= 0) {
                out.writeShort(pos |= 0xC000);
                return;
            }
            if (c != null) {
                c.add(out.getPos(), tname);
                if (Options.check("verbosecompression")) {
                    System.err.println("Adding " + tname + " at " + out.getPos());
                }
            }
            if (this.name[i] instanceof BitString) {
                out.writeByte(65);
                out.writeByte(((BitString)this.name[i]).wireBits());
                out.write(((BitString)this.name[i]).data);
            } else {
                out.writeString((byte[])this.name[i]);
            }
            ++i;
        }
        out.writeByte(0);
    }

    public void toWireCanonical(DataByteOutputStream out) throws IOException {
        int i = 0;
        while (i < this.labels) {
            if (this.name[i] instanceof BitString) {
                out.writeByte(65);
                out.writeByte(((BitString)this.name[i]).wireBits());
                out.write(((BitString)this.name[i]).data);
            } else {
                out.writeStringCanonical(new String((byte[])this.name[i]));
            }
            ++i;
        }
        out.writeByte(0);
    }

    public Name wild(int n) {
        Name wild = new Name(this, n - 1);
        wild.name[0] = new byte[]{42};
        return wild;
    }
}

