/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;

public class RRset {
    public Vector rrs = new Vector(1, 1);
    public Vector sigs = null;
    public int start = 0;
    public byte securityStatus = 0;

    public void addRR(Record r) {
        if (r.getType() != 24) {
            Vector vector = this.rrs;
            synchronized (vector) {
                if (!this.rrs.contains(r)) {
                    this.rrs.addElement(r);
                }
            }
        } else {
            if (this.sigs == null) {
                this.sigs = new Vector();
            }
            if (!this.sigs.contains(r)) {
                this.sigs.addElement(r);
            }
        }
    }

    public void clear() {
        Vector vector = this.rrs;
        synchronized (vector) {
            this.rrs.setSize(0);
        }
        this.sigs = null;
        this.start = 0;
    }

    public void deleteRR(Record r) {
        if (r.getType() != 24) {
            Vector vector = this.rrs;
            synchronized (vector) {
                this.rrs.removeElement(r);
            }
        } else if (this.sigs != null) {
            this.sigs.removeElement(r);
        }
    }

    public Record first() {
        try {
            return (Record)this.rrs.elementAt(0);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public short getDClass() {
        Record r = this.first();
        if (r == null) {
            return 0;
        }
        return r.getDClass();
    }

    public Name getName() {
        Record r = this.first();
        if (r == null) {
            return null;
        }
        return r.getName();
    }

    public byte getSecurity() {
        return this.securityStatus;
    }

    public int getTTL() {
        Enumeration e = this.rrs();
        if (!e.hasMoreElements()) {
            return 0;
        }
        int ttl = Integer.MAX_VALUE;
        while (e.hasMoreElements()) {
            Record r = (Record)e.nextElement();
            if (r.getTTL() >= ttl) continue;
            ttl = r.getTTL();
        }
        return ttl;
    }

    public short getType() {
        Record r = this.first();
        if (r == null) {
            return 0;
        }
        return r.getType();
    }

    public Enumeration rrs() {
        return new Enumerator(this);
    }

    void setSecurity(byte status) {
        this.securityStatus = status;
    }

    public Enumeration sigs() {
        if (this.sigs == null) {
            return new Vector(0).elements();
        }
        return this.sigs.elements();
    }

    public int size() {
        return this.rrs.size();
    }

    public String toString() {
        Record rr;
        StringBuffer sb = new StringBuffer();
        sb.append("{ [");
        Enumeration e = new Enumerator(this);
        while (e.hasMoreElements()) {
            rr = (Record)e.nextElement();
            sb.append(rr);
            if (!e.hasMoreElements()) continue;
            sb.append("<>");
        }
        sb.append("]");
        if (this.sigs != null) {
            sb.append(" [");
            e = this.sigs();
            while (e.hasMoreElements()) {
                rr = (Record)e.nextElement();
                sb.append(rr);
                if (!e.hasMoreElements()) continue;
                sb.append("<>");
            }
            sb.append("]");
        }
        sb.append(" }");
        return sb.toString();
    }

    class Enumerator
    implements Enumeration {
        /* synthetic */ RRset this$0;
        int count;
        Record[] records;

        Enumerator(RRset this$0) {
            this.this$0 = this$0;
            Vector vector = this$0.rrs;
            synchronized (vector) {
                int size = this$0.rrs.size();
                this.records = new Record[size];
                if (size == 0) {
                    return;
                }
                ++this$0.start;
                while (this$0.start >= size) {
                    this$0.start -= size;
                }
                int i = 0;
                int j = this$0.start;
                while (j < size) {
                    this.records[i++] = (Record)this$0.rrs.elementAt(j);
                    ++j;
                }
                j = 0;
                while (j < this$0.start) {
                    this.records[i++] = (Record)this$0.rrs.elementAt(j);
                    ++j;
                }
            }
        }

        public boolean hasMoreElements() {
            return this.count < this.records.length;
        }

        public Object nextElement() {
            if (this.count == this.records.length) {
                throw new NoSuchElementException();
            }
            return this.records[this.count++];
        }
    }
}

