/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.SIGRecord;
import org.xbill.DNS.TTL;
import org.xbill.DNS.Type;
import org.xbill.DNS.UNKRecord;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;
import org.xbill.DNS.utils.base16;

public abstract class Record
implements Cloneable {
    protected Name name;
    protected short type;
    protected short dclass;
    protected int ttl;
    protected int wireLength = -1;
    private static Class[] knownTypes = new Class[256];
    private static Class[] fromWireList;
    private static Class[] fromTextList;
    static Class class$org$xbill$DNS$Name;
    static Class class$org$xbill$DNS$Record;
    static Class class$org$xbill$DNS$utils$DataByteInputStream;
    static Class class$org$xbill$DNS$utils$MyStringTokenizer;

    static {
        Class[] classArray = new Class[5];
        Class<?> clazz = class$org$xbill$DNS$Name;
        if (clazz == null) {
            try {
                clazz = class$org$xbill$DNS$Name = Class.forName("org.xbill.DNS.Name");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        classArray[1] = Short.TYPE;
        classArray[2] = Integer.TYPE;
        classArray[3] = Integer.TYPE;
        Class<?> clazz2 = class$org$xbill$DNS$utils$DataByteInputStream;
        if (clazz2 == null) {
            try {
                clazz2 = class$org$xbill$DNS$utils$DataByteInputStream = Class.forName("org.xbill.DNS.utils.DataByteInputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[4] = clazz2;
        fromWireList = classArray;
        Class[] classArray2 = new Class[5];
        Class<?> clazz3 = class$org$xbill$DNS$Name;
        if (clazz3 == null) {
            try {
                clazz3 = class$org$xbill$DNS$Name = Class.forName("org.xbill.DNS.Name");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz3;
        classArray2[1] = Short.TYPE;
        classArray2[2] = Integer.TYPE;
        Class<?> clazz4 = class$org$xbill$DNS$utils$MyStringTokenizer;
        if (clazz4 == null) {
            try {
                clazz4 = class$org$xbill$DNS$utils$MyStringTokenizer = Class.forName("org.xbill.DNS.utils.MyStringTokenizer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[3] = clazz4;
        Class<?> clazz5 = class$org$xbill$DNS$Name;
        if (clazz5 == null) {
            try {
                clazz5 = class$org$xbill$DNS$Name = Class.forName("org.xbill.DNS.Name");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[4] = clazz5;
        fromTextList = classArray2;
    }

    protected Record() {
    }

    Record(Name _name, short _type, short _dclass, int _ttl) {
        this.name = _name;
        this.type = _type;
        this.dclass = _dclass;
        this.ttl = _ttl;
    }

    public boolean equals(Object arg) {
        if (arg == null || !(arg instanceof Record)) {
            return false;
        }
        Record r = (Record)arg;
        try {
            byte[] array2;
            if (this.type != r.type || this.dclass != r.dclass || !this.name.equals(r.name)) {
                return false;
            }
            byte[] array1 = this.rdataToWireCanonical();
            if (array1.length != (array2 = r.rdataToWireCanonical()).length) {
                return false;
            }
            int i = 0;
            while (i < array1.length) {
                if (array1[i] != array2[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static Record fromString(Name name, short type, short dclass, int ttl, String s, Name origin) throws IOException {
        return Record.fromString(name, type, dclass, ttl, new MyStringTokenizer(s), origin);
    }

    public static Record fromString(Name name, short type, short dclass, int ttl, MyStringTokenizer st, Name origin) throws IOException {
        Record rec;
        String s = st.nextToken();
        if (s.equals("#")) {
            byte[] data;
            s = st.nextToken();
            short length = Short.parseShort(s);
            if (length != (data = base16.fromString(s = st.remainingTokens())).length) {
                throw new IOException("Invalid unknown RR encoding: length mismatch");
            }
            DataByteInputStream in = new DataByteInputStream(data);
            rec = Record.newRecord(name, type, dclass, ttl, (int)length, in);
        }
        st.putBackToken(s);
        try {
            Class rrclass = Record.toClass(type);
            Constructor m = rrclass.getDeclaredConstructor(fromTextList);
            rec = (Record)m.newInstance(name, new Short(dclass), new Integer(ttl), st, origin);
            return rec;
        }
        catch (ClassNotFoundException classNotFoundException) {
            rec = new UNKRecord(name, type, dclass, ttl, st, origin);
            return rec;
        }
        catch (InvocationTargetException e) {
            if (Options.check("verbose")) {
                System.err.println("from text: " + e);
                System.err.println(e.getTargetException());
            }
            return null;
        }
        catch (Exception e) {
            if (Options.check("verbose")) {
                System.err.println("from text: " + e);
            }
            return null;
        }
    }

    static Record fromWire(DataByteInputStream in, int section) throws IOException {
        int start = in.getPos();
        Name name = new Name(in);
        short type = in.readShort();
        short dclass = in.readShort();
        if (section == 0) {
            return Record.newRecord(name, type, dclass);
        }
        int ttl = in.readInt();
        short length = in.readShort();
        if (length == 0) {
            return Record.newRecord(name, type, dclass, ttl);
        }
        Record rec = Record.newRecord(name, type, dclass, ttl, (int)length, in);
        rec.wireLength = in.getPos() - start;
        return rec;
    }

    public static Record fromWire(byte[] b, int section) throws IOException {
        DataByteInputStream in = new DataByteInputStream(b);
        return Record.fromWire(in, section);
    }

    public short getDClass() {
        return this.dclass;
    }

    public Name getName() {
        return this.name;
    }

    public short getRRsetType() {
        if (this.type == 24) {
            SIGRecord sig = (SIGRecord)this;
            return sig.getTypeCovered();
        }
        return this.type;
    }

    public int getTTL() {
        return this.ttl;
    }

    public short getType() {
        return this.type;
    }

    public short getWireLength() {
        return (short)this.wireLength;
    }

    public int hashCode() {
        try {
            byte[] array1 = this.toWire(1);
            return array1.hashCode();
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public static Record newRecord(Name name, short type, short dclass) {
        return Record.newRecord(name, type, dclass, 0, 0, null);
    }

    public static Record newRecord(Name name, short type, short dclass, int ttl) {
        return Record.newRecord(name, type, dclass, ttl, 0, null);
    }

    private static Record newRecord(Name name, short type, short dclass, int ttl, int length, DataByteInputStream in) throws IOException {
        Record rec;
        int recstart = in == null ? 0 : in.getPos();
        try {
            Class rrclass = Record.toClass(type);
            Constructor m = rrclass.getDeclaredConstructor(fromWireList);
            rec = (Record)m.newInstance(name, new Short(dclass), new Integer(ttl), new Integer(length), in);
        }
        catch (ClassNotFoundException classNotFoundException) {
            rec = new UNKRecord(name, type, dclass, ttl, length, in);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IOException) {
                throw (IOException)e.getTargetException();
            }
            if (Options.check("verbose")) {
                System.err.println("new record: " + e);
                System.err.println(e.getTargetException());
            }
            return null;
        }
        catch (Exception e) {
            if (Options.check("verbose")) {
                System.err.println("new record: " + e);
            }
            return null;
        }
        if (in != null && in.getPos() - recstart != length) {
            throw new IOException("Invalid record length");
        }
        rec.wireLength = length;
        return rec;
    }

    public static Record newRecord(Name name, short type, short dclass, int ttl, int length, byte[] data) {
        DataByteInputStream dbs = data != null ? new DataByteInputStream(data) : null;
        try {
            return Record.newRecord(name, type, dclass, ttl, length, dbs);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static Record newRecord(Name name, short type, short dclass, int ttl, byte[] data) {
        return Record.newRecord(name, type, dclass, ttl, data.length, data);
    }

    public abstract String rdataToString();

    public byte[] rdataToWireCanonical() throws IOException {
        DataByteOutputStream out = new DataByteOutputStream();
        this.rrToWireCanonical(out);
        return out.toByteArray();
    }

    abstract void rrToWire(DataByteOutputStream var1, Compression var2) throws IOException;

    void rrToWireCanonical(DataByteOutputStream out) throws IOException {
        this.rrToWire(out, null);
    }

    private static final Class toClass(short type) throws ClassNotFoundException {
        if (type < 0 || type > 255) {
            throw new ClassNotFoundException();
        }
        if (knownTypes[type] != null) {
            return knownTypes[type];
        }
        Class<?> clazz = class$org$xbill$DNS$Record;
        if (clazz == null) {
            try {
                clazz = class$org$xbill$DNS$Record = Class.forName("org.xbill.DNS.Record");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String s = clazz.toString();
        Record.knownTypes[type] = Class.forName(String.valueOf(s.substring(6, s.length() - 6)) + Type.string(type) + "Record");
        return knownTypes[type];
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        sb.append("\t");
        if (Options.check("BINDTTL")) {
            sb.append(TTL.format(this.ttl));
        } else {
            sb.append((long)this.ttl & 0xFFFFFFFFL);
        }
        sb.append(" ");
        if (this.dclass != 1 || !Options.check("noPrintIN")) {
            sb.append(DClass.string(this.dclass));
            sb.append(" ");
        }
        sb.append(Type.string(this.type));
        sb.append("\t\t");
        if (this.wireLength != 0) {
            sb.append(this.rdataToString());
        }
        return sb.toString();
    }

    public byte[] toWire(int section) throws IOException {
        DataByteOutputStream out = new DataByteOutputStream();
        this.toWire(out, section, null);
        return out.toByteArray();
    }

    void toWire(DataByteOutputStream out, int section, Compression c) throws IOException {
        int start = out.getPos();
        this.name.toWire(out, c);
        out.writeShort(this.type);
        out.writeShort(this.dclass);
        if (section == 0) {
            return;
        }
        out.writeInt(this.ttl);
        int lengthPosition = out.getPos();
        out.writeShort(0);
        this.rrToWire(out, c);
        out.writeShortAt(out.getPos() - lengthPosition - 2, lengthPosition);
        this.wireLength = out.getPos() - start;
    }

    public byte[] toWireCanonical() throws IOException {
        DataByteOutputStream out = new DataByteOutputStream();
        this.toWireCanonical(out);
        return out.toByteArray();
    }

    void toWireCanonical(DataByteOutputStream out) throws IOException {
        this.name.toWireCanonical(out);
        out.writeShort(this.type);
        out.writeShort(this.dclass);
        out.writeInt(this.ttl);
        int lengthPosition = out.getPos();
        out.writeShort(0);
        this.rrToWireCanonical(out);
        out.writeShortAt(out.getPos() - lengthPosition - 2, lengthPosition);
    }

    public Record withName(Name name) {
        Record rec = null;
        try {
            rec = (Record)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        rec.name = name;
        return rec;
    }
}

