/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Cache;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.FindServer;
import org.xbill.DNS.Message;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.Type;

public final class dns {
    private static Resolver res;
    private static Hashtable caches;
    private static Name[] searchPath;
    private static boolean searchPathSet;
    private static boolean initialized;

    static {
        dns.initialize();
    }

    private dns() {
    }

    private static synchronized void clearCaches() {
        Enumeration e = caches.elements();
        while (e.hasMoreElements()) {
            Cache c = (Cache)e.nextElement();
            c.clearCache();
        }
    }

    public static Record[] getAnyRecords(String name, short type) {
        return dns.getRecords(name, type, (short)1, (byte)1);
    }

    public static Record[] getAnyRecords(String namestr, short type, short dclass) {
        return dns.getRecords(namestr, type, dclass, (byte)1);
    }

    public static Record[] getAnyRecordsByAddress(String addr, short type) {
        String name = dns.inaddrString(addr);
        return dns.getRecords(name, type, (short)1, (byte)1);
    }

    public static synchronized Cache getCache() {
        return dns.getCache((short)1);
    }

    public static synchronized Cache getCache(short dclass) {
        Cache c = (Cache)caches.get(new Short(dclass));
        if (c == null) {
            c = new Cache(dclass);
            caches.put(new Short(dclass), c);
        }
        return c;
    }

    public static Record[] getRecords(String name, short type) {
        return dns.getRecords(name, type, (short)1, (byte)2);
    }

    public static Record[] getRecords(String namestr, short type, short dclass) {
        return dns.getRecords(namestr, type, dclass, (byte)2);
    }

    public static Record[] getRecords(String namestr, short type, short dclass, byte cred) {
        Record[] answers = null;
        Name name = new Name(namestr);
        if (!Type.isRR(type) && type != 255) {
            return null;
        }
        if (searchPath == null || name.isQualified()) {
            answers = dns.lookup(name, type, dclass, cred, 0, false);
        } else {
            int i = 0;
            while (i < searchPath.length) {
                answers = dns.lookup(new Name(namestr, searchPath[i]), type, dclass, cred, 0, false);
                if (answers != null) break;
                ++i;
            }
        }
        return answers;
    }

    public static Record[] getRecordsByAddress(String addr, short type) {
        String name = dns.inaddrString(addr);
        return dns.getRecords(name, type, (short)1, (byte)2);
    }

    public static synchronized Resolver getResolver() {
        return res;
    }

    public static String inaddrString(String s) {
        InetAddress address;
        try {
            address = InetAddress.getByName(s);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        return dns.inaddrString(address);
    }

    public static String inaddrString(InetAddress addr) {
        byte[] address = addr.getAddress();
        StringBuffer sb = new StringBuffer();
        int i = 3;
        while (i >= 0) {
            sb.append(address[i] & 0xFF);
            sb.append(".");
            --i;
        }
        sb.append("IN-ADDR.ARPA.");
        return sb.toString();
    }

    private static synchronized void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        if (res == null) {
            try {
                dns.setResolver(new ExtendedResolver());
            }
            catch (UnknownHostException unknownHostException) {
                System.err.println("Failed to initialize resolver");
                System.exit(-1);
            }
        }
        if (!searchPathSet) {
            searchPath = FindServer.searchPath();
        }
        if (caches == null) {
            caches = new Hashtable();
        } else {
            dns.clearCaches();
        }
    }

    private static Record[] lookup(Name name, short type, short dclass, byte cred, int iterations, boolean querysent) {
        Message response;
        if (iterations > 6) {
            return null;
        }
        if (Options.check("verbose")) {
            System.err.println("lookup " + name + " " + Type.string(type));
        }
        Cache cache = dns.getCache(dclass);
        SetResponse cached = cache.lookupRecords(name, type, cred);
        if (Options.check("verbose")) {
            System.err.println(cached);
        }
        if (cached.isSuccessful()) {
            Enumeration e;
            RRset[] rrsets = cached.answers();
            Vector v = new Vector();
            int i = 0;
            i = 0;
            while (i < rrsets.length) {
                e = rrsets[i].rrs();
                while (e.hasMoreElements()) {
                    v.addElement(e.nextElement());
                }
                ++i;
            }
            Record[] answers = new Record[v.size()];
            e = v.elements();
            i = 0;
            while (e.hasMoreElements()) {
                answers[i++] = (Record)e.nextElement();
            }
            return answers;
        }
        if (cached.isNXDOMAIN() || cached.isNXRRSET()) {
            return null;
        }
        if (cached.isCNAME()) {
            CNAMERecord cname = cached.getCNAME();
            return dns.lookup(cname.getTarget(), type, dclass, cred, ++iterations, false);
        }
        if (cached.isDNAME()) {
            DNAMERecord dname = cached.getDNAME();
            return dns.lookup(name.fromDNAME(dname), type, dclass, cred, ++iterations, false);
        }
        if (querysent) {
            return null;
        }
        Record question = Record.newRecord(name, type, dclass);
        Message query = Message.newQuery(question);
        try {
            response = res.send(query);
        }
        catch (Exception exception) {
            return null;
        }
        short rcode = response.getHeader().getRcode();
        if (rcode == 0 || rcode == 3) {
            cache.addMessage(response);
        }
        if (rcode != 0) {
            return null;
        }
        return dns.lookup(name, type, dclass, cred, iterations, true);
    }

    static boolean matchType(short type1, short type2) {
        return type1 == 255 || type2 == 255 || type1 == type2;
    }

    public static synchronized void setResolver(Resolver _res) {
        dns.initialize();
        res = _res;
    }

    public static synchronized void setSearchPath(String[] domains) {
        if (domains == null || domains.length == 0) {
            searchPath = null;
        } else {
            searchPath = new Name[domains.length];
            int i = 0;
            while (i < domains.length) {
                dns.searchPath[i] = new Name(domains[i]);
                ++i;
            }
        }
        searchPathSet = true;
    }
}

