/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;

public class MyStringTokenizer
implements Enumeration {
    private char[] string;
    private String delim;
    private boolean returnTokens;
    private int current;
    private String putBack;
    private boolean noescape;

    public MyStringTokenizer(String _s) {
        this(_s, " \t\n\r", false);
    }

    public MyStringTokenizer(String _s, String _delim) {
        this(_s, _delim, false);
    }

    public MyStringTokenizer(String _s, String _delim, boolean _returnTokens) {
        this.string = new char[_s.length()];
        _s.getChars(0, _s.length(), this.string, 0);
        this.delim = _delim;
        this.returnTokens = _returnTokens;
        this.current = 0;
    }

    public boolean hasMoreDelimiters() {
        return this.current < this.string.length;
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public boolean hasMoreTokens() {
        if (this.putBack != null) {
            return true;
        }
        if (this.current >= this.string.length) {
            return false;
        }
        if (!this.isDelim(this.current) || this.returnTokens) {
            return true;
        }
        int t = this.current;
        while (t < this.string.length && this.isDelim(t)) {
            ++t;
        }
        return t < this.string.length;
    }

    private boolean isDelim(int i) {
        return this.delim.indexOf(this.string[i]) >= 0;
    }

    public static void main(String[] args) throws IOException {
        InputStreamReader isr = new InputStreamReader(System.in);
        BufferedReader br = new BufferedReader(isr);
        block0: while (true) {
            MyStringTokenizer st = new MyStringTokenizer(br.readLine());
            while (true) {
                if (!st.hasMoreTokens()) continue block0;
                System.out.println(st.nextToken());
            }
            break;
        }
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public String nextToken() {
        if (this.putBack != null) {
            String s = this.putBack;
            this.putBack = null;
            return s;
        }
        int start = this.current;
        if (this.current >= this.string.length) {
            return null;
        }
        if (this.isDelim(this.current)) {
            while (this.current < this.string.length && this.isDelim(this.current)) {
                ++this.current;
            }
            if (this.returnTokens) {
                return new String(this.string, start, this.current - start);
            }
            if (this.current >= this.string.length) {
                return null;
            }
        }
        boolean quoted = false;
        boolean escaped = false;
        boolean bracketed = false;
        StringBuffer sb = new StringBuffer();
        while (this.current != this.string.length) {
            if (escaped) {
                if (Character.digit(this.string[this.current], 10) >= 0) {
                    String s = new String(this.string, this.current, 3);
                    int i = Integer.parseInt(s);
                    sb.append((char)i);
                    this.current += 2;
                } else {
                    sb.append(this.string[this.current]);
                }
                escaped = false;
            } else if (quoted) {
                if (this.string[this.current] == '\"') {
                    ++this.current;
                    break;
                }
                sb.append(this.string[this.current]);
            } else if (bracketed) {
                if (this.string[this.current] == ']') {
                    bracketed = false;
                }
                sb.append(this.string[this.current]);
            } else if (this.string[this.current] == '\"') {
                quoted = true;
            } else if (this.string[this.current] == '\\' && !this.noescape) {
                escaped = true;
            } else if (this.string[this.current] == '[' && this.delim.indexOf(46) >= 0) {
                bracketed = true;
                sb.append(this.string[this.current]);
            } else {
                if (this.isDelim(this.current)) break;
                sb.append(this.string[this.current]);
            }
            ++this.current;
        }
        return sb.toString();
    }

    public void putBackToken(String s) {
        this.putBack = s;
    }

    public String remainingTokens() {
        StringBuffer sb = new StringBuffer();
        while (this.hasMoreTokens()) {
            sb.append(this.nextToken());
        }
        return sb.toString();
    }

    public void setNoEscapeCharacter() {
        this.noescape = true;
    }
}

