/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.xbill.DNS.utils.hexdump;
import org.xbill.DNS.utils.md5;

public class hmacSigner {
    private byte[] ipad;
    private byte[] opad;
    private ByteArrayOutputStream bytes;
    private static final byte IPAD = 54;
    private static final byte OPAD = 92;
    private static final byte PADLEN = 64;
    public static boolean verbose;

    public hmacSigner(byte[] byArray) {
        byte[] key;
        if (byArray.length > 64) {
            key = md5.compute(byArray);
        }
        this.ipad = new byte[64];
        this.opad = new byte[64];
        int i = 0;
        while (i < key.length) {
            this.ipad[i] = (byte)(key[i] ^ 0x36);
            this.opad[i] = (byte)(key[i] ^ 0x5C);
            ++i;
        }
        while (i < 64) {
            this.ipad[i] = 54;
            this.opad[i] = 92;
            ++i;
        }
        this.bytes = new ByteArrayOutputStream();
        try {
            this.bytes.write(this.ipad);
        }
        catch (IOException iOException) {}
        if (verbose) {
            System.err.println(hexdump.dump("key", key));
        }
    }

    public void addData(byte[] b) {
        if (verbose) {
            System.err.println(hexdump.dump("add", b));
        }
        try {
            this.bytes.write(b);
        }
        catch (IOException iOException) {}
    }

    public void addData(byte[] b, int offset, int length) {
        if (length < 0 || offset + length > b.length) {
            if (verbose) {
                System.err.println("Invalid parameters");
            }
            return;
        }
        if (verbose) {
            System.err.println(hexdump.dump("partial add", b, offset, length));
        }
        this.bytes.write(b, offset, length);
    }

    private static boolean byteArrayCompare(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            return false;
        }
        int i = 0;
        while (i < b1.length) {
            if (b1[i] != b2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void clear() {
        this.bytes = new ByteArrayOutputStream();
        try {
            this.bytes.write(this.ipad);
        }
        catch (IOException iOException) {}
    }

    public byte[] sign() {
        byte[] output = md5.compute(this.bytes.toByteArray());
        this.bytes = new ByteArrayOutputStream();
        try {
            this.bytes.write(this.opad);
            this.bytes.write(output);
        }
        catch (IOException iOException) {}
        byte[] b = md5.compute(this.bytes.toByteArray());
        if (verbose) {
            System.err.println(hexdump.dump("sig", b));
        }
        return b;
    }

    public boolean verify(byte[] signature) {
        if (verbose) {
            System.err.println(hexdump.dump("ver", signature));
        }
        return hmacSigner.byteArrayCompare(signature, this.sign());
    }
}

