/*
 * Decompiled with CFR 0.152.
 */
package simtools.ui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.StringTokenizer;

public class UserProperties
extends Properties {
    protected File _file;
    protected String _productName;
    protected LinkedList _infoList = new LinkedList();
    private ArrayList masterPropertiesList;
    protected boolean _propertiesLoadedFromFile = false;
    protected static final String keyValueSeparators = "=: \t\r\n\f";
    protected static final String strictKeyValueSeparators = "=:";
    protected static final String specialSaveChars = "=: \t\r\n\f#!";
    protected static final String whiteSpaceChars = " \t\r\n\f";
    protected static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public UserProperties(String string) {
        this(string, false);
    }

    public UserProperties(String string, boolean bl) {
        super(bl ? System.getProperties() : null);
        String string2 = System.getProperty(string + ".home", System.getProperty("user.home", ""));
        this._file = new File(string2, "." + string);
        if (!this._file.exists() && this._file.mkdirs()) {
            this._file = new File(this._file, "config");
        } else if (this._file.isDirectory()) {
            this._file = new File(this._file, "config");
        }
        this._productName = string;
    }

    public UserProperties(File file) {
        super((Properties)null);
        this._file = file;
        this._productName = file.getName();
    }

    public File getFile() {
        return this._file;
    }

    public void read() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this._file);
            this.load(fileInputStream);
            this._propertiesLoadedFromFile = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void write() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this._file);
            this.store(fileOutputStream, null);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void read2() throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(this._file);
        this.load(fileInputStream);
        this._propertiesLoadedFromFile = true;
    }

    public String getProperty(String string) {
        Object object;
        Object object2;
        Object object3 = null;
        if (this.masterPropertiesList != null) {
            object2 = this.masterPropertiesList.iterator();
            while (object2.hasNext()) {
                object = (UserProperties)object2.next();
                String string2 = ((UserProperties)object).getProperty(string);
                if (string2 == null) continue;
                object3 = string2;
            }
        }
        if ((object2 = super.getProperty(string)) != null) {
            object3 = object2;
        }
        if ((object = System.getProperty(string)) != null) {
            object3 = object;
        }
        return object3;
    }

    public void write2() throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this._file);
        this.store(fileOutputStream, null);
    }

    public String getString(String string, String string2) {
        return this.getProperty(string, string2);
    }

    public void setString(String string, String string2) {
        this.setProperty(string, string2);
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.getProperty(string, bl ? "TRUE" : "FALSE");
        return string2.toUpperCase().equals("TRUE");
    }

    public void setBoolean(String string, boolean bl) {
        this.setProperty(string, bl ? "TRUE" : "FALSE");
    }

    public double getDouble(String string, double d) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return d;
        }
        try {
            double d2 = Double.parseDouble(string2);
            return d2;
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public float getFloat(String string, float f) {
        return (float)this.getDouble(string, f);
    }

    public void setDouble(String string, double d) {
        this.setProperty(string, String.valueOf(d));
    }

    public void setFloat(String string, float f) {
        this.setProperty(string, String.valueOf(f));
    }

    public long getLong(String string, long l) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return l;
        }
        try {
            return Long.decode(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public int getInt(String string, int n) {
        return (int)this.getLong(string, n);
    }

    public short getShort(String string, short s) {
        return (short)this.getLong(string, s);
    }

    public byte getByte(String string, byte by) {
        return (byte)this.getLong(string, by);
    }

    public void setLong(String string, long l) {
        this.setProperty(string, String.valueOf(l));
    }

    public void setInt(String string, int n) {
        this.setProperty(string, String.valueOf(n));
    }

    public void setShort(String string, short s) {
        this.setProperty(string, String.valueOf(s));
    }

    public void setByte(String string, byte by) {
        this.setProperty(string, String.valueOf(by));
    }

    public synchronized Object setProperty(String string, String string2) {
        Object object = null;
        String string3 = super.getProperty(string);
        if (string3 != null) {
            object = this.put(string, string2);
        } else {
            String string4 = null;
            if (this.masterPropertiesList != null) {
                Iterator iterator = this.masterPropertiesList.iterator();
                while (iterator.hasNext() && string4 == null) {
                    UserProperties userProperties = (UserProperties)iterator.next();
                    string4 = userProperties.getProperty(string);
                }
            }
            if (string4 != null && string4.equals(string2)) {
                object = string4;
            } else if (string4 == null || string4 != null && !string4.equals(string2)) {
                this._infoList.add(new Info(Info.KEY, string));
                object = this.put(string, string2);
            }
        }
        return object;
    }

    public void addComment(String string) {
        if (this._propertiesLoadedFromFile) {
            return;
        }
        if ((string = string.trim()).length() == 0) {
            string = "#";
        } else if (string.charAt(0) != '#') {
            string = "# " + string;
        }
        this._infoList.add(new Info(Info.COMMENT, string));
    }

    public void addNewLine() {
        if (this._propertiesLoadedFromFile) {
            return;
        }
        this._infoList.add(new Info(Info.EMPTY_LINE, null));
    }

    public synchronized void load(InputStream inputStream) throws IOException {
        this._infoList = new LinkedList();
        this.masterPropertiesList = new ArrayList();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "8859_1"));
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            int n;
            int n2;
            int n3;
            Object object;
            if (string.trim().length() == 0) {
                this._infoList.add(new Info(Info.EMPTY_LINE, null));
            }
            if (string.length() <= 0) continue;
            char c = string.charAt(0);
            if (c == '#' || c == '!') {
                this._infoList.add(new Info(Info.COMMENT, string));
                continue;
            }
            if (string.startsWith("@import")) {
                object = new StringTokenizer(string);
                if (((StringTokenizer)object).countTokens() <= 1) continue;
                ((StringTokenizer)object).nextToken();
                String string2 = ((StringTokenizer)object).nextToken();
                UserProperties userProperties = new UserProperties(new File(string2));
                try {
                    userProperties.read2();
                    this.masterPropertiesList.add(userProperties);
                }
                catch (IOException iOException) {
                    System.err.println("Failed to read imported file:" + string2);
                }
                this._infoList.add(new Info(Info.MASTER_LINE, string2));
                continue;
            }
            while (this.continueLine(string)) {
                object = bufferedReader.readLine();
                if (object == null) {
                    object = "";
                }
                String string3 = string.substring(0, string.length() - 1);
                n3 = 0;
                for (n3 = 0; n3 < ((String)object).length() && whiteSpaceChars.indexOf(((String)object).charAt(n3)) != -1; ++n3) {
                }
                object = ((String)object).substring(n3, ((String)object).length());
                string = new String(string3 + (String)object);
            }
            int n4 = string.length();
            for (n2 = 0; n2 < n4 && whiteSpaceChars.indexOf(string.charAt(n2)) != -1; ++n2) {
            }
            if (n2 == n4) continue;
            for (n3 = n2; n3 < n4; ++n3) {
                char c2 = string.charAt(n3);
                if (c2 == '\\') {
                    ++n3;
                    continue;
                }
                if (keyValueSeparators.indexOf(c2) != -1) break;
            }
            for (n = n3; n < n4 && whiteSpaceChars.indexOf(string.charAt(n)) != -1; ++n) {
            }
            if (n < n4 && strictKeyValueSeparators.indexOf(string.charAt(n)) != -1) {
                ++n;
            }
            while (n < n4 && whiteSpaceChars.indexOf(string.charAt(n)) != -1) {
                ++n;
            }
            String string4 = string.substring(n2, n3);
            String string5 = n3 < n4 ? string.substring(n, n4) : "";
            string4 = this.loadConvert(string4);
            string5 = this.loadConvert(string5);
            this.put(string4, string5);
            this._infoList.add(new Info(Info.KEY, string4));
        }
        return;
    }

    protected boolean continueLine(String string) {
        int n = 0;
        int n2 = string.length() - 1;
        while (n2 >= 0 && string.charAt(n2--) == '\\') {
            ++n;
        }
        return n % 2 == 1;
    }

    protected String loadConvert(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if ((n3 = string.charAt(n2++)) == 92) {
                if ((n3 = string.charAt(n2++)) == 117) {
                    int n4 = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        n3 = string.charAt(n2++);
                        switch (n3) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                n4 = (n4 << 4) + n3 - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                n4 = (n4 << 4) + 10 + n3 - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                n4 = (n4 << 4) + 10 + n3 - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    stringBuffer.append((char)n4);
                    continue;
                }
                if (n3 == 116) {
                    n3 = 9;
                } else if (n3 == 114) {
                    n3 = 13;
                } else if (n3 == 110) {
                    n3 = 10;
                } else if (n3 == 102) {
                    n3 = 12;
                }
                stringBuffer.append((char)n3);
                continue;
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    protected String saveConvert(String string, boolean bl) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    if (i == 0 || bl) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        stringBuffer.append('\\');
                        stringBuffer.append('u');
                        stringBuffer.append(UserProperties.toHex(c >> 12 & 0xF));
                        stringBuffer.append(UserProperties.toHex(c >> 8 & 0xF));
                        stringBuffer.append(UserProperties.toHex(c >> 4 & 0xF));
                        stringBuffer.append(UserProperties.toHex(c & 0xF));
                        continue block8;
                    }
                    if (specialSaveChars.indexOf(c) != -1) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public synchronized void store(OutputStream outputStream, String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "8859_1"));
        for (int i = 0; i < this._infoList.size(); ++i) {
            Info info = (Info)this._infoList.get(i);
            if (info._type == Info.COMMENT) {
                bufferedWriter.write(info._value);
                bufferedWriter.newLine();
                continue;
            }
            if (info._type == Info.EMPTY_LINE) {
                bufferedWriter.newLine();
                continue;
            }
            if (info._type == Info.MASTER_LINE) {
                bufferedWriter.write("@import " + info._value);
                bufferedWriter.newLine();
                continue;
            }
            String string2 = info._value;
            String string3 = (String)this.get(string2);
            string2 = this.saveConvert(string2, true);
            string3 = this.saveConvert(string3, false);
            bufferedWriter.write(string2 + "=" + string3);
            bufferedWriter.newLine();
        }
        bufferedWriter.flush();
    }

    protected static char toHex(int n) {
        return hexDigit[n & 0xF];
    }

    protected static class Info {
        public static final String IMPORT_FILE_PREFIX = "@import";
        public static int KEY = 0;
        public static int COMMENT = 1;
        public static int EMPTY_LINE = 2;
        public static int MASTER_LINE = 3;
        public final int _type;
        public final String _value;

        public Info(int n, String string) {
            this._type = n;
            this._value = string;
        }
    }
}

