/*
 * Decompiled with CFR 0.152.
 */
package org.instituteofthefuture.exif;

import com.apple.mrj.MRJAboutHandler;
import com.apple.mrj.MRJApplicationUtils;
import com.apple.mrj.MRJOpenDocumentHandler;
import com.apple.mrj.MRJPrefsHandler;
import com.apple.mrj.MRJQuitHandler;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import org.instituteofthefuture.IFConstants;
import org.instituteofthefuture.exif.EOMConstants;
import org.instituteofthefuture.exif.ExifOMatic;
import org.instituteofthefuture.gui.AboutDialog;

public class EOMMenuBar
extends JMenuBar
implements ActionListener,
EOMConstants,
MRJAboutHandler,
MRJQuitHandler,
MRJOpenDocumentHandler,
MRJPrefsHandler {
    private static boolean DEBUG = false;
    private ExifOMatic par;

    private final void registerMRJHandlers() {
        MRJApplicationUtils.registerAboutHandler(this);
        MRJApplicationUtils.registerQuitHandler(this);
        MRJApplicationUtils.registerOpenDocumentHandler(this);
        if (IFConstants.isMacOSX) {
            MRJApplicationUtils.registerPrefsHandler(this);
        }
    }

    private final void addFileMenu() {
        if (IFConstants.isMacOSX) {
            this.add(this.buildMenu("File", false, new String[]{"Open...", "Close", "Export...", "Process Folder...", "-", "Postcardware"}, new char[]{'O', 'W', 'E', 'F', ' ', 'D'}, "", ""));
        } else {
            this.add(this.buildMenu("File", false, new String[]{"Open...", "Close", "Export...", "Process Folder...", "-", "Exit"}, new char[]{'O', 'W', 'E', 'F', ' ', 'X'}, "", ""));
            this.add(this.buildMenu("About", false, new String[]{"Preferences", "-", "About", "Postcardware"}, new char[]{';', ' ', 'I', 'D'}, "", ""));
        }
    }

    private final JMenu buildMenu(String string, boolean bl, String[] stringArray, char[] cArray, String string2, String string3) {
        JMenu jMenu = new JMenu(string);
        EOMMenuBar.stylizeMenu(jMenu);
        EOMMenuBar.stylizeMenu(jMenu.getPopupMenu());
        ButtonGroup buttonGroup = new ButtonGroup();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-")) {
                jMenu.addSeparator();
            } else {
                JMenuItem jMenuItem = new JMenuItem();
                if (bl) {
                    jMenuItem = new JRadioButtonMenuItem(stringArray[n] + string2);
                    buttonGroup.add(jMenuItem);
                    if (jMenuItem.getText().indexOf(string3) != -1) {
                        jMenuItem.setSelected(true);
                    }
                } else {
                    jMenuItem = new JMenuItem(stringArray[n] + string2);
                }
                if (cArray != null && cArray[n] != ' ') {
                    jMenuItem.setAccelerator(KeyStroke.getKeyStroke((int)cArray[n], IFConstants.OS_KEY_MASK));
                }
                EOMMenuBar.stylizeMenu(jMenuItem);
                jMenuItem.addActionListener(this);
                jMenu.add(jMenuItem);
            }
            ++n;
        }
        return jMenu;
    }

    public static JComponent stylizeMenu(JComponent jComponent) {
        return jComponent;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)object;
            String string = jMenuItem.getText();
            if (string.equals("Open...")) {
                this.par.open();
            } else if (string.equals("Close")) {
                this.par.close();
            } else if (string.equals("Export...")) {
                this.par.export();
            } else if (string.equals("Process Folder...")) {
                this.par.processFolder();
            } else if (string.equals("About")) {
                this.par.about();
            } else if (string.equals("Preferences")) {
                this.par.showPrefsDialog();
            } else if (string.equals("Postcardware")) {
                AboutDialog.showPostcardware(this.par);
            } else if (string.equals("Exit")) {
                this.par.exit();
            }
        }
    }

    public void handleQuit() {
        this.par.exit();
    }

    public void handlePrefs() {
        this.par.showPrefsDialog();
    }

    public void handleAbout() {
        this.par.about();
    }

    public void handleOpenFile(File file) {
        this.par.openFile(file);
    }

    private static final void output(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    public void setEnabled(String string, boolean bl) {
        int n = 0;
        while (n < this.getMenuCount()) {
            JMenu jMenu = this.getMenu(n);
            int n2 = 0;
            while (n2 < jMenu.getItemCount()) {
                JMenuItem jMenuItem = jMenu.getItem(n2);
                if (jMenuItem != null && jMenuItem.getText().equals(string)) {
                    jMenuItem.setEnabled(bl);
                }
                ++n2;
            }
            ++n;
        }
    }

    public EOMMenuBar(ExifOMatic exifOMatic) {
        this.par = exifOMatic;
        this.registerMRJHandlers();
        this.addFileMenu();
        this.setEnabled("Export...", false);
        this.setEnabled("Close", false);
        EOMMenuBar.stylizeMenu(this);
    }
}

