/*
 * Decompiled with CFR 0.152.
 */
package org.instituteofthefuture.exif;

import com.apple.mrj.MRJFileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.Hashtable;
import java.util.Properties;
import org.instituteofthefuture.IFConstants;
import org.instituteofthefuture.exif.EOMConstants;
import org.instituteofthefuture.gui.Alerts;

public class EOMPrefs
implements EOMConstants {
    private static Properties prefs;
    private static File prefsFile;
    public static String EXPORT_UKNOWNS;
    public static String TXT_DELIMITOR;
    private static Hashtable DELIMITOR_TABLE;

    public static void load() {
        try {
            prefs = new Properties();
            prefs.load(new FileInputStream(prefsFile));
        }
        catch (Exception exception) {
            EOMPrefs.setDefaults();
        }
    }

    public static boolean store() {
        try {
            prefs.store(new FileOutputStream(prefsFile), "EXIF-O-Matic Preferences");
        }
        catch (Exception exception) {
            Alerts.showError("Preferences Error", "Unable to write preferences, exiting!");
            return false;
        }
        return true;
    }

    public static String get(String string) {
        if (!prefs.containsKey(string)) {
            prefs.setProperty(string, EOMPrefs.getDefault(string));
        }
        return prefs.getProperty(string);
    }

    public static void set(String string, String string2) {
        prefs.setProperty(string, string2);
    }

    public static void setDefaults() {
        prefs = new Properties();
        prefs.setProperty(EXPORT_UKNOWNS, EOMPrefs.getDefault(EXPORT_UKNOWNS));
        prefs.setProperty(TXT_DELIMITOR, EOMPrefs.getDefault(TXT_DELIMITOR));
    }

    public static String getDefault(String string) {
        if (string.equals(EXPORT_UKNOWNS)) {
            return "false";
        }
        if (string.equals(TXT_DELIMITOR)) {
            return "tab";
        }
        return null;
    }

    public static String getDelimitor(String string) {
        return DELIMITOR_TABLE.get(string).toString();
    }

    public static Object[] getDelimitorKeys() {
        return DELIMITOR_TABLE.keySet().toArray();
    }

    static {
        prefsFile = new File("EOMPrefs.properties");
        EXPORT_UKNOWNS = "ExportUnknownTags";
        TXT_DELIMITOR = "TextDelimitor";
        try {
            if (IFConstants.isMac) {
                String string = MRJFileUtils.findFolder(MRJFileUtils.kPreferencesFolderType).getPath();
                prefsFile = new File(string, "EOMPrefs.properties");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            prefsFile = new File("EOMPrefs.properties");
        }
        DELIMITOR_TABLE = new Hashtable();
        DELIMITOR_TABLE.put("tab", "\t");
        DELIMITOR_TABLE.put("space", " ");
        DELIMITOR_TABLE.put("colon", " : ");
        DELIMITOR_TABLE.put("slash", " / ");
        DELIMITOR_TABLE.put("dash", " - ");
        DELIMITOR_TABLE.put("equals sign", " = ");
        DELIMITOR_TABLE.put("comma", " , ");
        DELIMITOR_TABLE.put("end of line", IFConstants.EOL);
    }
}

