/*
 * Decompiled with CFR 0.152.
 */
package org.instituteofthefuture.exif;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.instituteofthefuture.IFConstants;
import org.instituteofthefuture.exif.EOMPrefs;
import org.instituteofthefuture.exif.ExifOMatic;
import org.instituteofthefuture.gui.Alerts;
import org.instituteofthefuture.gui.FileDialogs;
import org.instituteofthefuture.io.FileUtilities;
import org.instituteofthefuture.io.ImageUtilities;

public class ExifInfoWriter
extends JFrame
implements IFConstants,
ActionListener {
    static boolean independant = false;
    private static boolean DEBUG = false;
    public static final int FILE_HTML = 0;
    public static final int FILE_TXT = 1;
    public static final int FILE_XML = 2;
    private static String EXIF_SUB_DIR = "exif/";
    private static String THUMBNAIL_SUB_DIR = "thumbnails/";
    private static String MEDIUM_SUB_DIR = "medium/";
    private static String JS_FILE_NAME = "info.js";
    private File selectedFile;
    private JTextArea status;
    private JTextField jtfUserName;
    private JTextField jtfYear;

    public File selectFile() {
        this.setStatus("selecting file...");
        File file = FileDialogs.showOpenAWT("Select an Image to Process", null, null, "jpg", this);
        if (file == null) {
            this.setStatus("no file selected");
            return null;
        }
        this.setFile(file);
        return this.selectedFile;
    }

    public void setFile(File file) {
        this.selectedFile = file;
        this.setStatus("viewing file info for " + this.selectedFile.getAbsolutePath());
    }

    public void prepareForPhotoBot() {
        this.writeInfoForFolder(this.selectedFile.getParentFile(), false, 0, "../../exif.css");
        try {
            this.writePhotoBotInfo(this.selectedFile, false, this.jtfUserName.getText(), this.jtfYear.getText());
        }
        catch (IOException iOException) {
            System.out.println("CRAP!");
        }
    }

    private final boolean writePhotoBotInfo(File file, boolean bl, String string, String string2) throws IOException {
        if (file == null) {
            this.setStatus("no folder selected");
            return false;
        }
        File file2 = file.isFile() ? new File(file.getParent()) : file;
        File file3 = new File(file2, THUMBNAIL_SUB_DIR);
        File file4 = new File(file2, MEDIUM_SUB_DIR);
        File file5 = new File(file2, JS_FILE_NAME);
        if (bl || !file3.exists()) {
            file3.mkdir();
        }
        if (bl || !file4.exists()) {
            file4.mkdir();
        }
        File[] fileArray = file2.listFiles(new FilenameFilter(this){
            final /* synthetic */ ExifInfoWriter this$0;

            public final boolean accept(File file, String string) {
                boolean bl = false;
                if (string.toLowerCase().endsWith("jpg") || string.toLowerCase().endsWith("avi")) {
                    bl = true;
                }
                return bl;
            }
            {
                this.this$0 = exifInfoWriter;
            }
        });
        StringBuffer stringBuffer = new StringBuffer();
        Date date = GregorianCalendar.getInstance().getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy.MM.dd G 'at' hh:mm:ss z");
        stringBuffer.append("cgiLastEdited=\"" + simpleDateFormat.format(date) + "\";\n");
        stringBuffer.append("cgiUser=\"" + string + "\";\n");
        stringBuffer.append("cgiYear=\"" + string2 + "\";\n");
        stringBuffer.append("cgiFolder=\"" + file2.getName() + "\";\n");
        stringBuffer.append("cgiFiles = new Array(" + fileArray.length + ");\n");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < fileArray.length) {
            File file6;
            Image image;
            stringBuffer.append("cgiFiles[" + n3 + "] = new Array(\"" + fileArray[n3].getName() + "\",");
            File file7 = new File(file4, fileArray[n3].getName());
            Image image2 = null;
            if (fileArray[n3].getName().toLowerCase().endsWith("jpg") && (bl || !file7.exists())) {
                image2 = new ImageIcon(fileArray[n3].getAbsolutePath()).getImage();
                image = ImageUtilities.resizeTo(image2, new Dimension(640, 480));
                ImageUtilities.writeJPEG(image, file7, 80);
                ++n2;
            }
            if (fileArray[n3].getName().toLowerCase().endsWith("avi")) {
                file6 = new File(file3, FileUtilities.removeExtension(fileArray[n3].getName()) + ".jpg");
                stringBuffer.append("\"" + file6.getName() + "\"," + fileArray[n3].length() / 1000L + ");\n");
            } else {
                file6 = new File(file3, fileArray[n3].getName());
                if (image2 == null) {
                    image2 = new ImageIcon(fileArray[n3].getAbsolutePath()).getImage();
                }
                stringBuffer.append("" + image2.getWidth(null) + ',' + image2.getHeight(null) + ',' + fileArray[n3].length() / 1000L + ");\n");
            }
            if (bl || !file6.exists()) {
                if (fileArray[n3].getName().toLowerCase().endsWith("avi")) {
                    String string3 = FileUtilities.removeExtension(fileArray[n3].getAbsolutePath()) + ".THM";
                    image2 = new ImageIcon(string3).getImage();
                } else if (image2 == null) {
                    image2 = new ImageIcon(fileArray[n3].getAbsolutePath()).getImage();
                }
                image = ImageUtilities.resizeTo(image2, new Dimension(100, 75));
                ImageUtilities.writeJPEG(image, file6, 80);
                ++n;
            }
            ++n3;
        }
        stringBuffer.append("cgiImgCount=" + fileArray.length + ";\n");
        this.setStatus("  wrote " + n + " thumbs and " + n2 + " mediums of " + fileArray.length + " total files into " + file2.getName() + '/');
        FileWriter fileWriter = null;
        if (bl || !file5.exists()) {
            fileWriter = new FileWriter(file5);
            fileWriter.write(stringBuffer.toString());
            fileWriter.flush();
            fileWriter.close();
        }
        return true;
    }

    private final boolean writeThumbsForFolder(File file, boolean bl, String string, Dimension dimension) {
        if (file == null) {
            this.setStatus("no folder selected");
            return false;
        }
        File file2 = file.isFile() ? new File(file.getParent()) : file;
        File file3 = new File(file2, string);
        if (bl || !file3.exists()) {
            file3.mkdir();
        }
        File[] fileArray = file2.listFiles(new FilenameFilter(this){
            final /* synthetic */ ExifInfoWriter this$0;

            public final boolean accept(File file, String string) {
                boolean bl = false;
                if (string.toLowerCase().endsWith("jpg") || string.toLowerCase().endsWith("thm")) {
                    bl = true;
                }
                return bl;
            }
            {
                this.this$0 = exifInfoWriter;
            }
        });
        int n = 0;
        int n2 = 0;
        while (n2 < fileArray.length) {
            File file4 = new File(file3, fileArray[n2].getName());
            if (bl || !file4.exists()) {
                ++n;
                Image image = ImageUtilities.getImage(fileArray[n2].getAbsolutePath());
                Image image2 = ImageUtilities.resizeTo(image, dimension);
                ImageUtilities.writeJPEG(image2, file4, 70);
            }
            ++n2;
        }
        this.setStatus("  wrote thumbnailed images for " + n + '/' + fileArray.length + " image files in \"" + file2.getName() + '/' + string);
        return true;
    }

    public boolean writeInfoForYear(int n) {
        return this.writeInfoForYear(this.selectedFile.getParentFile().getParentFile(), n);
    }

    private final boolean writeInfoForYear(File file, int n) {
        if (file == null) {
            this.setStatus("no folder selected");
            return false;
        }
        if (!file.isDirectory()) {
            return false;
        }
        File[] fileArray = file.listFiles();
        int n2 = 0;
        while (n2 < fileArray.length) {
            File file2 = fileArray[n2];
            if (file2.isDirectory()) {
                if (independant) {
                    if (!this.writeInfoForFolder(file2, false, n, "../../../../exif.css")) {
                        this.setStatus(file2.getName() + " : error on file write");
                    }
                } else if (!this.writeInfoForFolder(file2, EOMPrefs.get(EOMPrefs.EXPORT_UKNOWNS).equals("true"), n, "../../../../exif.css")) {
                    this.setStatus(file2.getName() + " : error on file write");
                }
            }
            ++n2;
        }
        return true;
    }

    public boolean writeInfoForFolder(int n) {
        if (independant) {
            return this.writeInfoForFolder(this.selectedFile.getParentFile(), false, n, "exif.css");
        }
        return this.writeInfoForFolder(this.selectedFile.getParentFile(), EOMPrefs.get(EOMPrefs.EXPORT_UKNOWNS).equals("true"), n, "exif.css");
    }

    public boolean writeInfoForFolder(File file, int n) {
        if (independant) {
            return this.writeInfoForFolder(file, false, n, "exif.css");
        }
        return this.writeInfoForFolder(file, EOMPrefs.get(EOMPrefs.EXPORT_UKNOWNS).equals("true"), n, "exif.css");
    }

    private final boolean writeInfoForFolder(File file, boolean bl, int n, String string) {
        if (file == null) {
            this.setStatus("no folder selected");
            return false;
        }
        File file2 = file.isFile() ? new File(file.getParent()) : file;
        File file3 = new File(file2, EXIF_SUB_DIR);
        file3.mkdir();
        File[] fileArray = file2.listFiles(new FilenameFilter(this){
            final /* synthetic */ ExifInfoWriter this$0;

            public final boolean accept(File file, String string) {
                return string.toLowerCase().endsWith("jpg");
            }
            {
                this.this$0 = exifInfoWriter;
            }
        });
        int n2 = 0;
        while (n2 < fileArray.length) {
            File file4 = fileArray[n2];
            this.writeInfoForImage(file4, file3, bl, n, string);
            ++n2;
        }
        if (independant) {
            this.setStatus("  created info files for " + fileArray.length + " image files in \"" + file2.getName() + '/' + EXIF_SUB_DIR);
        } else {
            this.setStatus("created info files for " + fileArray.length + " image files in \"" + file2.getName() + '/' + EXIF_SUB_DIR);
        }
        return true;
    }

    public boolean writeInfoForImage(int n) {
        if (independant) {
            return this.writeInfoForImage(this.selectedFile, this.selectedFile.getParentFile(), false, n, null);
        }
        return this.writeInfoForImage(this.selectedFile, this.selectedFile.getParentFile(), EOMPrefs.get(EOMPrefs.EXPORT_UKNOWNS).equals("true"), n, null);
    }

    public boolean writeInfoForImage(int n, String string) {
        if (independant) {
            return this.writeInfoForImage(this.selectedFile, this.selectedFile.getParentFile(), false, n, string);
        }
        return this.writeInfoForImage(this.selectedFile, this.selectedFile.getParentFile(), EOMPrefs.get(EOMPrefs.EXPORT_UKNOWNS).equals("true"), n, string);
    }

    private final boolean writeInfoForImage(File file, File file2, boolean bl, int n, String string) {
        if (file == null) {
            this.setStatus("no file selected");
            return false;
        }
        ExifInfoWriter.output("write info for image");
        try {
            String string2 = file.getName().substring(0, file.getName().lastIndexOf("."));
            FileWriter fileWriter = this.openInfoFile(file2, string2, n, string);
            Metadata metadata = JpegMetadataReader.readMetadata(file);
            Iterator iterator = metadata.getDirectoryIterator();
            while (iterator.hasNext()) {
                Directory directory = (Directory)iterator.next();
                this.writeDirectoryName(directory.getName(), fileWriter, n);
                Iterator iterator2 = directory.getTagIterator();
                while (iterator2.hasNext()) {
                    Tag tag = (Tag)iterator2.next();
                    if (tag.getTagName().indexOf("Unknown") != -1 && !bl) continue;
                    this.writeTag(tag, fileWriter, n);
                }
            }
            this.closeInfoFile(fileWriter, n);
            ExifInfoWriter.output("created info file for " + file.getName());
            if (!independant) {
                this.setStatus("created info file for " + file.getName());
            }
        }
        catch (JpegProcessingException jpegProcessingException) {
            jpegProcessingException.printStackTrace();
            this.setStatus("     ERROR : " + jpegProcessingException);
            return false;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            this.setStatus("     ERROR : " + fileNotFoundException);
            return false;
        }
        return true;
    }

    private final FileWriter openInfoFile(File file, String string, int n, String string2) {
        ExifInfoWriter.output("open info file");
        FileWriter fileWriter = null;
        try {
            switch (n) {
                case 1: {
                    fileWriter = new FileWriter(new File(file, string + ".txt"));
                    fileWriter.write(string + ".jpg - EXIF Information" + IFConstants.EOL);
                    break;
                }
                case 2: {
                    break;
                }
                case 0: {
                    fileWriter = new FileWriter(new File(file, string + ".html"));
                    fileWriter.write("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">" + IFConstants.EOL + IFConstants.EOL);
                    fileWriter.write("<html>" + IFConstants.EOL + IFConstants.EOL);
                    fileWriter.write("  <head>" + IFConstants.EOL);
                    fileWriter.write("    <title>" + string + ".jpg - EXIF Information</title>" + IFConstants.EOL);
                    fileWriter.write("    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\">" + IFConstants.EOL);
                    if (string2 != null) {
                        fileWriter.write("    <link rel=\"stylesheet\" href=\"" + string2 + "\" type=\"text/css\">" + IFConstants.EOL);
                        if (string2.equals("exif.css")) {
                            FileWriter fileWriter2 = new FileWriter(new File(file, "exif.css"));
                            fileWriter2.write(FileUtilities.getStringFromResource("exif.css"));
                            fileWriter2.flush();
                            fileWriter2.close();
                        }
                    } else {
                        fileWriter.write("    <style type=\"text/css\">" + IFConstants.EOL);
                        fileWriter.write(FileUtilities.getStringFromResource("exif.css"));
                        fileWriter.write("    </style>" + IFConstants.EOL);
                    }
                    fileWriter.write("    <meta name=\"generator\" content=\"EXIF-O-Matic\">" + IFConstants.EOL);
                    fileWriter.write("  </head>" + IFConstants.EOL + IFConstants.EOL);
                    fileWriter.write("<body>" + IFConstants.EOL + IFConstants.EOL);
                    fileWriter.write(" <center>" + IFConstants.EOL + IFConstants.EOL);
                    fileWriter.write("  <table style=\"margin-left: auto; margin-right: auto; text-align: center;\">");
                    fileWriter.write("  <tr><td colspan=2 class=\"header\">" + string + ".jpg</td></tr>" + IFConstants.EOL);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.setStatus("     ERROR : " + iOException);
        }
        return fileWriter;
    }

    private final void closeInfoFile(FileWriter fileWriter, int n) {
        ExifInfoWriter.output("close info file");
        try {
            switch (n) {
                case 1: {
                    fileWriter.write(IFConstants.EOL);
                    break;
                }
                case 2: {
                    break;
                }
                case 0: {
                    Calendar calendar = Calendar.getInstance();
                    fileWriter.write("  <tr><td colspan=2 class=\"details\">");
                    fileWriter.write("generated by <a href=\"http://www.instituteofthefuture.org/exifomatic/\">EXIF-O-Matic</a> on " + calendar.get(1) + '.' + (calendar.get(2) + 1) + '.' + calendar.get(5));
                    fileWriter.write("</td></tr>" + IFConstants.EOL);
                    fileWriter.write("  </table>" + IFConstants.EOL + IFConstants.EOL);
                    fileWriter.write(" </center>" + IFConstants.EOL + IFConstants.EOL);
                    fileWriter.write("</body>" + IFConstants.EOL + IFConstants.EOL);
                    fileWriter.write("</html>" + IFConstants.EOL + IFConstants.EOL);
                }
            }
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.setStatus("     ERROR : " + iOException);
        }
    }

    private final void writeDirectoryName(String string, FileWriter fileWriter, int n) {
        try {
            switch (n) {
                case 1: {
                    fileWriter.write("- " + string + IFConstants.EOL);
                    break;
                }
                case 2: {
                    break;
                }
                case 0: {
                    fileWriter.write("  <tr>" + IFConstants.EOL);
                    fileWriter.write("    <td colspan=2 class=\"directoryname\">" + string + "</td>" + IFConstants.EOL);
                    fileWriter.write("  </tr>" + IFConstants.EOL);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.setStatus("     ERROR : " + iOException);
        }
    }

    private final void writeTag(Tag tag, FileWriter fileWriter, int n) {
        try {
            switch (n) {
                case 1: {
                    fileWriter.write(tag.getTagName() + EOMPrefs.getDelimitor(EOMPrefs.get(EOMPrefs.TXT_DELIMITOR)) + tag.getDescription() + IFConstants.EOL);
                    break;
                }
                case 2: {
                    break;
                }
                case 0: {
                    fileWriter.write("  <tr>" + IFConstants.EOL);
                    fileWriter.write("    <td class=\"tagname\">" + tag.getTagName() + "</td>" + IFConstants.EOL);
                    fileWriter.write("    <td class=\"tagdescrip\">" + tag.getDescription() + "</td>" + IFConstants.EOL);
                    fileWriter.write("  </tr>" + IFConstants.EOL);
                }
            }
        }
        catch (MetadataException metadataException) {
            metadataException.printStackTrace();
            this.setStatus("     ERROR : " + metadataException);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.setStatus("     ERROR : " + iOException);
        }
    }

    public void setStatus(String string) {
        ExifOMatic.setStatus(string);
        if (independant) {
            this.status.append(string + '\n');
        }
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        ExifInfoWriter exifInfoWriter = new ExifInfoWriter();
        independant = true;
        exifInfoWriter.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            String string = ((JButton)object).getText();
            if (string.equals("Select File...")) {
                this.selectedFile = this.selectFile();
            } else if (string.equals("Generate for File")) {
                this.writeInfoForImage(0);
            } else if (string.equals("Generate for Folder")) {
                this.writeInfoForFolder(0);
            } else if (string.equals("Generate for Year")) {
                this.writeInfoForYear(0);
            } else if (string.equals("Prepare for PhotoBot")) {
                this.prepareForPhotoBot();
            }
        }
    }

    public File getSelectedFile() {
        return this.selectedFile;
    }

    public String getSelectedFileName() {
        if (this.selectedFile != null) {
            return this.selectedFile.getName();
        }
        return null;
    }

    public Object[][] getTagsAsObjectArray() {
        try {
            Object[][] objectArray;
            Metadata metadata = JpegMetadataReader.readMetadata(this.getSelectedFile());
            Iterator iterator = metadata.getDirectoryIterator();
            int n = 0;
            while (iterator.hasNext()) {
                objectArray = (Object[][])iterator.next();
                n += objectArray.getTagCount();
            }
            ExifInfoWriter.output(this.selectedFile.getName() + " : tag count = " + n);
            objectArray = new Object[n][2];
            iterator = metadata.getDirectoryIterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Directory directory = (Directory)iterator.next();
                Iterator iterator2 = directory.getTagIterator();
                while (iterator2.hasNext()) {
                    Tag tag = (Tag)iterator2.next();
                    objectArray[n2][0] = tag.getTagName();
                    objectArray[n2][1] = tag.getDescription();
                    ++n2;
                }
            }
            return objectArray;
        }
        catch (Exception exception) {
            ExifInfoWriter.output(exception.toString());
            String string = exception.toString();
            int n = string.indexOf(":");
            if (n > -1) {
                string = string.substring(n + 1, string.length());
            }
            Alerts.showError("Error While Opening", "There appears to be a problem with " + this.selectedFile.getName() + " :\n" + string);
            return null;
        }
    }

    public static void output(String string) {
        if (DEBUG) {
            System.out.println(" ExifInfoWriter : " + string);
        }
    }

    public ExifInfoWriter() {
        super("PhotoBot Manager");
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ ExifInfoWriter this$0;

            public final void windowClosing(WindowEvent windowEvent) {
                this.this$0.close();
            }
            {
                this.this$0 = exifInfoWriter;
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.jtfUserName = new JTextField("rahulb");
        this.jtfYear = new JTextField("2003");
        JButton jButton = new JButton("Select File...");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Select File...");
        jButton2.addActionListener(this);
        JButton jButton3 = new JButton("Generate for File");
        jButton3.addActionListener(this);
        JButton jButton4 = new JButton("Generate for Folder");
        jButton4.addActionListener(this);
        JButton jButton5 = new JButton("Generate for Year");
        jButton5.addActionListener(this);
        JButton jButton6 = new JButton("Prepare for PhotoBot");
        jButton6.addActionListener(this);
        JPanel jPanel = new JPanel(new FlowLayout());
        jPanel.add(jButton);
        jPanel.add(new JLabel("username:"));
        jPanel.add(this.jtfUserName);
        jPanel.add(new JLabel("year:"));
        jPanel.add(this.jtfYear);
        jPanel.add(jButton6);
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        jPanel2.add(jButton4);
        jPanel2.add(jButton5);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add("PhotoBot", jPanel);
        jTabbedPane.add("Other", jPanel2);
        this.status = new JTextArea();
        this.status.setEditable(false);
        this.status.setFont(new Font("SansSerif", 0, 9));
        JScrollPane jScrollPane = new JScrollPane(this.status);
        jScrollPane.setPreferredSize(new Dimension(200, 200));
        this.getContentPane().add((Component)jTabbedPane, "Center");
        this.getContentPane().add((Component)jScrollPane, "South");
        this.setBounds(50, 50, 500, 400);
    }
}

