/*
 * Decompiled with CFR 0.152.
 */
package org.instituteofthefuture.io;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.swing.ImageIcon;
import org.instituteofthefuture.io.FileUtilities;

public class ImageUtilities {
    private static String[] match = new String[]{"M", "@", "#", "w", "$", "%", "&", "8", "X", "3", "*", "+", "i", ":", "-", ".", "`", " "};

    public static Image resizeTo(ImageIcon imageIcon, int n) {
        double d = (double)n / (double)imageIcon.getImage().getHeight(null);
        if (imageIcon.getImage().getWidth(null) > imageIcon.getImage().getHeight(null)) {
            d = (double)n / (double)imageIcon.getImage().getWidth(null);
        }
        int n2 = (int)(d * (double)imageIcon.getImage().getWidth(null));
        int n3 = (int)(d * (double)imageIcon.getImage().getHeight(null));
        Image image = imageIcon.getImage().getScaledInstance(n2, n3, 1);
        imageIcon.setImage(image);
        return image;
    }

    public static Image resizeTo(Image image, Dimension dimension) {
        return ImageUtilities.resizeTo(image, (int)dimension.getWidth(), (int)dimension.getHeight());
    }

    public static Image resizeTo(Image image, int n, int n2) {
        double d = (double)n2 / (double)image.getHeight(null);
        int n3 = (int)(d * (double)image.getWidth(null));
        int n4 = (int)(d * (double)image.getHeight(null));
        if (n3 > n) {
            d = (double)n / (double)image.getWidth(null);
            n3 = (int)(d * (double)image.getWidth(null));
            n4 = (int)(d * (double)image.getHeight(null));
        }
        Image image2 = image.getScaledInstance(n3, n4, 1);
        return image2;
    }

    public static Image rotateRight(Image image) {
        try {
            BufferedImage bufferedImage = new BufferedImage(image.getHeight(null), image.getWidth(null), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.setToRotation(1.5707963267948966, image.getHeight(null) / 2, image.getWidth(null) / 2);
            graphics2D.drawImage(image, affineTransform, null);
            return bufferedImage;
        }
        catch (Exception exception) {
            System.out.println("crap!");
            exception.printStackTrace();
            System.exit(0);
            return null;
        }
    }

    public static String toAscii(Image image, int n) {
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        int n4 = (int)((float)n3 / (float)n2 * (float)n);
        return ImageUtilities.toAscii(image, n, n4 /= 2);
    }

    public static String toAscii(Image image, int n, int n2) {
        int n3 = image.getWidth(null);
        int n4 = image.getHeight(null);
        int[] nArray = new int[n3 * n4];
        int n5 = n3;
        boolean bl = false;
        float f = (float)n3 / (float)n;
        float f2 = (float)n4 / (float)n2;
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n3, n4, nArray, 0, n5);
        StringBuffer stringBuffer = new StringBuffer();
        try {
            pixelGrabber.grabPixels();
            float f3 = 0.0f;
            while (f3 <= (float)n4 - f2) {
                float f4 = 0.0f;
                while (f4 <= (float)n3 - f) {
                    int n6 = nArray[Math.round(f4) + Math.round(f3) * n3];
                    int n7 = n6 & 0xFF000000;
                    int n8 = (n6 & 0xFF0000) / 65536;
                    int n9 = (n6 & 0xFF00) / 256;
                    int n10 = n6 & 0xFF;
                    int n11 = (n8 + n9 + n10) / 3;
                    int n12 = (int)((double)n11 / 14.5);
                    stringBuffer.append(match[n12]);
                    f4 += f;
                }
                stringBuffer.append("\n");
                f3 += f2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public static Image getImage(String string) {
        return new ImageIcon(string).getImage();
    }

    public static Image getImageFromResource(String string) {
        URL uRL = FileUtilities.getResource(string);
        if (uRL != null) {
            return ImageUtilities.getImageIconFromResource(string).getImage();
        }
        return null;
    }

    public static ImageIcon getImageIconFromResource(String string) {
        URL uRL = FileUtilities.getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        return null;
    }

    public static ImageIcon getImageIconFromStream(InputStream inputStream) throws IOException {
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        byte[] byArray = new byte[5000 * n3];
        byte[] byArray2 = new byte[5000];
        boolean bl = false;
        while (!bl) {
            int n4 = 0;
            if (inputStream.available() != 0) {
                n = inputStream.read(byArray2);
                boolean bl2 = false;
                if (n == -1) {
                    bl2 = true;
                }
                if (!(bl = bl2)) {
                    n4 = n;
                }
            } else {
                n = inputStream.read();
                boolean bl3 = false;
                if (n == -1) {
                    bl3 = true;
                }
                bl = bl3;
                byArray2[0] = (byte)n;
                if (!bl) {
                    n4 = 1;
                }
            }
            if (bl) continue;
            if (n2 + n4 > 5000 * n3) {
                byte[] byArray3 = new byte[5000 * ++n3];
                System.arraycopy(byArray, 0, byArray3, 0, n2);
                byArray = byArray3;
            }
            System.arraycopy(byArray2, 0, byArray, n2, n4);
            n2 += n4;
        }
        byte[] byArray4 = new byte[n2];
        if (n2 != 0) {
            System.arraycopy(byArray, 0, byArray4, 0, n2);
        }
        return new ImageIcon(byArray4);
    }

    public static boolean writeJPEG(Image image, File file, int n) {
        return ImageUtilities.writeJPEG(new ImageIcon(image), file, n);
    }

    public static boolean writeJPEG(ImageIcon imageIcon, File file, int n) {
        try {
            BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics2D.drawImage(imageIcon.getImage(), 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)bufferedOutputStream);
            JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
            n = Math.max(0, Math.min(n, 100));
            jPEGEncodeParam.setQuality((float)n / 100.0f, false);
            jPEGImageEncoder.setJPEGEncodeParam(jPEGEncodeParam);
            jPEGImageEncoder.encode(bufferedImage);
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("JPEG write error : file \"" + file.getName() + "\" no found!");
        }
        catch (IOException iOException) {
            System.out.println("JPEG write error : " + iOException);
        }
        return false;
    }
}

