/*
 * Decompiled with CFR 0.152.
 */
package shared.circbufinputstream;

import java.io.IOException;
import java.io.InputStream;

public class JCircBufInputStream
extends InputStream {
    private byte[] m_buf;
    private int m_readPos;
    private int m_writePos;
    private int m_markPos;

    public JCircBufInputStream(int n) {
        this.m_buf = new byte[n];
        this.m_readPos = 0;
        this.m_writePos = 0;
        this.m_markPos = -1;
    }

    public int available() throws IOException {
        if (this.m_buf == null) {
            throw new IOException("Buffer is closed!");
        }
        if (this.m_writePos >= this.m_readPos) {
            return this.m_writePos - this.m_readPos;
        }
        return this.m_buf.length - this.m_readPos + this.m_writePos;
    }

    public void close() {
        this.m_buf = null;
    }

    public void mark(int n) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[]{};
        this.read(byArray, 0, 1);
        return byArray[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.m_buf == null) {
            throw new IOException("Buffer is closed!");
        }
        if (byArray == null) {
            throw new NullPointerException("Invalid output buffer");
        }
        if (n < -1 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException("negative skip values are not supported");
        }
        int n3 = -1;
        if (this.m_readPos <= this.m_writePos) {
            n3 = Math.min(n2, this.m_writePos - this.m_readPos);
            System.arraycopy(this.m_buf, this.m_readPos, byArray, n, n3);
            this.m_readPos += n3;
        } else {
            n3 = Math.min(this.m_buf.length - this.m_readPos + this.m_writePos, n2);
            if (n3 <= this.m_buf.length - this.m_readPos) {
                System.arraycopy(this.m_buf, this.m_readPos, byArray, n, n3);
                this.m_readPos += n3;
            } else {
                System.arraycopy(this.m_buf, this.m_readPos, byArray, n, this.m_buf.length - this.m_readPos);
                System.arraycopy(this.m_buf, 0, byArray, n + this.m_buf.length - this.m_readPos, n3 - (this.m_buf.length - this.m_readPos));
                this.m_readPos = n3 - (this.m_buf.length - this.m_readPos);
            }
        }
        if (this.m_readPos == this.m_buf.length) {
            this.m_readPos = 0;
        }
        return n3;
    }

    public void reset() {
        this.m_markPos = -1;
    }

    public long skip(long l) {
        if (l < 0L) {
            throw new IndexOutOfBoundsException("negative skip values are not supported");
        }
        long l2 = l;
        if (this.m_readPos <= this.m_writePos) {
            if ((long)this.m_readPos + l <= (long)this.m_writePos) {
                this.m_readPos = (int)((long)this.m_readPos + l);
            } else {
                l2 = this.m_writePos - this.m_readPos;
                this.m_readPos = this.m_writePos;
            }
        } else if (l <= (long)(this.m_buf.length - this.m_readPos + this.m_writePos)) {
            this.m_readPos = (int)l - (this.m_buf.length - this.m_readPos);
        } else {
            l2 = this.m_buf.length - this.m_readPos + this.m_writePos;
            this.m_readPos = this.m_writePos;
        }
        return l2;
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.m_buf == null) {
            throw new IOException("Buffer is closed!");
        }
        if (byArray == null) {
            throw new NullPointerException("Invalid input buffer");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("Invalid arguments");
        }
        if (this.m_readPos <= this.m_writePos) {
            if ((n2 = Math.min(n2, this.m_buf.length - this.m_writePos + this.m_readPos)) <= this.m_buf.length - this.m_writePos) {
                System.arraycopy(byArray, n, this.m_buf, this.m_writePos, n2);
                this.m_writePos += n2;
            } else {
                System.arraycopy(byArray, n, this.m_buf, this.m_writePos, this.m_buf.length - this.m_writePos);
                System.arraycopy(byArray, n + this.m_buf.length - this.m_writePos, this.m_buf, 0, n2 - (this.m_buf.length - this.m_writePos));
                this.m_writePos = n2 - (this.m_buf.length - this.m_writePos);
            }
        }
        if (this.m_writePos == this.m_buf.length) {
            this.m_writePos = 0;
        }
    }
}

