/*
 * Decompiled with CFR 0.152.
 */
package jexifviewer;

import java.util.ArrayList;
import jexifviewer.JImageData;
import jexifviewer.Main;

final class JImageCache {
    private ArrayList<JImageData> m_list;
    private int m_size;
    private boolean m_bCallGc;

    private void trace() {
        if (Main.m_settings.isDebug()) {
            System.err.println("Cache:");
            for (JImageData jImageData : this.m_list) {
                System.err.println("\t" + jImageData);
            }
        }
    }

    public JImageCache(int n, boolean bl) {
        this.m_size = n;
        this.m_bCallGc = bl;
        this.m_list = new ArrayList();
    }

    protected JImageData find(String string) {
        if (this.m_list != null && this.m_list.size() > 0) {
            for (int i = this.m_list.size() - 1; i >= 0; --i) {
                if (!this.m_list.get(i).getFile().equals(string)) continue;
                return this.m_list.get(i);
            }
        }
        return null;
    }

    public void remove(String string) {
        if (this.m_list != null && this.m_list.size() > 0) {
            boolean bl = false;
            for (int i = this.m_list.size() - 1; i >= 0; --i) {
                if (!this.m_list.get(i).getFile().equals(string)) continue;
                this.m_list.remove(i);
                bl = true;
                break;
            }
            if (bl && this.m_bCallGc) {
                System.gc();
            }
        }
        if (Main.m_settings.isDebug()) {
            this.trace();
        }
    }

    public void add(JImageData jImageData) {
        if (this.find(jImageData.getFile()) == null) {
            this.m_list.add(jImageData);
            boolean bl = false;
            while (this.m_list.size() > this.m_size) {
                this.m_list.remove(0);
                bl = true;
            }
            if (bl && this.m_bCallGc) {
                System.gc();
            }
        }
        if (Main.m_settings.isDebug()) {
            this.trace();
        }
    }

    public JImageData get(String string) {
        return this.find(string);
    }

    public void clear() {
        this.m_list.clear();
        if (this.m_bCallGc) {
            System.gc();
        }
    }
}

