/*
 * Decompiled with CFR 0.152.
 */
package jexifviewer;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import jexifviewer.JExportDialog;
import jexifviewer.JIfdData;
import jexifviewer.JImageCache;
import jexifviewer.JImageData;
import jexifviewer.Main;
import jexifviewer.PngEncoderB;
import shared.cvshelper.Cvs;

@Cvs(header="$Header: /home/reiner/cvs/Java/JExifViewer/src/jexifviewer/JImgView.java,v 1.8 2010/04/02 12:12:13 reiner Exp $")
public final class JImgView
extends JComponent
implements Printable {
    protected BufferedImage m_img;
    private JIfdData m_ifd;
    private int m_orientation = 0;
    private float m_zoom = 0.0f;
    private boolean m_bZoomDirty = false;
    private JImageCache m_imgCache;
    private Point m_moveStartPoint;
    private boolean m_bMove = false;
    private boolean m_bMoveOutSide = false;
    private Point m_viewPos;
    private boolean m_bPreloadDirty = false;

    public JImgView(int n) {
        this.m_imgCache = new JImageCache(n, Main.m_settings.getCallGcAfterCacheOp());
        this.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "esc");
        this.getActionMap().put("esc", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.m_mainFrame.toggleView();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(107, 128), "ctrl_+");
        this.getActionMap().put("ctrl_+", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JImgView.this.setZoomUp();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(109, 128), "ctrl_-");
        this.getActionMap().put("ctrl_-", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JImgView.this.setZoomDown();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(10, 128), "ctrl_enter");
        this.getActionMap().put("ctrl_enter", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JImgView.this.resetZoom();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(106, 128), "ctrl_100%");
        this.getActionMap().put("ctrl_100%", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JImgView.this.setZoom(1.0f);
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(111, 128), "ctrl_50%");
        this.getActionMap().put("ctrl_50%", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JImgView.this.setZoom(0.5f);
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(98, 0), "ctrl_scrolldown");
        this.getActionMap().put("ctrl_scrolldown", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JImgView.this.m_zoom != 0.0f) {
                    JImgView.this.scrollImg(0, Main.m_settings.getImgScrollDelta());
                }
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(104, 0), "ctrl_scrollup");
        this.getActionMap().put("ctrl_scrollup", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JImgView.this.m_zoom != 0.0f) {
                    JImgView.this.scrollImg(0, -Main.m_settings.getImgScrollDelta());
                }
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(100, 0), "ctrl_scrollleft");
        this.getActionMap().put("ctrl_scrollleft", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JImgView.this.m_zoom != 0.0f) {
                    JImgView.this.scrollImg(-Main.m_settings.getImgScrollDelta(), 0);
                }
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(102, 0), "ctrl_scrollright");
        this.getActionMap().put("ctrl_scrollright", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JImgView.this.m_zoom != 0.0f) {
                    JImgView.this.scrollImg(Main.m_settings.getImgScrollDelta(), 0);
                }
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(103, 0), "ctrl_scrollupleft");
        this.getActionMap().put("ctrl_scrollupleft", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JImgView.this.m_zoom != 0.0f) {
                    JImgView.this.scrollImg(-Main.m_settings.getImgScrollDelta(), -Main.m_settings.getImgScrollDelta());
                }
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(105, 0), "ctrl_scrollupright");
        this.getActionMap().put("ctrl_scrollupright", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JImgView.this.m_zoom != 0.0f) {
                    JImgView.this.scrollImg(Main.m_settings.getImgScrollDelta(), -Main.m_settings.getImgScrollDelta());
                }
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(97, 0), "ctrl_scrolldownleft");
        this.getActionMap().put("ctrl_scrolldownleft", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JImgView.this.m_zoom != 0.0f) {
                    JImgView.this.scrollImg(-Main.m_settings.getImgScrollDelta(), Main.m_settings.getImgScrollDelta());
                }
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(99, 0), "ctrl_scrolldownright");
        this.getActionMap().put("ctrl_scrolldownright", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JImgView.this.m_zoom != 0.0f) {
                    JImgView.this.scrollImg(Main.m_settings.getImgScrollDelta(), Main.m_settings.getImgScrollDelta());
                }
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(101, 0), "ctrl_scrollcenter");
        this.getActionMap().put("ctrl_scrollcenter", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JImgView.this.m_zoom != 0.0f) {
                    Dimension dimension = JImgView.this.getSize();
                    JViewport jViewport = (JViewport)JImgView.this.getParent();
                    assert (jViewport != null);
                    Dimension dimension2 = jViewport.getExtentSize();
                    JImgView.this.setViewPosition(new Point(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height));
                }
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(96, 0), "ctrl_scrollhome");
        this.getActionMap().put("ctrl_scrollhome", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JImgView.this.m_zoom != 0.0f) {
                    JImgView.this.setViewPosition(new Point(0, 0));
                }
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(110, 0), "ctrl_scrollend");
        this.getActionMap().put("ctrl_scrollend", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (JImgView.this.m_zoom != 0.0f) {
                    Dimension dimension = JImgView.this.getSize();
                    JImgView.this.setViewPosition(new Point(dimension.width, dimension.height));
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (JImgView.this.getZoom() != 0.0f) {
                    JImgView.this.m_moveStartPoint = mouseEvent.getPoint();
                    JImgView.this.setCursor(Cursor.getPredefinedCursor(13));
                    JImgView.this.m_bMoveOutSide = false;
                    JImgView.this.m_bMove = true;
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (JImgView.this.m_bMove) {
                    JImgView.this.setCursor(Cursor.getPredefinedCursor(0));
                    JImgView.this.m_bMove = false;
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (JImgView.this.m_bMove) {
                    JImgView.this.setCursor(Cursor.getPredefinedCursor(0));
                    JImgView.this.m_bMoveOutSide = true;
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                if (JImgView.this.m_bMove && JImgView.this.m_bMoveOutSide) {
                    JImgView.this.setCursor(Cursor.getPredefinedCursor(13));
                    JImgView.this.m_bMoveOutSide = false;
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (JImgView.this.m_bMove && !JImgView.this.m_bMoveOutSide) {
                    JViewport jViewport = (JViewport)JImgView.this.getParent();
                    assert (jViewport != null);
                    Rectangle rectangle = jViewport.getViewRect();
                    if (rectangle.contains(mouseEvent.getPoint())) {
                        Point point = new Point(jViewport.getViewPosition());
                        point.translate(((JImgView)JImgView.this).m_moveStartPoint.x - mouseEvent.getPoint().x, ((JImgView)JImgView.this).m_moveStartPoint.y - mouseEvent.getPoint().y);
                        JImgView.this.setViewPosition(point);
                    }
                }
            }
        });
    }

    private void scrollImg(int n, int n2) {
        JViewport jViewport = (JViewport)this.getParent();
        assert (jViewport != null);
        Point point = new Point(jViewport.getViewPosition());
        point.translate(n, n2);
        this.setViewPosition(point);
    }

    private boolean doSetViewPosition(Point point, boolean bl) {
        boolean bl2 = true;
        JViewport jViewport = (JViewport)this.getParent();
        assert (jViewport != null);
        Point point2 = new Point(point);
        if (point2.x < 0) {
            point2.x = 0;
        }
        if (point2.y < 0) {
            point2.y = 0;
        }
        Dimension dimension = this.getSize();
        Dimension dimension2 = jViewport.getExtentSize();
        if (point2.x > dimension.width - dimension2.width) {
            point2.x = dimension.width - dimension2.width;
            bl2 = false;
        }
        if (point2.y > dimension.height - dimension2.height) {
            point2.y = dimension.height - dimension2.height;
            bl2 = false;
        }
        if (bl2 || bl) {
            jViewport.setViewPosition(point2);
        }
        return bl2;
    }

    private void setViewPosition(Point point) {
        this.doSetViewPosition(point, true);
    }

    private boolean setViewPosition(Point point, boolean bl) {
        return this.doSetViewPosition(point, bl);
    }

    public void setZoomDown() {
        this.setZoom(this.getRealZoom() - Main.m_settings.getZoomDelta());
    }

    public void setZoomUp() {
        this.setZoom(this.getRealZoom() + Main.m_settings.getZoomDelta());
    }

    private void adjustViewPosByZoom(float f) {
        float f2 = this.getRealZoom();
        float f3 = f2 - f;
        JViewport jViewport = (JViewport)this.getParent();
        assert (jViewport != null);
        Dimension dimension = jViewport.getExtentSize();
        this.m_viewPos = jViewport.getViewPosition();
        this.m_viewPos.translate(Math.round(((float)this.m_viewPos.x + (float)dimension.width / 2.0f) * f3 / f), Math.round(((float)this.m_viewPos.y + (float)dimension.height / 2.0f) * f3 / f));
        if (!this.setViewPosition(this.m_viewPos, false)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JImgView.this.setViewPosition(JImgView.this.m_viewPos);
                }
            });
        }
    }

    public void resetZoom() {
        this.m_zoom = 0.0f;
        this.m_bZoomDirty = true;
        this.internalSetZoom();
        this.repaint();
        if (Main.m_settings.isDebug()) {
            System.err.println("Reset zoom");
        }
    }

    public void setZoom(float f) {
        if ((double)f > 0.01 && f <= 8.0f) {
            float f2 = this.getRealZoom();
            this.m_zoom = f;
            this.m_bZoomDirty = true;
            this.internalSetZoom();
            this.repaint();
            if (Main.m_settings.isDebug()) {
                System.err.println("Zoom: " + this.m_zoom);
            }
            this.adjustViewPosByZoom(f2);
        }
    }

    public float getZoom() {
        return this.m_zoom;
    }

    public float getRealZoom() {
        float f = this.m_zoom;
        if (this.m_zoom == 0.0f && this.m_img != null) {
            Dimension dimension = this.getSize();
            int n = this.m_img.getWidth();
            int n2 = this.m_img.getHeight();
            switch (this.getOrientation()) {
                case 1: {
                    double d = (double)dimension.width / (double)n;
                    double d2 = (double)dimension.height / (double)n2;
                    f = (float)Math.min(d, d2);
                    break;
                }
                case 2: {
                    double d = (double)dimension.width / (double)n;
                    double d3 = (double)dimension.height / (double)n2;
                    f = (float)Math.min(d, d3);
                    break;
                }
                case 3: {
                    double d = (double)dimension.width / (double)n;
                    double d4 = (double)dimension.height / (double)n2;
                    f = (float)Math.min(d, d4);
                    break;
                }
                case 4: {
                    double d = (double)dimension.width / (double)n;
                    double d5 = (double)dimension.height / (double)n2;
                    f = (float)Math.min(d, d5);
                    break;
                }
                case 5: {
                    double d = (double)dimension.width / (double)n2;
                    double d6 = (double)dimension.height / (double)n;
                    f = (float)Math.min(d, d6);
                    break;
                }
                case 6: {
                    double d = (double)dimension.width / (double)n2;
                    double d7 = (double)dimension.height / (double)n;
                    f = (float)Math.min(d, d7);
                    break;
                }
                case 7: {
                    double d = (double)dimension.width / (double)n2;
                    double d8 = (double)dimension.height / (double)n;
                    f = (float)Math.min(d, d8);
                    break;
                }
                case 8: {
                    double d = (double)dimension.width / (double)n2;
                    double d9 = (double)dimension.height / (double)n;
                    f = (float)Math.min(d, d9);
                }
            }
        }
        return f;
    }

    private void internalSetZoom() {
        if (this.m_img != null) {
            int n = this.m_img.getWidth();
            int n2 = this.m_img.getHeight();
            if (n >= 0 && n2 >= 0) {
                if (this.m_zoom == 0.0f) {
                    Dimension dimension = new Dimension(1, 1);
                    this.setPreferredSize(dimension);
                } else {
                    Dimension dimension = new Dimension((int)((float)n * this.m_zoom), (int)((float)n2 * this.m_zoom));
                    this.setPreferredSize(dimension);
                }
                this.m_bZoomDirty = false;
                this.revalidate();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Main.m_mainFrame.updateTitle(JImgView.this.m_ifd);
                    }
                });
            }
        }
    }

    public static int getNextOrientation(int n, boolean bl) {
        switch (n) {
            case 1: {
                n = bl ? 6 : 8;
                break;
            }
            case 2: {
                n = bl ? 7 : 5;
                break;
            }
            case 3: {
                n = bl ? 8 : 6;
                break;
            }
            case 4: {
                n = bl ? 5 : 7;
                break;
            }
            case 5: {
                n = bl ? 2 : 4;
                break;
            }
            case 6: {
                n = bl ? 3 : 1;
                break;
            }
            case 7: {
                n = bl ? 4 : 2;
                break;
            }
            case 8: {
                n = bl ? 1 : 3;
            }
        }
        return n;
    }

    public static int getNextFlipOrientation(int n) {
        switch (n) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 4: {
                n = 3;
                break;
            }
            case 5: {
                n = 6;
                break;
            }
            case 6: {
                n = 5;
                break;
            }
            case 7: {
                n = 8;
                break;
            }
            case 8: {
                n = 7;
            }
        }
        return n;
    }

    public boolean isImage() {
        return this.m_img != null;
    }

    public JIfdData getIfdData() {
        return this.m_ifd;
    }

    protected int getOrientation(JIfdData jIfdData) {
        if (jIfdData != null) {
            int n = jIfdData.getOrientation();
            if (n <= 0 || n > 8) {
                n = 1;
            }
            return n;
        }
        return 0;
    }

    public int getOrientation() {
        return this.m_orientation == 0 ? this.getOrientation(this.m_ifd) : this.m_orientation;
    }

    public int getCustomOrientation() {
        return this.m_orientation;
    }

    public void setOrientation(int n) {
        this.m_orientation = n;
        this.repaint();
    }

    public void clearCache() {
        this.m_imgCache.clear();
    }

    public void removeFromCache(String string) {
        this.m_imgCache.remove(string);
    }

    public void preloadImg(final JIfdData jIfdData) {
        if (jIfdData != null && this.m_imgCache.get(jIfdData.getFilePath()) == null) {
            Thread thread = new Thread(){

                public void run() {
                    try {
                        final BufferedImage bufferedImage = ImageIO.read(new File(jIfdData.getFilePath()));
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                JImgView.this.m_imgCache.add(new JImageData(jIfdData.getFilePath(), bufferedImage));
                                Main.m_mainFrame.doPreload();
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            if (Main.m_settings.isDebug()) {
                System.err.println("Preload: " + jIfdData.getFilePath());
            }
            thread.start();
        }
    }

    public void setJpg(JIfdData jIfdData) {
        if (Main.m_settings.getSaveImage() != 0 && this.m_orientation != 0 && this.m_ifd != null && this.m_ifd.getOrientation() != this.m_orientation && (Main.m_settings.getSaveImage() == 1 || Main.m_settings.getSaveImage() == 2 && JOptionPane.showConfirmDialog(Main.m_mainFrame, String.format(Main.getString("img_saveorientation_ask"), this.m_ifd.getFilePath()), Main.getMessageBoxCaption(), 0, 3) == 0)) {
            this.saveOrientation(false);
        }
        if (jIfdData == null) {
            this.m_ifd = null;
            this.m_img = null;
            this.m_orientation = 0;
            this.m_bPreloadDirty = false;
        } else if (this.m_ifd == null || !jIfdData.getFilePath().equals(this.m_ifd.getFilePath())) {
            this.m_bZoomDirty = true;
            this.m_ifd = jIfdData;
            JImageData jImageData = this.m_imgCache.get(this.m_ifd.getFilePath());
            if (jImageData != null) {
                this.m_img = jImageData.getImage();
            } else {
                try {
                    this.m_img = ImageIO.read(new File(jIfdData.getFilePath()));
                    this.m_imgCache.add(new JImageData(this.m_ifd.getFilePath(), this.m_img));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.m_img.setAccelerationPriority(0.85f);
            this.m_orientation = 0;
            this.m_bPreloadDirty = true;
        }
        this.repaint();
        if (Main.m_settings.getCallGcInSetJpg()) {
            System.gc();
        }
        if (Main.m_settings.isDebug()) {
            System.err.println("Memory: (total, free, max): " + Runtime.getRuntime().totalMemory() + ", " + Runtime.getRuntime().freeMemory() + ", " + Runtime.getRuntime().maxMemory());
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n == 0) {
            graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
            RepaintManager repaintManager = RepaintManager.currentManager(this);
            repaintManager.setDoubleBufferingEnabled(false);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            this.doPaint(graphics, new Dimension((int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight()), true);
            repaintManager.setDoubleBufferingEnabled(true);
            System.gc();
            return 0;
        }
        return 1;
    }

    public void paintComponent(Graphics graphics) {
        Graphics graphics2 = graphics.create();
        if (this.m_bZoomDirty) {
            this.internalSetZoom();
        }
        if (this.doPaint(graphics2, this.m_zoom == 0.0f ? this.getSize() : this.getPreferredSize(), false) && this.m_bPreloadDirty) {
            this.m_bPreloadDirty = false;
            Main.m_mainFrame.doPreload();
        }
    }

    protected void doScaleRotate(BufferedImage bufferedImage, JIfdData jIfdData, Graphics graphics, Dimension dimension) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        int n2 = 0;
        int n3 = bufferedImage.getWidth(null);
        int n4 = bufferedImage.getHeight(null);
        switch (jIfdData != null ? this.getOrientation(jIfdData) : this.getOrientation()) {
            case 1: {
                d = (double)dimension.width / (double)n3;
                d2 = (double)dimension.height / (double)n4;
                d3 = Math.min(d, d2);
                graphics2D.scale(d3, d3);
                if ((int)((double)n3 * d3 + 0.5) < dimension.width) {
                    n = (int)(((double)dimension.width - (double)n3 * d3) / (2.0 * d3) + 0.5);
                }
                if ((int)((double)n4 * d3 + 0.5) < dimension.height) {
                    n2 = (int)(((double)dimension.height - (double)n4 * d3) / (2.0 * d3) + 0.5);
                }
                graphics2D.translate(n, n2);
                break;
            }
            case 2: {
                d = (double)dimension.width / (double)n3;
                d2 = (double)dimension.height / (double)n4;
                d3 = Math.min(d, d2);
                graphics2D.translate((double)n3 * d3, 0.0);
                graphics2D.scale(-d3, d3);
                if ((int)((double)n3 * d3 + 0.5) < dimension.width) {
                    n = (int)(((double)dimension.width - (double)n3 * d3) / (2.0 * d3) + 0.5);
                }
                if ((int)((double)n4 * d3 + 0.5) < dimension.height) {
                    n2 = (int)(((double)dimension.height - (double)n4 * d3) / (2.0 * d3) + 0.5);
                }
                graphics2D.translate(-n, n2);
                break;
            }
            case 3: {
                d = (double)dimension.width / (double)n3;
                d2 = (double)dimension.height / (double)n4;
                d3 = Math.min(d, d2);
                graphics2D.rotate(Math.PI);
                graphics2D.translate((double)(-n3) * d3, (double)(-n4) * d3);
                graphics2D.scale(d3, d3);
                if ((int)((double)n3 * d3 + 0.5) < dimension.width) {
                    n = (int)(((double)dimension.width - (double)n3 * d3) / (2.0 * d3) + 0.5);
                }
                if ((int)((double)n4 * d3 + 0.5) < dimension.height) {
                    n2 = (int)(((double)dimension.height - (double)n4 * d3) / (2.0 * d3) + 0.5);
                }
                graphics2D.translate(-n, -n2);
                break;
            }
            case 4: {
                d = (double)dimension.width / (double)n3;
                d2 = (double)dimension.height / (double)n4;
                d3 = Math.min(d, d2);
                graphics2D.rotate(Math.PI);
                graphics2D.translate(0.0, (double)(-n4) * d3);
                graphics2D.scale(-d3, d3);
                if ((int)((double)n3 * d3 + 0.5) < dimension.width) {
                    n = (int)(((double)dimension.width - (double)n3 * d3) / (2.0 * d3) + 0.5);
                }
                if ((int)((double)n4 * d3 + 0.5) < dimension.height) {
                    n2 = (int)(((double)dimension.height - (double)n4 * d3) / (2.0 * d3) + 0.5);
                }
                graphics2D.translate(n, -n2);
                break;
            }
            case 5: {
                d = (double)dimension.width / (double)n4;
                d2 = (double)dimension.height / (double)n3;
                d3 = Math.min(d, d2);
                graphics2D.rotate(1.5707963267948966);
                graphics2D.scale(d3, -d3);
                if ((int)((double)n4 * d3 + 0.5) < dimension.width) {
                    n = (int)(((double)dimension.width - (double)n4 * d3) / (2.0 * d3) + 0.5);
                }
                if ((int)((double)n3 * d3 + 0.5) < dimension.height) {
                    n2 = (int)(((double)dimension.height - (double)n3 * d3) / (2.0 * d3) + 0.5);
                }
                graphics2D.translate(n2, n);
                break;
            }
            case 6: {
                d = (double)dimension.width / (double)n4;
                d2 = (double)dimension.height / (double)n3;
                d3 = Math.min(d, d2);
                graphics2D.rotate(1.5707963267948966);
                graphics2D.translate(0.0, (double)(-n4) * d3);
                graphics2D.scale(d3, d3);
                if ((int)((double)n4 * d3 + 0.5) < dimension.width) {
                    n = (int)(((double)dimension.width - (double)n4 * d3) / (2.0 * d3) + 0.5);
                }
                if ((int)((double)n3 * d3 + 0.5) < dimension.height) {
                    n2 = (int)(((double)dimension.height - (double)n3 * d3) / (2.0 * d3) + 0.5);
                }
                graphics2D.translate(n2, -n);
                break;
            }
            case 7: {
                d = (double)dimension.width / (double)n4;
                d2 = (double)dimension.height / (double)n3;
                d3 = Math.min(d, d2);
                graphics2D.rotate(-1.5707963267948966);
                graphics2D.translate((double)(-n3) * d3, (double)n4 * d3);
                graphics2D.scale(d3, -d3);
                if ((int)((double)n4 * d3 + 0.5) < dimension.width) {
                    n = (int)(((double)dimension.width - (double)n4 * d3) / (2.0 * d3) + 0.5);
                }
                if ((int)((double)n3 * d3 + 0.5) < dimension.height) {
                    n2 = (int)(((double)dimension.height - (double)n3 * d3) / (2.0 * d3) + 0.5);
                }
                graphics2D.translate(-n2, -n);
                break;
            }
            case 8: {
                d = (double)dimension.width / (double)n4;
                d2 = (double)dimension.height / (double)n3;
                d3 = Math.min(d, d2);
                graphics2D.rotate(-1.5707963267948966);
                graphics2D.translate((double)(-n3) * d3, 0.0);
                graphics2D.scale(d3, d3);
                if ((int)((double)n4 * d3 + 0.5) < dimension.width) {
                    n = (int)(((double)dimension.width - (double)n4 * d3) / (2.0 * d3) + 0.5);
                }
                if ((int)((double)n3 * d3 + 0.5) < dimension.height) {
                    n2 = (int)(((double)dimension.height - (double)n3 * d3) / (2.0 * d3) + 0.5);
                }
                graphics2D.translate(n2, n);
            }
        }
    }

    public boolean doPaint(Graphics graphics, Dimension dimension, boolean bl) {
        if (this.m_ifd != null && this.m_img != null) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n = this.m_img.getWidth();
            int n2 = this.m_img.getHeight();
            if (dimension == null) {
                dimension = new Dimension(n, n2);
            }
            if (n2 > 0 && n > 0) {
                this.doScaleRotate(this.m_img, null, graphics, dimension);
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, Main.m_settings.getInterpolation());
                Rectangle rectangle = graphics2D.getClipBounds();
                if (rectangle == null) {
                    rectangle = new Rectangle(0, 0, dimension.width, dimension.height);
                }
                if (!bl) {
                    graphics2D.setColor(Main.m_settings.getImgViewBackColor());
                    graphics2D.fillRect((int)rectangle.getX(), (int)rectangle.getY(), (int)rectangle.getWidth(), (int)rectangle.getHeight());
                }
                graphics2D.drawImage(this.m_img, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, this);
                return true;
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            JViewport jViewport = (JViewport)this.getParent();
            assert (jViewport != null);
            Point point = jViewport.getViewPosition();
            dimension = jViewport.getExtentSize();
            String string = Main.getString("img_wait");
            Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(string, graphics2D);
            graphics2D.drawString(string, (int)point.getX() + (int)((dimension.getWidth() - rectangle2D.getWidth()) / 2.0), (int)point.getY() + (int)((dimension.getHeight() + rectangle2D.getHeight()) / 2.0));
            if (Main.m_settings.isDebug()) {
                System.err.println("no image !");
            }
            this.repaint(250L);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveOrientation(boolean bl) {
        boolean bl2 = false;
        if (this.m_ifd != null && this.m_orientation != 0) {
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile(this.m_ifd.getFilePath(), "rw");
                bl2 = this.m_ifd.updateTag(randomAccessFile, 274, this.m_orientation);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (randomAccessFile != null) {
                        randomAccessFile.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (bl2) {
            if (bl && this.m_ifd.readFromFile(this.m_ifd.getFilePath())) {
                this.m_orientation = 0;
                this.setJpg(this.m_ifd);
            }
            Main.m_mainFrame.updateTableItem(this.m_ifd);
        } else {
            JOptionPane.showMessageDialog(Main.m_mainFrame, String.format(Main.getString("img_saveorientation_failed"), this.m_ifd.getFilePath()), Main.getMessageBoxCaption(), 0);
        }
        return bl2;
    }

    public boolean export() {
        boolean bl = false;
        if (this.m_img != null) {
            JExportDialog jExportDialog = new JExportDialog(Main.m_mainFrame, this);
            jExportDialog.m_quality = Main.m_settings.getExportQuality();
            jExportDialog.m_scaleFactor = Main.m_settings.getExportScaleFactor();
            jExportDialog.m_bOptimizedHuf = Main.m_settings.isExportJpegOptimizedHufTable();
            jExportDialog.m_mimeType = Main.m_settings.getExportMimeType();
            jExportDialog.m_file = new File(this.m_ifd.getFilePath());
            if (jExportDialog.doModal()) {
                Main.m_mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                Main.m_settings.setExportQuality((float)jExportDialog.m_quality);
                Main.m_settings.setExportScalefactor((float)jExportDialog.m_scaleFactor);
                Main.m_settings.setExportJpegOptimizedHufTable(jExportDialog.m_bOptimizedHuf);
                Main.m_settings.setExportMimeType(jExportDialog.m_mimeType);
                if (jExportDialog.m_mimeType.equals("image/png")) {
                    bl = this.savePNG(jExportDialog.m_file, this.m_img, null, jExportDialog.m_scaleFactor);
                } else if (jExportDialog.m_mimeType.equals("image/jpeg")) {
                    bl = this.saveJPG(jExportDialog.m_file, this.m_img, null, jExportDialog.m_scaleFactor, jExportDialog.m_quality, jExportDialog.m_bOptimizedHuf);
                } else if (jExportDialog.m_mimeType.equals("image/bmp")) {
                    bl = this.saveBMP(jExportDialog.m_file, this.m_img, null, jExportDialog.m_scaleFactor);
                }
                Main.m_mainFrame.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        return bl;
    }

    protected boolean saveJPG(File file, BufferedImage bufferedImage, JIfdData jIfdData, double d, double d2, boolean bl) {
        boolean bl2 = false;
        if (bufferedImage != null) {
            FileImageOutputStream fileImageOutputStream;
            block10: {
                fileImageOutputStream = null;
                try {
                    if (file.exists()) {
                        file.delete();
                    }
                    BufferedImage bufferedImage2 = this.getBufferedImage(bufferedImage, jIfdData, d);
                    Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType("image/jpeg");
                    if (iterator.hasNext()) {
                        ImageWriter imageWriter = iterator.next();
                        if (Main.m_settings.isDebug()) {
                            System.err.println(imageWriter.getClass().getName());
                        }
                        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
                        imageWriteParam.setCompressionMode(2);
                        imageWriteParam.setCompressionQuality((float)d2);
                        if (bl && imageWriteParam instanceof JPEGImageWriteParam) {
                            JPEGImageWriteParam jPEGImageWriteParam = (JPEGImageWriteParam)imageWriteParam;
                            jPEGImageWriteParam.setOptimizeHuffmanTables(true);
                        }
                        fileImageOutputStream = new FileImageOutputStream(file);
                        imageWriter.setOutput(fileImageOutputStream);
                        imageWriter.write(null, new IIOImage(bufferedImage2, null, null), imageWriteParam);
                        imageWriter.dispose();
                        bl2 = true;
                    }
                }
                catch (IOException iOException) {
                    if (!Main.m_settings.isDebug()) break block10;
                    System.err.println(iOException.toString());
                }
            }
            if (fileImageOutputStream != null) {
                try {
                    fileImageOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return bl2;
    }

    protected boolean saveBMP(File file, BufferedImage bufferedImage, JIfdData jIfdData, double d) {
        boolean bl = false;
        if (bufferedImage != null) {
            FileImageOutputStream fileImageOutputStream;
            block9: {
                fileImageOutputStream = null;
                try {
                    if (file.exists()) {
                        file.delete();
                    }
                    BufferedImage bufferedImage2 = this.getBufferedImage(bufferedImage, jIfdData, d);
                    Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType("image/bmp");
                    if (iterator.hasNext()) {
                        ImageWriter imageWriter = iterator.next();
                        if (Main.m_settings.isDebug()) {
                            System.err.println(imageWriter.getClass().getName());
                        }
                        fileImageOutputStream = new FileImageOutputStream(file);
                        imageWriter.setOutput(fileImageOutputStream);
                        imageWriter.write(new IIOImage(bufferedImage2, null, null));
                        imageWriter.dispose();
                        bl = true;
                    }
                }
                catch (IOException iOException) {
                    if (!Main.m_settings.isDebug()) break block9;
                    System.err.println(iOException.toString());
                }
            }
            if (fileImageOutputStream != null) {
                try {
                    fileImageOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    protected boolean savePNG(File file, BufferedImage bufferedImage, JIfdData jIfdData, double d) {
        boolean bl = false;
        if (bufferedImage != null) {
            FileImageOutputStream fileImageOutputStream;
            block8: {
                fileImageOutputStream = null;
                try {
                    if (file.exists()) {
                        file.delete();
                    }
                    BufferedImage bufferedImage2 = this.getBufferedImage(bufferedImage, jIfdData, d);
                    PngEncoderB pngEncoderB = new PngEncoderB(bufferedImage2);
                    pngEncoderB.setCompressionLevel(9);
                    fileImageOutputStream = new FileImageOutputStream(file);
                    byte[] byArray = pngEncoderB.pngEncode(false);
                    if (byArray != null) {
                        fileImageOutputStream.write(byArray);
                    }
                    bl = true;
                }
                catch (IOException iOException) {
                    if (!Main.m_settings.isDebug()) break block8;
                    System.err.println(iOException.toString());
                }
            }
            if (fileImageOutputStream != null) {
                try {
                    fileImageOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    public Dimension getImageSize(BufferedImage bufferedImage, JIfdData jIfdData, double d) {
        int n = bufferedImage.getWidth(null);
        int n2 = bufferedImage.getHeight(null);
        switch (jIfdData == null ? this.getOrientation() : this.getOrientation(jIfdData)) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                int n3 = n;
                n = n2;
                n2 = n3;
            }
        }
        n2 = (int)(d * (double)n2 + 0.5);
        n = (int)(d * (double)n + 0.5);
        return new Dimension(n, n2);
    }

    public BufferedImage getBufferedImage(BufferedImage bufferedImage, JIfdData jIfdData, double d) {
        Dimension dimension = this.getImageSize(bufferedImage, jIfdData, d);
        BufferedImage bufferedImage2 = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(dimension.width, dimension.height);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        this.doScaleRotate(bufferedImage, jIfdData, graphics2D, dimension);
        Graphics2D graphics2D2 = graphics2D;
        graphics2D2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, Main.m_settings.getInterpolation());
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage2;
    }
}

