/*
 * Decompiled with CFR 0.152.
 */
package JDiskCat;

import JDiskCat.AboutWindow;
import JDiskCat.ProgressWindow;
import JDiskCat.SearchWindow;
import JDiskCat.SettingsWindow;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Main
extends JFrame
implements Runnable {
    private String dirName;
    private String diskPath;
    private String type;
    private static String selected;
    private String path;
    private PrintWriter out = null;
    private static DefaultListModel listModel;
    private DefaultTableModel tableModel;
    private Vector columns;
    private Vector data;
    private DocumentBuilder loader;
    private Document document;
    private Node parent;
    private Node root;
    private NodeList list;
    private static boolean nerdMode;
    private Map<Object, Icon> icons;
    private final Boolean unix;
    private static Preferences prefs;
    Thread dirListThread;
    ProgressWindow progressWindow = new ProgressWindow();
    SettingsWindow settingsWindow = new SettingsWindow();
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JButton jButton9;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private static JList jList1;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JSplitPane jSplitPane1;
    private static JTable jTable1;
    private JToolBar jToolBar1;

    static {
        nerdMode = false;
    }

    public Main() {
        listModel = new DefaultListModel();
        prefs = Preferences.userNodeForPackage(this.getClass());
        File currentDir = new File(System.getProperty("user.dir"));
        String userDir = currentDir.getAbsolutePath();
        int isUnix = userDir.lastIndexOf("/");
        this.unix = isUnix != -1;
        System.out.println("unix: " + this.unix);
        this.initComponents();
        this.columns = new Vector(3);
        this.columns.add("Name");
        this.columns.add("Size");
        this.columns.add("Date");
        this.tableModel = new DefaultTableModel();
        jTable1.setModel(this.tableModel);
        this.refreshDiskList();
        Dimension dialogSize = this.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (dialogSize.height > screenSize.height) {
            dialogSize.height = screenSize.height;
        }
        if (dialogSize.width > screenSize.width) {
            dialogSize.height = screenSize.width;
        }
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton9 = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jSeparator4 = new JToolBar.Separator();
        this.jButton7 = new JButton();
        this.jButton8 = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButton5 = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.jButton6 = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        jList1 = new JList();
        this.jScrollPane2 = new JScrollPane();
        jTable1 = new JTable();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem3 = new JMenuItem();
        this.jMenuItem4 = new JMenuItem();
        this.jMenuItem5 = new JMenuItem();
        this.jMenuItem1 = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.jMenuItem2 = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("JDiskCat 1.3.4");
        this.setBounds(new Rectangle(0, 0, 0, 0));
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/JDiskCat/img/list-add.png")));
        this.jButton1.setToolTipText("Add volume");
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setVerticalTextPosition(3);
        this.jButton1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Main.this.jButton1MouseReleased(evt);
            }
        });
        this.jToolBar1.add(this.jButton1);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/JDiskCat/img/list-remove.png")));
        this.jButton2.setToolTipText("Remove volume");
        this.jButton2.setEnabled(false);
        this.jButton2.setFocusable(false);
        this.jButton2.setHorizontalTextPosition(0);
        this.jButton2.setVerticalTextPosition(3);
        this.jButton2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Main.this.jButton2MouseReleased(evt);
            }
        });
        this.jToolBar1.add(this.jButton2);
        this.jButton9.setIcon(new ImageIcon(this.getClass().getResource("/JDiskCat/img/document-properties.png")));
        this.jButton9.setToolTipText("Display volume info");
        this.jButton9.setEnabled(false);
        this.jButton9.setFocusable(false);
        this.jButton9.setHorizontalTextPosition(0);
        this.jButton9.setVerticalTextPosition(3);
        this.jButton9.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Main.this.jButton9MouseReleased(evt);
            }
        });
        this.jToolBar1.add(this.jButton9);
        this.jToolBar1.add(this.jSeparator1);
        this.jButton3.setIcon(new ImageIcon(this.getClass().getResource("/JDiskCat/img/go-home.png")));
        this.jButton3.setToolTipText("Jump to root folder");
        this.jButton3.setEnabled(false);
        this.jButton3.setFocusable(false);
        this.jButton3.setHorizontalTextPosition(0);
        this.jButton3.setVerticalTextPosition(3);
        this.jButton3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Main.this.jButton3MouseReleased(evt);
            }
        });
        this.jToolBar1.add(this.jButton3);
        this.jButton4.setIcon(new ImageIcon(this.getClass().getResource("/JDiskCat/img/go-up.png")));
        this.jButton4.setToolTipText("Jump to parent folder");
        this.jButton4.setEnabled(false);
        this.jButton4.setFocusable(false);
        this.jButton4.setHorizontalTextPosition(0);
        this.jButton4.setVerticalTextPosition(3);
        this.jButton4.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Main.this.jButton4MouseReleased(evt);
            }
        });
        this.jToolBar1.add(this.jButton4);
        this.jToolBar1.add(this.jSeparator4);
        this.jButton7.setIcon(new ImageIcon(this.getClass().getResource("/JDiskCat/img/document-open.png")));
        this.jButton7.setToolTipText("Open file in registered application");
        this.jButton7.setEnabled(false);
        this.jButton7.setFocusable(false);
        this.jButton7.setHorizontalTextPosition(0);
        this.jButton7.setVerticalTextPosition(3);
        this.jButton7.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Main.this.jButton7MouseReleased(evt);
            }
        });
        this.jToolBar1.add(this.jButton7);
        this.jButton8.setIcon(new ImageIcon(this.getClass().getResource("/JDiskCat/img/folder-open.png")));
        this.jButton8.setToolTipText("Open containing folder");
        this.jButton8.setEnabled(false);
        this.jButton8.setFocusable(false);
        this.jButton8.setHorizontalTextPosition(0);
        this.jButton8.setVerticalTextPosition(3);
        this.jButton8.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Main.this.jButton8MouseReleased(evt);
            }
        });
        this.jToolBar1.add(this.jButton8);
        this.jToolBar1.add(this.jSeparator2);
        this.jButton5.setIcon(new ImageIcon(this.getClass().getResource("/JDiskCat/img/system-search.png")));
        this.jButton5.setToolTipText("Open search window");
        this.jButton5.setEnabled(false);
        this.jButton5.setFocusable(false);
        this.jButton5.setHorizontalTextPosition(0);
        this.jButton5.setVerticalTextPosition(3);
        this.jButton5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Main.this.jButton5MouseReleased(evt);
            }
        });
        this.jToolBar1.add(this.jButton5);
        this.jToolBar1.add(this.jSeparator3);
        this.jButton6.setIcon(new ImageIcon(this.getClass().getResource("/JDiskCat/img/system-log-out.png")));
        this.jButton6.setToolTipText("Exit program");
        this.jButton6.setFocusable(false);
        this.jButton6.setHorizontalTextPosition(0);
        this.jButton6.setVerticalTextPosition(3);
        this.jButton6.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Main.this.jButton6MouseReleased(evt);
            }
        });
        this.jToolBar1.add(this.jButton6);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setText(" ");
        this.jLabel2.setText(" ");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1, -1, 455, Short.MAX_VALUE).addGap(28, 28, 28).addComponent(this.jLabel2, -2, 153, -2)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel1)));
        this.jSplitPane1.setResizeWeight(0.4);
        this.jSplitPane1.setDoubleBuffered(true);
        jList1.setModel(listModel);
        jList1.setSelectionMode(0);
        jList1.setDoubleBuffered(true);
        jList1.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                Main.this.jList1ValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(jList1);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        jTable1.setAutoCreateRowSorter(true);
        jTable1.setModel(new DefaultTableModel(new Object[][]{new Object[3]}, new String[]{"Nazwa", "Wielko\u015b\u0107", "Data"}));
        jTable1.setAutoResizeMode(1);
        jTable1.setDoubleBuffered(true);
        jTable1.setEditingColumn(0);
        jTable1.setEditingRow(0);
        jTable1.setFillsViewportHeight(true);
        jTable1.setGridColor(new Color(0, 0, 0));
        jTable1.setIntercellSpacing(new Dimension(0, 0));
        jTable1.setShowHorizontalLines(false);
        jTable1.setShowVerticalLines(false);
        jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Main.this.jTable1MouseReleased(evt);
            }
        });
        this.jScrollPane2.setViewportView(jTable1);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        this.jMenu1.setText("Program");
        this.jMenuItem3.setIcon(new ImageIcon(this.getClass().getResource("/JDiskCat/img/folder-open.png")));
        this.jMenuItem3.setText("Open data files location");
        this.jMenuItem3.setToolTipText("Location of data file storage (operating system dependent-program folder under Windows, user's home folder under Linux).");
        this.jMenuItem3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Main.this.jMenuItem3MouseReleased(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem3);
        this.jMenuItem4.setIcon(new ImageIcon(this.getClass().getResource("/JDiskCat/img/document-open.png")));
        this.jMenuItem4.setText("Import catalog file");
        this.jMenuItem4.setToolTipText("Import catalog file (XML file) containing volume data. It will be copied to the program data files save location.");
        this.jMenuItem4.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Main.this.jMenuItem4MouseReleased(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem4);
        this.jMenuItem5.setIcon(new ImageIcon(this.getClass().getResource("/JDiskCat/img/preferences-system.png")));
        this.jMenuItem5.setText("Options");
        this.jMenuItem5.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Main.this.jMenuItem5MouseReleased(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem5);
        this.jMenuItem1.setIcon(new ImageIcon(this.getClass().getResource("/JDiskCat/img/system-log-out.png")));
        this.jMenuItem1.setText("Exit");
        this.jMenuItem1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Main.this.jMenuItem1MouseReleased(evt);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Help");
        this.jMenuItem2.setIcon(new ImageIcon(this.getClass().getResource("/JDiskCat/img/dialog-information.png")));
        this.jMenuItem2.setText("About JDiskCat...");
        this.jMenuItem2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                Main.this.jMenuItem2MouseReleased(evt);
            }
        });
        this.jMenu2.add(this.jMenuItem2);
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, 640, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jSplitPane1, -1, 640, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2)));
        this.getAccessibleContext().setAccessibleName("");
        this.pack();
    }

    private void jButton1MouseReleased(MouseEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File("."));
        chooser.setDialogTitle("Select drive or directory");
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(this) == 0) {
            this.dirName = chooser.getSelectedFile().getName();
            System.out.println(this.dirName.indexOf("./"));
            this.dirName = this.dirName.replace("./", "sp4t4A");
            this.dirName = this.dirName.replaceAll("sp4t4A", "");
            String tempPath = chooser.getSelectedFile().getPath();
            int temp = tempPath.lastIndexOf("/");
            if (temp != -1) {
                tempPath = tempPath.substring(0, temp);
                System.out.println("Path: " + tempPath);
            }
            Boolean unixDriveDetected = tempPath.equals("/media") || tempPath.equals("/mnt") || tempPath.equals("/Volumes");
            if (chooser.getSelectedFile().getParent() == null || unixDriveDetected.booleanValue()) {
                FileSystemView view = FileSystemView.getFileSystemView();
                File dir = new File(this.dirName);
                String name = view.getSystemDisplayName(dir);
                System.out.println("Full name: " + name);
                int index = name.lastIndexOf(" (");
                System.out.println("Index: " + index + " Length: " + name.length());
                if (index > 0) {
                    name = index < name.length() - 5 ? name.substring(index + 6, name.length()) : name.substring(0, index);
                }
                this.dirName = name;
                System.out.println("Name: " + name);
                File f = new File(chooser.getSelectedFile().getPath());
                System.out.println("Free: " + f.getFreeSpace());
                this.type = f.getFreeSpace() == 0L ? "cdrom" : "hd";
                if (chooser.getSelectedFile().getPath().trim().equals("A:\\") || chooser.getSelectedFile().getPath().trim().equals("B:\\")) {
                    this.type = "flop";
                }
            } else {
                this.type = "dir";
            }
            System.out.println("Type: " + this.type);
            this.diskPath = chooser.getSelectedFile().getPath();
            this.diskPath = this.diskPath.replace("./", "sp4t4A");
            this.diskPath = this.diskPath.replaceAll("sp4t4A", "");
            this.progressWindow.SetProgress(0);
            this.progressWindow.setVisible(true);
            this.dirListThread = new Thread(this);
            this.dirListThread.start();
        } else {
            System.out.println("Nothing selected!");
        }
    }

    private void jButton2MouseReleased(MouseEvent evt) {
        if (jList1.getSelectedIndex() != -1) {
            selected = (String)jList1.getSelectedValue();
            System.out.println("Selected: " + selected);
            Object[] options = new Object[]{"Yes", "No"};
            int n = JOptionPane.showOptionDialog(this, "Do you wish to remove the volume \"" + selected + "\"?", "Volume deletion", 0, 3, null, options, options[0]);
            if (n == 0) {
                boolean success = new File(String.valueOf(selected) + ".xml").delete();
                if (!success) {
                    System.out.println("Unable to remove " + selected);
                } else {
                    this.refreshDiskList();
                    this.tableModel = new DefaultTableModel();
                    jTable1.setModel(this.tableModel);
                }
            }
        } else {
            System.out.println("Nothing selected!");
        }
    }

    private void jButton3MouseReleased(MouseEvent evt) {
        this.goHome();
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        this.path = selected = (String)jList1.getSelectedValue();
        if (selected != null && !selected.isEmpty()) {
            this.readDisk(String.valueOf(selected) + ".xml");
            this.jButton2.setEnabled(true);
            this.jButton7.setEnabled(true);
            this.jButton8.setEnabled(true);
            this.jButton9.setEnabled(true);
        } else {
            this.jButton2.setEnabled(false);
            this.jButton7.setEnabled(false);
            this.jButton8.setEnabled(false);
            this.jButton9.setEnabled(false);
        }
        this.jButton3.setEnabled(false);
        this.jButton4.setEnabled(false);
        this.jLabel1.setText(this.path);
    }

    private void jMenuItem1MouseReleased(MouseEvent evt) {
        System.exit(0);
    }

    private void jButton4MouseReleased(MouseEvent evt) {
        this.levelUp();
    }

    private void jButton5MouseReleased(MouseEvent evt) {
        if (this.jButton5.isEnabled()) {
            new SearchWindow().setVisible(true);
        }
    }

    private void jMenuItem2MouseReleased(MouseEvent evt) {
        new AboutWindow().setVisible(true);
    }

    private void jButton6MouseReleased(MouseEvent evt) {
        System.exit(0);
    }

    private void jTable1MouseReleased(MouseEvent evt) {
        Point p = evt.getPoint();
        int row = jTable1.rowAtPoint(p);
        if (row != -1 && jTable1.getValueAt(row, 1).equals("<DIR>") && jTable1.getSelectedRow() != -1) {
            String value = (String)jTable1.getValueAt(row, 0);
            System.out.println(value);
            this.levelDown(value);
        }
    }

    private void jButton7MouseReleased(MouseEvent evt) {
        int row = jTable1.getSelectedRow();
        if (row != -1 && !jTable1.getValueAt(row, 1).equals("<DIR>") && !jTable1.getValueAt(row, 1).toString().isEmpty() && jTable1.getSelectedRow() != -1) {
            String filePath;
            int temp;
            Element rootElement = (Element)this.root;
            String rootPath = rootElement.getAttribute("path");
            if (rootPath.trim().length() == 3) {
                temp = this.path.indexOf("\\");
                if (temp != -1) {
                    filePath = this.path.substring(temp + 1);
                    filePath = String.valueOf(rootPath) + filePath + "\\" + (String)jTable1.getValueAt(row, 0);
                } else {
                    filePath = String.valueOf(rootPath) + (String)jTable1.getValueAt(row, 0);
                }
            } else {
                temp = this.path.indexOf("\\");
                if (temp != -1) {
                    filePath = this.path.substring(temp + 1);
                    filePath = String.valueOf(rootPath) + "\\" + filePath + "\\" + (String)jTable1.getValueAt(row, 0);
                } else {
                    filePath = String.valueOf(rootPath) + "\\" + (String)jTable1.getValueAt(row, 0);
                }
            }
            if (filePath.contains("/")) {
                filePath = filePath.replace('\\', '/');
            }
            System.out.println(filePath);
            File file = new File(filePath);
            if (file.exists()) {
                if (Desktop.isDesktopSupported()) {
                    Desktop desktop = Desktop.getDesktop();
                    try {
                        desktop.open(file);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                        JOptionPane.showMessageDialog(this, "An error occurred while opening the file. Most likely, no application is associated with that file type.", "Error opening the file.", 0);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this, "The requested file is not available. Check the availability of volume: \"" + selected + "\".", "Error opening the file.", 0);
            }
        }
    }

    private void jButton8MouseReleased(MouseEvent evt) {
        int row = jTable1.getSelectedRow();
        if (row != -1 && !jTable1.getValueAt(row, 1).equals("<DIR>") && !jTable1.getValueAt(row, 1).toString().isEmpty() && jTable1.getSelectedRow() != -1) {
            String filePath;
            int temp;
            Element rootElement = (Element)this.root;
            String rootPath = rootElement.getAttribute("path");
            if (rootPath.trim().length() == 3) {
                temp = this.path.indexOf("\\");
                if (temp != -1) {
                    filePath = this.path.substring(temp + 1);
                    filePath = String.valueOf(rootPath) + filePath;
                } else {
                    filePath = rootPath;
                }
            } else {
                temp = this.path.indexOf("\\");
                if (temp != -1) {
                    filePath = this.path.substring(temp + 1);
                    filePath = String.valueOf(rootPath) + "\\" + filePath;
                } else {
                    filePath = rootPath;
                }
            }
            if (filePath.contains("/")) {
                filePath = filePath.replace('\\', '/');
            }
            System.out.println(filePath);
            File file = new File(filePath);
            if (file.exists()) {
                if (Desktop.isDesktopSupported()) {
                    Desktop desktop = Desktop.getDesktop();
                    try {
                        desktop.open(file);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                        JOptionPane.showMessageDialog(this, "An error occurred while opening the folder.", "Error opening folder", 0);
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this, "The requested folder is not available. Check the availability of volume: \"" + selected + "\".", "Error opening folder", 0);
            }
        }
    }

    private void jButton9MouseReleased(MouseEvent evt) {
        try {
            String type;
            double temp;
            File xml = new File(String.valueOf(jList1.getSelectedValue().toString()) + ".xml");
            long length = xml.length();
            String dataSize = "" + length;
            if (length < 1024L) {
                dataSize = length + " B";
            }
            if (length >= 1024L && length < 0x100000L) {
                temp = (double)length / 1024.0;
                dataSize = String.valueOf(Main.numberFormat(temp)) + " kB";
            }
            if (length >= 0x100000L && length < 0x40000000L) {
                temp = (double)length / 1048576.0;
                dataSize = String.valueOf(Main.numberFormat(temp)) + " MB";
            }
            if (length >= 0x40000000L) {
                temp = (double)length / 1.073741824E9;
                dataSize = String.valueOf(Main.numberFormat(temp)) + " GB";
            }
            System.out.println(length);
            System.out.println(dataSize);
            DocumentBuilderFactory factory2 = DocumentBuilderFactory.newInstance();
            DocumentBuilder loader2 = factory2.newDocumentBuilder();
            Document document2 = loader2.parse(String.valueOf(jList1.getSelectedValue().toString()) + ".xml");
            Node root2 = document2.getLastChild();
            Element rootElement = (Element)root2;
            String rootPath = rootElement.getAttribute("path");
            int dirNodes = document2.getElementsByTagName("dir").getLength();
            int fileNodes = document2.getElementsByTagName("file").getLength();
            System.out.println("dirs: " + dirNodes + " files: " + fileNodes);
            if (rootPath.isEmpty()) {
                rootPath = "Unknown";
            }
            if ((type = rootElement.getAttribute("type")).isEmpty()) {
                type = "Unknown";
            }
            if (type.equals("hd")) {
                type = "Harddisk/flash drive partitiom";
            }
            if (type.equals("dir")) {
                type = "Folder";
            }
            if (type.equals("cdrom")) {
                type = "CD/DVD/BD";
            }
            if (type.equals("flop")) {
                type = "Floppy disk";
            }
            JOptionPane.showMessageDialog(this, "Type: " + type + "\nLocation: " + rootPath + "\nFiles: " + fileNodes + "\nFolders: " + dirNodes + "\nCatalog file size: " + dataSize + "\nCatalog file location: " + xml.getAbsolutePath(), "Properties: " + jList1.getSelectedValue().toString(), 1);
        }
        catch (ParserConfigurationException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println("xml parsing error");
        }
        catch (SAXException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println("xml parsing error");
        }
        catch (IOException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println("xml parsing error");
        }
        catch (HeadlessException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            System.out.println("xml parsing error");
        }
    }

    private void jMenuItem3MouseReleased(MouseEvent evt) {
        File currentDir = new File(System.getProperty("user.dir"));
        System.out.println(currentDir.getAbsolutePath());
        if (currentDir.exists()) {
            if (Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.open(currentDir);
                }
                catch (IOException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                    JOptionPane.showMessageDialog(this, "An error occurred while opening the folder.", "Error opening folder", 0);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this, "The requested folder is not available.", "Error opening folder", 0);
        }
    }

    private void jMenuItem4MouseReleased(MouseEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File("."));
        fc.setFileSelectionMode(0);
        fc.setFileFilter(new FileNameExtensionFilter("XML data files", "xml"));
        if (fc.showOpenDialog(this) == 0) {
            String xmlName = fc.getSelectedFile().getName();
            System.out.println(xmlName.indexOf("./"));
            xmlName = xmlName.replace("./", "sp4t4A");
            xmlName = xmlName.replaceAll("sp4t4A", "");
            System.out.println(xmlName);
            String f1Path = fc.getSelectedFile().getPath();
            int isUnix = f1Path.lastIndexOf("/");
            String f2Path = isUnix != -1 ? String.valueOf(System.getProperty("user.dir")) + "/" + xmlName : String.valueOf(System.getProperty("user.dir")) + "\\" + xmlName;
            System.out.println("Path1: " + f1Path + "\nPath2: " + f2Path);
            File f1 = new File(f1Path);
            File f2 = new File(f2Path);
            try {
                Main.copyFile(f1, f2);
            }
            catch (IOException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                JOptionPane.showMessageDialog(this, "An error occurred while importing volume file. Check your write priviledges.", "Error importing catalog file", 0);
            }
            this.refreshDiskList();
        } else {
            System.out.println("Nothing selected!");
        }
    }

    private void jMenuItem5MouseReleased(MouseEvent evt) {
        this.settingsWindow.setVisible(true);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    UIManager.put("Button.defaultButtonFollowsFocus", Boolean.TRUE);
                }
                catch (ClassNotFoundException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IllegalAccessException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (InstantiationException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (UnsupportedLookAndFeelException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
                new Main().setVisible(true);
            }
        });
    }

    private void dirList(String fname, Boolean firstStage) {
        File dir = new File(fname);
        Object[] chld = dir.listFiles();
        if (this.unix.booleanValue()) {
            Arrays.sort(chld);
        }
        if (chld == null) {
            System.out.println("The directory " + fname + " does not exist or is not a directory.");
            JOptionPane.showMessageDialog(this, "Katalog " + fname + " does not exist, is not a directory or you don't have sufficient privileges to read it.", "Error - send error report.", 0);
            System.exit(0);
        } else {
            int i = 0;
            while (i < chld.length) {
                if (firstStage.booleanValue()) {
                    this.progressWindow.SetProgress(100 * i / chld.length);
                }
                this.progressWindow.SetCurrentPath(dir.getAbsolutePath());
                String name = ((File)chld[i]).getName();
                name = name.replaceAll("&", "&amp;");
                Long modified = ((File)chld[i]).lastModified();
                Timestamp date = new Timestamp(modified);
                if (((File)chld[i]).isFile() && ((File)chld[i]).canRead()) {
                    String size = "" + ((File)chld[i]).length();
                    this.out.println("<file name=\"" + name + "\" date=\"" + date + "\" size=\"" + size + "\"/>");
                }
                if (((File)chld[i]).isDirectory() && ((File)chld[i]).canRead() && ((File)chld[i]).listFiles() != null) {
                    this.out.println("<dir name=\"" + name + "\" date=\"" + date + "\">");
                    this.dirList(((File)chld[i]).getPath(), false);
                    this.out.println("</dir>");
                }
                ++i;
            }
        }
    }

    private void refreshDiskList() {
        this.icons = new HashMap<Object, Icon>();
        listModel.clear();
        File dir = new File(".");
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".xml") || name.endsWith(".XML");
            }
        };
        File[] chld = dir.listFiles(filter);
        if (chld == null) {
            System.out.println("The selected directory does not exist or is not a directory.");
            System.exit(0);
        } else {
            Arrays.sort(chld, new Comparator(){

                public int compare(Object a, Object b) {
                    File filea = (File)a;
                    File fileb = (File)b;
                    if (filea.isDirectory() && !fileb.isDirectory()) {
                        return -1;
                    }
                    if (!filea.isDirectory() && fileb.isDirectory()) {
                        return 1;
                    }
                    return filea.getName().compareToIgnoreCase(fileb.getName());
                }
            });
            int i = 0;
            while (i < chld.length) {
                if (chld[i].isFile() && !chld[i].getName().equals("build.xml") && chld[i].length() > 0L) {
                    String name = Main.getFileNameWithoutExtension(chld[i].getName());
                    try {
                        DocumentBuilderFactory factory2 = DocumentBuilderFactory.newInstance();
                        DocumentBuilder loader2 = factory2.newDocumentBuilder();
                        Document document2 = loader2.parse(chld[i].getName());
                        Node root2 = document2.getLastChild();
                        Element rootElement = (Element)root2;
                        if (rootElement.hasAttribute("type") && rootElement.hasAttribute("name") && rootElement.hasAttribute("path")) {
                            listModel.addElement(name);
                            String type = rootElement.getAttribute("type");
                            if (type.isEmpty()) {
                                this.icons.put(name, null);
                            }
                            if (type.equals("hd")) {
                                this.icons.put(name, new ImageIcon(this.getClass().getResource("/JDiskCat/img/drive-harddisk.png")));
                            }
                            if (type.equals("dir")) {
                                this.icons.put(name, new ImageIcon(this.getClass().getResource("/JDiskCat/img/folder.png")));
                            }
                            if (type.equals("cdrom")) {
                                this.icons.put(name, new ImageIcon(this.getClass().getResource("/JDiskCat/img/media-optical.png")));
                            }
                            if (type.equals("flop")) {
                                this.icons.put(name, new ImageIcon(this.getClass().getResource("/JDiskCat/img/media-floppy.png")));
                            }
                        }
                    }
                    catch (ParserConfigurationException ex) {
                        Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                        System.out.println(ex.getStackTrace().toString());
                        JOptionPane.showMessageDialog(this, "File " + name + ".xml seems to be corrupted and cannot be loaded.", "Error - send error report.", 0);
                    }
                    catch (SAXException ex) {
                        Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                        System.out.println(ex.getStackTrace().toString());
                        JOptionPane.showMessageDialog(this, "File " + name + ".xml seems to be corrupted and cannot be loaded.", "Error - send error report.", 0);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                        System.out.println(ex.getStackTrace().toString());
                        JOptionPane.showMessageDialog(this, "File " + name + ".xml seems to be corrupted and cannot be loaded.", "Error - send error report.", 0);
                    }
                }
                ++i;
            }
        }
        jList1.setCellRenderer(new IconListRenderer(this.icons));
        if (jList1.getModel().getSize() > 0) {
            this.jButton5.setEnabled(true);
        } else {
            this.jButton5.setEnabled(false);
        }
    }

    public static String getFileNameWithoutExtension(String fileName) {
        File tmpFile = new File(fileName);
        tmpFile.getName();
        int whereDot = tmpFile.getName().lastIndexOf(46);
        if (whereDot > 0 && whereDot <= tmpFile.getName().length() - 2) {
            return tmpFile.getName().substring(0, whereDot);
        }
        return "";
    }

    private void readDisk(String filename) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            this.loader = factory.newDocumentBuilder();
            this.document = this.loader.parse(filename);
            this.parent = this.root = this.document.getLastChild();
            this.list = this.root.getChildNodes();
            this.refreshTable();
        }
        catch (Exception e) {
            System.out.println("error: " + e);
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getStackTrace().toString(), "Error - send error report.", 0);
        }
    }

    private void refreshTable() {
        String attribSize;
        String attribDate;
        String attribName;
        Element child;
        Vector<String> row;
        Node node;
        boolean grayFolderRows = prefs.getBoolean("GRAY_FOLDER_ROWS", false);
        this.data = new Vector(3);
        int tmp = 0;
        int i = 0;
        while (i < this.list.getLength()) {
            node = this.list.item(i);
            row = new Vector<String>(3);
            if (node instanceof Element) {
                child = (Element)node;
                attribName = child.getAttribute("name");
                attribDate = child.getAttribute("date");
                attribSize = child.getAttribute("size");
                if (attribSize.isEmpty()) {
                    attribSize = "<DIR>";
                    row.add(attribName);
                    row.add(attribSize);
                    row.add(attribDate);
                    this.data.add(row);
                    if (grayFolderRows) {
                        ++tmp;
                    }
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.list.getLength()) {
            node = this.list.item(i);
            row = new Vector(3);
            if (node instanceof Element) {
                child = (Element)node;
                attribName = child.getAttribute("name");
                attribDate = child.getAttribute("date");
                attribSize = child.getAttribute("size");
                if (attribSize.isEmpty()) {
                    attribSize = "<DIR>";
                } else {
                    long size = Long.parseLong(attribSize);
                    attribSize = Main.sizeFormat(size);
                }
                row.add(attribName);
                row.add(attribSize);
                row.add(attribDate);
                if (!attribSize.equals("<DIR>")) {
                    this.data.add(row);
                }
            }
            ++i;
        }
        this.tableModel = new DefaultTableModel(this.data, this.columns);
        jTable1.setModel(this.tableModel);
        if (grayFolderRows) {
            jTable1.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    c.setBackground(table.getValueAt(row, 1).toString().equals("<DIR>") ? Color.LIGHT_GRAY : Color.WHITE);
                    c.setForeground(table.getValueAt(row, 1).toString().equals("<DIR>") ? Color.BLACK : Color.BLACK);
                    return c;
                }
            });
        }
    }

    private void levelDown(String from) {
        int i = 0;
        while (i < this.list.getLength()) {
            Element child;
            String attribName;
            Node node = this.list.item(i);
            if (node instanceof Element && (attribName = (child = (Element)node).getAttribute("name")).equals(from)) {
                this.parent = node;
                break;
            }
            ++i;
        }
        this.path = String.valueOf(this.path) + "\\" + from;
        this.jLabel1.setText(this.path);
        this.list = this.parent.getChildNodes();
        this.refreshTable();
        this.jButton3.setEnabled(true);
        this.jButton4.setEnabled(true);
    }

    private void levelUp() {
        if (this.parent != this.root) {
            this.parent = this.parent.getParentNode();
            this.list = this.parent.getChildNodes();
            this.refreshTable();
            this.path = this.path.substring(0, this.path.lastIndexOf("\\"));
            this.jLabel1.setText(this.path);
            if (this.path.lastIndexOf("\\") == -1) {
                this.jButton3.setEnabled(false);
                this.jButton4.setEnabled(false);
            }
        }
    }

    private void goHome() {
        if (this.parent != this.root) {
            this.parent = this.root;
            this.list = this.parent.getChildNodes();
            this.refreshTable();
            this.path = selected;
            this.jLabel1.setText(this.path);
            this.jButton3.setEnabled(false);
            this.jButton4.setEnabled(false);
        }
    }

    public static String getSelected() {
        return selected;
    }

    public static int getSelectedIndex() {
        return jList1.getSelectedIndex();
    }

    @Override
    public void run() {
        this.jButton1.setEnabled(false);
        try {
            FileOutputStream fos = new FileOutputStream(String.valueOf(this.dirName) + ".xml");
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF8");
            File disk = new File(this.diskPath);
            if (disk.listFiles() != null && disk.canRead()) {
                this.out = new PrintWriter(osw);
                this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                this.out.println("<vol name=\"" + this.dirName + "\" path=\"" + this.diskPath + "\" type=\"" + this.type + "\">");
                System.out.println("path: " + this.diskPath);
                long start = System.currentTimeMillis();
                this.dirList(this.diskPath, true);
                long stop = System.currentTimeMillis();
                float runTime = stop - start;
                System.out.println("Cataloging duration: " + (runTime /= 1000.0f) + " s");
                this.jLabel1.setText("Cataloging duration: " + runTime + " s");
                this.out.println("</vol>");
                this.out.close();
                this.out = null;
                this.refreshDiskList();
            } else {
                JOptionPane.showMessageDialog(this, "Directory " + this.dirName + " doesn't exist or you don's have sufficient priviledges to read it.", "Error", 0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getStackTrace().toString(), "Error - send error report to author", 0);
        }
        this.jButton1.setEnabled(true);
        this.progressWindow.setVisible(false);
    }

    public static DefaultListModel getDiskList() {
        return listModel;
    }

    public static String numberFormat(double value) {
        String pattern = "###.##";
        DecimalFormat myFormatter = new DecimalFormat(pattern);
        String output = myFormatter.format(value);
        return output;
    }

    public static String sizeFormat(long length) {
        String dataSize = "" + length;
        nerdMode = prefs.getBoolean("NERD_MODE", false);
        if (!nerdMode) {
            double temp;
            if (length < 1024L) {
                dataSize = length + " B";
            }
            if (length >= 1024L && length < 0x100000L) {
                temp = (double)length / 1024.0;
                dataSize = String.valueOf(Main.numberFormat(temp)) + " kB";
            }
            if (length >= 0x100000L && length < 0x40000000L) {
                temp = (double)length / 1048576.0;
                dataSize = String.valueOf(Main.numberFormat(temp)) + " MB";
            }
            if (length >= 0x40000000L) {
                temp = (double)length / 1.073741824E9;
                dataSize = String.valueOf(Main.numberFormat(temp)) + " GB";
            }
        }
        return dataSize;
    }

    public static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
            System.out.println("File cloned");
        }
    }

    class IconListRenderer
    extends DefaultListCellRenderer {
        private Map<Object, Icon> icons = null;

        public IconListRenderer(Map<Object, Icon> icons) {
            this.icons = icons;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Icon icon = this.icons.get(value);
            label.setIcon(icon);
            return label;
        }
    }
}

