/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane;

import com.hbworks.dirpane.FileNameCellEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;

public class CellEditorContainer
extends Container
implements TableCellEditor,
TreeCellEditor {
    protected Component renderer;
    protected transient JTextField editor;
    protected transient FileNameCellEditor realEditor;
    protected transient Icon editingIcon;
    protected int editingOffset;
    protected boolean editingLeaf;
    protected boolean editingExpanded;

    public CellEditorContainer(FileNameCellEditor realEditor, Component renderer) {
        this.realEditor = realEditor;
        this.renderer = renderer;
        this.setLayout(null);
    }

    public Object getCellEditorValue() {
        return this.realEditor.getCellEditorValue();
    }

    public boolean isCellEditable(EventObject event) {
        if (this.realEditor.isCellEditable(event)) {
            this.add(this.editor);
            return true;
        }
        return false;
    }

    public boolean shouldSelectCell(EventObject event) {
        return this.realEditor.shouldSelectCell(event);
    }

    public boolean stopCellEditing() {
        if (this.realEditor.stopCellEditing()) {
            if (this.editor != null) {
                this.remove(this.editor);
            }
            this.editingIcon = null;
            return true;
        }
        return false;
    }

    public void cancelCellEditing() {
        this.realEditor.cancelCellEditing();
        if (this.editor != null) {
            this.remove(this.editor);
        }
        this.editingIcon = null;
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.realEditor.addCellEditorListener(l);
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.realEditor.removeCellEditorListener(l);
    }

    public void doLayout() {
        if (this.editor != null) {
            Dimension cSize = this.getSize();
            this.editor.getPreferredSize();
            this.editor.setLocation(this.editingOffset, 0);
            this.editor.setBounds(this.editingOffset, 0, cSize.width - this.editingOffset, cSize.height);
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.editingOffset = 0;
        this.editingIcon = null;
        TableCellRenderer r = (TableCellRenderer)((Object)this.renderer);
        Component c = r.getTableCellRendererComponent(table, value, isSelected, true, row, column);
        if (c instanceof JLabel) {
            JLabel renderedComponent = (JLabel)c;
            this.editingIcon = renderedComponent.getIcon();
            if (this.editingIcon != null) {
                this.editingOffset = renderedComponent.getIconTextGap() - 2 + this.editingIcon.getIconWidth();
            }
        }
        this.editor = (JTextField)this.realEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
        return this;
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        this.editingOffset = 0;
        this.editingIcon = null;
        TreeCellRenderer r = (TreeCellRenderer)((Object)this.renderer);
        Component c = r.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, true);
        if (c instanceof JLabel) {
            JLabel renderedComponent = (JLabel)c;
            this.editingIcon = renderedComponent.getIcon();
            if (this.editingIcon != null) {
                this.editingOffset = renderedComponent.getIconTextGap() - 2 + this.editingIcon.getIconWidth();
            }
        }
        this.editingLeaf = leaf;
        this.editingExpanded = expanded;
        this.editor = (JTextField)this.realEditor.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
        return this;
    }

    public void paint(Graphics g) {
        if (this.editingIcon != null) {
            int yLoc = Math.max(0, (this.getSize().height - this.editingIcon.getIconHeight() + 1) / 2);
            this.editingIcon.paintIcon(this, g, 0, yLoc);
        }
        super.paint(g);
    }

    public Dimension getPreferredSize() {
        if (this.editor != null) {
            Dimension pSize = this.editor.getPreferredSize();
            pSize.width += this.editingOffset + 10;
            return pSize;
        }
        return new Dimension(0, 0);
    }

    public void requestFocus() {
        if (this.editor != null) {
            this.editor.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Vector<Object> values = new Vector<Object>();
        s.defaultWriteObject();
        if (this.editingIcon != null && this.editingIcon instanceof Serializable) {
            values.addElement("editingIcon");
            values.addElement(this.editingIcon);
        }
        if (this.realEditor != null && this.realEditor instanceof Serializable) {
            values.addElement("realEditor");
            values.addElement(this.realEditor);
        }
        s.writeObject(values);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Vector values = (Vector)s.readObject();
        int indexCounter = 0;
        int maxCounter = values.size();
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals("editingIcon")) {
            this.editingIcon = (Icon)values.elementAt(++indexCounter);
            ++indexCounter;
        }
        if (indexCounter < maxCounter && values.elementAt(indexCounter).equals("realEditor")) {
            this.realEditor = (FileNameCellEditor)values.elementAt(++indexCounter);
            ++indexCounter;
        }
    }
}

