/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane;

import com.hbworks.dirpane.AcceptAllFileFilter;
import com.hbworks.dirpane.AutoRefresher;
import com.hbworks.dirpane.DefaultFileView;
import com.hbworks.dirpane.ExportComponentsFactory;
import com.hbworks.dirpane.FileFilter;
import com.hbworks.dirpane.FileSorter;
import com.hbworks.dirpane.FileSystem;
import com.hbworks.dirpane.FileSystemModel;
import com.hbworks.dirpane.FileView;
import com.hbworks.dirpane.event.LoadingListener;
import com.hbworks.dirpane.plaf.DirectoryPaneUI;
import com.hbworks.dirpane.resources.LocalizedStringTable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public abstract class DirectoryPane
extends JComponent
implements SwingConstants {
    public static final String IS_ACTIVEPANE_PROPERTY = "isActivePane";
    public static final String IS_GRAYOUTENABLED_PROPERTY = "canGrayoutPane";
    public static final String IS_SLAVE_PROPERTY = "isSlave";
    public static final String IS_EDITABLE_PROPERTY = "isEditable";
    public static final String IS_SORTING_PROPERTY = "isSorting";
    public static final String DIRECTORY_CHANGED_PROPERTY = "directoryChanged";
    public static final String SYNC_SLAVEDIRECTORY_PROPERTY = "syncSlaveDirectory";
    public static final String FILE_ADDED_PROPERTY = "fileAdded";
    public static final String FILE_DELETED_PROPERTY = "fileDeleted";
    public static final String FILE_RENAMED_PROPERTY = "fileRenamed";
    public static final String BUSY_PROPERTY = "isBusy";
    public static final String FILESYSTEM_CHANGED_PROPERTY = "fileSystemChanged";
    public static final String FILESORTER_CHANGED_PROPERTY = "fileSorterChanged";
    public static final String FILEVIEW_CHANGED_PROPERTY = "fileViewChanged";
    public static final String FILEHIDING_CHANGED_PROPERTY = "fileHidingChanged";
    public static final String FILEFILTER_CHANGED_PROPERTY = "fileFilterChanged";
    public static final String CHOOSABLE_FILEFILTER_CHANGED_PROPERTY = "choosableFileFilterChangedProperty";
    public static final String FILESELECTIONMODE_CHANGED_PROPERTY = "fileSelectionModeChanged";
    public static final String FOREGROUND_CHANGED_PROPERTY = "foregroundChanged";
    public static final String BACKGROUND_CHANGED_PROPERTY = "backgroundChanged";
    public static final String SELECTIONFOREGROUND_CHANGED_PROPERTY = "selectionForegroundChangedProperty";
    public static final String SELECTIONBACKGROUND_CHANGED_PROPERTY = "selectionBackgroundChanged";
    public static final String FONT_CHANGED_PROPERTY = "fontChanged";
    public static final String ROWHEIGHT_CHANGED_PROPERTY = "rowHeightChanged";
    public static final String AUTOREFRESHMODE_CHANGED_PROPERTY = "autoRefreshModeChanged";
    public static final Color DEFAULT_BACKGROUND = Color.white;
    public static final Color DEFAULT_NOTACTIVE_BACKGROUND = Color.getHSBColor(0.0f, 0.0f, 0.65f);
    public static final Font DEFAULT_FONT = new Font("dialog", 0, 11);
    public static final int DEFAULT_ROWHEIGHT = 18;
    public static final int FILES_ONLY = 0;
    public static final int DIRECTORIES_ONLY = 1;
    public static final int FILES_AND_DIRECTORIES = 2;
    private Vector filters = new Vector(5);
    private FileView fileView = null;
    protected DefaultFileView defFileView = null;
    private boolean useFileHiding = true;
    protected int fileSelectionMode = 2;
    protected FileFilter fileFilter = null;
    private FileFilter acceptAllFileFilter = null;
    private Color notActiveBackground = DEFAULT_NOTACTIVE_BACKGROUND;
    private Color selectionForeground = null;
    private Color selectionBackground = null;
    private int rowHeight = 18;
    private transient boolean activePane = false;
    private boolean isGrayoutEnabled = true;
    private transient boolean slave = false;
    private boolean editable = true;
    private transient boolean paintSelectionOnlyWhenActive = false;
    private transient boolean loading = false;
    private transient boolean sorting = false;
    private transient boolean isAutoRefreshing = false;
    private String defaultNewFolderName = LocalizedStringTable.getString("DirectoryPane.defaultNewFolderName");
    private transient boolean haspopup = false;
    protected File currentDirectory = null;
    protected File userDirectory = null;
    private String currentLocation = null;
    private String userLocation = null;
    protected transient Vector slavePanes = null;
    public transient JPopupMenu popupmenu = null;
    public FileSystemModel filesystemModel = null;
    protected String command;
    protected String doubleClickCommand = "doubleClick";
    protected String doubleClickContainerCommand = "doubleClickContainer";
    private Action newFolderAction = new NewFolderAction();
    private Action goHomeAction = new GoHomeAction();
    private Action goUpAction = new GoUpAction();
    private Action doubleClickAction = new DoubleClickAction();
    private Action refreshAction = new RefreshAction();
    private Action renameFileAction = new RenameFileAction();
    private Icon customFileIcon = null;
    private Icon customDirectoryIcon = null;
    private Icon customOpenDirectoryIcon = null;
    private Icon customFloppyDriveIcon = null;
    private Icon customHardDriveIcon = null;
    private Icon customComputerIcon = null;
    protected AutoRefresher autoRefresher = null;
    static /* synthetic */ Class class$java$awt$event$ActionListener;

    protected DirectoryPane() {
        this.init();
    }

    protected void init() {
        this.setBackground(DEFAULT_BACKGROUND);
        this.setOpaque(true);
        this.setFont(DEFAULT_FONT);
        this.defFileView = new DefaultFileView();
        this.acceptAllFileFilter = new AcceptAllFileFilter();
        this.addChoosableFileFilter(this.acceptAllFileFilter);
        this.fileFilter = this.acceptAllFileFilter;
        this.setActivePane(true);
    }

    protected void finalize() {
        this.stopAutoRefresher();
    }

    protected void startAutoRefresher() {
        if (this.autoRefresher == null) {
            this.autoRefresher = this.createAutoRefresher();
            if (this.currentDirectory != null) {
                this.autoRefresher.reset(this.currentDirectory);
            }
        }
    }

    protected void stopAutoRefresher() {
        if (this.autoRefresher != null) {
            this.autoRefresher.kill();
            this.autoRefresher = null;
        }
    }

    protected AutoRefresher createAutoRefresher() {
        return new AutoRefresher(this);
    }

    public AutoRefresher getAutoRefresher() {
        return this.autoRefresher;
    }

    public void blockAutoRefresher() {
        if (this.isAutoRefreshing) {
            this.autoRefresher.block();
        }
    }

    public void unblockAutoRefresher() {
        if (this.isAutoRefreshing) {
            this.autoRefresher.unblock();
        }
    }

    public void clearAutoRefresher() {
        if (this.isAutoRefreshing) {
            this.autoRefresher.clear();
        }
    }

    public void resetAutoRefresher(File dir) {
        if (this.isAutoRefreshing) {
            this.autoRefresher.reset(dir);
        }
    }

    public void addToAutoRefresher(File dir) {
        if (this.isAutoRefreshing) {
            this.autoRefresher.add(dir);
        }
    }

    public void removeFromAutoRefresher(File dir) {
        if (this.isAutoRefreshing) {
            this.autoRefresher.remove(dir);
        }
    }

    public boolean isAutoRefreshing() {
        return this.isAutoRefreshing;
    }

    public void setAutoRefreshing(boolean refresh) {
        boolean oldState = this.isAutoRefreshing;
        this.isAutoRefreshing = refresh;
        if (this.isAutoRefreshing) {
            this.startAutoRefresher();
        } else {
            this.stopAutoRefresher();
        }
        this.firePropertyChange(AUTOREFRESHMODE_CHANGED_PROPERTY, oldState, this.isAutoRefreshing);
    }

    public JButton getGoUpButton() {
        return ExportComponentsFactory.createGoUpButton(this);
    }

    public JButton getGoHomeButton() {
        return ExportComponentsFactory.createGoHomeButton(this);
    }

    public JButton getNewFolderButton() {
        return ExportComponentsFactory.createNewFolderButton(this);
    }

    public JComboBox getDirectoryHistoryComboBox() {
        return ExportComponentsFactory.createDirectoryHistoryComboBox(this);
    }

    public abstract JComboBox getDirectoryComboBox();

    public JComboBox getFilterComboBox() {
        return ExportComponentsFactory.createFilterComboBox(this);
    }

    public abstract JTextField getFilenameField();

    public JTextField getPatternSearchField() {
        return ExportComponentsFactory.createPatternSearchField(this);
    }

    public boolean accept(File f) {
        boolean shown = true;
        if (this.fileFilter != null) {
            shown = this.fileFilter.accept(f);
        }
        return shown;
    }

    public FileFilter getAcceptAllFileFilter() {
        return this.acceptAllFileFilter;
    }

    public void setAcceptAllFileFilterDescription(String description) {
        this.acceptAllFileFilter.setDescription(description);
    }

    public String getAcceptAllFileFilterDescription() {
        return this.acceptAllFileFilter.getDescription();
    }

    public void setDefaultNewFolderName(String name) {
        this.defaultNewFolderName = name;
    }

    public String getDefaultNewFolderName() {
        return this.defaultNewFolderName;
    }

    public abstract void startEditorOnFile(File var1);

    public FileFilter[] getChoosableFileFilters() {
        Object[] filterArray = new FileFilter[this.filters.size()];
        this.filters.copyInto(filterArray);
        return filterArray;
    }

    public void addChoosableFileFilter(FileFilter filter) {
        if (!this.filters.contains(filter)) {
            FileFilter[] oldValue = this.getChoosableFileFilters();
            this.filters.addElement(filter);
            this.firePropertyChange(CHOOSABLE_FILEFILTER_CHANGED_PROPERTY, oldValue, this.getChoosableFileFilters());
        }
    }

    public boolean removeChoosableFileFilter(FileFilter f) {
        if (this.filters.contains(f)) {
            FileFilter[] oldValue = this.getChoosableFileFilters();
            this.filters.removeElement(f);
            this.firePropertyChange(CHOOSABLE_FILEFILTER_CHANGED_PROPERTY, oldValue, this.getChoosableFileFilters());
            return true;
        }
        return false;
    }

    public void resetChoosableFileFilters() {
        FileFilter[] oldValue = this.getChoosableFileFilters();
        this.filters.removeAllElements();
        this.filters.addElement(this.acceptAllFileFilter);
        this.firePropertyChange(CHOOSABLE_FILEFILTER_CHANGED_PROPERTY, oldValue, this.getChoosableFileFilters());
    }

    public void setFileSelectionMode(int mode) {
        if (this.fileSelectionMode == mode) {
            return;
        }
        int oldValue = this.fileSelectionMode;
        this.fileSelectionMode = mode;
        this.firePropertyChange(FILESELECTIONMODE_CHANGED_PROPERTY, oldValue, this.fileSelectionMode);
    }

    public int getFileSelectionMode() {
        return this.fileSelectionMode;
    }

    public boolean isFileSelectionEnabled() {
        return this.fileSelectionMode == 0 || this.fileSelectionMode == 2;
    }

    public boolean isDirectorySelectionEnabled() {
        return this.fileSelectionMode == 1 || this.fileSelectionMode == 2;
    }

    public boolean isFileHidingEnabled() {
        return this.useFileHiding;
    }

    public void setFileHidingEnabled(boolean b) {
        boolean oldValue = this.useFileHiding;
        this.useFileHiding = b;
        this.firePropertyChange(FILEHIDING_CHANGED_PROPERTY, oldValue, this.useFileHiding);
    }

    public void setFileFilter(FileFilter filter) {
        if (filter == null) {
            filter = this.acceptAllFileFilter;
        }
        FileFilter oldValue = this.fileFilter;
        this.fileFilter = filter;
        this.addChoosableFileFilter(filter);
        this.firePropertyChange(FILEFILTER_CHANGED_PROPERTY, oldValue, this.fileFilter);
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setFileView(FileView fileView) {
        if (fileView == null) {
            fileView = this.defFileView;
        }
        FileView oldValue = this.fileView;
        this.fileView = fileView;
        this.firePropertyChange(FILEVIEW_CHANGED_PROPERTY, oldValue, fileView);
    }

    public FileView getFileView() {
        if (this.fileView == null) {
            return this.defFileView;
        }
        return this.fileView;
    }

    public DefaultFileView getDefaultFileView() {
        return this.defFileView;
    }

    public void setCustomFileIcon(Icon icon) {
        this.customFileIcon = icon;
    }

    public Icon getCustomFileIcon() {
        return this.customFileIcon;
    }

    public void setCustomDirectoryIcon(Icon icon) {
        this.customDirectoryIcon = icon;
    }

    public Icon getCustomDirectoryIcon() {
        return this.customDirectoryIcon;
    }

    public void setCustomOpenDirectoryIcon(Icon icon) {
        this.customOpenDirectoryIcon = icon;
    }

    public Icon getCustomOpenDirectoryIcon() {
        return this.customOpenDirectoryIcon;
    }

    public void setCustomFloppyDriveIcon(Icon icon) {
        this.customFloppyDriveIcon = icon;
    }

    public Icon getCustomFloppyDriveIcon() {
        return this.customFloppyDriveIcon;
    }

    public void setCustomHardDriveIcon(Icon icon) {
        this.customHardDriveIcon = icon;
    }

    public Icon getCustomHardDriveIcon() {
        return this.customHardDriveIcon;
    }

    public void setCustomComputerIcon(Icon icon) {
        this.customComputerIcon = icon;
    }

    public Icon getCustomComputerIcon() {
        return this.customComputerIcon;
    }

    public String getName(File f) {
        String filename = null;
        if (this.getFileView() != null) {
            filename = this.getFileView().getName(f);
        }
        if (filename == null && this.defFileView != null) {
            filename = this.defFileView.getName(f);
        }
        return filename;
    }

    public void putDescription(File f, String fileDescription) {
        if (this.getFileView() != null) {
            this.getFileView().putDescription(f, fileDescription);
        }
        if (this.defFileView != null) {
            this.defFileView.putDescription(f, fileDescription);
        }
    }

    public String getDescription(File f) {
        String description = null;
        if (this.getFileView() != null) {
            description = this.getFileView().getDescription(f);
        }
        if (description == null && this.defFileView != null) {
            description = this.defFileView.getDescription(f);
        }
        return description;
    }

    public void putTypeDescription(File f, String typeDescription) {
        if (this.getFileView() != null) {
            this.getFileView().putTypeDescription(f, typeDescription);
        }
        if (this.defFileView != null) {
            this.defFileView.putTypeDescription(f, typeDescription);
        }
    }

    public String getTypeDescription(File f) {
        String typeDescription = null;
        if (this.getFileView() != null) {
            typeDescription = this.getFileView().getTypeDescription(f);
        }
        if (typeDescription == null && this.defFileView != null) {
            typeDescription = this.defFileView.getTypeDescription(f);
        }
        return typeDescription;
    }

    public void putTypeIcon(File f, Icon icon) {
        if (this.getFileView() != null) {
            this.getFileView().putIcon(f, icon);
        }
        if (this.defFileView != null) {
            this.defFileView.putIcon(f, icon);
        }
    }

    public Icon getTypeIcon(File f) {
        Icon icon = null;
        if (this.getFileView() != null) {
            icon = this.getFileView().getIcon(f);
        }
        if (icon == null && this.defFileView != null) {
            icon = this.defFileView.getIcon(f);
        }
        return icon;
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, 100);
    }

    public void setForeground(Color c) {
        Color oldFG = this.getForeground();
        Color newFG = c;
        super.setForeground(newFG);
        this.firePropertyChange(FOREGROUND_CHANGED_PROPERTY, oldFG, newFG);
    }

    public void setBackground(Color c) {
        Color oldBG = this.getBackground();
        Color newBG = c != null ? c : DEFAULT_BACKGROUND;
        super.setBackground(newBG);
        this.firePropertyChange(BACKGROUND_CHANGED_PROPERTY, oldBG, newBG);
    }

    public void setNotActiveBackground(Color c) {
        this.notActiveBackground = c;
    }

    public Color getNotActiveBackground() {
        return this.notActiveBackground;
    }

    public void setSelectionForeground(Color c) {
        Color newFG;
        Color oldFG = this.selectionForeground;
        this.selectionForeground = newFG = c;
        this.firePropertyChange(SELECTIONFOREGROUND_CHANGED_PROPERTY, oldFG, newFG);
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public void setSelectionBackground(Color c) {
        Color newBG;
        Color oldBG = this.selectionBackground;
        this.selectionBackground = newBG = c;
        this.firePropertyChange(SELECTIONBACKGROUND_CHANGED_PROPERTY, oldBG, newBG);
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public void setFont(Font f) {
        Font oldFont = this.getFont();
        Font newFont = f != null ? f : DEFAULT_FONT;
        super.setFont(newFont);
        this.firePropertyChange(FONT_CHANGED_PROPERTY, oldFont, f);
    }

    public void setRowHeight(int h) {
        int newHeight;
        if (h <= 0) {
            h = 18;
        }
        int oldHeight = this.rowHeight;
        this.rowHeight = newHeight = h;
        this.firePropertyChange(ROWHEIGHT_CHANGED_PROPERTY, oldHeight, newHeight);
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setActivePane(boolean b) {
        boolean newflag;
        boolean oldflag = this.activePane;
        this.activePane = newflag = b;
        this.firePropertyChange(IS_ACTIVEPANE_PROPERTY, oldflag, newflag);
    }

    public boolean isActivePane() {
        return this.activePane;
    }

    public void setPaintSelectionOnlyWhenActive(boolean b) {
        this.paintSelectionOnlyWhenActive = b;
    }

    public boolean isPaintSelectionOnlyWhenActive() {
        return this.paintSelectionOnlyWhenActive;
    }

    public void setGrayoutEnabled(boolean b) {
        boolean newflag;
        boolean oldflag = this.isGrayoutEnabled;
        this.isGrayoutEnabled = newflag = b;
        this.firePropertyChange(IS_GRAYOUTENABLED_PROPERTY, oldflag, newflag);
    }

    public boolean isGrayoutEnabled() {
        return this.isGrayoutEnabled;
    }

    public void setEditable(boolean b) {
        boolean newflag;
        boolean oldflag = this.editable;
        this.editable = newflag = b;
        this.firePropertyChange(IS_EDITABLE_PROPERTY, oldflag, newflag);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setLoading(boolean b) {
        this.loading = b;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setSorting(boolean b) {
        boolean newflag;
        boolean oldflag = this.sorting;
        this.sorting = newflag = b;
        this.firePropertyChange(IS_SORTING_PROPERTY, oldflag, newflag);
    }

    public boolean isSorting() {
        return this.sorting;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupmenu;
    }

    public boolean hasPopupMenu() {
        return this.haspopup;
    }

    public void setPopupMenu(JPopupMenu p) {
        this.haspopup = p != null;
        this.popupmenu = p;
    }

    public void removePopupMenu() {
        this.popupmenu = null;
        this.haspopup = false;
    }

    public PropertyChangeListener createSlaveDriver() {
        return new SlaveDriver();
    }

    public boolean isSlave() {
        return this.slave;
    }

    protected void setSlave(boolean b) {
        boolean newstate;
        boolean oldstate = this.slave;
        this.slave = newstate = b;
        this.firePropertyChange(IS_SLAVE_PROPERTY, new Boolean(oldstate), new Boolean(newstate));
    }

    public void addSlave(DirectoryPane aSlave) {
        if (aSlave == null) {
            return;
        }
        if (!this.sharesMasterFileSystem(aSlave)) {
            throw new IllegalArgumentException("Slave " + aSlave + " does not share its FileSystem with master " + this);
        }
        if (this.slavePanes == null) {
            this.slavePanes = new Vector();
        }
        if (!this.slavePanes.contains(aSlave)) {
            this.slavePanes.addElement(aSlave);
            if (aSlave.getModel().directoryCanBeCurrent(this.getCurrentDirectory())) {
                aSlave.setCurrentDirectory(this.getCurrentDirectory().getPath());
            }
            this.addPropertyChangeListener(aSlave.createSlaveDriver());
            aSlave.setSlave(true);
        }
    }

    public void removeSlave(DirectoryPane aSlave) {
        if (this.slavePanes == null) {
            System.out.println("There are no slaves, nothing found to remove.");
            return;
        }
        if (!this.slavePanes.contains(aSlave)) {
            System.out.println(aSlave + " is not a slave of " + this + ", can't be removed.");
            return;
        }
        this.slavePanes.removeElement(aSlave);
        this.removePropertyChangeListener(aSlave.getModel());
        aSlave.setSlave(false);
    }

    public Vector getSlaves() {
        if (this.slavePanes == null) {
            return new Vector();
        }
        return this.slavePanes;
    }

    public boolean sharesMasterFileSystem(DirectoryPane aSlave) {
        if (!aSlave.getModel().getFileSystem().equals(this.filesystemModel.getFileSystem())) {
            return false;
        }
        File thisRoot = this.getFileSystemRoot();
        File slaveCur = aSlave.getCurrentDirectory();
        if (slaveCur == null) {
            slaveCur = this.getWorkingDirectory();
        }
        File slaveParent = slaveCur;
        do {
            if (slaveParent != thisRoot) continue;
            return true;
        } while ((slaveParent = this.getParentDirectory(slaveParent)) != null);
        return false;
    }

    protected void synchronizeSlaveDirectory(File masterDir) {
        File oldValue = this.currentDirectory;
        this.filesystemModel.setCurrentDirectory(masterDir);
        this.currentDirectory = this.filesystemModel.getCurrentDirectory();
        this.firePropertyChange(SYNC_SLAVEDIRECTORY_PROPERTY, oldValue, this.currentDirectory);
    }

    public abstract void setMultiSelectionEnabled(boolean var1);

    public abstract void setSelectionMode(int var1);

    public abstract int getSelectionMode();

    public abstract File getSelectedFile();

    public abstract File[] getSelectedFiles();

    public Object retrieveFromFileSystem(File holder) throws IOException {
        this.firePropertyChange(BUSY_PROPERTY, null, new Boolean(true));
        Object retVal = this.filesystemModel.retrieveFromFileSystem(holder);
        this.firePropertyChange(BUSY_PROPERTY, null, new Boolean(false));
        return retVal;
    }

    public File loadIntoFileSystem(Object obj, File parentDir, boolean overwritePermissionGranted) throws IOException {
        this.firePropertyChange(BUSY_PROPERTY, null, new Boolean(true));
        File newFile = null;
        this.blockAutoRefresher();
        newFile = this.filesystemModel.loadIntoFileSystem(obj, parentDir, overwritePermissionGranted);
        if (newFile != null) {
            this.firePropertyChange(FILE_ADDED_PROPERTY, null, newFile);
        }
        this.firePropertyChange(BUSY_PROPERTY, null, new Boolean(false));
        return newFile;
    }

    public boolean deleteFile(File f) {
        if (!this.isEditable()) {
            return false;
        }
        this.firePropertyChange(BUSY_PROPERTY, null, new Boolean(true));
        this.blockAutoRefresher();
        boolean deleted = this.filesystemModel.deleteFile(f);
        if (deleted) {
            this.firePropertyChange(FILE_DELETED_PROPERTY, null, f);
        }
        this.firePropertyChange(BUSY_PROPERTY, null, new Boolean(false));
        return deleted;
    }

    public boolean deleteFile(File[] files) {
        if (!this.isEditable()) {
            return false;
        }
        boolean deleted = true;
        int i = 0;
        while (i < files.length) {
            deleted &= this.deleteFile(files[i]);
            ++i;
        }
        return deleted;
    }

    public boolean deleteDirectory(File dir) {
        if (!this.isEditable()) {
            return false;
        }
        this.firePropertyChange(BUSY_PROPERTY, null, new Boolean(true));
        File parent = this.getParentDirectory(dir);
        this.blockAutoRefresher();
        boolean wiped = this.filesystemModel.deleteDirectory(dir);
        if (wiped) {
            this.firePropertyChange(FILE_DELETED_PROPERTY, null, dir);
        }
        this.firePropertyChange(BUSY_PROPERTY, null, new Boolean(false));
        return wiped;
    }

    public boolean renameFile(File oldfile, String newname) {
        if (!this.isEditable()) {
            return false;
        }
        this.firePropertyChange(BUSY_PROPERTY, null, new Boolean(true));
        File parent = this.getParentDirectory(oldfile);
        File newfile = this.createFileObject(parent, newname);
        this.blockAutoRefresher();
        boolean renamed = this.filesystemModel.renameFile(oldfile, newfile);
        if (renamed) {
            this.firePropertyChange(FILE_RENAMED_PROPERTY, oldfile, newfile);
        }
        this.firePropertyChange(BUSY_PROPERTY, null, new Boolean(false));
        return renamed;
    }

    public boolean createDirectory(File parentDir, String dirName) {
        if (!this.isEditable()) {
            return false;
        }
        this.firePropertyChange(BUSY_PROPERTY, null, new Boolean(true));
        File newDir = this.createFileObject(parentDir, dirName);
        this.blockAutoRefresher();
        boolean created = this.filesystemModel.createDirectory(newDir);
        if (created) {
            this.firePropertyChange(FILE_ADDED_PROPERTY, null, newDir);
        }
        this.firePropertyChange(BUSY_PROPERTY, null, new Boolean(false));
        return created;
    }

    public boolean createDirectories(File parentDir, String pathName) {
        if (!this.isEditable()) {
            return false;
        }
        this.firePropertyChange(BUSY_PROPERTY, null, new Boolean(true));
        File newDir = this.createFileObject(parentDir, pathName);
        this.blockAutoRefresher();
        boolean created = this.filesystemModel.createDirectories(newDir);
        if (created) {
            this.firePropertyChange(FILE_ADDED_PROPERTY, null, newDir);
        }
        this.firePropertyChange(BUSY_PROPERTY, null, new Boolean(false));
        return created;
    }

    public abstract void createNewFolder();

    public void refresh() {
        this.refresh(this.currentDirectory);
    }

    public void refresh(String location) {
        if (location != null) {
            this.refresh(this.createFileObject(location));
        } else {
            this.refresh(this.getWorkingDirectory());
        }
    }

    public void refresh(File dir) {
        this.blockAutoRefresher();
        this.filesystemModel.refresh(dir);
        this.resetAutoRefresher(dir);
    }

    public void addLoadingListener(LoadingListener l) {
        this.filesystemModel.addLoadingListener(l);
    }

    public void removeLoadingListener(LoadingListener l) {
        this.filesystemModel.removeLoadingListener(l);
    }

    public FileSystemModel getModel() {
        return this.filesystemModel;
    }

    protected abstract void setModel(FileSystemModel var1);

    public String getUserLocation() {
        return this.userLocation;
    }

    public void setUserLocation(String loc) {
        this.setUserDirectory(loc);
    }

    public String getCurrentLocation() {
        return this.currentLocation;
    }

    public void setCurrentLocation(String loc) {
        this.setCurrentDirectory(loc);
    }

    public File getUserDirectory() {
        return this.userDirectory;
    }

    public void setUserDirectory(String userPath) {
        if (userPath != null) {
            this.userDirectory = this.createFileObject(userPath);
            if (this.userDirectory != null) {
                this.userLocation = this.userDirectory.getPath();
            }
        } else {
            this.userDirectory = this.getHomeDirectory();
        }
    }

    public boolean isCurrentDirectory(File dir) {
        if (this.currentDirectory == null) {
            return false;
        }
        if (dir == null) {
            return false;
        }
        String thisPath = this.currentDirectory.getPath();
        String thatPath = dir.getPath();
        return thisPath.equalsIgnoreCase(thatPath);
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setCurrentDirectory(String currentPath) {
        this.blockAutoRefresher();
        File oldValue = this.currentDirectory;
        File curDir = null;
        curDir = currentPath != null ? this.createFileObject(currentPath) : this.getWorkingDirectory();
        this.filesystemModel.setCurrentDirectory(curDir);
        this.currentDirectory = this.filesystemModel.getCurrentDirectory();
        if (this.currentDirectory != null) {
            this.currentLocation = this.currentDirectory.getPath();
            this.resetAutoRefresher(this.currentDirectory);
        }
        this.firePropertyChange(DIRECTORY_CHANGED_PROPERTY, oldValue, this.currentDirectory);
    }

    public void goHome() {
        File userDir = this.getUserDirectory();
        File homeDir = this.getHomeDirectory();
        if (userDir != null) {
            this.setCurrentDirectory(userDir.getPath());
        } else {
            this.setCurrentDirectory(homeDir.getPath());
        }
    }

    public void goUp() {
        File curDir = this.getCurrentDirectory();
        File parent = this.filesystemModel.getParentDirectory(curDir);
        if (parent != null) {
            this.setCurrentDirectory(parent.getPath());
        }
    }

    public abstract void setFileSystem(FileSystem var1);

    public FileSystem getFileSystem() {
        return this.filesystemModel.getFileSystem();
    }

    public void setFileSorter(FileSorter newSorter) {
        FileSorter oldSorter = this.filesystemModel.getFileSorter();
        this.filesystemModel.setFileSorter(newSorter);
        this.firePropertyChange(FILESORTER_CHANGED_PROPERTY, oldSorter, newSorter);
    }

    public FileSorter getFileSorter() {
        return this.filesystemModel.getFileSorter();
    }

    public String getFileSeparator() {
        return this.filesystemModel.getFileSeparator();
    }

    public File getFileSystemRoot() {
        return this.filesystemModel.getFileSystemRoot();
    }

    public File createFileObject(String path) {
        return this.filesystemModel.createFileObject(path);
    }

    public File createFileObject(File dir, String name) {
        return this.filesystemModel.createFileObject(dir, name);
    }

    public File getParentDirectory(File dir) {
        return this.filesystemModel.getParentDirectory(dir);
    }

    public File getHomeDirectory() {
        return this.filesystemModel.getHomeDirectory();
    }

    public File getWorkingDirectory() {
        return this.filesystemModel.getWorkingDirectory();
    }

    public File[] getFiles(File dir, boolean useFileHiding) {
        return this.filesystemModel.getFiles(dir, useFileHiding);
    }

    public int getDirectoryType(File dir) {
        return this.filesystemModel.getDirectoryType(dir);
    }

    public boolean doesFileExist(File file) {
        return this.filesystemModel.doesFileExist(file);
    }

    public boolean isHiddenFile(File file) {
        return this.filesystemModel.isHiddenFile(file);
    }

    public boolean isTraversable(File file) {
        return this.filesystemModel.isTraversable(file);
    }

    public boolean isReadOnly(File file) {
        return this.filesystemModel.isReadOnly(file);
    }

    public synchronized void addActionListener(ActionListener l) {
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = DirectoryPane.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = DirectoryPane.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, l);
    }

    protected void fireActionPerformed(String command) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$java$awt$event$ActionListener == null ? DirectoryPane.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) {
                if (e == null) {
                    e = new ActionEvent(this, 1001, command);
                }
                ((ActionListener)listeners[i + 1]).actionPerformed(e);
            }
            i -= 2;
        }
    }

    public void setActionCommand(String command) {
        String oldCommand = this.command;
        this.command = command;
        this.firePropertyChange("actionCommand", oldCommand, command);
    }

    public String getActionCommand() {
        return this.command;
    }

    public void setDoubleClickCommand(String command) {
        String oldCommand = this.doubleClickCommand;
        this.doubleClickCommand = command;
        this.firePropertyChange("doubleClickCommand", oldCommand, command);
    }

    public String getDoubleClickCommand() {
        return this.doubleClickCommand;
    }

    public void setDoubleClickContainerCommand(String command) {
        String oldCommand = this.doubleClickContainerCommand;
        this.doubleClickContainerCommand = command;
        this.firePropertyChange("doubleClickContainerCommand", oldCommand, command);
    }

    public String getDoubleClickContainerCommand() {
        return this.doubleClickContainerCommand;
    }

    public abstract void performDoubleClick();

    public Action getNewFolderAction() {
        return this.newFolderAction;
    }

    public Action getGoHomeAction() {
        return this.goHomeAction;
    }

    public Action getGoUpAction() {
        return this.goUpAction;
    }

    public Action getDoubleClickAction() {
        return this.doubleClickAction;
    }

    public Action getRefreshAction() {
        return this.refreshAction;
    }

    public Action getRenameFileAction() {
        return this.renameFileAction;
    }

    public DirectoryPaneUI getUI() {
        return (DirectoryPaneUI)this.ui;
    }

    public void updateUI() {
        String basicPackageName = "com.hbworks.dirpane.plaf.basic.";
        Object[] basicDefs = new Object[]{"PaneTableUI", basicPackageName + "BasicPaneTableUI", "PaneTreeUI", basicPackageName + "BasicPaneTreeUI", "TableDirectoryPaneUI", basicPackageName + "BasicTableDirectoryPaneUI", "TreeDirectoryPaneUI", basicPackageName + "BasicTreeDirectoryPaneUI"};
        UIManager.getDefaults().putDefaults(basicDefs);
        LookAndFeel lf = UIManager.getLookAndFeel();
        if (lf.getID().equals("Metal")) {
            String metalPackageName = "com.hbworks.dirpane.plaf.metal.";
            Object[] metalDefs = new Object[]{"PaneTableUI", metalPackageName + "MetalPaneTableUI", "PaneTreeUI", metalPackageName + "MetalPaneTreeUI", "TableDirectoryPaneUI", metalPackageName + "MetalTableDirectoryPaneUI", "TreeDirectoryPaneUI", metalPackageName + "MetalTreeDirectoryPaneUI"};
            UIManager.getDefaults().putDefaults(metalDefs);
        } else if (lf.getID().equals("Motif")) {
            String motifPackageName = "com.hbworks.dirpane.plaf.motif.";
            Object[] motifDefs = new Object[]{"PaneTableUI", motifPackageName + "MotifPaneTableUI", "PaneTreeUI", motifPackageName + "MotifPaneTreeUI", "TableDirectoryPaneUI", motifPackageName + "MotifTableDirectoryPaneUI", "TreeDirectoryPaneUI", motifPackageName + "MotifTreeDirectoryPaneUI"};
            UIManager.getDefaults().putDefaults(motifDefs);
        } else if (lf.getID().equals("Windows")) {
            String windowsPackageName = "com.hbworks.dirpane.plaf.windows.";
            Object[] winDefs = new Object[]{"PaneTableUI", windowsPackageName + "WindowsPaneTableUI", "PaneTreeUI", windowsPackageName + "WindowsPaneTreeUI", "TableDirectoryPaneUI", windowsPackageName + "WindowsTableDirectoryPaneUI", "TreeDirectoryPaneUI", windowsPackageName + "WindowsTreeDirectoryPaneUI"};
            UIManager.getDefaults().putDefaults(winDefs);
        } else if (lf.getID().equals("Platinum")) {
            String macPackageName = "com.hbworks.dirpane.plaf.mac.";
            Object[] macDefs = new Object[]{"PaneTableUI", macPackageName + "MacPaneTableUI", "PaneTreeUI", macPackageName + "MacPaneTreeUI", "TableDirectoryPaneUI", macPackageName + "MacTableDirectoryPaneUI", "TreeDirectoryPaneUI", macPackageName + "MacTreeDirectoryPaneUI"};
            UIManager.getDefaults().putDefaults(macDefs);
        } else {
            String metalPackageName = "com.hbworks.dirpane.plaf.metal.";
            Object[] fallbackDefs = new Object[]{"PaneTableUI", metalPackageName + "MetalPaneTableUI", "PaneTreeUI", metalPackageName + "MetalPaneTreeUI", "TableDirectoryPaneUI", metalPackageName + "MetalTableDirectoryPaneUI", "TreeDirectoryPaneUI", metalPackageName + "MetalTreeDirectoryPaneUI"};
            UIManager.getDefaults().putDefaults(fallbackDefs);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.setActivePane(true);
        this.setLoading(false);
        this.setSorting(false);
        this.setSlave(false);
        this.setAutoRefreshing(false);
        this.haspopup = false;
        this.paintSelectionOnlyWhenActive = false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class RenameFileAction
    extends AbstractAction {
        public RenameFileAction() {
            super(LocalizedStringTable.getString("DirectoryPane.renameFileAction"));
        }

        public void actionPerformed(ActionEvent e) {
            File f = DirectoryPane.this.getSelectedFile();
            DirectoryPane.this.startEditorOnFile(f);
        }
    }

    protected class RefreshAction
    extends AbstractAction {
        public RefreshAction() {
            super(LocalizedStringTable.getString("DirectoryPane.refreshAction"));
        }

        public void actionPerformed(ActionEvent e) {
            DirectoryPane.this.refresh();
        }
    }

    protected class DoubleClickAction
    extends AbstractAction {
        public DoubleClickAction() {
            super(LocalizedStringTable.getString("DirectoryPane.doubleClickAction"));
        }

        public void actionPerformed(ActionEvent e) {
            DirectoryPane.this.performDoubleClick();
        }
    }

    protected class GoUpAction
    extends AbstractAction {
        public GoUpAction() {
            super(LocalizedStringTable.getString("DirectoryPane.goUpAction"));
        }

        public void actionPerformed(ActionEvent e) {
            DirectoryPane.this.goUp();
        }
    }

    protected class GoHomeAction
    extends AbstractAction {
        public GoHomeAction() {
            super(LocalizedStringTable.getString("DirectoryPane.goHomeAction"));
        }

        public void actionPerformed(ActionEvent e) {
            DirectoryPane.this.goHome();
        }
    }

    protected class NewFolderAction
    extends AbstractAction {
        public NewFolderAction() {
            super(LocalizedStringTable.getString("DirectoryPane.newFolderAction"));
        }

        public void actionPerformed(ActionEvent e) {
            DirectoryPane.this.createNewFolder();
        }
    }

    class SlaveDriver
    implements PropertyChangeListener {
        SlaveDriver() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            Object oldvalue = e.getOldValue();
            Object newvalue = e.getNewValue();
            String name = e.getPropertyName();
            if (name == DirectoryPane.FILESYSTEM_CHANGED_PROPERTY) {
                FileSystem masterSystem = (FileSystem)newvalue;
                DirectoryPane.this.setFileSystem(masterSystem);
            } else if (name == DirectoryPane.DIRECTORY_CHANGED_PROPERTY) {
                File masterDir = (File)newvalue;
                DirectoryPane.this.synchronizeSlaveDirectory(masterDir);
            } else if (name == DirectoryPane.FILE_ADDED_PROPERTY) {
                File f = (File)newvalue;
                DirectoryPane.this.filesystemModel.fileAdded(f);
            } else if (name == DirectoryPane.FILE_DELETED_PROPERTY) {
                File f = (File)newvalue;
                DirectoryPane.this.filesystemModel.fileDeleted(f);
            } else if (name == DirectoryPane.FILE_RENAMED_PROPERTY) {
                File oldfile = (File)oldvalue;
                File newfile = (File)newvalue;
                DirectoryPane.this.filesystemModel.fileRenamed(oldfile, newfile);
            }
        }
    }
}

