/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.TreeCellEditor;

public class FileNameCellEditor
implements TableCellEditor,
TreeCellEditor,
ActionListener,
Serializable {
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    protected JTextField editorComponent;
    protected int clickCountToStart = 1;
    static /* synthetic */ Class class$javax$swing$event$CellEditorListener;

    public FileNameCellEditor(JTextField tf) {
        this.editorComponent = tf;
        this.editorComponent.addActionListener(this);
        this.editorComponent.registerKeyboardAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                FileNameCellEditor.this.cancelCellEditing();
            }
        }, KeyStroke.getKeyStroke(27, 0), 0);
    }

    public Component getComponent() {
        return this.editorComponent;
    }

    public void setClickCountToStart(int count) {
        this.clickCountToStart = count;
    }

    public int getClickCountToStart() {
        return this.clickCountToStart;
    }

    public void setCellEditorValue(Object aValue) {
        if (aValue != null) {
            if (aValue instanceof File) {
                this.editorComponent.setText(((File)aValue).getName());
            } else {
                this.editorComponent.setText(aValue.toString());
            }
        } else {
            this.editorComponent.setText("");
        }
        this.editorComponent.selectAll();
    }

    public Object getCellEditorValue() {
        return this.editorComponent.getText();
    }

    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            if (SwingUtilities.isRightMouseButton((MouseEvent)anEvent)) {
                return false;
            }
            if (((MouseEvent)anEvent).getClickCount() != this.clickCountToStart) {
                return false;
            }
        }
        return true;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return false;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.listenerList.add(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = FileNameCellEditor.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, l);
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.listenerList.remove(class$javax$swing$event$CellEditorListener == null ? (class$javax$swing$event$CellEditorListener = FileNameCellEditor.class$("javax.swing.event.CellEditorListener")) : class$javax$swing$event$CellEditorListener, l);
    }

    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$javax$swing$event$CellEditorListener == null ? FileNameCellEditor.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingStopped(this.changeEvent);
            }
            i -= 2;
        }
    }

    protected void fireEditingCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == (class$javax$swing$event$CellEditorListener == null ? FileNameCellEditor.class$("javax.swing.event.CellEditorListener") : class$javax$swing$event$CellEditorListener)) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i + 1]).editingCanceled(this.changeEvent);
            }
            i -= 2;
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.stopCellEditing();
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        String stringValue = tree.convertValueToText(value, isSelected, expanded, leaf, row, false);
        this.setCellEditorValue(stringValue);
        return this.editorComponent;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setCellEditorValue(value);
        return this.editorComponent;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

