/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane.comp;

import com.hbworks.dirpane.TableDirectoryPane;
import com.hbworks.dirpane.plaf.mac.MacIconFactory;
import com.hbworks.dirpane.plaf.metal.MetalIconFactory;
import com.hbworks.dirpane.plaf.motif.MotifIconFactory;
import com.hbworks.dirpane.plaf.windows.WindowsIconFactory;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

public class DetailsViewButton
extends JToggleButton {
    static final long serialVersionUID = -676351346305015208L;
    public static final String DIRECTORYPANE_PROPERTY = "directoryPane";
    TableDirectoryPane pane;

    public DetailsViewButton() {
        this((TableDirectoryPane)null);
    }

    public DetailsViewButton(TableDirectoryPane pane) {
        if (pane != null) {
            this.pane = pane;
            if (pane.getViewMode().equals("detailsview")) {
                this.setSelected(true);
            }
            this.addActionListener(pane.getDetailsViewAction());
        }
    }

    public void setDirectoryPane(TableDirectoryPane newpane) {
        TableDirectoryPane newprop;
        if (newpane == null) {
            throw new IllegalArgumentException("Can not set a null DirectoryPane");
        }
        TableDirectoryPane oldprop = this.pane;
        this.pane = newprop = newpane;
        if (this.pane.getViewMode().equals("detailsview")) {
            this.setSelected(true);
        }
        this.addActionListener(this.pane.getDetailsViewAction());
        this.firePropertyChange(DIRECTORYPANE_PROPERTY, oldprop, newprop);
    }

    public TableDirectoryPane getDirectoryPane() {
        return this.pane;
    }

    public Icon getIcon() {
        LookAndFeel lf = UIManager.getLookAndFeel();
        if (lf.getID().equals("Metal")) {
            return MetalIconFactory.getDetailsViewIcon();
        }
        if (lf.getID().equals("Windows")) {
            return WindowsIconFactory.getDetailsViewIcon();
        }
        if (lf.getID().equals("Motif")) {
            return MotifIconFactory.getDetailsViewIcon();
        }
        if (lf.getID().equals("Platinum")) {
            return MacIconFactory.getDetailsViewIcon();
        }
        return UIManager.getIcon("FileChooser.detailsViewIcon");
    }

    public Icon getDisabledIcon() {
        try {
            Image image = ((ImageIcon)this.getIcon()).getImage();
            Image disabledImage = GrayFilter.createDisabledImage(image);
            return new ImageIcon(disabledImage);
        }
        catch (ClassCastException e) {
            return this.getIcon();
        }
    }

    public Insets getMargin() {
        return new Insets(1, 1, 1, 1);
    }

    public float getAlignmentY() {
        return 0.5f;
    }
}

