/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane.plaf;

import com.hbworks.dirpane.TreeDirectoryPane;
import com.hbworks.dirpane.plaf.DirectoryPaneUI;
import com.hbworks.dirpane.plaf.basic.BasicPaneTreeUI;
import com.hbworks.misc.GlassPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.TreePath;

public abstract class TreeDirectoryPaneUI
extends DirectoryPaneUI {
    protected TreeDirectoryPane directoryPane = null;
    protected JTree tree = null;

    public void installUI(JComponent c) {
        super.installUI(c);
        this.installColors();
    }

    public void uninstallUI(JComponent c) {
        this.uninstallColors();
        super.uninstallUI(c);
    }

    protected void installColors() {
        if (this.paneBackground == null) {
            this.paneActiveBackground = this.directoryPane.getBackground();
            this.paneNotActiveBackground = this.directoryPane.getNotActiveBackground();
            this.paneBackground = this.directoryPane.isGrayoutEnabled() ? (this.directoryPane.isActivePane() ? this.paneActiveBackground : this.paneNotActiveBackground) : this.paneActiveBackground;
            Color fg = this.directoryPane.getForeground();
            this.paneForeground = fg == null ? UIManager.getColor("Tree.foreground") : fg;
            Color sfg = this.directoryPane.getSelectionForeground();
            this.paneSelectionForeground = sfg == null ? UIManager.getColor("Tree.selectionForeground") : sfg;
            Color sbg = this.directoryPane.getSelectionBackground();
            this.paneSelectionBackground = sbg == null ? UIManager.getColor("Tree.selectionBackground") : sbg;
            this.paneSelectionBorder = UIManager.getColor("Tree.selectionBorderColor");
        }
    }

    protected void uninstallColors() {
        this.paneBackground = null;
        this.paneForeground = null;
        this.paneActiveBackground = null;
        this.paneNotActiveBackground = null;
        this.paneSelectionForeground = null;
        this.paneSelectionBackground = null;
        this.paneSelectionBorder = null;
    }

    protected JComponent createGlassPaneFor(Container c) {
        return new CoverGlass(c);
    }

    public TreeDirectoryPane getDirectoryPane() {
        return this.directoryPane;
    }

    public JTree getUITree() {
        return this.tree;
    }

    public abstract void restoreUIView();

    protected class CoverGlass
    extends GlassPanel {
        public CoverGlass(Container c) {
            super(c);
            this.setVisible(false);
        }

        public void processMouseEvent(MouseEvent e) {
            if (e.getID() == 501) {
                TreeDirectoryPaneUI.this.directoryPane.setActivePane(true);
                if ((e.getModifiers() & 4) > 0) {
                    super.processMouseEvent(e);
                } else {
                    MouseEvent targetEvent = SwingUtilities.convertMouseEvent(this, e, this.targetContainer);
                    int targetX = targetEvent.getX();
                    int targetY = targetEvent.getY();
                    Component x = SwingUtilities.getDeepestComponentAt(this.targetContainer, targetX, targetY);
                    boolean hitExpandControl = false;
                    boolean hitScrollBar = false;
                    if (x instanceof JTree) {
                        JTree tree = (JTree)x;
                        MouseEvent treeEvent = SwingUtilities.convertMouseEvent(this.targetContainer, targetEvent, tree);
                        int treeX = treeEvent.getX();
                        int treeY = treeEvent.getY();
                        BasicPaneTreeUI ui = (BasicPaneTreeUI)tree.getUI();
                        TreePath path = ui.getClosestPathForLocation(tree, treeX, treeY);
                        hitExpandControl = ui.isLocationInExpandControl(path, treeX, treeY);
                    } else if (x instanceof JScrollBar) {
                        hitScrollBar = true;
                    }
                    if (hitExpandControl || hitScrollBar || TreeDirectoryPaneUI.this.directoryPane.isSelectionEmpty()) {
                        super.processMouseEvent(e);
                    } else {
                        e.consume();
                    }
                }
            } else if (e.getID() == 502) {
                super.processMouseEvent(e);
            }
        }
    }
}

