/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.dirpane.plaf.mac;

import com.hbworks.dirpane.plaf.basic.BasicPaneTreeUI;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.tree.TreePath;

public class MacPaneTreeUI
extends BasicPaneTreeUI {
    protected boolean pressedOnControl = false;
    protected boolean highlightControl = false;
    protected Icon darkExpandedIcon;
    protected Icon darkCollapsedIcon;
    protected TreePath firstPath;
    protected MouseMotionListener mouseMotionHandler;

    public static ComponentUI createUI(JComponent x) {
        return new MacPaneTreeUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.darkExpandedIcon = UIManager.getIcon("Tree.darkExpandedIcon");
        this.darkCollapsedIcon = UIManager.getIcon("Tree.darkCollapsedIcon");
    }

    protected void installListeners() {
        super.installListeners();
        this.mouseMotionHandler = this.createMouseMotionListener();
        if (this.mouseMotionHandler != null) {
            this.tree.addMouseMotionListener(this.mouseMotionHandler);
        }
    }

    protected void uninstallListeners() {
        if (this.mouseMotionHandler != null) {
            this.tree.removeMouseMotionListener(this.mouseMotionHandler);
            this.mouseMotionHandler = null;
        }
        super.uninstallListeners();
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return new MouseMotionHandler();
    }

    public boolean isLocationInExpandControl(TreePath path, int mouseX, int mouseY) {
        boolean mightHaveExpandControl;
        int row = this.getRowForPath(this.tree, path);
        int depth = path.getPathCount() - 1;
        boolean bl = mightHaveExpandControl = depth > 0 || depth == 0 && this.getShowsRootHandles();
        if (this.tree != null && !this.isLeaf(row) && mightHaveExpandControl) {
            Icon icon = this.tree.isExpanded(path) ? this.getExpandedIcon() : this.getCollapsedIcon();
            Rectangle rowBounds = this.tree.getPathBounds(path);
            Insets insets = this.tree.getInsets();
            int rowMiddle = rowBounds.y + rowBounds.height / 2;
            int top = rowMiddle - icon.getIconHeight() / 2;
            int bottom = rowMiddle + icon.getIconHeight() / 2;
            int right = insets.left + icon.getIconWidth() - 1;
            if (mouseY >= top && mouseY <= bottom && mouseX >= insets.left && mouseX <= right) {
                return true;
            }
        }
        return false;
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
    }

    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
    }

    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
    }

    protected boolean shouldPaintExpandControl(TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (!this.getShowsRootHandles() && this.isRootVisible() && path.getPathCount() == 1) {
            return false;
        }
        return super.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf);
    }

    protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        g.translate(insets.left, 0);
        Object value = path.getLastPathComponent();
        if (!(isLeaf || hasBeenExpanded && this.treeModel.getChildCount(value) <= 0)) {
            int middleYOfKnob = bounds.y + bounds.height / 2;
            if (isExpanded) {
                Icon expandedIcon = this.getExpandedIcon();
                int middleXOfKnob = expandedIcon.getIconWidth() / 2;
                if (expandedIcon != null) {
                    this.drawCentered(this.tree, g, expandedIcon, middleXOfKnob, middleYOfKnob);
                }
            } else {
                Icon collapsedIcon = this.getCollapsedIcon();
                int middleXOfKnob = collapsedIcon.getIconWidth() / 2;
                if (collapsedIcon != null) {
                    this.drawCentered(this.tree, g, collapsedIcon, middleXOfKnob, middleYOfKnob);
                }
            }
        }
        g.translate(-insets.left, 0);
    }

    public Icon getExpandedIcon() {
        if (this.highlightControl) {
            return this.darkExpandedIcon;
        }
        return super.getExpandedIcon();
    }

    public Icon getCollapsedIcon() {
        if (this.highlightControl) {
            return this.darkCollapsedIcon;
        }
        return super.getCollapsedIcon();
    }

    protected JTree getTree() {
        return this.tree;
    }

    protected void handleExpandControlClick(TreePath path, int mouseX, int mouseY) {
        super.handleExpandControlClick(path, mouseX, mouseY);
    }

    protected void repaintControl(TreePath path) {
        Rectangle bounds = this.getPathBounds(this.tree, path);
        bounds.x = this.tree.getInsets().left;
        bounds.width = this.getExpandedIcon().getIconWidth();
        this.tree.repaint(bounds);
    }

    public class MouseMotionHandler
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent e) {
            if (MacPaneTreeUI.this.pressedOnControl) {
                int x = e.getX();
                int y = e.getY();
                TreePath path = MacPaneTreeUI.this.getClosestPathForLocation(MacPaneTreeUI.this.getTree(), x, y);
                boolean locationInControl = MacPaneTreeUI.this.isLocationInExpandControl(path, x, y);
                if (!MacPaneTreeUI.this.highlightControl && locationInControl) {
                    MacPaneTreeUI.this.highlightControl = true;
                    MacPaneTreeUI.this.repaintControl(MacPaneTreeUI.this.firstPath);
                } else if (MacPaneTreeUI.this.highlightControl && !locationInControl) {
                    MacPaneTreeUI.this.highlightControl = false;
                    MacPaneTreeUI.this.repaintControl(MacPaneTreeUI.this.firstPath);
                }
            }
        }
    }

    public class MouseHandler
    extends BasicPaneTreeUI.MouseHandler {
        public void mousePressed(MouseEvent e) {
            TreePath path;
            int x = e.getX();
            int y = e.getY();
            MacPaneTreeUI.this.firstPath = path = MacPaneTreeUI.this.getClosestPathForLocation(MacPaneTreeUI.this.getTree(), x, y);
            if (MacPaneTreeUI.this.isLocationInExpandControl(path, x, y)) {
                MacPaneTreeUI.this.pressedOnControl = true;
                MacPaneTreeUI.this.highlightControl = true;
                MacPaneTreeUI.this.repaintControl(path);
            } else {
                super.mousePressed(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            TreePath path = MacPaneTreeUI.this.getClosestPathForLocation(MacPaneTreeUI.this.getTree(), x, y);
            MacPaneTreeUI.this.highlightControl = false;
            if (MacPaneTreeUI.this.pressedOnControl && MacPaneTreeUI.this.isLocationInExpandControl(path, x, y)) {
                MacPaneTreeUI.this.pressedOnControl = false;
                MacPaneTreeUI.this.handleExpandControlClick(path, x, y);
            } else {
                MacPaneTreeUI.this.pressedOnControl = false;
                super.mouseReleased(e);
            }
        }
    }
}

