/*
 * Decompiled with CFR 0.152.
 */
package com.hbworks.examples.rmi;

import com.hbworks.examples.rmi.RemoteFile;
import com.hbworks.examples.rmi.RemoteFileSystem;
import java.io.File;
import java.io.IOException;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.ExportException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;

public class RemoteFileSystemImpl
extends UnicastRemoteObject
implements RemoteFileSystem {
    private File remoteRoot;
    private Class fileSubType = class$com$hbworks$examples$rmi$RemoteFile == null ? (class$com$hbworks$examples$rmi$RemoteFile = RemoteFileSystemImpl.class$("com.hbworks.examples.rmi.RemoteFile")) : class$com$hbworks$examples$rmi$RemoteFile;
    static /* synthetic */ Class class$com$hbworks$examples$rmi$RemoteFile;

    public static void main(String[] args) {
        System.setSecurityManager(new RMISecurityManager());
        try {
            try {
                LocateRegistry.createRegistry(1099);
            }
            catch (ExportException ee) {
            }
            catch (RemoteException re) {
                System.err.println(re.getMessage());
                re.printStackTrace();
            }
            RemoteFileSystemImpl rfs = new RemoteFileSystemImpl(args[0]);
            Naming.rebind("/RemoteFileSystem", rfs);
            System.out.println("RemoteFileSystem registered");
        }
        catch (Exception e) {
            System.err.println("RemoteFileSystem exception: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public RemoteFileSystemImpl(String root) throws RemoteException {
        this.remoteRoot = new File(root);
    }

    public String getFileSeparator() {
        return "\\";
    }

    public void setFileSubType(Class type) {
    }

    public Class getFileSubType() {
        return this.fileSubType;
    }

    public File createFileObject(String path) throws RemoteException {
        RemoteFile file = null;
        try {
            file = new RemoteFile(this.remoteRoot, path);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return file;
    }

    public File createFileObject(String path, String filename) throws RemoteException {
        RemoteFile file = null;
        try {
            file = new RemoteFile(this.remoteRoot, path, filename);
        }
        catch (IllegalArgumentException iaex) {
            // empty catch block
        }
        return file;
    }

    public File createFileObject(File dir, String path) throws RemoteException {
        RemoteFile file = null;
        try {
            file = dir == null ? new RemoteFile(this.remoteRoot, path) : new RemoteFile(this.remoteRoot, dir, path);
        }
        catch (IllegalArgumentException iaex) {
            // empty catch block
        }
        return file;
    }

    public File[] getFiles(File dir, boolean useFileHiding) throws RemoteException {
        Vector<File> files = new Vector<File>();
        String[] names = dir.list();
        int nameCount = names == null ? 0 : names.length;
        int i = 0;
        while (i < nameCount) {
            File f = this.createFileObject(dir, names[i]);
            if (useFileHiding) {
                if (!this.isHiddenFile(f)) {
                    files.addElement(f);
                }
            } else {
                files.addElement(f);
            }
            ++i;
        }
        Object[] fileArray = new File[files.size()];
        files.copyInto(fileArray);
        return fileArray;
    }

    public File getParentDirectory(File dir) throws RemoteException {
        String parentFilename;
        if (dir != null && (parentFilename = dir.getParent()) != null) {
            return this.createFileObject(parentFilename);
        }
        return null;
    }

    public boolean isHiddenFile(File f) throws RemoteException {
        return false;
    }

    public boolean isFileSystemRoot(File f) throws RemoteException {
        return f == this.remoteRoot;
    }

    public File getFileSystemRoot() throws RemoteException {
        return this.remoteRoot;
    }

    public int getDirectoryType(File dir) throws RemoteException {
        return 3;
    }

    public File loadIntoFileSystem(Object obj, File parentDir, boolean overwritePermissionGranted) throws RemoteException, IOException {
        if (overwritePermissionGranted) {
            return null;
        }
        if (this.doesFileExist((File)obj)) {
            return null;
        }
        return null;
    }

    public Object retrieveFromFileSystem(File holder) throws IOException {
        return null;
    }

    public boolean doesFileExist(File file) throws RemoteException {
        return file.exists();
    }

    public boolean isReadOnly(File file) throws RemoteException {
        return !file.canWrite();
    }

    public boolean isProtected(File file) throws RemoteException {
        return !file.canRead();
    }

    public boolean isTraversable(File file) throws RemoteException {
        return file.isDirectory();
    }

    public boolean isRegularFile(File file) throws RemoteException {
        return file.isFile();
    }

    public boolean isAbsolute(File file) throws RemoteException {
        return file.isAbsolute();
    }

    public long getLength(File file) throws RemoteException {
        return file.length();
    }

    public String getAbsolutePath(File file) throws RemoteException {
        return file.getAbsolutePath();
    }

    public String getCanonicalPath(File file) throws RemoteException, IOException {
        return file.getCanonicalPath();
    }

    public long getLastModifiedTime(File file) throws RemoteException {
        return file.lastModified();
    }

    public boolean createDirectory(File file) throws RemoteException {
        return file.mkdir();
    }

    public boolean createDirectories(File file) throws RemoteException {
        return file.mkdirs();
    }

    public boolean deleteFile(File file) throws RemoteException {
        return file.delete();
    }

    public boolean renameFile(File file, File dest) throws RemoteException {
        return file.renameTo(dest);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

