/*
 * Created on 14.09.2006
 */
package de.ssfuture.tools.updater;

/**
 * @author Sebastian Schleemilch
 */
public interface LoggingInterface {
	
	/**
	 * @param text
	 * The default logging output
	 */
	public void defaultLog(String text);
	
	/**
	 * @param text
	 * A output for important logs
	 */
	public void headlineLog(String text);
	
	/**
	 * @param description
	 * @param min
	 * @param max
	 * If you want to make a progress status information.
	 * Just one progress at the same time!
	 * First init, then habe a look at <code>progressStatus(int status)</code>
	 * and then finish a progress by using <code>progressStatusExit()</code>
	 */
	public void progressStatusInit(String description, int min, int max);
	
	/**
	 * @see headlineLog(String text)
	 * @param status
	 */
	public void progressStatus(int status);
	
	/**
	 * @see headlineLog(String text)
	 */
	public void progressStatusExit();

}
