/*
 * Created on 14.09.2006
 */
package de.ssfuture.tools.updater;

import java.awt.Frame;
import java.io.IOException;
import java.net.URL;

import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

import de.ssfuture.tools.jfonttools.WindowPositionTools;

/**
 * @author Sebastian Schleemilch
 */
public class UpdateBrowser extends JDialog implements HyperlinkListener, LoggingInterface, Runnable {
	JEditorPane browser = new JEditorPane();
	JProgressBar bar = new JProgressBar();
	static final String title = "Updater";
	String innerlog;
	URL updateURL = null;
	
	public UpdateBrowser(Frame parent, String updatepage) {
		super(parent, title, true);
		WindowPositionTools.middle(this);
		browser.setEditable(false);
		browser.setContentType("text/html");
		getContentPane().add(new JScrollPane(browser), "Center");
		getContentPane().add(bar, "South");
		setPage(updatepage);
		browser.addHyperlinkListener(this);
		setVisible(true);
	}
	
	private void setPage(String url) {
		try {
			browser.setPage(url);
		} catch (IOException e) {
			e.printStackTrace();
			browser.setText("<html>" +
					"<font color=\"#AA0000\"><center><h1>IO ERROR</h1></center></font>" +
					"<i>" + url + "</i> is not reachable! May network or system error.<br>" +
					"<center>Please use the <b>HOME</b> Button<center><br>" +
					"<hr>" +
					"The complete Error (for reporting a bug):<br><i>" +
					e.getMessage().replaceAll("\n", "<br>") + "</i>" +
					"<br><hr><i>(c) 2006 JFontTools</i>" +
					"</html>");
		}
	}

	public void hyperlinkUpdate(HyperlinkEvent e) {
		if(e.getEventType() != HyperlinkEvent.EventType.ACTIVATED)
			return;
		if(e.getURL().getPath().endsWith(".jar")) {
			int useroption = JOptionPane.showConfirmDialog(this, "<html>" +
					"Do you want to install the update<br>" +
					"<center>" + e.getURL().getFile() + "?</center><br>" +
					"(Means download and install it)</html>", 
					"Install Update?", JOptionPane.YES_NO_OPTION);
			if(useroption == JOptionPane.YES_OPTION) {
				innerlog = "<h1>Starting update process</h1>";
				browser.setText("");
				updateURL = e.getURL();
				new Thread(this).start();
			}
			else{
				System.out.println("Update Browser: " + e.getURL().toString());
			}
		}
	}
	
	public void run() {
		try {
			Thread.currentThread().sleep(500);
		} catch (InterruptedException e1) {}
		try {
			new Updater("JFontTools.jar", updateURL, this);
		} catch (IOException e1) {
			e1.printStackTrace();
			headlineLog("Fatal error init updater!");
			defaultLog(e1.getMessage());
		}
	}
	
	
	public void defaultLog(String text) {
		innerlog += "<br>" + text.replaceAll("\n", "<br>");
		browser.setText("<html>" + innerlog + "</html>");
	}
	public void headlineLog(String text) {
		innerlog += "<br><h2>" + text.replaceAll("\n", "<br>") + "</h2>";
		browser.setText("<html>" + innerlog + "</html>");
		setTitle(text);
	}
	public void progressStatus(int status) {
		bar.setValue(status);
	}
	public void progressStatusExit() {
		bar.setMinimum(0);
		bar.setMaximum(0);
		bar.setStringPainted(false);
		bar.setValue(0);
	}
	public void progressStatusInit(String description, int min, int max) {
		bar.setMinimum(min);
		bar.setMaximum(max);
		defaultLog("Progress started: " + description);
		bar.setStringPainted(true);
	}
	
}
