/*
 * Decompiled with CFR 0.152.
 */
package de.dlcc.callnotify;

import de.dlcc.callnotify.AliveTimer;
import de.dlcc.callnotify.CallNotifyMessage;
import de.dlcc.callnotify.ClientKeyListener;
import de.dlcc.callnotify.MessageSender;
import de.dlcc.callnotify.ObjectListener;
import de.dlcc.callnotify.ObjectReceiver;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CallNotifyClient
extends Frame
implements ObjectReceiver {
    private String notifyServer;
    private static int listenPort = 0;
    private static int sendPort = 0;
    private InetAddress ownIP;
    private InetAddress forceIP;
    private InetAddress serverIP;
    private JTextArea ta;
    private Properties p = new Properties();
    private int sizeX;
    private int sizeY;
    private double posX;
    private double posY;
    static String version = "0.16 ";
    private CallNotifyMessage msg;
    private MessageSender ms;
    private boolean waitingForAliveAck = false;
    private int aliveInterval;
    private boolean connected = false;

    public CallNotifyClient() {
        super("DLCC CallNotify");
        CallNotifyClient.printProgramInfo();
        this.getProps();
        try {
            this.ownIP = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            if (this.forceIP != null) {
                System.out.println("Couldn't determine own IP address, using address from config.");
                this.ownIP = this.forceIP;
            }
            System.out.println("Couldn't determine own IP, please specify in the config file:\nforceIP=<your_client's_ip_address>");
            System.exit(0);
        }
        ((Component)this).setSize(new Dimension(this.sizeX, this.sizeY));
        ((Component)this).setLocation(new Point((int)this.posX, (int)this.posY));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CallNotifyClient.this.quitApp();
            }
        });
        this.createUI();
    }

    private void register() {
        this.msg = new CallNotifyMessage(1, "", this.ownIP);
        this.ms = new MessageSender(this.serverIP, this.msg, listenPort, sendPort);
        this.ms.start();
    }

    private void deregister() {
        this.msg = new CallNotifyMessage(2, "", this.ownIP);
        this.ms = new MessageSender(this.serverIP, this.msg, listenPort, sendPort);
        this.ms.start();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void requestStatus() {
        if (this.connected) {
            this.msg = new CallNotifyMessage(10, null, this.ownIP);
            this.ms = new MessageSender(this.serverIP, this.msg, listenPort, sendPort);
            this.ms.start();
        } else {
            this.ta.insert("Not connected.\n", 0);
        }
    }

    public void requestLastEntries() {
        if (this.connected) {
            this.msg = new CallNotifyMessage(12, null, this.ownIP);
            this.ms = new MessageSender(this.serverIP, this.msg, listenPort, sendPort);
            this.ms.start();
        } else {
            this.ta.insert("Not connected.\n", 0);
        }
    }

    private void newPBEntry(String string) {
        this.msg = new CallNotifyMessage(8, string, this.ownIP);
        this.ms = new MessageSender(this.serverIP, this.msg, listenPort, sendPort);
        this.ms.start();
    }

    public static void main(String[] stringArray) {
        CallNotifyClient callNotifyClient = new CallNotifyClient();
        ObjectListener objectListener = new ObjectListener(listenPort, callNotifyClient);
        objectListener.start();
        callNotifyClient.register();
        ((Component)callNotifyClient).setVisible(true);
        AliveTimer aliveTimer = new AliveTimer(30, callNotifyClient);
        aliveTimer.start();
    }

    public void alive() {
        if (!this.connected) {
            this.waitingForAliveAck = true;
            this.msg = new CallNotifyMessage(3, null, this.ownIP);
            this.ms = new MessageSender(this.serverIP, this.msg, listenPort, sendPort);
            this.ms.start();
        } else {
            if (this.waitingForAliveAck) {
                this.connected = false;
                this.ta.insert("Connection to server lost!\n", 0);
                this.toFront();
                Toolkit.getDefaultToolkit().beep();
            }
            this.waitingForAliveAck = true;
            this.msg = new CallNotifyMessage(3, null, this.ownIP);
            this.ms = new MessageSender(this.serverIP, this.msg, listenPort, sendPort);
            this.ms.start();
        }
    }

    public void newObject(Object object) {
        this.msg = (CallNotifyMessage)object;
        int n = this.msg.getType();
        switch (n) {
            case 7: {
                this.positiveSignal();
                String string = new String(this.msg.getDetails() + "\n");
                this.ta.insert(string, 0);
                this.toFront();
                Toolkit.getDefaultToolkit().beep();
                break;
            }
            case 4: {
                this.positiveSignal();
                break;
            }
            case 5: {
                this.connected = false;
                this.ta.insert("Server rejected connection!\n", 0);
                break;
            }
            case 6: {
                this.connected = false;
                this.ta.insert("Server shutdown, connection lost.\n", 0);
                this.toFront();
                Toolkit.getDefaultToolkit().beep();
                break;
            }
            case 9: {
                this.positiveSignal();
                break;
            }
            case 11: {
                this.positiveSignal();
                this.ta.insert(this.msg.getDetails(), 0);
                break;
            }
            case 13: {
                this.positiveSignal();
                this.ta.insert(this.msg.getDetails(), 0);
            }
        }
    }

    private void positiveSignal() {
        if (!this.connected) {
            this.ta.insert("CallNotify ready.\n", 0);
        }
        this.connected = true;
        this.waitingForAliveAck = false;
    }

    private void getProps() {
        try {
            FileInputStream fileInputStream = new FileInputStream("config.txt");
            this.p.load(fileInputStream);
            if (this.p.getProperty("serverAddress") != null && this.p.getProperty("listenPort") != null && this.p.getProperty("sendPort") != null) {
                System.out.println("Using server " + this.p.getProperty("serverAddress"));
                this.notifyServer = this.p.getProperty("serverAddress");
                this.serverIP = InetAddress.getByName(this.notifyServer);
                System.out.println("Using listen port " + this.p.getProperty("listenPort"));
                listenPort = Integer.parseInt(this.p.getProperty("listenPort"));
                System.out.println("Using send port " + this.p.getProperty("sendPort"));
                sendPort = Integer.parseInt(this.p.getProperty("sendPort"));
                this.sizeX = this.p.getProperty("sizeX") != null ? Integer.parseInt(this.p.getProperty("sizeX")) : 300;
                this.sizeY = this.p.getProperty("sizeY") != null ? Integer.parseInt(this.p.getProperty("sizeY")) : 105;
                this.posX = this.p.getProperty("posX") != null ? (double)Integer.parseInt(this.p.getProperty("posX")) : 50.0;
                this.posY = this.p.getProperty("posY") != null ? (double)Integer.parseInt(this.p.getProperty("posY")) : 50.0;
                if (this.p.getProperty("forceIP") != null) {
                    try {
                        this.forceIP = InetAddress.getByName(this.p.getProperty("forceIP"));
                    }
                    catch (UnknownHostException unknownHostException) {
                        System.out.println("Error getting IP from config, please correct.");
                        System.exit(0);
                    }
                } else {
                    this.forceIP = null;
                }
                this.aliveInterval = this.p.getProperty("aliveInterval") != null ? Integer.parseInt(this.p.getProperty("aliveInterval")) : 30;
            } else {
                System.out.println("Please make sure you have the properties serverAddress and clientListenPort set in your config.txt file, eg.\n\nserverAddress=192.168.1.1\nlistenPort=1888\nsendPort=1887");
                System.exit(0);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("No config file found, cannot start.\nCreating a config file template, please edit this file according to your\nenvironment and try again.");
            try {
                FileOutputStream fileOutputStream = new FileOutputStream("config.txt");
                String string = new String("serverAddress=192.168.1.1\n\r");
                fileOutputStream.write(string.getBytes());
                string = new String("logFile=caller_id.log\n\r");
                fileOutputStream.write(string.getBytes());
                string = new String("listenPort=1888\n\r");
                fileOutputStream.write(string.getBytes());
                string = new String("sendPort=1887\n\r");
                fileOutputStream.write(string.getBytes());
                fileOutputStream.flush();
                fileOutputStream.close();
                System.exit(0);
            }
            catch (FileNotFoundException fileNotFoundException2) {
                System.out.println("Couldn't create file.");
                System.exit(0);
            }
            catch (IOException iOException) {
                System.out.println("IO Exception!");
                System.exit(0);
            }
        }
        catch (IOException iOException) {
            System.out.println("IO Exception!");
            System.exit(0);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Error in config file, please correct and try again.");
            System.exit(0);
        }
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        this.ta = new JTextArea();
        this.ta.setEditable(false);
        this.ta.addKeyListener(new ClientKeyListener(this));
        this.add((Component)new JScrollPane(this.ta), "Center");
    }

    private void quitApp() {
        this.deregister();
        Properties properties = System.getProperties();
        String string = properties.getProperty("java.version");
        if (string.startsWith("1.1")) {
            System.exit(0);
        }
        Dimension dimension = this.getSize();
        this.sizeX = dimension.width;
        this.sizeY = dimension.height;
        this.p.setProperty("sizeX", Integer.toString(this.sizeX));
        this.p.setProperty("sizeY", Integer.toString(this.sizeY));
        Point point = this.getLocationOnScreen();
        this.posX = point.getX();
        this.posY = point.getY();
        this.p.setProperty("posX", Integer.toString((int)this.posX));
        this.p.setProperty("posY", Integer.toString((int)this.posY));
        try {
            FileOutputStream fileOutputStream = new FileOutputStream("config.txt");
            this.p.store(fileOutputStream, "DLCC CallNotify Properties");
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Error saving properties.");
        }
        System.exit(0);
    }

    public static void printProgramInfo() {
        System.out.println("***************************************************");
        System.out.println("* CallNotifyClient                 Version " + version + "  *");
        System.out.println("* (c) 2002,2003 Dennis Luemkemann                 *");
        System.out.println("***************************************************");
    }
}

