/*
 * Decompiled with CFR 0.152.
 */
package com.vyx.jni;

import com.ibm.regex.Match;
import com.ibm.regex.RegularExpression;
import com.vyx.util.Misc;

public final class CDTOCRec {
    public int trackNo = 0;
    public boolean fData = true;
    public int flags = 0;
    public String startTime = "00:00:00";
    public int startBlock = 0;
    public String lengthTime = "00:00:00";
    public int lengthBlocks = 0;
    RegularExpression re = new RegularExpression("(\\d+)\\s+(\\S+)\\s+(\\d+)\\s+(\\d{2}:\\d{2}:\\d{2})\\(\\s*(\\d+)\\)\\s*(\\d{2}:\\d{2}:\\d{2})\\(\\s*(\\d+)\\)");
    RegularExpression reL = new RegularExpression("(Leadout)\\s+(\\S+)\\s+(\\d+)\\s+(\\d{2}:\\d{2}:\\d{2})\\(\\s*(\\d+)\\)", "i");
    Match m = new Match();

    public CDTOCRec() {
    }

    public CDTOCRec(String string) {
        this();
        this.split(string);
    }

    public final String getTrackFlagsStr() {
        return Misc.formatInt(5, this.flags);
    }

    public final String getTrackLengthStr() {
        return String.valueOf(this.lengthTime) + "(" + Misc.formatInt(6, this.lengthBlocks) + ")";
    }

    public final String getTrackModeStr() {
        return this.fData ? " DATA" : "AUDIO";
    }

    public final String getTrackNoStr() {
        return this.trackNo == -1 ? "Leadout" : Misc.formatInt(7, this.trackNo);
    }

    public final String getTrackStartStr() {
        return String.valueOf(this.startTime) + "(" + Misc.formatInt(6, this.startBlock) + ")";
    }

    public void split(String string) {
        if (this.re.matches(string, this.m)) {
            this.trackNo = Integer.valueOf(this.m.getCapturedText(1));
            this.fData = this.m.getCapturedText(2).equalsIgnoreCase("DATA");
            this.flags = Integer.valueOf(this.m.getCapturedText(3));
            this.startTime = this.m.getCapturedText(4);
            this.startBlock = Integer.valueOf(this.m.getCapturedText(5));
            this.lengthTime = this.m.getCapturedText(6);
            this.lengthBlocks = Integer.valueOf(this.m.getCapturedText(7));
        } else if (this.reL.matches(string, this.m)) {
            this.trackNo = -1;
            this.fData = this.m.getCapturedText(2).equalsIgnoreCase("DATA");
            this.flags = Integer.valueOf(this.m.getCapturedText(3));
            this.startTime = this.m.getCapturedText(4);
            this.startBlock = Integer.valueOf(this.m.getCapturedText(5));
            this.lengthTime = "";
            this.lengthBlocks = 0;
        }
    }

    public String toString() {
        if (this.trackNo == 0) {
            return "[????]";
        }
        String string = this.trackNo == -1 ? "Leadout" : Misc.formatInt(7, this.trackNo);
        string = String.valueOf(string) + ", " + (this.fData ? " DATA" : "AUDIO");
        string = String.valueOf(string) + ", " + this.startTime + "(" + Misc.formatInt(6, this.startBlock) + ")";
        if (this.lengthBlocks != 0) {
            string = String.valueOf(string) + ", " + this.lengthTime + "(" + Misc.formatInt(6, this.lengthBlocks) + ")";
        }
        return string;
    }
}

